#include <stdio.h>
#include <stdlib.h>

#define BUFFER 4096
#define MAX_FORMAT_SIZE 100

int main(int argc, char *argv[])
{
    FILE *sample_file;
    char sentence[BUFFER];
    char format[MAX_FORMAT_SIZE];
   
    if(argc==1)
    {
	fprintf(stderr, "Syntax: %s <filename>\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    sample_file=fopen(argv[1], "w");
    if(sample_file==NULL)
    {
	fprintf(stderr, "Cant open file '%s' for writing\n", argv[1]);
	perror("");
	exit(EXIT_FAILURE);
    }

    printf("Enter sentence to be written into file : ");
    sprintf(format, "%%%d[^\n]", BUFFER -1);
    scanf(format, sentence);
    fprintf(sample_file, "%s", sentence);
    printf("Sentence '%s' written to file '%s'\n", sentence, argv[1]);
    fclose(sample_file);
    printf("Closed file '%s'\n", argv[1]);

    
    printf("Opening file '%s' for input\n", argv[1]);
    sample_file=fopen(argv[1], "r");
    if(sample_file==NULL)
    {
	fprintf(stderr, "Cant open file '%s' for reading\n", argv[1]);
	perror("");
	exit(EXIT_FAILURE);
    }
    fscanf(sample_file, format, sentence);
    printf("Read '%s' from file %s\n", sentence, argv[1]);
    fclose(sample_file);
    printf("Closed file '%s'\n", argv[1]);

    exit(EXIT_SUCCESS);
    return 0;
}
