#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>

#define BUFFER_SIZE 40
//#define BUFFER_SIZE 4096
//#define BUFFER_SIZE 4096000

int main(int argc, char *argv[])
{
    FILE *input_file;
    FILE *output_file;
    int characters_read=1;
    char buffer1[BUFFER_SIZE];
    struct timeval tv1;
    struct timezone tz1;
    unsigned long start_seconds;
    unsigned long start_micro_seconds;
    unsigned long end_seconds;
    unsigned long end_micro_seconds;
    unsigned long difference_seconds;
    unsigned long difference_micro_seconds;
   
    if(argc<3)
    {
	fprintf(stderr, "Syntax: %s <source_file> <destination_file>\n", argv[0]);
	exit(EXIT_FAILURE);
    }
   

    //Storing starting time
    gettimeofday(&tv1,&tz1);
    start_seconds=tv1.tv_sec;
    start_micro_seconds=tv1.tv_usec;


    //copying file
    output_file=fopen(argv[2], "w");
    if(output_file==NULL)
    {
	fprintf(stderr, "Cant open file '%s' for writing\n", argv[2]);
	perror("");
	exit(EXIT_FAILURE);
    }

    input_file=fopen(argv[1], "r");
    if(input_file==NULL)
    {
	fprintf(stderr, "Cant open file '%s' for reading\n", argv[1]);
	perror("");
	exit(EXIT_FAILURE);
    }

    while(!feof(input_file) && characters_read>0)
    {
	characters_read=fread(buffer1, 1, BUFFER_SIZE, input_file); 
	fwrite(buffer1, 1, characters_read, output_file); 
    }

    fclose(input_file);
    fclose(output_file);
    sync();

    //Storing end time
    gettimeofday(&tv1,&tz1);
    end_seconds=tv1.tv_sec;
    end_micro_seconds=tv1.tv_usec;


    //Finding time taken to copy
    if(start_micro_seconds>=end_micro_seconds)
    {
	difference_micro_seconds = start_micro_seconds-end_micro_seconds;
	difference_seconds = end_seconds-start_seconds-1;
    }
    else
    {
	difference_micro_seconds = end_micro_seconds-start_micro_seconds;
	difference_seconds = end_seconds - start_seconds;
    }

    printf("Program took %lu.%06lu seconds to complete\n", difference_seconds, difference_micro_seconds);

    exit(EXIT_SUCCESS);
    return 0;
}
