#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>


#define INPUT_STREAM 0
#define OUTPUT_STREAM 1
#define ERROR_STREAM 2

#define BUFFER_SIZE 40
//#define BUFFER_SIZE 4096
//#define BUFFER_SIZE 4096000


int main(int argc, char *argv[])
{
    int input_file_descriptor;
    int output_file_descriptor;
    int characters_read=1;
    char message[BUFFER_SIZE];
    char buffer1[BUFFER_SIZE];
    struct timeval tv1;
    struct timezone tz1;
    unsigned long start_seconds;
    unsigned long start_micro_seconds;
    unsigned long end_seconds;
    unsigned long end_micro_seconds;
    unsigned long difference_seconds;
    unsigned long difference_micro_seconds;
   
    if(argc==1)
    {
	sprintf(message, "Syntax: %s <filename>\n", argv[0]);
	write(ERROR_STREAM, message, strlen(message));
	exit(EXIT_FAILURE);
    }


    //storing start time
    gettimeofday(&tv1,&tz1);
    start_seconds=tv1.tv_sec;
    start_micro_seconds=tv1.tv_usec;


    //copying file
    output_file_descriptor=open(argv[2], O_WRONLY | O_CREAT | O_TRUNC, 00666 );
    if(output_file_descriptor<0)
    {
	sprintf(message, "Cant open file '%s' for writing\n", argv[2]);
	strcat(message, strerror(errno));
	strcat(message, "\n");
	write(ERROR_STREAM, message, strlen(message));
	exit(EXIT_FAILURE);
    }

    input_file_descriptor=open(argv[1], O_RDONLY);
    if(input_file_descriptor<0)
    {
	sprintf(message, "Cant open file '%s' for reading\n", argv[1]);
	strcat(message, strerror(errno));
	strcat(message, "\n");
	write(ERROR_STREAM, message, strlen(message));
	exit(EXIT_FAILURE);
    }

    while(characters_read>0)
    {
	characters_read=read(input_file_descriptor, buffer1, BUFFER_SIZE);
	write(output_file_descriptor, buffer1, characters_read);
    }

    close(input_file_descriptor);
    close(output_file_descriptor);
    sync();

    //storing end time
    gettimeofday(&tv1,&tz1);
    end_seconds=tv1.tv_sec;
    end_micro_seconds=tv1.tv_usec;


    //finding time taken to copy
    if(start_micro_seconds>=end_micro_seconds)
    {
	difference_micro_seconds = start_micro_seconds-end_micro_seconds;
	difference_seconds = end_seconds-start_seconds-1;
    }
    else
    {
	difference_micro_seconds = end_micro_seconds-start_micro_seconds;
	difference_seconds = end_seconds - start_seconds;
    }

    printf("Program took %lu.%06lu seconds to complete\n", difference_seconds, difference_micro_seconds);

    exit(EXIT_SUCCESS);
    return 0;
}

