#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>
#include <string.h>

#include "sqlite_example2.h"

sqlite3 *database1;

static int callback (void *NotUsed, int argc, char **argv, char **azColName)
{
    NotUsed = 0;
    int i;
    for (i = 0; i < argc; i++)
    {
	printf ("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf ("\n");
    return 0;
}

int main (int argc, char **argv)
{
    char *zErrMsg = 0;
    int rc;
    char sql_query[BUFFER];

    if (argc != 2)
    {
	fprintf (stderr, "Usage: %s DATABASE\n", argv[0]);
	exit (1);
    }
    rc = sqlite3_open (argv[1], &database1);
    if (rc)
    {
	fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (database1));
	sqlite3_close (database1);
	exit (1);
    }
    
    strcpy(sql_query, "CREATE TABLE email_address(student_id,email_address)");
    rc = sqlite3_exec (database1, sql_query, callback, 0, &zErrMsg);
   /* if (rc != SQLITE_OK)
    {
	fprintf (stderr, "SQL error: %s\n", zErrMsg);
	// This will free zErrMsg if assigned 
	if (zErrMsg)
	    free (zErrMsg);
    }*/

    show_menu();
    sqlite3_close (database1);

    exit(EXIT_SUCCESS);
    return 0;
}


void show_menu()
{
    int choice=0;

    while(choice!=5)
    {
	printf("\n\nOPTIONS\n");
	printf("1. Store record\n");
	printf("2. Fetch record\n");
	printf("3. Print all records\n");
	printf("4. Delete record\n");
	printf("5. Exit\n");
	printf("Enter your choice:");
	scanf("%d", &choice);

	if(choice<1 || choice > 5)
	    printf("Invalid choice. Choice must be between 1 and 5.\n");
	else
	{
	    switch(choice)
	    {
		case 1:
		    store_record();
		    break;

		case 2:
		    fetch_record();
		    break;

		case 3:
		    print_all_records();
		    break;

		case 4:
		    delete_record();
		    break;
	    }
	}
    }
}


void store_record()
{
    char sql_statement[BUFFER];
    char student_id[STUDENT_ID_SIZE];
    char email_address[EMAIL_ADDRESS_SIZE];
    int rc;
    char *zErrMsg = 0;

    printf("Enter student ID (no spaces) : ");
    scanf("%s", student_id);
    printf("Enter email address (no spaces) : ");
    scanf("%s", email_address);

    sprintf(sql_statement, "INSERT into email_address values('%s','%s')", student_id, email_address);
    rc = sqlite3_exec (database1, sql_statement, callback, 0, &zErrMsg);
    if (rc != SQLITE_OK)
    {
	fprintf (stderr, "SQL error: %s\n", zErrMsg);
	// This will free zErrMsg if assigned 
	if (zErrMsg)
	    free (zErrMsg);
    }
    else
    {
	printf("Record stored successfully.\n");
    }
}


void fetch_record()
{
    char sql_statement[BUFFER];
    char student_id[STUDENT_ID_SIZE];
    int rc;
    char *zErrMsg = 0;

    printf("Enter student id for which email address should be searched : ");
    scanf("%s",student_id);
    
    sprintf(sql_statement, "SELECT * from email_address where student_id='%s'", student_id);
    rc = sqlite3_exec (database1, sql_statement, callback, 0, &zErrMsg);
    if (rc != SQLITE_OK)
    {
	fprintf (stderr, "SQL error: %s\n", zErrMsg);
	// This will free zErrMsg if assigned 
	if (zErrMsg)
	    free (zErrMsg);
    }
}

void print_all_records()
{
    char sql_statement[BUFFER];
    int rc;
    char *zErrMsg = 0;

    strcpy(sql_statement, "SELECT * from email_address");
    rc = sqlite3_exec (database1, sql_statement, callback, 0, &zErrMsg);
    if (rc != SQLITE_OK)
    {
	fprintf (stderr, "SQL error: %s\n", zErrMsg);
	// This will free zErrMsg if assigned 
	if (zErrMsg)
	    free (zErrMsg);
    }
}

void delete_record()
{
    char sql_statement[BUFFER];
    char student_id[STUDENT_ID_SIZE];
    int rc;
    char *zErrMsg = 0;

    printf("Enter student id for whose record is to be deleted : ");
    scanf("%s",student_id);
    
    sprintf(sql_statement, "DELETE from email_address where student_id='%s'", student_id);
    rc = sqlite3_exec (database1, sql_statement, callback, 0, &zErrMsg);
    if (rc != SQLITE_OK)
    {
	fprintf (stderr, "SQL error: %s\n", zErrMsg);
	// This will free zErrMsg if assigned 
	if (zErrMsg)
	    free (zErrMsg);
    }
    else
    {
	printf("Record deleted successfully.\n");
    }
}

