/**This program is to practice GTK by creating a window with a label inside it.
  The program will use GtkWidget of GtkLabel and GtkWindow to show message to user.
  We will call gtk_quit() at delete_event() using signals so that program ends 
  if some one tries to close top window.
  * @author Saurabh Barjatiya
  * @version 1.0
  * @file 03-gtk_delete_event.c
  *
  */

#include <gtk/gtk.h>
#include <stdlib.h>

void end_program(GtkWidget *widget1, gpointer data);

/**This is where program starts. This creates a window with a label hi in it.
  * The program also registers function end_program() which calls gtk_main_quit() to end program,
  * if someone tries to close top level window.
  * @param argc Number of arguments passed to program
  * @param argv Array of arugments passed to program
  * @returns EXIT_SUCCESS if program exits properly, EXIT_FAILURE otherwise.
  *
  */
int main(int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *label_hi;

    gtk_init(&argc, &argv);

    window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    label_hi=gtk_label_new("Hi");
    gtk_container_add(GTK_CONTAINER(window), label_hi);

    gtk_window_set_title(GTK_WINDOW(window), "02-gtk_label example");
    gtk_window_set_default_size(GTK_WINDOW(window),340,200);
    g_signal_connect(G_OBJECT(window),"delete_event",G_CALLBACK(end_program),NULL);

    gtk_widget_show(label_hi);
    gtk_widget_show(window);
    gtk_main();

    return EXIT_SUCCESS;
}

/** This function is called when someone tries to close top level window.
  * @param widget1 Widget that generated the event
  * @param data Additional data passed by widget while generating the signal
  *
  */
void end_program(GtkWidget *widget1, gpointer data)
{
    gtk_main_quit();

}



