/** This program is created for learning purposes only. It creates a window
 * with a button in it. You must close the window by clicking on button.
 * Clicking close on top right or sending close by window manager in any other
 * way will not work.
 * @file 04-button_and_signal.c
 * @author Saurabh Barjatiya
 */

#include <gtk/gtk.h>
#include <stdlib.h>


gint window_delete_event(GtkWidget *widget1, gpointer data);
void window_destroy(GtkWidget *widget1, gpointer data);
void print_hello(GtkWidget *widget1, gpointer data);


/** This is where program execution starts. All arguments are passed
 * to gtk for processing, which removes any arguments relevant to it.
 * All other arguments are ignored.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 * @return EXIT_SUCCESS on success, EXIT_FAILURE on failure
 */
int main(int argc, char *argv[])
{
	GtkWidget *window;
	GtkWidget *button;
	
	gtk_init(&argc, &argv);
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size(GTK_WINDOW(window),200,200);
	gtk_container_set_border_width(GTK_CONTAINER(window),20);
	
	g_signal_connect(G_OBJECT(window),"delete_event",G_CALLBACK(window_delete_event),NULL);
	g_signal_connect(G_OBJECT(window),"destroy",G_CALLBACK(window_destroy),NULL);
	
	
	button = gtk_button_new_with_label("Hello World");
	g_signal_connect(G_OBJECT(button),"clicked",G_CALLBACK(print_hello), NULL);
	g_signal_connect_swapped(G_OBJECT(button), "clicked", G_CALLBACK(gtk_widget_destroy), GTK_OBJECT(window));

	gtk_container_add(GTK_CONTAINER(window), button);
	
	gtk_widget_show(button);	
	gtk_widget_show(window);
	gtk_main();
	
	return EXIT_SUCCESS;
}

/** It is called when user tries to close window using window manager.
 * We will always disable closing of window using window manager.
 * @param widget1 Widget which generated the event
 * @param data any additional data passed while generating signal
 * @return TRUE if you want to disable closing, FALSE otherwise
 */
gint window_delete_event(GtkWidget *widget1, gpointer data)
{
	g_print("Delete event occurred.\n");
	return TRUE;
	
}


/** This is called on pressing button after calling print_hello.
 * It calls gtk_main_quit() to end gtk_main and return to main()
 * @param widget1 Widget which generated the event.
 * @param data Data passed by generator
 */
void window_destroy(GtkWidget *widget1, gpointer data)
{
	gtk_main_quit();
}


/** This is called when button is clicked to print hello world on terminal.
 * Then other callback functions are called in the order in which
 * they were connected.
 * @param widget1 Widegt which generated the signal
 * @param data Data passed while generating signal
 */
void print_hello(GtkWidget *widget1, gpointer data)
{
	g_print("Hello World\n");
}
