/**This program is to practice GTK by creating a creating check button
  * @author Saurabh Barjatiya
  * @version 1.0
  * @file 08-gtk_check_button.c
  *
  */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>

void button_toggled(GtkWidget *widget1, gpointer data);

/**This is where program starts and displays a check button
  * @param argc Number of arguments passed to program
  * @param argv Array of arugments passed to program
  * @returns EXIT_SUCCESS if program exits properly, EXIT_FAILURE otherwise.
  *
  */
int main(int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *check_button;

    gtk_init(&argc, &argv);
    
    window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "08-gtk_check_button example");
    gtk_window_set_default_size(GTK_WINDOW(window),340,200);

    check_button = gtk_check_button_new_with_label("I like GTK");
    gtk_container_add(GTK_CONTAINER(window), check_button);

    g_signal_connect(G_OBJECT(window), "delete_event", G_CALLBACK(gtk_main_quit), NULL);
    g_signal_connect(G_OBJECT(check_button), "toggled", G_CALLBACK(button_toggled), NULL);

    gtk_widget_show(check_button);
    gtk_widget_show(window);
    gtk_main();

    return EXIT_SUCCESS;
}


void button_toggled(GtkWidget *widget1, gpointer data)
{
    static gboolean button_status=FALSE;

    if(button_status==TRUE)
	button_status=FALSE;
    else
	button_status=TRUE;

    if(button_status==TRUE)
    {
	printf("You like GTK. Nice :) \n");
    }
    else
    {
	printf("What :O   You do not like GTK. :(. But why? \n");    
    }

}


