#include <unistd.h>	//for close(), write(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strlen(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 

#define BUFFER 4096

//used to store file descriptor of port we are listing to
int listen_file_descriptor;

void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    
    return_value =close(listen_file_descriptor);

    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(1);
    }

    printf("Shutdown complete.\n");
    exit(0);
}
    

/**
  * Used to create a tcp day_time server. This program forks()
  * when child connects and responds to requests concurrently.
  * Note that it will work only for ipv4 servers.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{
    //used to store file descriptor of socket when a client is connected.
    int connection_file_descriptor; 

    //used to store line from server temporarily
    char temp_line[BUFFER];

    //used to store address of ipv4 server 
    struct sockaddr_in server_address;

    //used to store time in ticks temporarily
    time_t ticks;

    //used to store return value for checking whether call to
    //a function was successfull or not
    int return_value;

    //used to catch Ctrl+C and close listen_file_descriptor
    //and terminate.
    struct sigaction act1;

    //used to store process id of child so that we can handle 
    //requests concurrently
    int pid=0;
    
    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;

    sigaction(SIGINT, &act1, 0);
    
    //try to open socket
    listen_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);

    //if socket opening failed then print error message and quit
    if(listen_file_descriptor < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(1);
    }

    //initialize struct server_address to all zeros.
    bzero(&server_address, sizeof(server_address));

    //set the protocol used to be ipv4
    server_address.sin_family = AF_INET;

    //let server listen on any interface connected to
    //the server
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);

    //set the port to be 13, by default tcp day time servers
    //listen on port 13. htons is used to convert byte ordering from
    //system dependent (bigendian|littlendian) to network type, i.e.
    //system indepent. htons is host to network short.
    server_address.sin_port = htons(13);

    //bind the socket to port, so that it we can listen on socket
    return_value = bind(listen_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address));
    
    //quit if could not bind
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(1);
    }

    //let clients queue on socket and start listening to it
    //Let 5 clients queue at a time.
    return_value = listen(listen_file_descriptor, 5);
    
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(1);
    }
    
    while(1)
    {
	connection_file_descriptor = accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);

	if(connection_file_descriptor < 0)
	{
	    perror("accept() failed.");
	    exit(1);
	}

	pid=fork();
	if(pid!=0)
	{
	    //i.e. in parent
	    close(connection_file_descriptor);
	    continue;
	}

	ticks = time(NULL);
	snprintf(temp_line, sizeof(temp_line), "%.24s\r\n", ctime(&ticks));
	
	return_value = write(connection_file_descriptor, temp_line, strlen(temp_line));

	if(return_value < 0)
	{
	    perror("write() failed.");
	    exit(1);
	}
	
	return_value = close(connection_file_descriptor);

	if(return_value <0)
	{
	    perror("close failed");
	    exit(1);
	}

	return_value = close(listen_file_descriptor);

	if(return_value <0)
	{
	    perror("close failed");
	    exit(1);
	}

	exit(EXIT_SUCCESS);
    }
        
    return 0;
}

