#include <stdio.h>	//for printf(),
#include <unistd.h>	//for close(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strcpy(), strlen()
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), inet_pton()
#include <sys/types.h>	//for socket(), inet_pton()
#include <arpa/inet.h>	//for htons(), inet_pton()
#include <netinet/in.h>	//for struct sockaddr_in,

#define LISTEN_PORT 9999
#define BUFFER_SIZE 4096
#define WAIT_TIME 10

/**
  * Used to connect to blocking input server and send different
  * types of test data.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{
    int socket_file_descriptor; 
    char output_data[BUFFER_SIZE];
    int character_written;
    struct sockaddr_in server_address;

    if(argc != 2)
    {
	fprintf(stderr, "%s: usage: %s <server_ip_address>\n", argv[0], argv[0]);
	exit(EXIT_FAILURE);
    }

    socket_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);
    if(socket_file_descriptor < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_port = htons(LISTEN_PORT);
    if(inet_pton(AF_INET, argv[1], &server_address.sin_addr) <= 0)
    {
	fprintf(stderr, "%s: the supplied ipv4 address %s is incorrect.\n", argv[0], argv[1]);
	exit(EXIT_FAILURE);
    }

    if(connect(socket_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address)) < 0)
    {
	fprintf(stderr, "%s: cannot connect to server %s\n", argv[0], argv[1]);
	exit(EXIT_FAILURE);
    }

    printf("Test 1: No \\n at end\n");
    strcpy(output_data, "No \\n at end");
    character_written = write(socket_file_descriptor, output_data, strlen(output_data));
    if(character_written < 0)
    {
	printf("Write error\n");
	exit(EXIT_FAILURE);
    }
    printf("Data written, waiting for %d seconds\n", WAIT_TIME);
    sleep(WAIT_TIME);

    close(socket_file_descriptor);
    printf("\n");

    exit(EXIT_SUCCESS);
    return 0;
}
