#include <stdio.h>
#include <pcap.h>
#include <stdlib.h>

int main ()
{
    pcap_if_t *all_device_list;
    pcap_if_t *current_device;
    int interface_count = 0;
    char error_message[PCAP_ERRBUF_SIZE];

    /* Retrieve the device list from the local machine */
    if (pcap_findalldevs(&all_device_list, error_message)	== -1)
    {
	fprintf (stderr, "Error in pcap_findall_device_list_ex: %s\n", error_message);
	exit(EXIT_FAILURE);
    }

    /* Print the list */
    for (current_device = all_device_list; current_device != NULL; current_device = current_device->next)
    {
	printf ("%d. %s", ++interface_count, current_device->name);
	if (current_device->description)
	    printf (" (%s)\n", current_device->description);
	else
	    printf (" (No description available)\n");
    }

    if (interface_count == 0)
    {
	fprintf(stderr, "Either No interfaces found! Make sure WinPcap is installed.\n");
	fprintf(stderr, "OR you are not running program as root user.\n");
	exit(EXIT_FAILURE);
    }

    /* We don't need any more the device list. Free it */
    pcap_freealldevs(all_device_list);

    exit(EXIT_SUCCESS);
    return 0;
}
