#include <stdio.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>

#define KEY 200401196
#define MEMORY_SIZE 4096 

int main()
{
    int shmid;
    char *shared_memory;
    char text[MEMORY_SIZE];
   
   shmid = shmget(KEY, MEMORY_SIZE, 0666|IPC_CREAT);
   if(shmid<0)
   {
       fprintf(stderr, "Error occurred while using shmget for KEY %d\n", KEY);
       perror("");
       exit(EXIT_FAILURE);
   }

   shared_memory = (char *) shmat(shmid, NULL, 0);
   if(shared_memory < 0)
   {
       fprintf(stderr, "Error occurred while using shmat for shmid %d\n", shmid);
       perror("");
       exit(EXIT_FAILURE);
   }

   printf("Enter text to be stored in shared memory : ");
   scanf("%s", text);
   strcpy(shared_memory, text);

   printf("Value written to shared memory\n");
   exit(EXIT_SUCCESS);

   return 0;
}
