/* This is the GTK calculator which is executed on server side 
 * File name: servercalculator.c 
 * Here the calculation of user information that passed from client is calculated and the final result is return back to the client 

*/

#include <unistd.h>	/*for close(), write(),*/
#include <stdio.h>	/*for fprintf(), perror(), snprintf(),*/
#include <stdlib.h>	/*for exit(),*/
#include <string.h>	/*for strlen(),*/
#include <math.h>       /* for pow,sin,cos sqrt etc*/ 
#include <strings.h>	/*for bzero(),*/
#include <sys/socket.h>	/*for socket(), bind(), listen(), accept(),*/
#include <netinet/in.h>	/*for struct sockaddr_in,*/
#include <time.h>	/*for time(), time_t, */
#include <signal.h>	/*for sigaction(), */
#define BUFFER 4096
#define PI 3.14159265
/*used to store file descriptor of port we are listing to*/
 int listen_file_descriptor;
                           
	int addition(int x,int y)   {return x+y;}
	int subtraction(int x,int y)  {return x-y;}
	int multiplication(int x,int y)   {return x*y;}
	int division(int x,int y)   
   	{ if(y==0) 
             { 
              perror("\nError \n");
	      exit(1);     // return 0;
             }
     	 else
   	  return x/y;
   	  }
int modEstimator(int x,int y)  /* x mod(y) && y must be positive and both x&y integer.*/
	{
    	 if (y <= 0) 
     { perror("\nError \n");
	    exit(1);  
          
      }
    	int  estimator = x / y;
     	 estimator = estimator -estimator;
      	if (estimator < 0) 
                  return (estimator*y + y) ;
     	 return x%y;
	}
int power(int x,int y){ return (pow(x,y));}
 

int MainCalculator(int x,int y,char o)
{
 
	switch(o)
	{
	 case '+':
                   return(addition(x,y));
                    break;               
         case '-':
                    return(subtraction(x,y));
                    break;
         case '*':
                   return( multiplication(x,y));
                    break;
          case '/':
                   return (division(x,y));
                   break;
     
        case '%':  
                return(modEstimator(x,y));
                break;
        case  '^':
                 return(power(x,y));
                  break;
	}
return 0;
}/*
int factorial(int a)
   {
  if(a==1||a==0)
    return a;
else
   return (a*factorial(a-1));
  }


  int calc(int x, char 0)
   {
    switch(o)
	{
	 case 's':
                   return (sqrt(x));
                    break;     
        case 'a':  
                return (abs(x));
                break;
        case  'l':
                 return(log(x));
                  break;     
        case 'n':
               return (ln(x));
               break;     
        case 'u':
               return (sin (x*PI/180));
                break;
        case 'v':
                 return(cos(x*PI/180));
                 break;
       case 't':
                 return (tan (x*PI/180));
                 break;
        case 'f':
                 return (factorial(x));
                 break;
        	}
return 0;
}

*/


void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    
    return_value =close(listen_file_descriptor);

    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(1);
    }

    printf("Shutdown complete.\n");
    exit(0);
}    
   

/**
  * Used to create a tcp  server. This is an iterative server
  * and hence responds to only one client at a time.
  * Note that it will work only for ipv4 servers.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */


int main(int argc, char *argv[])
{
    //used to store file descriptor of socket when a client is connected.
    int connection_file_descriptor; 

    //used to store line from server temporarily
    char temp_line[BUFFER];

    //used to store address of ipv4 server 
    struct sockaddr_in server_address;
	//struct sockaddr_in client_address;

    //used to store time in ticks temporarily
   // time_t ticks;

    //used to store return value for checking whether call to
    //a function was successfull or not
    int return_value;

    //used to catch Ctrl+C and close listen_file_descriptor
    //and terminate.
    struct sigaction act1;
    
    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;

    sigaction(SIGINT, &act1, 0);
    
    //try to open socket
    listen_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);

    //if socket opening failed then print error message and quit
    if(listen_file_descriptor < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(1);
    }

    //initialize struct server_address to all zeros.
    bzero(&server_address, sizeof(server_address));

    //set the protocol used to be ipv4
    server_address.sin_family = AF_INET;

    //let server listen on any interface connected to
    //the server
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);

    //set the port to be 13, by default tcp day time servers
    //listen on port 13. htons is used to convert byte ordering from
    //system dependent (bigendian|littlendian) to network type, i.e.
    //system indepent. htons is host to network short.
    server_address.sin_port = htons(1224);

    //bind the socket to port, so that it we can listen on socket
    return_value = bind(listen_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address));
    
    //quit if could not bind
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(1);
    }

    //let clients queue on socket and start listening to it
    //Let 5 clients queue at a time.
    return_value = listen(listen_file_descriptor, 5);
    

    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(1);
    }
    
    while(1)
    {
	connection_file_descriptor = accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);
    
	if(connection_file_descriptor < 0)
	{
	    perror("accept() failed.");
	    exit(1);
	}

	
	temp_line[0]='\0';
    /*  ******************************************************************* */
	int num;
	num=read (connection_file_descriptor, temp_line, BUFFER);
	temp_line[num]='\0';

        printf("Message from client is %s\n",temp_line);
	char op1[100],op2[100],opr;
	int i;
          int len =strlen(temp_line);
         printf("the last char is %c\n",temp_line[len-1]);
   //if(temp_line[len-1]=='s') { for(i=0;i< len-2;i++)
            
	for(i=0;i<strlen(temp_line);i++)
	{	if(temp_line[i]==' ')
			break;	
		else
			op1[i]=temp_line[i];
	}
	op1[i]='\0';
	int j,k=0;
	for(j=i+1;j<strlen(temp_line);j++)
	{	if(temp_line[j]==' ')
			break;	
		else
	op2[k++]=temp_line[j];
	}
	op2[k]='\0';
	opr=temp_line[j+1];
	int op11,op22;
	op11=atoi(op1);
	op22=atoi(op2);
  
	sprintf(temp_line,"%d",MainCalculator(op11,op22,opr));
                
	return_value = write(connection_file_descriptor, temp_line, strlen(temp_line));
	temp_line[0]='\0';
	//}

	/*if(temp_line[0]=='s')
	{
		int opnd1=0;		
		int i;
	for(i=1;i<strlen(temp_line);i++)
			opnd1=opnd1*10+temp_line[i]-'0';
	printf("\nsquare root of %d is:%lf\n",opnd1,sqrt(opnd1));
	sprintf(temp_line,"%lf",sqrt(opnd1));
	return_value = write(connection_file_descriptor, temp_line, strlen(temp_line));
	temp_line[0]='\0';
	}
	if(temp_line[0]=='u')
	{
		int opnd1=0;		
		int i;
	for(i=1;i<strlen(temp_line);i++)
			opnd1=opnd1*10+temp_line[i]-'0';
	//printf("\nsquare root of %d is:%lf\n",opnd1,sqrt(opnd1));
		sprintf(temp_line,"%lf",sin (opnd1*PI/180));
		return_value = write(connection_file_descriptor, temp_line, strlen(temp_line));
	temp_line[0]='\0';
	}
	if(temp_line[0]=='v')
	{
		int opnd1=0;		
		int i;
	for(i=1;i<strlen(temp_line);i++)
			opnd1=opnd1*10+temp_line[i]-'0';
	//printf("\nsquare root of %d is:%lf\n",opnd1,sqrt(opnd1));
		sprintf(temp_line,"%lf",cos (opnd1*PI/180));
		return_value = write(connection_file_descriptor, temp_line, strlen(temp_line));
	temp_line[0]='\0';
	}
   ******************************************** ** */
	if(return_value < 0)
	{
	    perror("write() failed.");
	    exit(1);
	}
	
	return_value = close(connection_file_descriptor);

	if(return_value <0)
	{
	    perror("close failed");
	    exit(1);
	}
    }        
    return 0;
}

