/** popup.c pops up a notification onscreen
 * @author Ankit Sharma,Rameez Meheboob
 * @date April 2008
 */
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <mysql/mysql.h> 

/** daemon_init() initializes the program as a daemon in the background
 * @returns void
 * @param void
 */
void daemon_init()
{
	int i;
	pid_t pid;
	char path[512];
	if((pid=fork())!=0)
	{
		exit(0);
	}
	setsid();
	signal(SIGHUP,SIG_IGN);
	if((pid=fork())!=0)
	{
		exit(0);
	}
	getcwd(path,512);
	chdir(path);
	umask(0);
	for(i=0;i<64;i++)
	{
		close(i);
	}
}

MYSQL *connection1;
MYSQL_RES *result;
MYSQL_ROW sqlrow;

/** ret_any_day_more adds any number of days to a given date and returns the new date
 * @returns void
 * @param mod_date is the date to which any number of days is to be added
 * @param dat pointer in which newly formed date will be returned
 * @param no is the number of days to be added
 */
void ret_any_day_more(char mod_date[15],char dat[15],int no)
{
	int return_value;
	char qry[100];
	sprintf(qry,"select DATE_ADD('%s',INTERVAL %d DAY)",mod_date,no);
	return_value =  mysql_query (connection1,qry);

	if (return_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
		result = mysql_use_result(connection1);
		if (result)
		{
			while ((sqlrow = mysql_fetch_row (result)))
			{
				strcpy(dat,sqlrow[0]);
			}
		}
		mysql_free_result(result);
	}
}

/** conv_date_integer converts a given date into its corresponding integer parts
 * @returns void
 * @param dt The date to be converted into integer parts
 * @param dat Pointer where day of dt will be returned as integer 
 * @param dat Pointer where month of dt will be returned as integer 
 * @param dat Pointer where year of dt will be returned as integer 
 */
void conv_date_integer(char dt[15],int *dat,int *mnt,int *yr)
{
	*dat=atoi(dt+8);
	*mnt=atoi(dt+5);
	*yr=atoi(dt);
	printf("\nconv_date_integer():database date:<%d/%d/%d>\n",*dat,*mnt,*yr);
}

/** create_new_date creates a date in the form of yyyy-mm-dd in a string format given the day, month and year
 * @returns void
 * @param dt pointer where the newly created date will be returned
 * @param d the day of the date
 * @param m the month of the date
 * @param y the year of the date
 */
void get_new_date(char dt[15],int d,int m,int y)
{
	if(d<10 && m<10)
		sprintf(dt,"%d-0%d-0%d",y,m,d);
	else if(d<10 && m>9)
		sprintf(dt,"%d-%d-0%d",y,m,d);
	else if(d>9 && m<10)
		sprintf(dt,"%d-0%d-%d",y,m,d);
	else
		sprintf(dt,"%d-%d-%d",y,m,d);
}

/** delete_event is calles to restore control back to console when popup window is closed
 * @returns False
 * @param widget gtk widget type
 */
gint delete_event( GtkWidget *widget,GdkEvent  *event,gpointer   data )
{
	gtk_main_quit ();
	return(FALSE);
}

/** main function where the program starts working
 * @return zero on success
 * @param argc number of command line arguments
 * @param argv actual command line arguments
 */
int main( int   argc,char *argv[])
{
	daemon_init();

	GtkWidget *window;
	GtkWidget *table;
	GtkWidget *label_question;
	char server[30],dbuser[30],dbpassword[30],dbname[30],lbl[100],qry[300];
	char g_dt[15],g_day[5],g_ed[15],g_ew[15],g_currdate[15],g_curday[5],temp[100],tm[15],tag[5],dat[15],t[10];
	int i,result,g_hour,g_min,g_o,g_d,g_w,g_m,g_y,g_eo,g_em,g_ey,g_curmnth,g_curyr,type,dd,mm,yy;

	strcpy(server,"localhost");
	strcpy(dbuser,"alarm_user");
	strcpy(dbpassword,"alarm_password");
	strcpy(dbname,"alarm");

	connection1 = mysql_init (NULL);
	if (!connection1)
	{
		fprintf (stderr, "MySQL initialization failed\n");
		exit(EXIT_FAILURE);
	}	

	connection1=mysql_real_connect (connection1, server,dbuser,dbpassword,dbname, 0, NULL, 0);

	if (connection1)
	{
		printf ("Connection successful\n");
	}
	else
	{
		printf ("Connection failed\n");
		return -1;
	}


	gtk_init (&argc, &argv);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	strcpy(g_dt,argv[1]);
	strcpy(g_day,argv[2]);
	g_hour=atoi(argv[3]);
	g_min=atoi(argv[4]);
	g_o=atoi(argv[5]);
	g_d=atoi(argv[6]);
	g_w=atoi(argv[7]);
	g_m=atoi(argv[8]);
	g_y=atoi(argv[9]);
	g_eo=atoi(argv[10]);
	strcpy(g_ed,argv[11]);
	strcpy(g_ew,argv[12]);
	g_em=atoi(argv[13]);
	g_ey=atoi(argv[14]);
	strcpy(g_currdate,argv[15]);
	g_curmnth=atoi(argv[16]);
	g_curyr=atoi(argv[17]);
	strcpy(g_curday,argv[18]);
	type=atoi(argv[19]);

	strcpy(lbl,"");

	for(i=20;i<argc;i++)
	{
		strcat(lbl,argv[i]);
		strcat(lbl," ");
		/*printf("<%s>",lbl);*/
	}
	lbl[strlen(lbl)-1]='\0';


	if(g_o==1)
	{
		sprintf(qry,"delete from ers where hour=%d and min=%d and event='%s' and dt='%s'",g_hour,g_min,lbl,g_dt);
		strcpy(t,"Once");
		printf("The QUERY %s",qry);
		result=mysql_query(connection1,qry);
		if(result)
			printf("g_o failed\n");
	}
	else if(g_d==1)
	{
		sprintf(qry,"update ers set ed='%s' where hour=%d and min=%d and event='%s' and dt='%s'",g_currdate,g_hour,g_min,lbl,g_dt);  
		strcpy(t,"Daily");
		printf("The QUERY %s",qry);
		result=mysql_query(connection1,qry);
		if(result)
			printf("g_d failed\n");
	}
	else if(g_w==1)
	{
		ret_any_day_more(g_dt,dat,7);
		sprintf(qry,"update ers set dt='%s', ew='%s' where hour=%d and min=%d and event='%s' and day='%s' and dt='%s'",dat,g_currdate,g_hour,g_min,lbl,g_curday,g_dt); 
		strcpy(t,"Weekly");
		printf("The QUERY %s",qry);
		result=mysql_query(connection1,qry);
		if(result)
			printf("g_w failed\n");
	}
	else if(g_m==1)
	{
		conv_date_integer(g_dt,&dd,&mm,&yy);
		if((g_curmnth+1)>12)
			get_new_date(dat,dd,1,yy+1);
		else
			get_new_date(dat,dd,g_curmnth+1,yy);

		if(g_curmnth==12)
		    g_curmnth=0;

		sprintf(qry,"update ers set dt='%s', em=%d where hour=%d and min=%d and event='%s' and dt='%s'",dat,g_curmnth,g_hour,g_min,lbl,g_dt);
		strcpy(t,"Monthly");
		printf("The QUERY %s",qry);
		result=mysql_query(connection1,qry);
		if(result)
			printf("g_m failed\n");
	}
	else if(g_y==1)
	{
		conv_date_integer(g_dt,&dd,&mm,&yy);
		get_new_date(dat,dd,mm,g_curyr+1);

		sprintf(qry,"update ers set dt='%s', ey=%d where hour=%d and min=%d and event='%s' and dt='%s'",dat,g_curyr,g_hour,g_min,lbl,g_dt);
		strcpy(t,"Yearly");
		printf("The QUERY %s",qry);
		result=mysql_query(connection1,qry);
		if(result)
			printf("g_y failed\n");
	}

	strcpy(tag,"AM");

	if(g_hour>=13)
	{
		g_hour-=12;
		strcpy(tag,"PM");
	}
	else if(g_hour==0)
		g_hour+=12;

	if(g_hour<10 && g_min<10)
		sprintf(tm,"0%d:0%d %s",g_hour,g_min,tag);
	else if(g_hour<10 && g_min>9)
		sprintf(tm,"0%d:%d %s",g_hour,g_min,tag);
	else if(g_hour>9 && g_min<10)
		sprintf(tm,"%d:0%d %s",g_hour,g_min,tag);
	else
		sprintf(tm,"%d:%d %s",g_hour,g_min,tag);


	if(type==1)
		sprintf(temp,"You Have Missed Event: '%s' \nScheduled for: '%s' \nAt: %s\nEvent type: %s",lbl,g_dt,tm,t);
	else if(type==2)
		sprintf(temp,"You Have Event: '%s' \nScheduled for: '%s' \nAt: %s\nEvent type: %s",lbl,g_dt,tm,t);

	label_question=gtk_label_new(temp);    	
	gtk_window_set_title (GTK_WINDOW (window), "Event Reminder");
	gtk_window_set_default_size(GTK_WINDOW(window),120,80);
	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER_ALWAYS);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",GTK_SIGNAL_FUNC (delete_event), NULL);
	gtk_container_set_border_width (GTK_CONTAINER (window), 20);
	table = gtk_table_new (1, 1, TRUE);
	gtk_container_add (GTK_CONTAINER (window), table);
	gtk_table_attach_defaults (GTK_TABLE(table), label_question, 0, 1, 0, 1);
	gtk_widget_show (label_question);
	gtk_widget_show (table);
	gtk_widget_show (window);


	gtk_main ();
	mysql_close(connection1);

	return 0;
}
