/**
*   @file downloadmanager.c
*   @brief This is the main file for the download manager.
*
*   @author Anshul Gupta,Nikhil Jain
*
*   @date 3/31/2010
*/
#include <gtk/gtk.h>
#include<sqlite3.h>		
#include <unistd.h>		
#include <stdio.h>		
#include <stdlib.h>		
#include <string.h>		
#include <strings.h>		
#include <sys/socket.h>		
#include <sys/types.h>		
#include <time.h>		
#include <signal.h>		
#include <poll.h>
#include <pthread.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <errno.h>
#include<time.h>
#include <fcntl.h>
#include <arpa/inet.h>	
#include <netinet/in.h>	
		
#include "stack.h"

#define SIZE 5000
#define BUFFERSIZE 4096
#define BUFFER 4096

/**
  * This structure contains details for the thread handler to work.
  */
typedef struct 
{
	int id;
	char request[SIZE];
	char filename[SIZE];
	char fname[SIZE];
	char fpath[SIZE];
	char host[SIZE];
}download_details;

download_details reqarray[10]; 

// sqlite variables for the sqlite3 database
sqlite3 *database1,*database2;
char tempvalue[50];

// general global program variables
char proxy[SIZE];
char port[SIZE];
char dpath[SIZE];
char display[SIZE];
char tempbreak[SIZE];
pthread_t threadid[SIZE];
char host[200];
Stack s1;
char downloadpath[5][1000];
int flag[5]={0,0,0,0,0};
int fd[SIZE];
int notfound;
char finalname[SIZE];
int forbidden;
char remains[5000];
int gateway;
int moved;
int bad;
int goingon[5];

//main window widgets
GtkWidget *menupane;
GtkWidget *framedownload;
GtkWidget *top_Level_Main_Window;
GtkWidget *filemenu;
GtkWidget *menu;
GtkWidget *editmenu;
GtkWidget *temp;
GtkWidget *newdownloadmenu;
GtkWidget *hpaneforprogressbar;
GtkWidget *submenuforfile;
GtkWidget *setproxymenu;
GtkWidget *helpmenu;
GtkWidget *submenuforhelp;
GtkWidget *help;
GtkWidget *setpathmenu;
GtkWidget *exitmenu;
GtkWidget *submenuforedit;
GtkWidget *infomenu;
GtkWidget *viewmenu;
GtkWidget *cleardownloads;
GtkWidget *viewdownloadsmenu;
GtkWidget *submenuforview;
GtkWidget *tabs;
GtkWidget *tempbutton,*tempbutton1;
GtkWidget *tablabelproxy,*tablabelport,*tablabeldownload;
GtkWidget *vboxforpbar,*vboxfortab1,*vboxfortab2,*vboxfortab3;
GtkWidget *labelproxy1,*labelproxy2;
GtkWidget *labelport1,*labelport2;
GtkWidget *labeldownload1,*labeldownload2;
GtkWidget *tabproxybutton;
GtkWidget *tabportbutton;
GtkWidget *tabdownloadbutton;
GtkWidget *tabviewdloadbutton;
GtkWidget *tabnewdloadbutton;
GtkWidget *tplabel[15];
GtkWidget *tooltipfortab1,*tooltipfortab2,*tooltipfortab3;
GtkWidget *progressbar[5];
GtkWidget *progressbartitle[5];
GtkWidget *progressbarstop[5];
GtkWidget *tempprogressbar[5];
GtkWidget *hboxforpbar[5];
GtkWidget *tabframe1,*tabframe2,*tabframe3;
GtkWidget *tmp[50];
GtkWidget *hsep[5];
int tp=0;
int p=0;
int t=0;
int hp=0;

//proxywindow widgets
GtkWidget *proxywindow;
GtkWidget *noproxylabel;
GtkWidget *noproxyentry;
GtkWidget *noproxyhbox;
GtkWidget *vboxforoptions;
GtkWidget *proxyadd;
GtkWidget *portadd;
GtkWidget *proxylabel;
GtkWidget *portlabel;
GtkWidget *mainlabel;
GtkWidget *submitproxy;
GtkWidget *proxyhbox;
GtkWidget *porthbox;
GtkWidget *templabel,*templabel1,*templabel2,*templabel3,*templabel4,*templabel10,*templabel11;
GtkWidget *hboxforsubmit;
GtkWidget *framedownload1;

//set default path window
GtkWidget *dpathwindow;
GtkWidget *dpathmainlabel;
GtkWidget *pathchooser;
GtkWidget *dpathentry;
GtkWidget *dpathsubmit,*dpathexit;
GtkWidget *vboxfordpath;
GtkWidget *hboxforpath;
GtkWidget *hboxforsubmit;
GtkWidget *templabel5,*templabel6,*templabel7,*templabel8,*templabel9;

//new download window
GtkWidget *newdownloadwindow;
GtkWidget *ndmainlabel;
GtkWidget *URLlabel;
GtkWidget *savetolabel;
GtkWidget *filenamelabel;
GtkWidget *URLentry;
GtkWidget *filenameentry;
GtkWidget *savetoentry;
GtkWidget *submitdownload;
GtkWidget *exitdownload;
GtkWidget *vboxfordownload;
GtkWidget *hboxforURL,*hboxforsave,*hboxforfilename,*hboxforsubmitd;
GtkWidget *templabel12,*templabel13,*templabel14,*templabel15,*templabel16,*templabel17,*templabel18;
GtkWidget *filechooser;

// view downloads page
GtkWidget *vdmainlabel;
GtkWidget *treeview;
GtkListStore *liststoredownload;
GtkWidget *viewdownloadwindow;
GtkTreeIter iter;
GtkCellRenderer *renderer;
GtkTreePath *path;
GtkTreeViewColumn  *col;

// info window
GtkWidget *infonotebook;
GtkWidget *releaselabel;
GtkWidget *readmelabel;
GtkWidget *infowindow;
GtkWidget *releasepage;
GtkWidget *readmepage;
GtkWidget *releasenote[11];
GtkWidget *readmenote[12];

// helpwindow
GtkWidget *helpwindow;
GtkWidget *helplabels[16];
GtkWidget *helpvbox;

//GTK declaration of functions
int createdefaultpathwindow(int,char*[]);
int createhelpwindow(int,char *[]);
int createinfowindow(int ,char *[]);
int createproxywindow(int,char*[]);
void dialogerror(gchar [200]);
int createnewdownloadwindow(int ,char *[]);
int createviewdownloadwindow(int,char *[]);
void buttonclicked(GtkButton *,gpointer);
void pathselected(GtkFileChooser *,gpointer);
gint window_delete_event(GtkWidget *, gpointer);
gint hidewindow(GtkWidget *, gpointer);

//databse related function
/**
  * This is used to break the strings by adding \n to it when
  * the length of the string is more than 30 bytes. The string is 
  * broken in chunks of 30 bytes.
  *
  * @returns The string broken from the original string
  * @param str The input string to be broken(character array)
  *
  */
char* breakstring(char str[SIZE]);
static int callback (void *, int , char **, char **);
static int callback1(void *, int , char **, char **);
int connect_to_db();
int connect_to_db1();

/**
  * The function is used to fetch proxy,port,path from the database.
  *
  * @returns The path,proxy,path from the database.
  * @param id The id whose value is to be fetched(dpath,proxy,port).
  *
  */
char * return_data(char id[20]);

/**
  * The function is used to insert filename,path,size,date of download of the file in the database.
  * @returns 1 if the insertion in database is done correctly.
  * @param name filename to be downloaded.
  * @param path path of the file to be downloaded.
  * @param size size of the file to be downloaded.
  * @param date date of download.
  * @param time time taken to download the file
  *
  */
int insert_data(char name[200],char path[200],int size,char date[200],char time[200]);
void show_data();

/**
  * The function is called as a result of executing the any query 
  * on the downloads database to append the results to the liststore.
  *
  * @returns TRUE if the query was executed properly, FALSE otherwise. 
  * @param id The field we want to update like dpath,proxy or port. 
  * @param key The value to be updated to.
  *
  */
int update_values(char id[20],char key[200]);

//HTTP URL related function
/**
  * The function is used to get the length of the file requested.
  * @returns the length of the URL in bytes requested.
  * @param message the response string received from the server.
  *
  */
int getlength(char message[SIZE]);
void *threadHandler(void *);

/**
  * The function is used to get the host name from the URL.
  * @returns extracts the host string from the URL string. 
  * @param url exact URL filename from the UI.
  *
  */
char *hostextractor(char url[]);

/**
  * The function is used to get the name of the file from the URL requested.
  * @returns the name of the file from the file string. 
  * @param namefile exact URL filename from the UI.
  *
  */
char * nameextractor(char namefile[SIZE]);

/**
  * The function is used to get the tell whether the URL requested is appended with HTTP or not.
  * @returns 1 if http is present at the start else 0. 
  * @param url exact URL filename from the UI.
  *
  */
int checkhttp(char url[]);



/**
  * This is used to break the strings by adding \n to it when
  * the length of the string is more than 30 bytes. The string is 
  * broken in chunks of 30 bytes.
  *
  * @returns The string broken from the original string
  * @param str The input string to be broken(character array)
  *
  */
char* breakstring(char str[SIZE])
{
	strcpy(tempbreak,"");
	int i;
	int b=0;
		
	//breal the string in chunks of 30 bytes
	for(i=0;i<strlen(str);i++)
	{
		if(i%30==0 && i!=0)
		{
			tempbreak[b++]=10;
		}
		else
		{
			tempbreak[b++]=str[i];
		}
	}
	tempbreak[b++]='\0';

	//return the broken string
	return tempbreak;

}

/**
  * This function is used to delete the files whose downloading is going on
  * when cntrl+c is pressed.
  *
  * @returns Nothing
  * @param signal The signal which is generated
  *
  */
void close_properly (int signal)
{
	int i;
	for(i=0;i<5;i++)
	{
		if(goingon[i]==1)
		{
			close(fd[i]);
		
			char del[200];
			//delete the file created
			sprintf(del,"rm -f %s",reqarray[i].filename);
			//printf("%s\n",del);		
			system(del);
		
		}
	}	
	exit(1);
	//printf("nikhil\n");
}

/**
  * The function is called as a result of executing the any query 
  * on the settings database to return the answer to the query.
  *
  * @returns 0 
  * @param NotUsed Normally assigned value 0 can be used for other purposes
  * @param argc Number of columns in the result
  * @param argv The values of all the columns. 
  * @param azColName The column headers
  */
static int callback (void *NotUsed, int argc, char **argv, char **azColName)
{
	NotUsed = 0;
	
	//copy the path proxy or the port no to the tempvalue to be used in the main function
	strcpy(tempvalue,argv[1]);
	return 0;
}

/**
  * The function is called as a result of executing the any query 
  * on the downloads database to append the results to the liststore.
  *
  * @returns 0 
  * @param NotUsed Normally assigned value 0 can be used for other purposes. 
  * @param argc Number of columns in the result
  * @param argv The values of all the columns. 
  * @param azColName The column headers
  */
static int callback1(void *NotUsed, int argc, char **argv, char **azColName)
{
	
	NotUsed = 0;
	
	//populate the liststore fow showing the downloads
	gtk_list_store_append(liststoredownload, &iter);
	gtk_list_store_set((liststoredownload),&iter,0,argv[0],1,argv[1],2,(guint)(atoi(argv[2])),3,argv[3],4,argv[5],-1);
	return 0;
}

/**
  *The function is used to clear the details of all downloads from the downloads database.
  *
  * @returns TRUE on successfull deletion, FALSE otherwise 
  */
int cleardownloaddetails()
{
	char sql_statement[BUFFER];
	int rc;
	char *zErrMsg = 0;

	//constrcu and fire the query for getting the path proxy or port number
	sprintf(sql_statement, "delete from ddetails");
	rc = sqlite3_exec (database2, sql_statement, callback, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "SQL error: %s\n", zErrMsg);
		return 0;
	}
	return 1;
}
/**
  * The function connects the application to the settings.sqlite3
  * database.
  *
  * @returns TRUE on successfull connection, FALSE otherwise 
  */
int connect_to_db()
{
	int rc;
	char name[200]="settings.sqlite3";

	//open and connect to the databasee settings.sqlite3
	rc = sqlite3_open (name, &database1);
	if (rc)
	{
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (database1));
		sqlite3_close (database1);
		return 0;
	}
	return 1;
}
/**
  * The function connects the application to the downloads.sqlite3
  * database.
  *
  * @returns TRUE on successfull connection, FALSE otherwise 
  *
  */
int connect_to_db1()
{
	int rc;
	char name[200]="downloads.sqlite3";
	// open and connect to the database downloads.sqlite3
	rc = sqlite3_open (name, &database2);
	if (rc)
	{
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (database2));
		sqlite3_close (database2);
		return 0;
	}
	return 1;
}

/**
  * The function is used to fetch proxy,port,path from the database.
  *
  * @returns The path,proxy,path from the database.
  * @param id The id whose value is to be fetched(dpath,proxy,port).
  *
  */
char * return_data(char id[20])
{
	char sql_statement[BUFFER];
	int rc;
	char *zErrMsg = 0;

	//constrcu and fire the query for getting the path proxy or port number
	sprintf(sql_statement, "SELECT * from settings where name='%s'", id);
	rc = sqlite3_exec (database1, sql_statement, callback, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "SQL error: %s\n", zErrMsg);
	}
	return tempvalue;
}

/**
  * The function is used to insert filename,path,size,date of download of the file in the database.
  * @returns 1 if the insertion in database is done correctly.
  * @param name filename to be downloaded.
  * @param path path of the file to be downloaded.
  * @param size size of the file to be downloaded.
  * @param date date of download.
  * @param time time taken to download the file
  *
  */
int insert_data(char name[200],char path[200],int size,char date[200],char time[200])
{
	char sql_statement[BUFFER];
	int rc;
	char *zErrMsg = 0;

	//construct and fire the query to insert the details in the downloads database
	sprintf(sql_statement, "insert into ddetails values('%s','%s',%d,'%s','%s','%s')",name,path,size,date,"nikhil",time);
	rc = sqlite3_exec (database2, sql_statement, callback1, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "SQL error: %s\n", zErrMsg);
	}
	return 1;

}

/**
  * The function fires the query to the downloads database to get 
  * all the download details till now.
  *
  * @returns Nothing 
  *
  */
void show_data()
{
	char sql_statement[BUFFER];
	int rc;
	char *zErrMsg = 0;
	
	//construct and fire the query for getting the details related to the downloads to be shown in view downloads
	sprintf(sql_statement, "SELECT * from ddetails");
	rc = sqlite3_exec (database2, sql_statement, callback1, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "SQL error: %s\n", zErrMsg);
	}
	
}

/**
  * The function is called as a result of executing the any query 
  * on the downloads database to append the results to the liststore.
  *
  * @returns TRUE if the query was executed properly, FALSE otherwise. 
  * @param id The field we want to update like dpath,proxy or port. 
  * @param key The value to be updated to.
  *
  */
int update_values(char id[20],char key[200])
{
	char sql_statement[BUFFER];
	int rc;
	char *zErrMsg = 0;

	//construct and fire the update query for updating the values of path,port or proxy
	sprintf(sql_statement, "UPDATE settings set value='%s' where name='%s'", key,id);
	rc = sqlite3_exec (database1, sql_statement, callback, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		return 0;
		printf("Conditions to modify are not correct\n");
	}
	return 1;
}

/**
  * The function is the signal handler for the the file chooser 
  * when we choose the path of the directory from it.
  *
  * @returns Nothing 
  * @param chooser the object which received the signal. 
  * @param user_data user data set when the signal handler was connected.
  *
  */
void pathselected(GtkFileChooser *chooser,gpointer user_data)
{
	if(chooser==GTK_FILE_CHOOSER(filechooser)) // download windows file chooser
	{
		// get the folder name selected
		gchar *path=gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(filechooser));
		printf("file chooser activated\n");
		gtk_entry_set_text(GTK_ENTRY(savetoentry),path);
		
		
	}
	else if(chooser==GTK_FILE_CHOOSER(pathchooser))// file chooser for the dpath window
	{
		//get the folder name selected
		gchar *path=gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(pathchooser));
		printf("file chooser activated\n");
		gtk_entry_set_text(GTK_ENTRY(dpathentry),path);
	}
}


/**
  * The function is the signal handler for the closing window when 
  * we click on the cross symbol on the top of the window.
  *
  * @returns TRUE to stop other handlers from being invoked for the event. FALSE to propagate the event further. 
  * @param widget1 the object which received the signal
  * @param data user data set when the signal handler was connected.
  *
  */
gint window_delete_event(GtkWidget *widget1, gpointer data)
{
	// close the window(main)
	int i;
	for(i=0;i<5;i++)
	{
		if(goingon[i]==1)
		{
			close(fd[i]);
		
			char del[200];
			//delete the file created
			sprintf(del,"rm -f %s",reqarray[i].filename);
			//printf("%s\n",del);		
			system(del);
		
		}
	}	
	gtk_main_quit();
	return TRUE;
	
}

/**
  * The function is the signal handler for hiding all the windows
  * except the main ones when they are closed.
  *
  * @returns TRUE to stop other handlers from being invoked for the event. FALSE to propagate the event further. 
  * @param widget1 the object which received the signal
  * @param data user data set when the signal handler was connected.
  *
  */
gint hidewindow(GtkWidget *widget1, gpointer data)
{
	// hide the window and then close it
	gtk_widget_hide(widget1);
	gtk_main_quit();
	return TRUE;
	
}

/**
  * The function is used to get the length of the file requested.
  * @returns the length of the URL in bytes requested.
  * @param message the response string received from the server.
  *
  */
int getlength(char message[SIZE])
{
	//return 1;
	int i=0;
	int l=0;
	int j=0,there=0;
	char length[50];
//	printf("length of the message in getlength is:%d\n",strlen(message));
	for(i=0;i<strlen(message);i++)
	{
		
		if(message[i]=='3' && message[i+1]=='0' && message[i+2]=='2' && message[i+4]=='M') // check for the gateway time out error
		{
			
			moved=1;
		}
		if(message[i]=='5' && message[i+1]=='0' && message[i+2]=='4' && message[i+4]=='G') // check for the gateway time out error
		{
			
			gateway=1;
		}
		if(message[i]=='4' && message[i+1]=='0' && message[i+2]=='0' && message[i+4]=='B')// check for the bad request error
		{
			
			bad=1;
		}
		if(message[i]=='4' && message[i+1]=='0' && message[i+2]=='3' && message[i+4]=='F') // check for the forbidden resource error
		{
			printf("forbidden\n");
			forbidden=1;
		}
		else if(message[i]=='4' && message[i+1]=='0' && message[i+2]=='4' && message[i+4]=='N') // check for the file not found error
		{
			notfound=1;
		}
		if(message[i]=='C' && message[i+1]=='o' && message[i+13]=='h') // to get the content length
		{
			j=i+16;
			for(;message[j]!='\n';j++)
			{
				length[l++]=message[j];
			}
			length[l++]='\0';
			there=1;
			break;
		}
	}
	if(there==0)
		return 0;
//	printf("------------%s\n",length);
	
	//return the length of the response or the size of the file
	return atoi(length);
}

/**
  * The function is used to return the data after the newline i.e after the 
  * http response from the proxy.
  * @returns The remaining data after newline
  * @param message2 The first response sent by the proxy to the http request
  * @param mlen The size of the message 2 paramater.
  *
  */
int remainingdata(char message2[5000],int mlen)
{
	int i;
	int j;
	strcpy(remains,"");
	int r=0;
//	printf("length of the message is:%d\n",strlen(message2));
	for(i=0;i<mlen;i++)
	{
		if(message2[i]=='\n' && message2[i+1]=='\r' && message2[i+2]=='\n') // check for the \n \r\n
		{
			
			//printf("in remaining data function:%c %c\n",message2[j-1],message2[j]);
			//printf("j's value is:%d\n",j);
			for(j=i+3;j<mlen;j++)
			{
				//printf("%d\n",j);
				//printf("%d\n",r);
				//printf("<%d>\n",message2[j]);
				//printf("%c",message[j]);
				remains[r]=message2[j];
				//printf("%c\n\n",remains[r]);
				r++;
				
			}
			//remains[r++]='\0';
			break;
		}
	}
	//printf("\nlalau%d\n",strlen(remains));
	
	return r;
	// return the remaining data	
	//return remains;
	
}
/**
  * The function used to generate a new download thread for 
  * every file from the UI.
  * @param arg1 the defualt void pointer passed to a string.
  *
  */
void *threadHandler(void *arg1)
{

	download_details *req;
    	double frac;
	char status[SIZE];
    	req = (download_details *)arg1;
    //	printf("in thread:%s\n",req->request);	

     	//printf("\n------ IN THERAD %s  ------\n",req->filename);
	flag[req->id]=1;

	struct sockaddr_in addr;
    	struct hostent *hp;
    	int soc;
    	char message[SIZE];
    	int msglen;
	notfound=0;
   
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progressbar[req->id]),0.0);
	gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Connecting. Please wait");
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progressbar[req->id]),"");
	
	//Get a socket
	if((soc = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		fprintf(stderr,"Couldn't get a socket.\n"); 
		//close(soc);          /* timeout */
		push(&s1,req->id);
	        gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Could'nt get a Socket");	
	  
	        pthread_exit(NULL);
	
	}
	else
	{
		fprintf(stderr,"Got a socket.\n");
		
	}   
  	int flags, n, error;
  	socklen_t len;
  	fd_set rset, wset;
  	struct timeval tval;
  	int nsec = 6;
  	flags = fcntl(soc, F_GETFL, 0);
  	fcntl(soc, F_SETFL, flags | O_NONBLOCK);

	memset(&addr,0,sizeof(addr));

	//Get address for proxy
	if(strcmp(proxy,"")!=0)
	{
		if((hp = gethostbyname(proxy)) == NULL)
		{
		
			fprintf(stderr,"Couldn't get an address.\n");
			fprintf(stderr,"\nTimeout error!\n");
			close(soc);          /* timeout */
			push(&s1,req->id);
	        	gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Please check your proxy settings");	
	  
	        	pthread_exit(NULL);
		}
		else 
		{
		//	printf("%s\n",(char *)hp->h_addr);
		       // fprintf(stderr,"Got an address.\n");
		}
	}
	else
	{
		if((hp = gethostbyname(req->host)) == NULL)
		{
		
			fprintf(stderr,"Couldn't get an address.\n");
			fprintf(stderr,"\nTimeout error!\n");
			close(soc);          /* timeout */
			push(&s1,req->id);
	        	gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Please check your proxy settings");	
	  
	        	pthread_exit(NULL);
		}
		else 
		{
			//printf("%s\n",(char *)hp->h_addr);
		        //fprintf(stderr,"Got an address.\n");
		}
	}

    	//bcopy is deprecated also, using memcpy instead
	memcpy((char *)&addr.sin_addr.s_addr, (char *)hp->h_addr, hp->h_length);

    	//fill int port number and type
	if(strcmp(proxy,"")!=0)
		addr.sin_port = htons(atoi(port));
	else
		addr.sin_port=htons(80);
	addr.sin_family = AF_INET;
	error = 0;
    	if ( (n = connect(soc, (struct sockaddr *)&addr, sizeof(addr))) < 0)
         	if (errno != EINPROGRESS)
		{
			push(&s1,req->id);
         		fprintf(stderr,"\nconnect error!\n");
	  		pthread_exit(NULL);
		}	

	/* Do whatever we want while the connect is taking place. */

     	if (n == 0)
        	 goto done;               /* connect completed immediately */

     	FD_ZERO(&rset);
     	FD_SET(soc, &rset);
     	wset = rset;
     	tval.tv_sec = nsec;
     	tval.tv_usec = 0;
	
	// select to check for connection error
     	if ( (n = select(soc + 1, &rset, &wset, NULL,nsec ? &tval : NULL)) == 0) 
	{
	         close(soc);          /* timeout */
		 push(&s1,req->id);
	         fprintf(stderr,"\nTimeout error!\n");
		 gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Could not Connect. Check your proxy settings if any or the connection status");
	         errno = ETIMEDOUT;
	         pthread_exit(NULL);
       }

	if (FD_ISSET(soc, &rset) || FD_ISSET(soc, &wset))
        {
        	 len = sizeof(error);
       		 if (getsockopt(soc, SOL_SOCKET, SO_ERROR, &error, &len) < 0)
             		 pthread_exit(NULL);     /* Solaris pending error */
        }
	else
        	 fprintf(stderr,"\nselect error: soc not set");

	done:
     	fcntl(soc, F_SETFL, flags);  /* restore file status flags */
     	
	if (error)
	{
	         close(soc);           /* just in case */
	         errno = error;
	    	 pthread_exit(NULL);
	}
    
     	//NOW THE HTTP PART!!!
    		
		
   	//send the request
	int characters_written = write(soc ,req->request, strlen(req->request));
	if(characters_written<0)
	{
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Could not send the request. Try after some time");
		//dialogerror("cound not locate the resource. Please check the URL\n");
		push(&s1,req->id);
		moved=0;
		pthread_exit(NULL);
	}
	//printf("%d",characters_written);   
	double data1=0;   
	long int data=0,m=1,count=0;
	double after=0.0;
	

	//read the response
	
	msglen = read(soc,message,768);
	message[msglen]='\0';
	//fprintf(stderr,"%s\n",message);
	//fprintf(stderr,"original first read masglen:%d %d\n",msglen,strlen(message));   
	long int length=getlength(message);
	
	if(length>10000000)
		after=0.01;
	else
		after=0.05;

	//check for the error flows
	if(moved==1)
	{
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Resource is moved to a different location");
		//dialogerror("cound not locate the resource. Please check the URL\n");
		push(&s1,req->id);
		moved=0;
		pthread_exit(NULL);
	}
	if(notfound==1)
	{
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"cound not locate the resource. Please check the URL");
		//dialogerror("cound not locate the resource. Please check the URL\n");
		push(&s1,req->id);
		notfound=0;
		pthread_exit(NULL);
	}
	else if(forbidden==1)
	{
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"The resource is forbidden to be downloaded");
		//dialogerror("cound not locate the resource. Please check the URL\n");
		push(&s1,req->id);
		forbidden=0;
		pthread_exit(NULL);
	}
	else if(gateway==1)
	{
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Gateway time out");
		//dialogerror("cound not locate the resource. Please check the URL\n");
		push(&s1,req->id);
		gateway=0;
		pthread_exit(NULL);
	}
	else if(bad==1)
	{
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"Bad Request Error");
		//dialogerror("cound not locate the resource. Please check the URL\n");
		push(&s1,req->id);
		bad=0;
		pthread_exit(NULL);
	}
	
	//create new file as specified
	if ((fd[req->id] = open(req->filename, O_CREAT | O_RDWR, 0644)) < 0)
	{
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),"You dont have enough memory or permission for creation of the new file");
	    	//printf("open failed\nExiting Thread %s  ------\n",req->filename);
		push(&s1,req->id);
		pthread_exit(NULL);
	}	
	
	gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),req->fname);
	//printf("-----------------------------------------\n");
	
	goingon[req->id]=1;
	char per[10];
	int ans;
	int i;
	
	char ch='%';
	int time1,min,secs,hours;
	char timer[50];
	time_t result;
	double kbps;
	long int t1,t2,data2,diff,t3;
	int datawritten=0;
	struct tm* brokentime;
	int tempreturn=remainingdata(message,msglen);
	strcpy(per,"");
	
	// write the first response data back tothe file
	datawritten=write(fd[req->id],remains,tempreturn);
	//printf("%d\n",datawritten);
	data = data + tempreturn;
	data1 = data1 + tempreturn;
	result = time(NULL);
 	brokentime = localtime(&result);
  	t3=t1=(long int)result;
	
	// if the files are downloaded such that the conetent leength is not specified
	if(length==0)
	{
		//printf("in length==0");
		while(msglen>0)
		{
        		data = data + msglen;
			msglen = read(soc,message,BUFFERSIZE-2);
			write(fd[req->id],message,msglen);
		}	
		gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progressbar[req->id]),1.0);
		gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progressbar[req->id]),"100%");
		strcpy(status,req->fname);
		strcat(status,"  completed");
		gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),status);
		//printf("%ld\n",data);
		close(soc);   

		//close the file descriptor
    		close(fd[req->id]);     

		//push the id into the stack
		push(&s1,req->id);

		//take the time value
		time_t rawtime;
		time ( &rawtime );
	  	
		//store download details in the dtabase
		result = time(NULL);
 		brokentime = localtime(&result); 
 	 	t2=(long int)result;
		int timefield=t2-t3;
		int timemins=timefield/60;
		int timesecs=timefield%60;
		int timehours=timemins/60;
		timemins=timemins%60;
		char timetostore[200];
		sprintf(timetostore,"%d hours %d mins %d secs",timehours,timemins,timesecs);
		flag[req->id]=0;
		pthread_exit(NULL);
		return NULL;



	}
        
	
	//continiously write to the file read from the socket and update he progress bar and its titile
	while(msglen>0)
	{
		msglen = read(soc,message,BUFFERSIZE-2);
		write(fd[req->id],message,msglen);
		data = data + msglen;
		data1 = data1 + msglen;
		data2=data2+msglen;
		frac=(data1)/length;
		ans=frac*100;
		sprintf(per,"%d%c",ans,ch);
		//printf("%s\n",per);
		if(count==5)
		{
			//sprintf(per,"%d",ans);
			//printf("%ld\n",data);
			result = time(NULL);
 		 	brokentime = localtime(&result); 
  			t2=(long int)result;
			diff=t2-t1;
			t1=t2;
			if(diff==0)
				diff=1;
			if(data2!=0)
				time1=(length-data)/(data2/diff);
			min=time1/60;
			if(min>60)
			{
				hours=min/60;
				min=min%60;
			}
			else
			{
				hours=0;
			}
			secs=time1%60;
			kbps=(data2)/(diff*1024.0);
			if(hours==0)
				sprintf(timer,"%s %d mins %d secs remaining at %f kbps",req->fname,min,secs,kbps);
			else
				sprintf(timer,"%s %d hours %d mins %d secs remaining at %f kbps",req->fname,hours,min,secs,kbps);
			gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),timer);
			data2=0;
			gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progressbar[req->id]),frac);
			gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progressbar[req->id]),per);
		}
		if(frac>=1.0/1)
		{
			
			//printf("%ld\n",data);
			//printf("%lf\n",frac);
			result = time(NULL);
 		 	brokentime = localtime(&result); 
  			t2=(long int)result;
  		
			diff=t2-t1;
		
			t1=t2;
			if(diff==0)
				diff=1;
			if(data2!=0)
				time1=(length-data)/(data2/diff);
			
			min=time1/60;
			if(min>60)
			{
				hours=min/60;
				min=min%60;
			}
			else
			{
				hours=0;
			}
			secs=time1%60;
		
			kbps=(data2)/(diff*1024.0);
			if(hours==0)
				sprintf(timer,"%s %d mins %d secs remaining at %f kbps",req->fname,min,secs,kbps);
			else
				sprintf(timer,"%s %d hours %d mins %d secs remaining at %f kbps",req->fname,hours,min,secs,kbps);
			gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),timer);
			data2=0;
			gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progressbar[req->id]),1.0);
			gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progressbar[req->id]),per);
		}
		else if(frac>after*m)	
		{
			//printf("%ld\n",data);
			//printf("%lf\n",frac);
			result = time(NULL);
 		 	brokentime = localtime(&result); 
  			t2=(long int)result;
  		
			diff=t2-t1;
		
			t1=t2;
			if(diff==0)
				diff=1;
			if(data2!=0)
				time1=(length-data)/(data2/diff);
		
			min=time1/60;
			if(min>60)
			{
				hours=min/60;
				min=min%60;
			}
			else
			{
				hours=0;
			}
			secs=time1%60;
		
			kbps=(data2)/(diff*1024.0);
			if(hours==0)
				sprintf(timer,"%s %d mins %d secs remaining at %f kbps",req->fname,min,secs,kbps);
			else
				sprintf(timer,"%s %d hours %d mins %d secs remaining at %f kbps",req->fname,hours,min,secs,kbps);
			gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),timer);
			data2=0;
			gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progressbar[req->id]),frac);
			gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progressbar[req->id]),per);
			m++;
		}
		if(data>=length)
		{	
			break;
		}
		count++;
    	}   
	
	
	// temp loop for sync pupposes
	for(i=0;i<1000000;i++);
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progressbar[req->id]),1.0);
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progressbar[req->id]),"100%");
	strcpy(status,req->fname);
	strcat(status,"  completed");
	gtk_label_set_text(GTK_LABEL(progressbartitle[req->id]),status);
	result = time(NULL);
 	brokentime = localtime(&result); 
  	t2=(long int)result;
	int timefield=t2-t3;
	int timemins=timefield/60;
	int timesecs=timefield%60;
	int timehours=timemins/60;
	timemins=timemins%60;
	char timetostore[200];
	sprintf(timetostore,"%d hours %d mins %d secs",timehours,timemins,timesecs);
      
	//close the socket
    	close(soc);   

	//close the file descriptor
    	close(fd[req->id]);     
	

	//push the id into the stack
	push(&s1,req->id);

	//take the time value
	time_t rawtime;
	time ( &rawtime );
 
	//store download details in the dtabase
	insert_data(req->fname,req->fpath,length,ctime (&rawtime),timetostore);
	flag[req->id]=0;
	
	goingon[req->id]=0;
	//exit from the thread
	pthread_exit(NULL);
	return NULL;
}

/**
  * The function is used to get the host name from the URL.
  * @returns extracts the host string from the URL string. 
  * @param url exact URL filename from the UI.
  *
  */
char * hostextractor(char url[SIZE])
{
	int i,j;
	strcpy(host,"");
	int h=0;
	for(i=0;i<strlen(url);i++)
	{
		//check for the first occurring // in the URL
		if(url[i]=='/'&& url[i+1]=='/')
		{
			j=i+2;
			for(;url[j]!='/';j++)
			{
				host[h++]=url[j];
			}
			host[h++]='\0';
			break;
			
		}
	}
//	printf("%s\n",host);

	//return the host
	return host;
}

/**
  * The function is used to get the name of the file from the URL requested.
  * @returns the name of the file from the file string. 
  * @param namefile exact URL filename from the UI.
  *
  */
char * nameextractor(char namefile[SIZE])
{
	char tempname[SIZE];
	int tn=0,i;
	int fn=0;
	strcpy(finalname,"");
	for(i=strlen(namefile)-1;i>=0;i--)
	{
		// check for the first / in the reverse string
		if(namefile[i]=='/')
		{
			tempname[tn++]='\0';
			break;
		}
		else
		{
			tempname[tn++]=namefile[i];
		}
	}
//	printf("name of the file<%s>\n",tempname);
	
	//reverse the string again to get the right name	
	for(i=strlen(tempname)-1;i>=0;i--)
	{
		finalname[fn++]=tempname[i];
	}
	finalname[fn++]='\0';

	//return the filename
	return finalname;
}

/**
  * The function is used to get the tell whether the URL requested is appended with HTTP or not.
  * @returns 1 if http is present at the start else 0. 
  * @param url exact URL filename from the UI.
  *
  */
int checkhttp(char url[SIZE])
{
	//chech whether the url contains http:// at the begining or not
	if(url[0]=='h' && url[1]=='t' && url[2]=='t' && url[3]=='p' && url[4]==':' && url[5]=='/' && url[6]=='/')
		return 1;
	else
		return 0;
}

/**
  * The function is the signal handler for the clicks done 
  * on the buttons in various windows.
  *
  * @returns Nothing
  * @param button the object which received the signal
  * @param user_data user data set when the signal handler was connected.
  *
  */
void buttonclicked(GtkButton *button,gpointer   user_data) 
{
	int argc=1;
	char *argv[5];
	if(button==GTK_BUTTON(submitproxy)) //submit button for the proxy window
	{

		//get the prot number and proxy address
		char tempproxy[SIZE];
		strcpy(tempproxy,gtk_entry_get_text(GTK_ENTRY(proxyadd)));
		char tempport[SIZE];
		strcpy(tempport,gtk_entry_get_text(GTK_ENTRY(portadd)));
		
		//store in the database
		int ret=update_values("proxy",tempproxy);
		if(ret==1)
		{
			strcpy(proxy,tempproxy);
			
			//set the proxy value in the tabbed pane in the main window
			if(strlen(proxy)<=30 && strcmp(proxy,"")!=0)
			{
				gtk_label_set_text(GTK_LABEL(labelproxy2),proxy);
			}
			else if(strcmp(proxy,"")!=0)
			{
				char tb[200];
				strcpy(tb,breakstring(proxy));
				gtk_label_set_text(GTK_LABEL(labelproxy2),tb);
			}	
		}
		
		// do the same for port number
		ret=update_values("port",tempport);
		if(ret==1)
			strcpy(port,tempport);
		gtk_label_set_text(GTK_LABEL(labelport2),port);
		gtk_widget_hide(proxywindow);	
		gtk_main_quit();
	}
	else if(button==GTK_BUTTON(dpathsubmit)) // submit button of the path window
	{
		
		char tempdpath[SIZE];
		
		// get the dath value and update it
		strcpy(tempdpath,gtk_entry_get_text(GTK_ENTRY(dpathentry)));
		int ret=update_values("dpath",tempdpath);
		if(strcmp(tempdpath,"")==0 && strcmp(dpath,"")==0)
		{
			dialogerror("please select a default path");
			return;if(strcmp(tempdpath,"")==0 && strcmp(dpath,"")==0)
		{
			dialogerror("please select a default path");
			return;
		}
		}
		if(ret==1)
		{
			strcpy(dpath,tempdpath);

			// display it on the tabbed pane on the main screen
			if(strlen(dpath)<=30)
			{
				gtk_label_set_text(GTK_LABEL(labeldownload2),dpath);
			}
			else
			{
				char tb[SIZE];
				strcpy(tb,breakstring(dpath));
				gtk_label_set_text(GTK_LABEL(labeldownload2),tb);
			}
		
		}
		gtk_widget_hide(dpathwindow);
		gtk_entry_set_text(GTK_ENTRY(dpathentry)," ");
		gtk_main_quit();
	}
	else if(button==GTK_BUTTON(dpathexit)) // exit button of the path window
	{

		// close the dpath window
		gtk_widget_hide(dpathwindow);
		gtk_main_quit();
	}
	else if(button==GTK_BUTTON(submitdownload))// submit button of the download window
	{
		// take all the details from the window
		char URL[SIZE];
		char store[SIZE];
		char filename[SIZE];
		char hostname[SIZE];
		char getrequest[SIZE];
		strcpy(URL,gtk_entry_get_text(GTK_ENTRY(URLentry)));
		strcpy(filename,gtk_entry_get_text(GTK_ENTRY(filenameentry)));
		if(strcmp(URL,"")==0)
		{
			dialogerror("Please specify the download URL\n");
			return;
		}
		else
		{
			char tname[SIZE];
			char http[SIZE]="http://";
	
			// get the storage path
			strcpy(store,gtk_entry_get_text(GTK_ENTRY(savetoentry)));
			if(strcmp(dpath,"")==0 && strcmp(store,"")==0)
			{
				dialogerror("please select a default path or a path of dowload from here");
				return;
			}
			//printf("%s \n%s\n<%s>\n",URL,store,filename);
	
			//extract the host name
			strcpy(hostname,hostextractor(URL));
			//printf("%s\n",hostname);
	
			// extract the filename
			strcpy(tname,nameextractor(URL));

			//check for the starting http://
			int check=checkhttp(URL);
			if(check==0)
			{
				// prepend http://
				strcat(http,URL);
				strcpy(URL,http);
			}
			// construct the req array variable taking index from stack
			gtk_widget_hide(newdownloadwindow);
			gtk_main_quit();
			//check if the stack is full or not
			if(isempty(&s1))
			{
				dialogerror("U have reached the limits for maximum parallel downloads. Please try when any one downloads finish");
				return;
			}

			//take the value from the stack
			int index=pop(&s1);
			//printf("%d\n",index);
	
			//prepare GET request
			strcpy(getrequest,"GET ");
			strcat(getrequest,URL);
			strcat(getrequest," HTTP/1.1\nHost: ");
			strcat(getrequest,hostname);
			strcat(getrequest,"\nUser-Agent: Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.1.3) Gecko/20090909 Fedora/3.5.3-1.fc11 Firefox/3.5.3\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\nAccept-Language: en-us,en;q=0.5\nAccept-Encoding: \nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\nKeep-Alive: 300\nCache-Control: 1#no-cache\nProxy-Connection: keep-alive\n\n");
			//sprintf(getrequest,"%s","GET %s\nHost: %s\nFrom: Anshul!!!\nUser-Agent: Testing txt\n\n",URL,hostname);
			//printf("%s",getrequest);
	
			//store the get request and other details to be used by the thread			
			strcpy(reqarray[index].request,getrequest);
			reqarray[index].id=index;
			strcpy(reqarray[index].filename,store);
			strcat(reqarray[index].filename,"/");
			if(strcmp(filename,"")==0 && strcmp(tname,"")==0)
			{
				//printf("nikhil\n");
				strcat(reqarray[index].filename,"temp");
			}
			else if(strcmp(filename,"")==0)
			{
				//printf("anshul\n");
				strcat(reqarray[index].filename,tname);
			}
			else
			{
				//printf("jogi\n");
				strcat(reqarray[index].filename,filename);
			}
			//printf("filename is:%s\n",reqarray[index].filename);
			strcpy(reqarray[index].fpath,store);
			if(strcmp(filename,"")==0 && strcmp(tname,"")==0)
				strcpy(reqarray[index].fname,"temp");
			else if(strcmp(filename,"")!=0)
				strcpy(reqarray[index].fname,filename);
			else
				strcpy(reqarray[index].fname,tname);
			strcpy(reqarray[index].host,hostname);

			//create the new thread
			int return_value = pthread_create(&threadid[index], NULL,threadHandler, (void *)&reqarray[index]);
			if(return_value<0)
			{
				dialogerror("unexpected error. Please try after some time");
			}
		}
	}
	else if(button==GTK_BUTTON(exitdownload)) // exit button of the download page
	{
			
		//exit the new download window
		gtk_widget_hide(newdownloadwindow);
		gtk_main_quit();
	}
	else if(button==GTK_BUTTON(tabdownloadbutton)) // change settings button on port1
	{
		createdefaultpathwindow(argc,argv);
	}
	else if(button==GTK_BUTTON(tabproxybutton)) // change settings button on port1
	{
		createproxywindow(argc,argv);
	}
	else if(button==GTK_BUTTON(tabviewdloadbutton)) // change settings button on port1
	{
		createviewdownloadwindow(argc,argv);
	}
	else if(button==GTK_BUTTON(tabnewdloadbutton)) // change settings button on port1
	{
		createnewdownloadwindow(argc,argv);
	}
	else if(button==GTK_BUTTON(tabportbutton)) // change settings button on the tab2
	{
		createproxywindow(argc,argv);
	}
	else if(button==GTK_BUTTON(progressbarstop[0]) && flag[0]==1)
	{
		
		// perform all the thread closing activities
		close(fd[0]);
		gtk_label_set_text(GTK_LABEL(progressbartitle[0]),"download cancelled");
		flag[0]=0;
		fprintf(stderr,"canceling thread:%d",pthread_cancel(threadid[0]));
		char del[200];
		push(&s1,0);
		
		//delete the file created
		sprintf(del,"rm -f %s",reqarray[0].filename);
		printf("%s\n",del);		
		system(del);
		
		printf("nikhil");
	}
	else if(button==GTK_BUTTON(progressbarstop[1]) && flag[1]==1) // exit button of the path window
	{
		// perform all the thread closing activities
		close(fd[1]);
		gtk_label_set_text(GTK_LABEL(progressbartitle[1]),"download cancelled");
		flag[1]=0;
		fprintf(stderr,"canceling thread:%d",pthread_cancel(threadid[1]));
		char del[SIZE];

		//delete the file created
		sprintf(del,"rm -f %s",reqarray[1].filename);
		system(del);
		push(&s1,1);
		printf("nikhil");
	}
	else if(button==GTK_BUTTON(progressbarstop[2]) && flag[2]==1) // exit button of the path window
	{
		// perform all the thread closing activities
		close(fd[2]);
		gtk_label_set_text(GTK_LABEL(progressbartitle[2]),"download cancelled");
		flag[2]=0;
		fprintf(stderr,"canceling thread:%d",pthread_cancel(threadid[2]));
		char del[SIZE];

		//delete the file created
		sprintf(del,"rm -f %s",reqarray[2].filename);
		system(del);
		push(&s1,2);
		printf("nikhil");
	}
	else if(button==GTK_BUTTON(progressbarstop[3]) && flag[3]==1) // exit button of the path window
	{
		// perform all the thread closing activities
		close(fd[3]);
		gtk_label_set_text(GTK_LABEL(progressbartitle[3]),"download cancelled");
		flag[3]=0;
		fprintf(stderr,"canceling thread:%d",pthread_cancel(threadid[3]));
		char del[SIZE];

		//delete the file created
		sprintf(del,"rm -f %s",reqarray[3].filename);
		system(del);
		push(&s1,3);
		printf("nikhil");
	}
	else if(button==GTK_BUTTON(progressbarstop[4]) && flag[4]==1) // exit button of the path window
	{
		// perform all the thread closing activities
		close(fd[4]);
		gtk_label_set_text(GTK_LABEL(progressbartitle[4]),"download cancelled");
		flag[4]=0;
		fprintf(stderr,"canceling thread:%d",pthread_cancel(threadid[4]));
		char del[SIZE];
		
		//delete the file created
		sprintf(del,"rm -f %s",reqarray[4].filename);
		system(del);
		push(&s1,4);
		printf("nikhil");
	}

}
/**
  * The function is used to create a new dialog window which shows the sucess messages.
  * @returns Nothing 
  * @param msg Sucess message to be displayed
  *
  */
void dialogsucess(gchar msg[200])
{

	//create the dialog window for displaying the error
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT,GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"%s",msg);
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
} 


/**
  * The function is used to create a new dialog window which shows the error.
  * @returns Nothing 
  * @param msg Error message to be displayed
  *
  */
void dialogerror(gchar msg[200])
{

	//create the dialog window for displaying the error
	GtkWidget *dialog;
	dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT,GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,"%s",msg);
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
} 

/**
  * The function is used to create the view download window
  * which shows the information for all the files downloaded so far
  *
  * @returns The EXIT STATUS of the window, EXIT_SUCESS for sucessful return else 0
  * @param argc The number of parameter passed to the window for initialization
  * @param argv array of the parameters(names of them)
  *
  */
int createviewdownloadwindow(int argc,char *argv[])
{
	gtk_init(&argc,&argv);
	viewdownloadwindow=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(viewdownloadwindow), "**View Downloads**");
	gtk_window_set_position(GTK_WINDOW(viewdownloadwindow),GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect(G_OBJECT(viewdownloadwindow),"delete_event",G_CALLBACK(hidewindow),NULL);
	gtk_window_set_modal(GTK_WINDOW(viewdownloadwindow),TRUE);
	gtk_window_set_default_size(GTK_WINDOW(viewdownloadwindow),450,150);
	//gtk_window_set_resizable(GTK_WINDOW(viewdownloadwindow),FALSE); 

	//create a new list store
	liststoredownload=gtk_list_store_new (5, G_TYPE_STRING,G_TYPE_STRING,G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING);

	//get the data to be appended
	show_data();
	
	//create the tree view for the list store
	treeview= gtk_tree_view_new();
	//gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview),TRUE);
	gtk_tree_view_set_headers_clickable(GTK_TREE_VIEW(treeview),TRUE);

	//1st column
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, "File Name");
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, renderer, "text", 0);
	gtk_tree_view_column_set_clickable(col,TRUE);
	gtk_tree_view_column_set_sort_column_id(col,0);
	
	// 2nd column
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, "Path");
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, renderer, "text", 1);
	gtk_tree_view_column_set_clickable(col,TRUE);
	gtk_tree_view_column_set_sort_column_id(col,1);
	
	// 3rd column
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, "File Size");
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, renderer, "text", 2);	
	gtk_tree_view_column_set_clickable(col,TRUE);
	gtk_tree_view_column_set_sort_column_id(col,2);
	
	// 4th column
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, "Date");
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, renderer, "text", 3);
	gtk_tree_view_column_set_clickable(col,TRUE);	

	//5th column
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, "Time taken to download");
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, renderer, "text", 4);
	gtk_tree_view_column_set_clickable(col,TRUE);	

	// add to the container
	gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), GTK_TREE_MODEL(liststoredownload));
	g_object_unref(liststoredownload);
	gtk_container_add (GTK_CONTAINER (viewdownloadwindow), treeview);
	
	//show all the widgets
	gtk_widget_show_all(treeview);
	gtk_widget_show_all(viewdownloadwindow);
	gtk_main();


	return EXIT_SUCCESS;
		
}

/**
  * The function is used to create the new download window
  * which is used to set the URL,path,name of the download.
  *
  * @returns The EXIT STATUS of the window, EXIT_SUCESS for sucessful return else 0
  * @param argc The number of parameter passed to the window for initialization
  * @param argv array of the parameters(names of them)
  *
  */
int createnewdownloadwindow(int argc,char *argv[])
{
	gtk_init(&argc,&argv);
	
	//create the top level new download window
	newdownloadwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(newdownloadwindow), "**New Download**");
	gtk_window_set_position(GTK_WINDOW(newdownloadwindow),GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect(G_OBJECT(newdownloadwindow),"delete_event",G_CALLBACK(hidewindow),NULL);
	gtk_window_set_resizable(GTK_WINDOW(newdownloadwindow),FALSE); 
	gtk_window_set_modal(GTK_WINDOW(newdownloadwindow),TRUE);
	
	
	//create the labels
	ndmainlabel=gtk_label_new("       Specify the details for the new Download:       ");
	templabel12=gtk_label_new("");
	templabel13=gtk_label_new("");
	templabel14=gtk_label_new("");
	templabel15=gtk_label_new("");
	templabel16=gtk_label_new("");
	templabel17=gtk_label_new("");
	templabel18=gtk_label_new("");
	URLlabel=gtk_label_new("Enter the URL:             ");
	savetolabel=gtk_label_new("Save to:");
	filenamelabel=gtk_label_new("Enter the name of File:");

	//create the enteries
	URLentry=gtk_entry_new();
	savetoentry=gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(savetoentry),FALSE);
	filenameentry=gtk_entry_new();

	//create the buttons
	submitdownload=gtk_button_new_with_mnemonic("_Submit");
	gtk_button_set_use_underline(GTK_BUTTON(submitdownload),TRUE);
	exitdownload=gtk_button_new_with_mnemonic("_Exit");
	gtk_button_set_use_underline(GTK_BUTTON(exitdownload),TRUE);

	//create the file chooser
	filechooser=gtk_file_chooser_button_new("newdownloadpath", GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);

	//create the vbox and embed it in the top level window
	vboxfordownload=gtk_vbox_new(TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxfordownload),15);
	gtk_container_add (GTK_CONTAINER (newdownloadwindow),vboxfordownload);

	

	//create the hboxes
	hboxforURL=gtk_hbox_new(TRUE,0);
	hboxforsave=gtk_hbox_new(TRUE,0);
	hboxforfilename=gtk_hbox_new(TRUE,0);
	hboxforsubmitd=gtk_hbox_new(TRUE,0);

	//embed the widgets into the vbox
	gtk_box_pack_start(GTK_BOX(vboxfordownload), ndmainlabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), templabel12, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), hboxforURL, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), templabel13, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), hboxforsave, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), templabel14, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), hboxforfilename, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), templabel15, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordownload), hboxforsubmitd, TRUE, TRUE, 0);

	//embed widgets in the hboxes we have
	gtk_box_pack_start(GTK_BOX(hboxforURL), URLlabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforURL), URLentry, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsave), savetolabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsave), savetoentry, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsave), filechooser, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforfilename), filenamelabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforfilename), filenameentry, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmitd), templabel16, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmitd), submitdownload, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmitd), templabel17, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmitd), exitdownload, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmitd), templabel18, TRUE, TRUE, 0);

	//attach signaas to the widgets
	g_signal_connect(G_OBJECT(submitdownload),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(exitdownload),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(filechooser),"selection-changed",G_CALLBACK(pathselected),NULL);

	//set some default values
	gtk_entry_set_text(GTK_ENTRY(savetoentry),dpath);

	//show all the widgets
	gtk_widget_show(vboxfordownload);
	gtk_widget_show(ndmainlabel);
	gtk_widget_show(URLlabel);
	gtk_widget_show(savetolabel);
	gtk_widget_show(filenamelabel);
	gtk_widget_show(templabel12);
	gtk_widget_show(templabel13);
	gtk_widget_show(templabel14);
	gtk_widget_show(templabel15);
	gtk_widget_show(templabel16);
	gtk_widget_show(templabel17);
	gtk_widget_show(templabel18);
	gtk_widget_show(URLentry);
	gtk_widget_show(filenameentry);
	gtk_widget_show(filechooser);
	gtk_widget_show(hboxforURL);
	gtk_widget_show(hboxforsave);
	gtk_widget_show(hboxforfilename);
	gtk_widget_show(submitdownload);
	gtk_widget_show(exitdownload);
	gtk_widget_show(savetoentry);
	gtk_widget_show(hboxforsubmitd);
	gtk_widget_show(newdownloadwindow);
	
	gtk_main();


	return EXIT_SUCCESS;
		
}

/**
  * The function is used to create the help window
  * which shows the various help options for using the software.
  *
  * @returns The EXIT STATUS of the window, EXIT_SUCESS for sucessful return else 0
  * @param argc The number of parameter passed to the window for initialization
  * @param argv array of the parameters(names of them)
  *
  */
int createhelpwindow(int argc,char *argv[])
{
	int i;
	gtk_init(&argc,&argv);
	
	// create the proxy top level window
	helpwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(helpwindow), "**HELP**");
	gtk_window_set_position(GTK_WINDOW(helpwindow),GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect(G_OBJECT(helpwindow),"delete_event",G_CALLBACK(hidewindow),NULL);
	gtk_window_set_resizable(GTK_WINDOW(helpwindow),FALSE);
	gtk_window_set_modal(GTK_WINDOW(helpwindow),TRUE); 
	
	//create a vbox and add it to the window
	helpvbox=gtk_vbox_new(TRUE,0);
	gtk_container_add (GTK_CONTAINER (helpwindow),helpvbox);
	gtk_container_set_border_width(GTK_CONTAINER(helpvbox),15);
	
	
	// create all the labels
	helplabels[0]=gtk_label_new("The various accessibility features for this software are:");
	helplabels[1]=gtk_label_new("");
	helplabels[2]=gtk_label_new("The main page shows you the basic layout");
	helplabels[3]=gtk_label_new("The tabbed pane gives you the various options on hand");
	helplabels[4]=gtk_label_new("Progress bar along with the stop buttons are for the downloads");
	helplabels[5]=gtk_label_new("Labels below the progress bar are for status information");
	helplabels[6]=gtk_label_new("The menu bar above shows the various options available in a menu form");
	helplabels[7]=gtk_label_new("We have provided shortcut helps like for example pressing alt+f follwed by n shows the new download window");
	helplabels[8]=gtk_label_new("There are various options for proxy settings, path settings,information,view downloads through menu");
	helplabels[9]=gtk_label_new("The windows can be closed through alt+f4 orby cliking on the close option of the window");
	helplabels[10]=gtk_label_new("Any reviews are higly welcomed");
	helplabels[11]=gtk_label_new("");
	helplabels[12]=gtk_label_new("Mail us at:");
	helplabels[13]=gtk_label_new("Nikhil: nikhiljain656@yahoo.co.in");
	helplabels[14]=gtk_label_new("Anshul: anshulgolu123@gmail.com");
	
	//add all the labels to the vbox
	for(i=0;i<15;i++)
	{
		gtk_box_pack_start(GTK_BOX(helpvbox), helplabels[i], TRUE, TRUE, 0);
	}

	gtk_widget_show_all(helpvbox);
	gtk_widget_show_all(helpwindow);

	gtk_main();


	return EXIT_SUCCESS;
	

	
	
}

/**
  * The function is used to create the default path window
  * which deals with the default path settings.
  *
  * @returns The EXIT STATUS of the window, EXIT_SUCESS for sucessful return else 0
  * @param argc The number of parameter passed to the window for initialization
  * @param argv array of the parameters(names of them)
  *
  */
int createdefaultpathwindow(int argc,char *argv[])
{
	gtk_init(&argc,&argv);
	
	// create the proxy top level window
	dpathwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dpathwindow), "**Path settings**");
	gtk_window_set_position(GTK_WINDOW(dpathwindow),GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect(G_OBJECT(dpathwindow),"delete_event",G_CALLBACK(hidewindow),NULL);
	gtk_window_set_resizable(GTK_WINDOW(dpathwindow),FALSE);
	gtk_window_set_modal(GTK_WINDOW(dpathwindow),TRUE); 

	//create the labels
	dpathmainlabel=gtk_label_new("       Enter or choose the default path for saving Downloads:       ");
	templabel5=gtk_label_new("");
	templabel6=gtk_label_new("");
	templabel7=gtk_label_new("");
	templabel8=gtk_label_new("");
	templabel9=gtk_label_new("");

	//create and embed the vbox
	vboxfordpath=gtk_vbox_new(TRUE,0);
	gtk_container_add (GTK_CONTAINER (dpathwindow), vboxfordpath);
	gtk_container_set_border_width(GTK_CONTAINER(vboxfordpath),15);
	
	
	//create the hboxes for the path and buttons
	hboxforpath=gtk_hbox_new(TRUE,0);
	hboxforsubmit=gtk_hbox_new(TRUE,0);	

	//create the buttons
	dpathsubmit=gtk_button_new_with_mnemonic("_Submit");
	gtk_button_set_use_underline(GTK_BUTTON(dpathsubmit),TRUE);
	dpathexit=gtk_button_new_with_mnemonic("_Exit");
	gtk_button_set_use_underline(GTK_BUTTON(dpathexit),TRUE);

	//create the entry
	dpathentry=gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(dpathentry),FALSE);

	//create the file chooser
	pathchooser=gtk_file_chooser_button_new("path", GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	
	//embed in vbox
	gtk_box_pack_start(GTK_BOX(vboxfordpath), dpathmainlabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordpath), templabel5, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordpath), hboxforpath, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordpath), templabel6, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfordpath), hboxforsubmit, TRUE, TRUE, 0);
	
	//embed the h box
	gtk_box_pack_start(GTK_BOX(hboxforpath), dpathentry, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforpath), pathchooser, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), templabel7, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), dpathsubmit, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), templabel8, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), dpathexit, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), templabel9, TRUE, TRUE, 0);

	//attach the signals to the widgets
	g_signal_connect(G_OBJECT(dpathsubmit),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(dpathexit),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(pathchooser),"selection-changed",G_CALLBACK(pathselected),NULL);

	//set some default values
	gtk_entry_set_text(GTK_ENTRY(dpathentry),dpath);
	gtk_entry_set_overwrite_mode(GTK_ENTRY(dpathentry),TRUE);



	//show all the items
	gtk_widget_show(vboxfordpath);
	gtk_widget_show(dpathmainlabel);
	gtk_widget_show(templabel5);
	gtk_widget_show(templabel6);
	gtk_widget_show(templabel7);
	gtk_widget_show(templabel8);
	gtk_widget_show(templabel9);
	gtk_widget_show(dpathsubmit);
	gtk_widget_show(dpathexit);
	gtk_widget_show(hboxforpath);
	gtk_widget_show(hboxforsubmit);
	gtk_widget_show(dpathentry);
	gtk_widget_show(pathchooser);
	gtk_widget_show(dpathwindow);
	
	gtk_main();


	return EXIT_SUCCESS;
	


	
	
}

/**
  * The function is used to create the proxy settings window
  * which deals with the proxy settings for the software.
  *
  * @returns The EXIT STATUS of the window, EXIT_SUCESS for sucessful return else 0
  * @param argc The number of parameter passed to the window for initialization
  * @param argv array of the parameters(names of them)
  *
  */
int createproxywindow(int argc, char *argv[])
{
	gtk_init(&argc,&argv);
	
	// create the proxy top level window
	proxywindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(proxywindow), "**Proxy Settings**");
	gtk_window_set_position(GTK_WINDOW(proxywindow),GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect(G_OBJECT(proxywindow),"delete_event",G_CALLBACK(hidewindow),NULL);
	gtk_window_set_resizable(GTK_WINDOW(proxywindow),FALSE); 
	gtk_window_set_modal(GTK_WINDOW(proxywindow),TRUE);
	

	//craete the hbox and add to the container
	vboxforoptions=gtk_vbox_new(TRUE,0);
	gtk_container_add (GTK_CONTAINER (proxywindow), vboxforoptions);
	gtk_container_set_border_width(GTK_CONTAINER(vboxforoptions),15);
	

	//create the hboxes for the port and proxy
	proxyhbox=gtk_hbox_new(TRUE,0);
	porthbox=gtk_hbox_new(TRUE,0);	
	hboxforsubmit=gtk_hbox_new(TRUE,0);
	noproxyhbox=gtk_hbox_new(TRUE,0);	

	//create the various labels
	mainlabel=gtk_label_new("Enter your proxy Details:");
	proxylabel=gtk_label_new("Proxy Address:");
	portlabel=gtk_label_new("Port No:");
	templabel=gtk_label_new("");
	templabel1=gtk_label_new("");
	templabel2=gtk_label_new("");
	templabel3=gtk_label_new("");
	templabel4=gtk_label_new("");
	templabel10=gtk_label_new("");
	templabel11=gtk_label_new("");
	noproxylabel=gtk_label_new("No Proxy for:");	
	
	//create the enteries
	proxyadd=gtk_entry_new();
	portadd=gtk_entry_new();
	noproxyentry=gtk_entry_new();
	
	//create a button
	submitproxy=gtk_button_new_with_mnemonic("_Submit");
	gtk_button_set_use_underline(GTK_BUTTON(submitproxy),TRUE);

	//add al the things to the vbox and hbox
	gtk_box_pack_start(GTK_BOX(vboxforoptions), mainlabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), templabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), proxyhbox, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), templabel1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), porthbox, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), templabel2, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), noproxyhbox, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), templabel10, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxforoptions), hboxforsubmit, TRUE, TRUE, 0);

	// to hbox
	gtk_box_pack_start(GTK_BOX(proxyhbox), proxylabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(proxyhbox), proxyadd, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(porthbox), portlabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(porthbox), portadd, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), templabel3, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), submitproxy, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hboxforsubmit), templabel4, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(noproxyhbox), noproxylabel, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(noproxyhbox), noproxyentry, TRUE, TRUE, 0);
	

	//attach the signals to the widgets
	g_signal_connect(G_OBJECT(submitproxy),"clicked",G_CALLBACK(buttonclicked),NULL);

	// set some default values
	if(strcmp(proxy,"")!=0)
		gtk_entry_set_text(GTK_ENTRY(proxyadd),proxy);
	if(strcmp(port,"")!=0)
		gtk_entry_set_text(GTK_ENTRY(portadd),port);

	// show all the things
	gtk_widget_show(vboxforoptions);
	gtk_widget_show(templabel1);
	gtk_widget_show(templabel);
	gtk_widget_show(templabel2);
	gtk_widget_show(mainlabel);
	gtk_widget_show(proxylabel);
	gtk_widget_show(portlabel);
	gtk_widget_show(proxyadd);
	gtk_widget_show(portadd);
	gtk_widget_show(submitproxy);
	gtk_widget_show(proxyhbox);
	gtk_widget_show(porthbox);
	gtk_widget_show(templabel3);
	gtk_widget_show(templabel4);
	gtk_widget_show(hboxforsubmit);
	gtk_widget_show(noproxylabel);
	gtk_widget_show(noproxyentry);
	gtk_widget_show(noproxyhbox);
	gtk_widget_show(templabel10);
	gtk_widget_show(noproxylabel);
	gtk_widget_show(proxywindow);

	gtk_main();
	return EXIT_SUCCESS;


}

/**
  * The function is used to create the information window
  * which shows the information related to the software.
  *
  * @returns The EXIT STATUS of the window, EXIT_SUCESS for sucessful return else 0
  * @param argc The number of parameter passed to the window for initialization
  * @param argv array of the parameters(names of them)
  *
  */
int createinfowindow(int argc,char *argv[])
{
	int i=0;

	
	gtk_init(&argc,&argv);	
	
	//create the top level window
	infowindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(infowindow), "**General Information**");
	gtk_window_set_position(GTK_WINDOW(infowindow),GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect(G_OBJECT(infowindow),"delete_event",G_CALLBACK(hidewindow),NULL);
	gtk_window_set_resizable(GTK_WINDOW(infowindow),FALSE); 
	gtk_window_set_modal(GTK_WINDOW(infowindow),TRUE);

	//create the notebook
	infonotebook=gtk_notebook_new();

	// create the two pages
	releasepage=gtk_vbox_new(TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER(releasepage),15);
	readmepage=gtk_vbox_new(TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER(readmepage),15);
	
		
	//create the labels
	releaselabel=gtk_label_new("Release Notes");
	readmelabel=gtk_label_new("Readme");
	releasenote[0]=gtk_label_new("Here are some of the release notes that you should keep in mind while working with the software:");
	releasenote[2]=gtk_label_new("Please configure your proxy and default path settings first before starting for ease of use");
	gtk_label_set_justify(GTK_LABEL(releasenote[2]),GTK_JUSTIFY_LEFT);
	releasenote[4]=gtk_label_new("It can only download five files at a time.Giving more files will ask you to wait for some time while the downloading finishes");
	releasenote[6]=gtk_label_new("The download progress bars are shown but they are not errors.By clicking on stop buttons of non working progress bar will not initiate any action");
	releasenote[1]=gtk_label_new("");
	releasenote[3]=gtk_label_new("");
	releasenote[5]=gtk_label_new("");
	releasenote[7]=gtk_label_new("");
	releasenote[8]=gtk_label_new("If you dont specify the download file name,it will take the name of the downloaded file from the URL");
	releasenote[9]=gtk_label_new("");
	releasenote[10]=gtk_label_new("If you dont specify the path of downlaod it will take the default path as the path for download");

	for(i=1;i<3;i=i+2)
	{
		readmenote[i]=gtk_label_new("");
	}
	readmenote[4]=gtk_label_new("");
	readmenote[5]=gtk_label_new("");
	readmenote[0]=gtk_label_new("Made By:");
	readmenote[2]=gtk_label_new("Nikhil Jain(200905026) MTech CSE");
	readmenote[3]=gtk_label_new("Anshul Gupta(200905005) MTech CSE");
	readmenote[6]=gtk_label_new("Future prospects:");
	readmenote[7]=gtk_label_new("To enable downloads through sessions");
	readmenote[8]=gtk_label_new("To have more than five downloads");
	readmenote[9]=gtk_label_new("To have stoppage and resume of the downloads");
	readmenote[10]=gtk_label_new("To enable downloads through sessions");
	readmenote[11]=gtk_label_new("To have download queues");
	
	
	
	//append the pages to the notebook and notebook to the window
	gtk_notebook_append_page(GTK_NOTEBOOK(infonotebook),releasepage,releaselabel);
	gtk_notebook_append_page(GTK_NOTEBOOK(infonotebook),readmepage,readmelabel);
	gtk_container_add (GTK_CONTAINER (infowindow), infonotebook);
	for(i=0;i<12;i++)
	{
		gtk_box_pack_start(GTK_BOX(readmepage), readmenote[i], TRUE, TRUE, 0);
	}	
	for(i=0;i<11;i++)
	{	
		gtk_box_pack_start(GTK_BOX(releasepage), releasenote[i], TRUE, TRUE, 0);	
	}

	//show the widgets
	gtk_widget_show_all(releasepage);
	gtk_widget_show_all(readmepage);
	gtk_widget_show_all(infowindow);
	
	gtk_main();
	return EXIT_SUCCESS;

	
	
}


/**
  * The function is the signal handler for the clicks done 
  * on the menu items on the main window.
  *
  * @returns Nothing
  * @param menuitem the object which received the signal
  * @param user_data user data set when the signal handler was connected.
  *
  */
void menuitemclick(GtkMenuItem *menuitem,gpointer user_data)
{
	int argc=1;
	char *argv[5];
	if(menuitem==GTK_MENU_ITEM(setproxymenu)) // proxy menu item
	{
		createproxywindow(argc,argv);
	}
	else if(menuitem==GTK_MENU_ITEM(setpathmenu)) //path menu item
	{
		createdefaultpathwindow(argc,argv);
	}
	else if(menuitem==GTK_MENU_ITEM(newdownloadmenu)) // new download menu item
	{
		createnewdownloadwindow(argc,argv);
	}
	else if(menuitem==GTK_MENU_ITEM(viewdownloadsmenu)) // view download menu item
	{
		createviewdownloadwindow(argc,argv);
	}
	else if(menuitem==GTK_MENU_ITEM(infomenu)) // info manu item
	{
		createinfowindow(argc,argv);
	}
	else if(menuitem==GTK_MENU_ITEM(help)) // help menu item
	{
		createhelpwindow(argc,argv);
	}
	else if(menuitem==GTK_MENU_ITEM(cleardownloads)) // help menu item
	{
		cleardownloaddetails();
		dialogsucess("All download details deleted");
	}
}

/**
  * The function is used to create the main window
  * which shows all the options plus the downloading details.
  *
  * @returns The EXIT STATUS of the window, EXIT_SUCESS for sucessful return else 0
  * @param argc The number of parameter passed to the window for initialization
  * @param argv array of the parameters(names of them)
  *
  */
int main(int argc,char *argv[])
{	
	//local variable
	int i,j;
	
	
	//createviewdownloadwindow(argc,argv);
	//initializeReqarray(); // initialize the request array
	
	struct sigaction act1;
   
	//close connections when Ctrl+C is pressed
	act1.sa_handler = close_properly;
    	sigemptyset (&act1.sa_mask);
    	act1.sa_flags = 0;
    	sigaction (SIGINT, &act1, 0);

	// initialize the stack
	initialize(&s1);
	for(i=4;i>=0;i--)
	{
		push(&s1,i);
	}
	
	//connect to the databases
	connect_to_db();
	connect_to_db1();
	
	gtk_init(&argc,&argv);
	labeldownload2=gtk_label_new("");
	labelproxy2=gtk_label_new("");
	labelport2=gtk_label_new("");

	// set the initial proxy path settings
	strcpy(proxy,return_data("proxy"));
	//printf("%s\n",proxy);
	strcpy(port,return_data("port"));
	//printf("%s\n",port);
	strcpy(dpath,return_data("dpath"));
	//printf("%s\n",dpath);
	if(strcmp(proxy,"")==0 || strcmp(port,"")==0)
	{
		createproxywindow(argc,argv);
	}
	if(strcmp(dpath,"")==0)
	{
		createdefaultpathwindow(argc,argv);
	}

	//createnewdownloadwindow(argc,argv);
	
	//dialogerror("cannot open the windpw\n");
		
	//frame creation
	framedownload=gtk_frame_new("Downloads");
	tabframe1=gtk_frame_new("Proxy");
	tabframe2=gtk_frame_new("Port");
	tabframe3=gtk_frame_new("Download");
	
	// create the main top level window
	top_Level_Main_Window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size(GTK_WINDOW(top_Level_Main_Window),1000,600);
	gtk_window_set_title(GTK_WINDOW(top_Level_Main_Window), "**My DOWNLOAD MANAGER**");
	gtk_window_set_position(GTK_WINDOW(top_Level_Main_Window),GTK_WIN_POS_CENTER_ALWAYS);
	g_signal_connect(G_OBJECT(top_Level_Main_Window),"delete_event",G_CALLBACK(window_delete_event),NULL);
	
	// create the vertical pane for the menu
	menupane=gtk_vpaned_new();
	gtk_container_add (GTK_CONTAINER (top_Level_Main_Window), menupane);


	// create the horizontal pane for showing the downloading
	hpaneforprogressbar=gtk_hpaned_new();

	//create all the progress bars an the hboxes for it
	for(i=0;i<5;i++)
	{
		progressbar[i]=gtk_progress_bar_new();
		hboxforpbar[i]=gtk_hbox_new(TRUE,0);
		hsep[i]=gtk_hseparator_new();
	}

	//create the stop buttons for the progress bar
	for(i=0;i<5;i++)
	{
		progressbartitle[i]=gtk_label_new("Your File name");
		tempprogressbar[i]=gtk_label_new("");
		progressbarstop[i]=gtk_button_new_with_label("Stop");
		g_signal_connect(G_OBJECT(progressbarstop[i]),"clicked",G_CALLBACK(buttonclicked),NULL);
		
	}
	
	// create empty labels
	for(i=0;i<50;i++)
	{
		tmp[i]=gtk_label_new("");
	}
	
	//add the buttons to the hboxes
	for(i=0;i<5;i++)
	{
		gtk_box_pack_start(GTK_BOX(hboxforpbar[i]), progressbarstop[i], TRUE, TRUE, 0);
		for(j=0;j<4;j++)
		{
			gtk_box_pack_start(GTK_BOX(hboxforpbar[i]), tmp[tp++], TRUE, TRUE, 0);	
		}
	}

	//create the vboxes
	vboxforpbar=gtk_vbox_new(TRUE,0);
	vboxfortab1=gtk_vbox_new(TRUE,0);
	vboxfortab2=gtk_vbox_new(TRUE,0);
	vboxfortab3=gtk_vbox_new(TRUE,0);
	gtk_paned_add2(GTK_PANED(hpaneforprogressbar),framedownload);
	gtk_container_set_border_width(GTK_CONTAINER(vboxforpbar),15);
	gtk_container_add (GTK_CONTAINER (framedownload), vboxforpbar);
	gtk_container_set_border_width(GTK_CONTAINER(framedownload),15);

	
	//create the labels for the tabs
	tablabelproxy=gtk_label_new("Proxy");
	tablabelport=gtk_label_new("Port");
	tablabeldownload=gtk_label_new("Download");
	labelproxy1=gtk_label_new("Current Proxy:");
	tooltipfortab1=gtk_label_new("Proxy Address is the address of\nthe proxy server");
	tooltipfortab2=gtk_label_new("Port Address is the portnumber\n of the proxy server");
	tooltipfortab3=gtk_label_new("The Path shown is the default \npath of downloads");
	if((strlen(proxy))<=30)
	{
		
		gtk_label_set_text(GTK_LABEL(labeldownload2),proxy);
	}
	else
	{
		char tb[200];
		strcpy(tb,breakstring(proxy));
		gtk_label_set_text(GTK_LABEL(labeldownload2),tb);
		
	}
	labelproxy2=gtk_label_new(proxy);
	labelport1=gtk_label_new("Current Port:");
	gtk_label_set_text(GTK_LABEL(labelport2),port);
	labeldownload1=gtk_label_new("Default save Path:");
	//printf("\n%d\n",strlen(dpath));
	if((strlen(dpath))<=30)
	{
		gtk_label_set_text(GTK_LABEL(labeldownload2),dpath);
		
	}
	else
	{
		char tb[200];
		strcpy(tb,breakstring(dpath));
		gtk_label_set_text(GTK_LABEL(labeldownload2),tb);
		
	}
	for(i=0;i<15;i++)
	{
		tplabel[i]=gtk_label_new("");
	}
	
	//create the tab structure  and add it to the hpane
	tabs=gtk_notebook_new();
	gtk_paned_add1(GTK_PANED(hpaneforprogressbar),tabs);
	gtk_notebook_append_page(GTK_NOTEBOOK(tabs),tabframe1,tablabelproxy);
	gtk_notebook_append_page(GTK_NOTEBOOK(tabs),tabframe2,tablabelport);
	gtk_notebook_append_page(GTK_NOTEBOOK(tabs),tabframe3,tablabeldownload);
	gtk_container_add (GTK_CONTAINER (tabframe1), vboxfortab1);
	gtk_container_set_border_width(GTK_CONTAINER(tabframe1),15);
	gtk_container_add (GTK_CONTAINER (tabframe2), vboxfortab2);
	gtk_container_set_border_width(GTK_CONTAINER(tabframe2),15);
	gtk_container_add (GTK_CONTAINER (tabframe3), vboxfortab3);
	gtk_container_set_border_width(GTK_CONTAINER(tabframe3),15);
	
	//create the buttons
	tabproxybutton=gtk_button_new_with_mnemonic("_change Settings");
	gtk_button_set_use_underline(GTK_BUTTON(tabproxybutton),TRUE);
	tabportbutton=gtk_button_new_with_mnemonic("_change settings");
	gtk_button_set_use_underline(GTK_BUTTON(tabportbutton),TRUE);
	tabdownloadbutton=gtk_button_new_with_mnemonic("_change settings");
	gtk_button_set_use_underline(GTK_BUTTON(tabdownloadbutton),TRUE);
	tabviewdloadbutton=gtk_button_new_with_label("View _Downloads");
	gtk_button_set_use_underline(GTK_BUTTON(tabviewdloadbutton),TRUE);
	tabnewdloadbutton=gtk_button_new_with_label("_New Download");
	gtk_button_set_use_underline(GTK_BUTTON(tabnewdloadbutton),TRUE);
	

	
	
	// add the things to the vbox
//	gtk_box_pack_start(GTK_BOX(vboxfortab1), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab1), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab1), labelproxy1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab1), labelproxy2, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab1), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab1), tabproxybutton, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab1), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab1), tooltipfortab1, TRUE, TRUE, 0);
	for(i=0;i<2;i++)	
	{
		gtk_box_pack_start(GTK_BOX(vboxfortab1), tplabel[t++], TRUE, TRUE, 0);
	}

	//gtk_box_pack_start(GTK_BOX(vboxfortab2), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab2), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab2), labelport1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab2), labelport2, TRUE, TRUE, 0);	
	gtk_box_pack_start(GTK_BOX(vboxfortab2), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab2), tabportbutton, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab2), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab2), tooltipfortab2, TRUE, TRUE, 0);
	for(i=0;i<2;i++)	
	{
		gtk_box_pack_start(GTK_BOX(vboxfortab2), tplabel[t++], TRUE, TRUE, 0);
	}
	
//	gtk_box_pack_start(GTK_BOX(vboxfortab3), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), labeldownload1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), labeldownload2, TRUE, TRUE, 0);	
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tabdownloadbutton, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tabviewdloadbutton, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tabnewdloadbutton, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tplabel[t++], TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vboxfortab3), tooltipfortab3, TRUE, TRUE, 0);
	// add to the vbox of progress bar
	for(i=0;i<5;i++)
	{
		gtk_box_pack_start(GTK_BOX(vboxforpbar),hboxforpbar[i], TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(vboxforpbar), progressbar[i], TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(vboxforpbar), progressbartitle[i], TRUE, TRUE, 0);	
		//gtk_box_pack_start(GTK_BOX(vboxforpbar), tempprogressbar[i], TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(vboxforpbar), hsep[i], TRUE, TRUE, 0);
		
	}
	
	
	// create a menubar
	menu=gtk_menu_bar_new();
	gtk_paned_add1(GTK_PANED(menupane),menu);
	gtk_paned_add2(GTK_PANED(menupane),hpaneforprogressbar);

	//create the menu items
	filemenu= gtk_menu_item_new_with_mnemonic("_File");
	editmenu= gtk_menu_item_new_with_mnemonic("_Edit");
	viewmenu= gtk_menu_item_new_with_mnemonic("_View");	
	helpmenu= gtk_menu_item_new_with_mnemonic("_Help");	

	//create the imagemenuitem
	newdownloadmenu= gtk_image_menu_item_new_with_mnemonic("_New Downloads");
	setproxymenu=gtk_image_menu_item_new_with_mnemonic("_Proxy Settings");
	setpathmenu=gtk_image_menu_item_new_with_mnemonic("Path _Settings");
	exitmenu=gtk_image_menu_item_new_with_mnemonic("E_xit");
	infomenu=gtk_image_menu_item_new_with_mnemonic("_Info");
	viewdownloadsmenu=gtk_image_menu_item_new_with_mnemonic("View _Downloads");
	help=gtk_image_menu_item_new_with_mnemonic("_Help");
	cleardownloads=gtk_image_menu_item_new_with_mnemonic("_Clear Download details");

	// shortcuts for the menu
	gtk_menu_item_set_use_underline(GTK_MENU_ITEM(filemenu),TRUE);
	gtk_menu_item_set_use_underline(GTK_MENU_ITEM(editmenu),TRUE);
	gtk_menu_item_set_use_underline(GTK_MENU_ITEM(viewmenu),TRUE);
	gtk_menu_item_set_use_underline(GTK_MENU_ITEM(helpmenu),TRUE);
	
	// attach the itemmenu's to the menu'
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),filemenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),editmenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),viewmenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu),helpmenu);

	//create submenu for menuitems
	submenuforfile=gtk_menu_new();  
	submenuforedit=gtk_menu_new();
	submenuforview=gtk_menu_new();
	submenuforhelp=gtk_menu_new();
	
	// attach the submenu to menuitems
	gtk_menu_item_set_submenu (GTK_MENU_ITEM(filemenu),submenuforfile);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM(editmenu),submenuforedit);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM(viewmenu),submenuforview);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM(helpmenu),submenuforhelp);	

	// attach the imagemenuitems to the submenus
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforfile),newdownloadmenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforfile),viewdownloadsmenu);	
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforfile),exitmenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforedit),setproxymenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforedit),setpathmenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforview),infomenu);
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforhelp),help);
	gtk_menu_shell_append(GTK_MENU_SHELL(submenuforedit),cleardownloads);

	//attacg the signals
	g_signal_connect(G_OBJECT(setproxymenu),"activate",G_CALLBACK(menuitemclick),NULL);
	g_signal_connect(G_OBJECT(setpathmenu),"activate",G_CALLBACK(menuitemclick),NULL);
	g_signal_connect(G_OBJECT(newdownloadmenu),"activate",G_CALLBACK(menuitemclick),NULL);
	g_signal_connect(G_OBJECT(exitmenu),"activate",G_CALLBACK(window_delete_event),NULL);
	g_signal_connect(G_OBJECT(viewdownloadsmenu),"activate",G_CALLBACK(menuitemclick),NULL);
	g_signal_connect(G_OBJECT(cleardownloads),"activate",G_CALLBACK(menuitemclick),NULL);
	g_signal_connect(G_OBJECT(infomenu),"activate",G_CALLBACK(menuitemclick),NULL);
	g_signal_connect(G_OBJECT(help),"activate",G_CALLBACK(menuitemclick),NULL);
	g_signal_connect(G_OBJECT(tabproxybutton),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(tabportbutton),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(tabdownloadbutton),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(tabviewdloadbutton),"clicked",G_CALLBACK(buttonclicked),NULL);
	g_signal_connect(G_OBJECT(tabnewdloadbutton),"clicked",G_CALLBACK(buttonclicked),NULL);


	//display all the widgets
	gtk_widget_show(menu);
	gtk_widget_show(menupane);
	gtk_widget_show(filemenu);
	gtk_widget_show(editmenu);
	gtk_widget_show(newdownloadmenu);
	gtk_widget_show(submenuforfile);
	gtk_widget_show(submenuforedit);
	gtk_widget_show(exitmenu);
	gtk_widget_show(setpathmenu);
	gtk_widget_show(setproxymenu);
	gtk_widget_show(viewmenu);
	gtk_widget_show(cleardownloads);
	gtk_widget_show_all(vboxfortab1);
	gtk_widget_show_all(vboxfortab2);
	gtk_widget_show_all(vboxfortab3);
	gtk_widget_show_all(tabframe1);
	gtk_widget_show_all(tabframe2);
	gtk_widget_show_all(tabframe3);
	gtk_widget_show_all(framedownload);
	gtk_widget_show_all(vboxforpbar);
	gtk_widget_show(viewdownloadsmenu);
	gtk_widget_show(infomenu);
	gtk_widget_show(submenuforhelp);
	gtk_widget_show(helpmenu);
	gtk_widget_show(help);
	gtk_widget_show(submenuforview);
	gtk_widget_show(hpaneforprogressbar);
	gtk_widget_show_all(tabs);
	for(i=0;i<5;i++)
	{
		gtk_widget_show_all(hboxforpbar[i]);
	}
	gtk_widget_show(tablabelproxy);
	gtk_widget_show(top_Level_Main_Window);
	
	
	// start the main core logic
	gtk_main();
	
	//close the connections to the databases
	sqlite3_close (database1);
	sqlite3_close (database2);
	
	return EXIT_SUCCESS;
}
