/** This is a very useful birthday reminder tool which helps in remembering the birthdays of friends and relatives.
 * user can add new birthdays, anniversaries and can edit and delete entries also.
 * user shown a window of upcoming birthdays and recently past birthdays no of days to remind before or after selected by user.
 * user can also import and export his friends birthdays in csv file.
 * user can email also to friends whose birthday is coming or recently gone.  
 * @file birhtday_reminder.c
 * @author Deepak Shrivastava (200905007) & Tushar Jain (200905038)
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <pthread.h>
#include <sqlite3.h>

//Global Widgets
GtkWidget *btn_add, *btn_edit, *btn_delete;
GtkWidget *add_window,*edit_window;
GtkWidget *entry_name,*entry_email,*edit_entry_name,*edit_entry_email;
GtkWidget *combo_date, *combo_month, *combo_year, *combo_etype, *edit_combo_date, *edit_combo_month, *edit_combo_year, *edit_combo_etype;
GtkWidget *spin_pdays, *spin_adays;

//Global Variables
gchar *clicked_name, *clicked_edate, *clicked_etype, *clicked_email, *replaced_name, *mail_clicked_email;
int day_in_advance;
int day_after_event;
int flag_listwindow;
int startup;
char path[100];

//Function Declaration
int getpath();

static GtkWidget* create_view();
static GtkTreeModel* create_model();
void fill_model (GtkTreeModel* , char*, char*, char*, char*);

void callback_action_add(GtkWidget *, GtkTreeView *);
void callback_add_record(GtkWidget*, GtkTreeView*);

void callback_action_edit(GtkWidget *, GtkTreeView *);
void callback_edit_record(GtkWidget*, GtkTreeView*);

void callback_action_delete(GtkWidget*, GtkTreeView*);

void window_destroy (GtkWidget *, gpointer);

int row_selected(GtkTreeView*);
void callback_rowselected(GtkTreeView *, GtkTreePath *, GtkTreeViewColumn *, gpointer);

int callback_export(GtkWidget* btn, gpointer data);
static int callback_csv (void *NotUsed, int argc, char **argv, char **azColName);
int callback_import (GtkWidget*, GtkTreeView*);
void callback_email (GtkWidget *, GtkTreeView*);
void* mail_thread(void*);
int mail_row_selected(GtkTreeView*);


int listwindow();
void callback_quit(GtkWidget *, gpointer);
void exit_program(GtkWidget *, gpointer);

static GtkWidget* create_second_view();
static GtkTreeModel* create_second_model();
void fill_second_model (GtkTreeModel* , char*, char*);

void clear_list(GtkWidget *, GtkTreeView *);
void main_window_destroy (GtkWidget *, gpointer);
void parameters(int , int , int);
int ReadParameters();
static int callback_parameters (void *, int , char **, char **);
void check_button_callback (GtkWidget *, gpointer);


//Get User Name
int getpath()
{
	char *homepath;
	homepath = getenv("HOME");
	if(homepath == NULL)
	{
		exit(0);
		//return EXIT_FAILURE;
	}

	//sprintf(path, "%s/.reminder", homepath);
	sprintf(path,"./");

	return(0);
}


//************************************* DATABASE CODE *************************************************************
//DATABASE FUNCTION DECLARATION


int AddRecords(char*, char*, char*, char*);
int EditRecords(char*, char*, char*, char*, char*);
int DeleteRecords(char*);
int ReadRecords(GtkTreeModel *);
//int SearchRecords();
//int PatternSearch();
static int sql_callback (void*, int, char **, char **);
int con_to_sql(char*);

int LoadRecords(GtkTreeModel *);
static int sql_callback_load (void*, int, char **, char **);
int load_sql(GtkTreeModel *, char*, int);

/** This function is used to store the birthday records in sqlite database.
 * @param name is stores the name 
 * @param edate stores the date of birth/ anniversary
 * @param eid stores the email id of the person
 * @return 0 on success
 */
int AddRecords(char *name, char*edate, char*etype, char* eid)
{
	char qry[1024];			
	
	bzero(qry,1024);		
	sprintf(qry , "insert into event_tbl values ('%s', '%s', '%s', '%s')", name, edate, etype, eid);
	con_to_sql(qry);

	//fprintf(stdout,"\nRecord added successfully!\n");

	return(0);
}

/** This function is used to edit the birthday records in sqlite database.
 * @param oname is the name of entry to be edited
 * @param name stores the name 
 * @param edate stores the date of birth/ anniversary
 * @param eid stores the email id of the person
 * @return 0 on success
 */
int EditRecords(char* oname, char* name, char* edate, char* etype, char* eid)
{

	char qry[1024];
	
	bzero(qry,1024);
	
	sprintf(qry , "update event_tbl set name = '%s', event_date = '%s', event_type = '%s', email_id = '%s' where name = '%s'", name, edate, etype, eid, oname);
		
	con_to_sql(qry);

	//fprintf(stdout,"\nRecord Modified successfully!\n");
	
	return(0);
}

/** This function is used to delete the birthday record in sqlite database.
 * @param name stores the name of the  record to be deleted.
 * @return 0 on success
 */
int DeleteRecords(char* name)
{
	char qry[1024];
	
	bzero(qry,1024);
	sprintf(qry , "delete from event_tbl where name = '%s'", name);
	con_to_sql(qry);

	//fprintf(stdout,"\nRecord erased successfully!\n");
	
	return(0);
}

/** This function is used to populate the list of upcoming and recently past birthdays.
 * @param second_model is the model which will populate
 * @return 0 on success
 */
int ReadRecords(GtkTreeModel *second_model)
{
	char qry[1024];
	
	strcpy(qry , "select * from event_tbl order by event_date");

	load_sql(second_model, qry, 1);

	return(0);
}

/** This function checks whether given year is leap year or not.
 * @param year is the year for which we are checking leap year condition.
 * @return 1 if year is leap year 0 if year is not leap year 
 */
int isLeapYear(int year)
{
	if(year%400 ==0 || (year%100 != 0 && year%4 == 0))
	{
		//printf("Year %d is a leap year",year);
		return 1;
	}
	else
	{
		//printf("Year %d is not a leap year",year);
		return 0;
	}
}

/** This function checks upcoming and recently past birthdays from database and show it in the window.
 * @param second_model is the model in which we will fill the records
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 * @param azColName is the name of column of the table.
 * @return 0 on success
 */
static int sql_callback (void *second_model, int argc, char **argv, char **azColName)
{
	//used to store time in ticks
	time_t ticks;
	struct tm * timeinfo;

	char sysdaystr[10], sysyy[10], str[500], email[500];
	char *pch, mm[10], dd[10], yy[10];
	int sys_day_of_year, sysyear, month, day, year, event_day_of_year, count=0, difference, backdiff;
	const int DaysInMonth[13] = {0,0,31,59,90,120,151,181,212,243,273,304,334};

	strcpy(str,"empty");
	strcpy(email,"empty");

	time ( &ticks );
	timeinfo = localtime ( &ticks );

	/*
	strftime (sysmm, 20, "Month = %m", timeinfo);
	puts (sysmm);
	strftime (sysdd, 20, "Date = %d", timeinfo);
	puts (sysdd);
	*/

	strftime (sysyy, 10, "%Y", timeinfo);
	sysyear = atoi(sysyy);

	strftime (sysdaystr, 10, "%j", timeinfo);
	sys_day_of_year = atoi(sysdaystr);
	
	pch = strtok (argv[1],"-");
	while (pch != NULL)
 	{
		if(count == 0)
		{
			strcpy(mm,pch);    			
		}
		if(count == 1)
		{
			strcpy(dd,pch);    				
		}
		if(count == 2)
		{
			strcpy(yy,pch);   						
		}
		pch = strtok (NULL, "-");
		count++;	
	 }
		
        month = atoi(mm);
	day = atoi(dd);
	year = atoi(yy);
	
	event_day_of_year = DaysInMonth[month] + day;
	
	if(isLeapYear(sysyear))
	{
		if(month > 2)
		{
			event_day_of_year++;
		}
	}
	
	if(sys_day_of_year > event_day_of_year)
	{
		if(isLeapYear(sysyear + 1))
		{
			if(month > 2)
			{
				event_day_of_year++;
			}
		}

		if(isLeapYear(sysyear))
		{
			difference = 366 - sys_day_of_year + event_day_of_year;
			if( difference <= day_in_advance)
			{
				if(difference == 0)
				{
					sprintf(str, "It's %s's %d %s Today!", argv[0], sysyear+1-year, argv[2]);
					sprintf(email, "%s", argv[3]);
				}
				else
				{
					sprintf(str, "It's %s's %s in %d day%s.", argv[0], argv[2], difference, (difference>1?"s":""));
					sprintf(email, "%s", argv[3]);
				}
			}
		}
		else
		{
			difference = 365 - sys_day_of_year + event_day_of_year;
			if( difference <= day_in_advance)
			{
				if(difference == 0)
				{
					sprintf(str, "It's %s's %d %s Today!", argv[0], sysyear+1-year, argv[2]);
					sprintf(email, "%s", argv[3]);
				}
				else
				{
					sprintf(str, "It's %s's %s in %d day%s.", argv[0], argv[2], difference, (difference>1?"s":""));
					sprintf(email, "%s", argv[3]);
				}
			}
		}

		backdiff = sys_day_of_year - event_day_of_year;
		if((backdiff != 0) && (backdiff <= day_after_event))
		{
			sprintf(str, "It was %s's %s %d day%s ago.", argv[0], argv[2], backdiff, (backdiff>1?"s":""));
			sprintf(email, "%s", argv[3]);
		}

	}
	else
	{
		difference = event_day_of_year - sys_day_of_year;
		if(difference <= day_in_advance)
		{
			if(difference == 0)
			{
				sprintf(str, "It's %s's %d %s Today!", argv[0], sysyear-year, argv[2]);
				sprintf(email, "%s", argv[3]);
			}
			else
			{
				sprintf(str, "It's %s's %s in %d day%s.", argv[0], argv[2], difference, (difference>1?"s":""));
				sprintf(email, "%s", argv[3]);
			}
		}
	}

	if(strcmp(str,"empty"))
	{
		fill_second_model(GTK_TREE_MODEL(second_model), str, email);
		flag_listwindow = 1;
	}

	return 0;
}

/** This function connects to the database and executes the qyery and load its results to the main window.
 * @param qry is the query to be executed
 * @return 0 on success
 */
int con_to_sql(char *qry)
{
	sqlite3 *db;
	char *zErrMsg = 0 , dbpath[100];
	int rc;
	
	sprintf(dbpath, "%s/EventList.sq", path);
	rc = sqlite3_open (dbpath, &db);
	if (rc)
	{
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db));
		sqlite3_close (db);
		exit (1);
	}
	rc = sqlite3_exec (db, qry, sql_callback, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		//fprintf (stderr, "SQL error: %s\n", zErrMsg);
		if(rc == 19)
		{	
			GtkWidget *dialog;
			gint response;

			dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "A Record with name %s already exists! Do you want to replace it?", replaced_name);
			gtk_window_set_title(GTK_WINDOW(dialog), "Confirm Replace");
	
			response = gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);

			if(response == GTK_RESPONSE_YES)
			{
				DeleteRecords(replaced_name);
				con_to_sql(qry);
			}
		}
	}
	sqlite3_close (db);
	return 0;
}

//Loading Records From Database

/** This function loads records from the database to the window.It also checks whether database exists or not
 * if not then it also creates the database.
 * @param model is the model where we want to load the records
 * @return 0 on success
 */
int LoadRecords(GtkTreeModel *model)
{
	char qry[1024];
	GtkWidget *dialog;
	gint response;
    	int rc;


	bzero(qry, 1024);
	sprintf(qry , "select * from event_tbl order by name");

    	rc = load_sql(model, qry, 0);
    	if (rc)
    	{
		dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "No Previous Event List Found. Do you want to create new Event List?");
		
		gtk_window_set_title(GTK_WINDOW(dialog), "List Not Found!");
	
		response = gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);

		if(response == GTK_RESPONSE_YES)
		{
		//	fprintf (stderr, "Creating Table.\n");

			bzero(qry, 1024);
			sprintf(qry , "create table event_tbl (name, event_date, event_type, email_id, primary key(name))");
			
			rc = load_sql(model, qry, 0);
			if(rc)
		    	{
				//fprintf (stdout, "SQL error: %s\n", zErrMsg);
				exit(1);
			}
			else
			{
				//fprintf (stdout, "Table created successfully\n");
			}


			sqlite3 *db;
		    	char *zErrMsg = 0, dbpath[100];

			sprintf(dbpath, "%s/EventList.sq", path);
		    	rc = sqlite3_open (dbpath, &db);
		    	if (rc)
		    	{
				//fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db));
				sqlite3_close (db);
				exit (1);
		    	}

			bzero(qry, 1024);
			sprintf(qry , "create table parameters_tbl (days_after_event, days_in_advance, startup)");
		
			rc = sqlite3_exec (db, qry, callback_parameters, 0, &zErrMsg);
			if(rc)
		    	{
				//fprintf (stdout, "SQL error: %s\n", zErrMsg);
				exit(1);
			}
			else
			{
				//fprintf (stdout, "Table created successfully\n");
			}

			sqlite3_close (db);
			
		}
		else
		{
			sprintf(qry, "rm %s/EventList.sq", path);
			system(qry);
			exit(0);
			return 0;
		}

    	}
	else
	{
		//printf ("\nRecords Loaded Successfully!\n");
	}

	return(0);
}

/** This function acts as callback function for load_sql.
 * @param model is the model in which we will fill the records
 * @param argc Number of arguments passed
 * @param argv NULL terminated array of command line arguments
 * @param azColName is the name of column of the table
 * @return 0 on success
 */
static int sql_callback_load (void *model, int argc, char **argv, char **azColName)
{
	if(argc)	
		fill_model((GtkTreeModel *)model, argv[0] , argv[1] , argv[2] ? argv[2] : "NULL", argv[3] ? argv[3] : "NULL");
	
	return 0;
}

/** This function loads the records from database to model.
 * @param model is the model in which we will fill the records
 * @param qry is the query to be executed
 * @param flag is the indicator of database exists or not
 * @return 0 on success
 */
int load_sql (GtkTreeModel *model, char *qry, int flag)
{
    	sqlite3 *db;
    	char *zErrMsg = 0, dbpath[100];
	
    	int rc;

	sprintf(dbpath, "%s/EventList.sq", path);
    	rc = sqlite3_open (dbpath, &db);
    	if (rc)
    	{
		//fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db));
		sqlite3_close (db);
		exit (1);
    	}

	if(flag)
	{
		rc = sqlite3_exec (db, qry, sql_callback, (void *)model, &zErrMsg);
	}
	else
	{
		rc = sqlite3_exec (db, qry, sql_callback_load, (void *)model, &zErrMsg);
	}
	if (rc != SQLITE_OK)
    	{
//		fprintf (stderr, "SQL error: %s\n", zErrMsg);
		sqlite3_close (db);
		return(1);
	}
	
    	sqlite3_close (db);
    	
	return 0;
}

//******************************************************************************************************


//Tree View Implementation
enum
{
	COL_NAME = 0,
	COL_DATE,
	COL_ETYPE,
	COL_EMAIL,
	NUM_COLS
} ;

/** This function is used to create the model in which we will show the records.
 * @returns model
 */
static GtkTreeModel* create_model()
{
	GtkListStore  *store;
	
	store = gtk_list_store_new (NUM_COLS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

	return GTK_TREE_MODEL (store);
}

/** This function fill the model with records.
 * @param model is the model in which we will fill the records
 * @param name is the name of the person in the record
 * @param edate is the date of the event in the record
 * @param email is the email address of the person in the record
 * @return 0 on success
 */
void fill_model (GtkTreeModel *model, char* name, char* edate, char* etype, char* email)
{
	GtkListStore  *store;
	GtkTreeIter    iter;

	store = GTK_LIST_STORE(model);

	/* Append a row and fill in some data */
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, COL_NAME, name, COL_DATE, edate, COL_ETYPE, etype, COL_EMAIL, email, -1);

}

/** This function creates the view in which records will be shown.
 * @return view to be shown 
 */
static GtkWidget* create_view (void)
{
	GtkCellRenderer     *renderer;
	GtkTreeModel        *model;
	GtkWidget           *view;

	view = gtk_tree_view_new ();

	/* --- Column #1 --- */

	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (view), -1, "Name", renderer, "text", COL_NAME, NULL);

	/* --- Column #2 --- */

	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (view), -1, "Event Date", renderer, "text", COL_DATE, NULL);

	/* --- Column #3 --- */

	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (view), -1, "Event Type", renderer, "text", COL_ETYPE, NULL);

	/* --- Column #4 --- */

	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (view), -1, "Email", renderer, "text", COL_EMAIL, NULL);

	model = create_model();
	LoadRecords(model);

	gtk_tree_view_set_model (GTK_TREE_VIEW (view), model);

	/* The tree view has acquired its own reference to the
	*  model, so we can drop ours. That way the model will
	*  be freed automatically when the tree view is destroyed */

	g_object_unref (model);

	return view;
}

//--------------------------------------------------------------------------------

/** This function acts as callback function for add button in the main window which opens a window to add a new record.
 * @param widget is the button for which function is called
 * @param view is the view to be filled
 * @return void 
 */
void callback_action_add(GtkWidget *widget,GtkTreeView *view )
{
	// disabling add button after first click
	gtk_widget_set_sensitive(widget,FALSE);	


	GtkWidget *table;
	GtkWidget *button_save,*button_cancel;
	GtkWidget *lbl_name,*lbl_heading,*lbl_eday,*lbl_etype,*lbl_email;
	
	int i;
//Initialize window and it's attributes
	//gtk_init(&argc, &argv);

	add_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position((GtkWindow *)add_window, GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(add_window), "ADD New Record");
	gtk_window_set_default_size(GTK_WINDOW(add_window),300,150);
	gtk_container_set_border_width(GTK_CONTAINER(add_window),20);

	/* Create a 5x4 table */
	table = gtk_table_new (6, 4, TRUE);

	/* Put the table in the main window */
	gtk_container_add (GTK_CONTAINER (add_window), table);

	lbl_heading=gtk_label_new("Add New Record");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_heading, 0, 4, 0, 1);

	lbl_name=gtk_label_new("Name*");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_name, 0, 1, 1, 2);

	entry_name =  gtk_entry_new();	
	gtk_table_attach_defaults (GTK_TABLE(table), entry_name, 1, 4, 1, 2);

	lbl_eday=gtk_label_new("Event Date*");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_eday, 0, 1, 2, 3);
	    
	char temp[10];
	
	// adding month in combo box
	combo_month = gtk_combo_box_new_text();

	sprintf(temp,"MM");
	gtk_combo_box_append_text(GTK_COMBO_BOX (combo_month),temp);

	for(i=1;i<=12;i++)
	{
		if(i <= 9)
		{
			sprintf(temp,"0%d",i);
		}
		else
		{		
			sprintf(temp,"%d",i);
		}
		gtk_combo_box_append_text(GTK_COMBO_BOX (combo_month),temp);
	
	}

	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_month ),0);    
	  //  gtk_combo_set_popdown_strings (GTK_COMBO (combo_month), items);
	
	gtk_table_attach_defaults (GTK_TABLE(table), combo_month, 1, 2, 2, 3);

	// adding date in combo box
	combo_date = gtk_combo_box_new_text();
	sprintf(temp,"DD");
	gtk_combo_box_append_text(GTK_COMBO_BOX (combo_date),temp);
	for(i=1;i<=31;i++)
	{
		if(i <= 9)
		{
			sprintf(temp,"0%d",i);
		}
		else
		{		
			sprintf(temp,"%d",i);
		}
		gtk_combo_box_append_text(GTK_COMBO_BOX (combo_date),temp);
	}    

	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_date),0);
	  //gtk_combo_set_popdown_strings (GTK_COMBO (combo_date), items);
	
	gtk_table_attach_defaults (GTK_TABLE(table), combo_date, 2, 3, 2, 3);
	
	
	
	// adding year in combo box
	combo_year = gtk_combo_box_new_text();
	sprintf(temp,"YYYY");
	gtk_combo_box_append_text(GTK_COMBO_BOX (combo_year),temp);
	for(i=1950;i<=2050;i++)
	{
		sprintf(temp,"%d",i);
		//items = g_list_append (items, temp);
		gtk_combo_box_append_text(GTK_COMBO_BOX (combo_year),temp);
	
	}  

	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_year),0);    
	
	gtk_table_attach_defaults (GTK_TABLE(table), combo_year, 3, 4, 2, 3);

	//Combo Box for Event Type

	lbl_etype=gtk_label_new("Event Type*");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_etype, 0, 1, 3, 4);
	
	combo_etype = gtk_combo_box_new_text();
	
	gtk_combo_box_append_text(GTK_COMBO_BOX (combo_etype),"Event Type");

	gtk_combo_box_append_text(GTK_COMBO_BOX (combo_etype),"Anniversary");

	gtk_combo_box_append_text(GTK_COMBO_BOX (combo_etype),"Birthday");
	
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_etype),0);
	
	gtk_table_attach_defaults (GTK_TABLE(table), combo_etype, 1, 3, 3, 4);


	lbl_email=gtk_label_new("Email Address");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_email, 0, 1, 4, 5);
	
	entry_email =  gtk_entry_new();	
	gtk_table_attach_defaults (GTK_TABLE(table), entry_email, 1, 4, 4, 5);
	
	button_save = gtk_button_new_with_label ("Save");
	g_signal_connect(G_OBJECT(button_save),"clicked",G_CALLBACK(callback_add_record) , view);
        gtk_table_attach_defaults (GTK_TABLE(table), button_save, 0, 2, 5, 6);
	    

	button_cancel = gtk_button_new_with_label ("Cancel");
        g_signal_connect_swapped(G_OBJECT(button_cancel), "clicked", G_CALLBACK(gtk_widget_destroy), GTK_OBJECT(add_window));
	gtk_table_attach_defaults (GTK_TABLE(table), button_cancel, 2, 4, 5, 6);
	    
	//Handling Events
	g_signal_connect(G_OBJECT(add_window),"destroy",G_CALLBACK(window_destroy),NULL);
	
	//Displaying Window
	gtk_widget_show_all(add_window);
	gtk_main();

}

/** This function acts as callback function for save button of add window.
 * @param widget is the button for which function is called
 * @param view is the view to be filled
 * @return void 
 */
void callback_add_record(GtkWidget *widget,GtkTreeView *view)
{
	// enabling add button after first click
	gtk_widget_set_sensitive(btn_add,TRUE);

	const gchar *name, *month = NULL, *date = NULL, *year= NULL, *email, *etype;
	char edate[1024];	
	GtkWidget *dialog;	
	name = gtk_entry_get_text(GTK_ENTRY(entry_name));
	email = gtk_entry_get_text(GTK_ENTRY(entry_email));
	
	month = gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo_month));
	date = gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo_date));
	year = gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo_year));
	
	etype = gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo_etype));

	if(strcmp(name,"") == 0)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Name not entered. Please enter name");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return ;
	}
	
	
	if(strcmp(month , "MM" ) == 0 || strcmp(date , "DD" ) == 0 || strcmp(year , "YYYY" ) == 0)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Date not entered. Please enter complete date.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return ;
	}
	else
	{
		sprintf(edate,"%s-%s-%s",(char *)month,(char *)date,(char *)year);
	}

	if(strcmp(etype , "Event Type" ) == 0)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Event Type not selected. Please select Type of Event.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return ;
	}

	clicked_name = (char*)name;
	replaced_name = clicked_name;
	clicked_edate = edate;
	clicked_etype = (char*)etype;
	clicked_email = (char*)email;
	AddRecords((char*)name, edate, (char*)etype, (char*)email);

	gtk_widget_destroy (add_window);

	gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(view)));
	LoadRecords(gtk_tree_view_get_model(view));
}

/** This function acts as callback function for edit button in the main window which opens a window to edit selected record.
 * @param widget is the button for which function is called
 * @param view is the view to be filled
 * @return void 
 */
void callback_action_edit(GtkWidget * widget, GtkTreeView * view)
{
	//Function Calls For Getting Clicked attribute's Values	

	int res;

	res = row_selected(view);
	if(res)
	{
		return;
	}

	// disabling edit button after first click
	gtk_widget_set_sensitive(widget,FALSE);

	GtkWidget *table;
	GtkWidget *button_save,*button_cancel;
	GtkWidget *lbl_name, *lbl_heading, *lbl_eday, *lbl_etype, *lbl_email;
	
	int i;
//Initialize window and it's attributes
	//gtk_init(&argc, &argv);

	edit_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position((GtkWindow *)edit_window, GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(edit_window), "EDIT Record");
	gtk_window_set_default_size(GTK_WINDOW(edit_window),300,150);
	gtk_container_set_border_width(GTK_CONTAINER(edit_window),20);

	/* Create a 5x4 table */
	table = gtk_table_new (6, 4, TRUE);

	/* Put the table in the main window */
	gtk_container_add (GTK_CONTAINER (edit_window), table);

	lbl_heading=gtk_label_new("Edit This Record");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_heading, 0, 4, 0, 1);

	lbl_name=gtk_label_new("Name*");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_name, 0, 1, 1, 2);

	edit_entry_name =  gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(edit_entry_name), clicked_name);	
	gtk_table_attach_defaults (GTK_TABLE(table), edit_entry_name, 1, 4, 1, 2);

	lbl_eday=gtk_label_new("event Date*");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_eday, 0, 1, 2, 3);
	
	char *pch,mm[5],dd[5],yy[10];
	int count = 0;

	strcpy(mm ,"0");
	strcpy(dd ,"0");
	strcpy(yy ,"0");

	if(clicked_edate != NULL)
	{
		 pch = strtok (clicked_edate,"-");
		 while (pch != NULL)
  	 	{
			if(count == 0)
			{
				strcpy(mm,pch);    			
			}
			if(count == 1)
			{
				strcpy(dd,pch);    				
			}
			if(count == 2)
			{
				strcpy(yy,pch);   						
			}
				pch = strtok (NULL, "-");
				count++;	
  		 }
	}	
	
	char temp[10];
	
	// adding month in combo box
	edit_combo_month = gtk_combo_box_new_text();
	sprintf(temp,"MM");
	gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_month),temp);

	for(i=1;i<=12;i++)
	{
		if(i <= 9)
		{
			sprintf(temp,"0%d",i);
		}
		else
		{		
			sprintf(temp,"%d",i);
		}
		gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_month),temp);
	
	}    

	gtk_combo_box_set_active(GTK_COMBO_BOX(edit_combo_month ),atoi(mm));
	gtk_table_attach_defaults (GTK_TABLE(table), edit_combo_month, 1, 2, 2, 3);
	
	// adding date in combo box
	edit_combo_date = gtk_combo_box_new_text();
	sprintf(temp,"MM");
	gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_date),temp);

	for(i=1;i<=31;i++)
	{
		if(i <= 9)
		{
			sprintf(temp,"0%d",i);
		}
		else
		{		
			sprintf(temp,"%d",i);
		}
		gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_date),temp);
	} 

	gtk_combo_box_set_active(GTK_COMBO_BOX(edit_combo_date ),atoi(dd));
	gtk_table_attach_defaults (GTK_TABLE(table), edit_combo_date, 2, 3, 2, 3);

	// adding year in combo box
	edit_combo_year = gtk_combo_box_new_text();
	sprintf(temp,"MM");
	gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_year),temp);

	for(i=1950;i<=2050;i++)
	{
		sprintf(temp,"%d",i);
		//items = g_list_append (items, temp);
		gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_year),temp);
	
	}      
	
	gtk_combo_box_set_active(GTK_COMBO_BOX(edit_combo_year ),(atoi(yy)-1949));
	gtk_table_attach_defaults (GTK_TABLE(table), edit_combo_year, 3, 4, 2, 3);
	

	//Combo Box for Event Type

	lbl_etype=gtk_label_new("Event Type*");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_etype, 0, 1, 3, 4);
	
	edit_combo_etype = gtk_combo_box_new_text();
	
	gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_etype),"Event Type");

	gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_etype),"Anniversary");

	gtk_combo_box_append_text(GTK_COMBO_BOX (edit_combo_etype),"Birthday");

	if(strcmp(clicked_etype, "Anniversary") == 0)	
		gtk_combo_box_set_active(GTK_COMBO_BOX(edit_combo_etype), 1);
	else
		gtk_combo_box_set_active(GTK_COMBO_BOX(edit_combo_etype), 2);


	gtk_table_attach_defaults (GTK_TABLE(table), edit_combo_etype, 1, 3, 3, 4);


	lbl_email=gtk_label_new("Email Address");
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_email, 0, 1, 4, 5);
	
	edit_entry_email =  gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(edit_entry_email), clicked_email);
	gtk_table_attach_defaults (GTK_TABLE(table), edit_entry_email, 1, 4, 4, 5);
	
	button_save = gtk_button_new_with_label ("Save");
	g_signal_connect(G_OBJECT(button_save),"clicked",G_CALLBACK(callback_edit_record) , view);
        gtk_table_attach_defaults (GTK_TABLE(table), button_save, 0, 2, 5, 6);
	    

	button_cancel = gtk_button_new_with_label ("Cancel");
        g_signal_connect_swapped(G_OBJECT(button_cancel), "clicked", G_CALLBACK(gtk_widget_destroy), GTK_OBJECT(edit_window));
        gtk_table_attach_defaults (GTK_TABLE(table), button_cancel, 2, 4, 5, 6);
	    
	//Handling Events
	g_signal_connect(G_OBJECT(edit_window),"destroy",G_CALLBACK(window_destroy),NULL);
	
	//Displaying Window
	gtk_widget_show_all(edit_window);
	gtk_main();	
}

/** This function acts as callback function for save button in the edit record window.    
 * @param widget is the button for which function is called
 * @param view is the view to be filled
 * @return void 
 */
void callback_edit_record(GtkWidget *widget,GtkTreeView *view)
{
	// enabling edit button after first click
	gtk_widget_set_sensitive(btn_edit,TRUE);


	const gchar *name, *month = NULL, *date = NULL, *year= NULL, *etype, *email;
	char edate[1024];	
	GtkWidget *dialog;
	
	name = gtk_entry_get_text(GTK_ENTRY(edit_entry_name));
	email = gtk_entry_get_text(GTK_ENTRY(edit_entry_email));
	
	month = gtk_combo_box_get_active_text(GTK_COMBO_BOX(edit_combo_month));
	date = gtk_combo_box_get_active_text(GTK_COMBO_BOX(edit_combo_date));
	year = gtk_combo_box_get_active_text(GTK_COMBO_BOX(edit_combo_year));

	etype = gtk_combo_box_get_active_text(GTK_COMBO_BOX(edit_combo_etype));
	
	if(strcmp(name,"") == 0)
	{
    		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Name not entered. Please enter name");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return ;
	}
	
	if(strcmp(month , "MM" ) == 0 || strcmp(date , "DD" ) == 0 || strcmp(year , "YYYY" ) == 0)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Date not entered. Please enter complete date.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return ;
	}
	else
	{
		sprintf(edate,"%s-%s-%s",(char *)month,(char *)date,(char *)year);
	}

	replaced_name = (char*)name;
	EditRecords(clicked_name, (char*)name, edate, (char*)etype, (char*)email);

	gtk_widget_destroy (edit_window);
	
	gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(view)));
	LoadRecords(gtk_tree_view_get_model(view));
}

/** This function acts as callback function for delete button in the main window.
 * @param widget is the button for which function is called
 * @param view is the view to be filled
 * @return void 
 */
void callback_action_delete(GtkWidget * widget, GtkTreeView * view)
{
	//Function Calls For Getting Clicked attribute's Values

	int res;

	res = row_selected(view);
	if(res)
	{
		return;
	}
	
	GtkWidget *dialog;
	gint response;

	dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "Delete %s's Record! Are You Sure?", clicked_name);
	gtk_window_set_title(GTK_WINDOW(dialog), "Confirm Delete");
	
	response = gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);

	if(response == GTK_RESPONSE_YES)
	{
		DeleteRecords(clicked_name);
		gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(view)));
		LoadRecords(gtk_tree_view_get_model(view));
	}
}

/** This function acts as callback function for add and edit window.
 * @param widget is the widget for which function is called
 * @param data is the gpointer containing NULL
 * @return void 
 */
void window_destroy(GtkWidget *widget, gpointer data)
{
	// enabling add button after first click
	gtk_widget_set_sensitive(btn_add,TRUE);

	// enabling edit button after first click
	gtk_widget_set_sensitive(btn_edit,TRUE);

	gtk_main_quit();
}

/** This function fetches the selected record from the main window to edit or delete.
 * @param view is the view to be filled
 * @return 0 on success 
 */
int row_selected(GtkTreeView *view)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection* select;
	GList* list;
	guint row_clicked_count;
	GtkWidget *dialog;
	GtkTreePath* treepath;

	select = gtk_tree_view_get_selection(view);

	list = gtk_tree_selection_get_selected_rows(select, NULL);

	row_clicked_count = g_list_length(list);

	if(row_clicked_count < 1)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "No Record Selected! Please Select a Record.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return(1) ;
	}
	else if(row_clicked_count > 1)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "More Than One Record Selected! Select One Record At a Time.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return(1) ;
	}

	treepath = (GtkTreePath*)g_list_nth_data(list, 0);

	model = gtk_tree_view_get_model(view);
	
	if(gtk_tree_model_get_iter(model, &iter, treepath))
	{
		gtk_tree_model_get(model, &iter, COL_NAME, &clicked_name, -1);

		gtk_tree_model_get(model, &iter, COL_DATE, &clicked_edate, -1);

		gtk_tree_model_get(model, &iter, COL_ETYPE, &clicked_etype, -1);

		gtk_tree_model_get(model, &iter, COL_EMAIL, &clicked_email, -1);

		replaced_name = clicked_name;
	}
	return(0);
}

/** This function is invoked by row activated signal.
 * @param view is the view to be filled
 * @param treepath is the tree path
 * @param col is the column of the tree view
 * @param data is the gpointer
 * @return 0 on success 
 */
void callback_rowselected(GtkTreeView *view, GtkTreePath *treepath, GtkTreeViewColumn *col, gpointer data)
{
	callback_action_edit(btn_edit, view);
}

//--------------------------------------------------------------------------------

//Second Tree View Implementation
enum
{
	NEW_COL_STRING = 0,
	NEW_COL_EMAIL,
	NEW_NUM_COLS
};

/** This function is to create the model for start window which shows the upcoming birthdays.
 * @return model in which birthdays will be shown 
 */
static GtkTreeModel* create_second_model()
{
	GtkListStore  *second_store;
	
	second_store = gtk_list_store_new (NEW_NUM_COLS, G_TYPE_STRING, G_TYPE_STRING);

	return GTK_TREE_MODEL (second_store);
}

/** This function is used to populate the upcoming birthdays window.
 * @param second_model is the model which will show the birthdays
 * @param str stores the information to be shown
 * @param email is the email address of the record
 * @return void 
 */
void fill_second_model (GtkTreeModel *second_model, char* str, char* email)
{
	GtkListStore  *second_store;
	GtkTreeIter    second_iter;

	second_store = GTK_LIST_STORE(second_model);

	/* Append a row and fill in some data */
	gtk_list_store_append (second_store, &second_iter);
	gtk_list_store_set (second_store, &second_iter, NEW_COL_STRING, str, NEW_COL_EMAIL, email, -1);
}

/** This function view for the window showing upcoming birthdays.
 * @return view to show the information 
 */
static GtkWidget* create_second_view (void)
{
	GtkCellRenderer     *second_renderer;
	GtkTreeModel        *second_model;
	GtkWidget           *second_view;

	second_view = gtk_tree_view_new ();

	/* --- Column #1 --- */

	second_renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (second_view), -1, "Event Updates", second_renderer, "text", NEW_COL_STRING, NULL);

	/* --- Column #2 --- */

	//second_renderer = gtk_cell_renderer_text_new ();
	//gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (second_view), -1, "Email Id", second_renderer, "text", NEW_COL_EMAIL, NULL);

	second_model = create_second_model();
	ReadRecords(second_model);

	gtk_tree_view_set_model (GTK_TREE_VIEW (second_view), second_model);

	/* The tree view has acquired its own reference to the
	*  model, so we can drop ours. That way the model will
	*  be freed automatically when the tree view is destroyed */

	g_object_unref (second_model);

	return second_view;
}

/** This function generates the upcoming event list.
 * @return view to show the information 
 */
int listwindow()
{
	GtkWidget *window;
	GtkWidget *scroll_window;
	GtkWidget *vbox;
	GtkWidget *btn_email, *btn_mainwindow, *btn_ok;
	GtkWidget *second_view;
	GtkWidget *table;

	flag_listwindow = 0;

//Initialize window and it's attributes
	//gtk_init(&argc, &argv);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position((GtkWindow *)window, GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(window), "Updates");
	gtk_window_set_default_size(GTK_WINDOW(window),450,300);
	gtk_container_set_border_width(GTK_CONTAINER(window),20);

//Vertical Box
	vbox = gtk_vbox_new (FALSE, 10);

//scroll window
	scroll_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_window),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

//Tree View

	second_view = create_second_view ();
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW(second_view), FALSE);
		       			
// packing treeview in scroll window 

	gtk_container_add (GTK_CONTAINER (scroll_window), second_view);

	// CREATING TABLE
	table = gtk_table_new (1, 6, TRUE);
	//gtk_table_set_col_spacing (GTK_TABLE(table),3,10);
	
	btn_mainwindow = gtk_button_new_with_label("Home");
	g_signal_connect(G_OBJECT(btn_mainwindow),"clicked",G_CALLBACK(callback_quit) , NULL);
	gtk_table_attach_defaults (GTK_TABLE(table), btn_mainwindow, 2, 4, 0, 1);	

	btn_email = gtk_button_new_with_label("Email");
	g_signal_connect(G_OBJECT(btn_email),"clicked",G_CALLBACK(callback_email) ,second_view);
	gtk_table_attach_defaults (GTK_TABLE(table), btn_email, 0, 1, 0, 1);
	
	btn_ok = gtk_button_new_with_label("Close");
 	//g_signal_connect_swapped(G_OBJECT(btn_ok), "clicked", G_CALLBACK(gtk_widget_destroy), GTK_OBJECT(window));
	g_signal_connect(G_OBJECT(btn_ok),"clicked",G_CALLBACK(exit_program), NULL);
	gtk_table_attach_defaults (GTK_TABLE(table), btn_ok, 5, 6, 0, 1);

//Packing Components in vbox
	gtk_box_pack_start(GTK_BOX (vbox), scroll_window, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX (vbox), table, FALSE, FALSE, 0);
		
//Puting vbox in window
	gtk_container_add (GTK_CONTAINER (window), vbox);

//Handling Events
	g_signal_connect(G_OBJECT(window), "delete-event",G_CALLBACK(exit_program), NULL);
	

//Displaying Window
	if(flag_listwindow == 0)
	{
		fill_second_model (gtk_tree_view_get_model(GTK_TREE_VIEW(second_view)), "No Events in Recent & Upcoming Days!", NULL);
	}
	
	gtk_widget_show_all(window);
	gtk_main();

	gtk_widget_destroy(window);

	return EXIT_SUCCESS;
}

/** This function acts as callback function for quitting window and shows the main window on clicking.
 * @param widget is the widget for which function is called
 * @param data is the user data to pass in the fuction
 * @return void 
 */
void callback_quit(GtkWidget *widget, gpointer data)
{
	gtk_main_quit();
}

/** This function exits from program
 * @param widget is the widget for which function is called
 * @param data is the user data passed to this function
 * @return void 
 */
void exit_program(GtkWidget *mainbtn, gpointer data)
{
	gtk_main_quit();
	exit(0);
}


/** This is main function which shows main window and calls upcoming birthday window
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments. * returns void 
 * @return 0 on complition
 */
int main(int argc, char *argv[])
{
	GtkWidget *window;
	GtkWidget *scroll_window;
	GtkWidget *vbox;
	GtkWidget *btn_export, *btn_import, *btn_close, *btn_clearlist;
	GtkWidget *lbl_previous_days,*lbl_after_days,*lbl_csv;
	GtkWidget *chk_startup;	
	GtkWidget *view;
	GtkWidget *table, *btntable;
	GtkWidget *topframe, *hsep;
	GtkWidget *bdimage, *giftimage;
	char imgpath[100];

// initializing clicked variables
	clicked_name = NULL;
	clicked_edate = NULL;
	clicked_email = NULL;
	replaced_name = clicked_name;

	getpath();
	ReadParameters();

	//Initialize window and it's attributes
	gtk_init(&argc, &argv);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position((GtkWindow *)window, GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(window), "Birthday Reminder");
	gtk_window_set_default_size(GTK_WINDOW(window),700,600);
	gtk_container_set_border_width(GTK_CONTAINER(window),20);


//Vertical Box
	vbox = gtk_vbox_new (FALSE, 10);

//scroll window
	scroll_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_window),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

//Tree View

	view = create_view ();
	gtk_tree_view_column_set_sort_column_id( gtk_tree_view_get_column((GtkTreeView *)view, COL_NAME), COL_NAME);
       	gtk_tree_view_column_set_sort_column_id( gtk_tree_view_get_column((GtkTreeView *)view, COL_DATE), COL_DATE);
	gtk_tree_view_column_set_sort_column_id( gtk_tree_view_get_column((GtkTreeView *)view, COL_ETYPE), COL_ETYPE);
       	gtk_tree_view_column_set_sort_column_id( gtk_tree_view_get_column((GtkTreeView *)view, COL_EMAIL), COL_EMAIL);	
	gtk_tree_view_set_grid_lines((GtkTreeView *)view, GTK_TREE_VIEW_GRID_LINES_HORIZONTAL);

	// handling tree events
	g_signal_connect(G_OBJECT(view),"row-activated",GTK_SIGNAL_FUNC(callback_rowselected),NULL);

		
// packing treeview in scroll window 

	gtk_container_add (GTK_CONTAINER (scroll_window), view);

//Button Table

	btntable = gtk_table_new (1, 5, TRUE);

//Buttons
	//Initialization
	btn_add = gtk_button_new_with_label("Add");
	gtk_table_attach_defaults (GTK_TABLE(btntable), btn_add, 0, 1, 0, 1);
	g_signal_connect(G_OBJECT(btn_add),"clicked",G_CALLBACK(callback_action_add) , view);
	//gtk_widget_grab_default(btn_add);

	btn_edit = gtk_button_new_with_label("Edit");
	gtk_table_attach_defaults (GTK_TABLE(btntable), btn_edit, 2, 3, 0, 1);
	g_signal_connect(G_OBJECT(btn_edit),"clicked",G_CALLBACK(callback_action_edit) ,view);

	btn_delete = gtk_button_new_with_label("Delete");
	gtk_table_attach_defaults (GTK_TABLE(btntable), btn_delete, 4, 5, 0, 1);
	g_signal_connect(G_OBJECT(btn_delete),"clicked",G_CALLBACK(callback_action_delete) , view);

// CREATING TABLE
	table = gtk_table_new (4, 6, TRUE);
	//gtk_table_set_col_spacing (GTK_TABLE(table), 5, 2);
	gtk_table_set_row_spacings (GTK_TABLE(table), 3);


	chk_startup = gtk_check_button_new_with_label("Run at startup");
	g_signal_connect(G_OBJECT(chk_startup),"clicked",G_CALLBACK(check_button_callback) , NULL);
	gtk_table_attach_defaults (GTK_TABLE(table),chk_startup, 0, 2, 0, 1);


	btn_import = gtk_button_new_with_label("Import List");
	g_signal_connect(G_OBJECT(btn_import),"clicked",G_CALLBACK(callback_import) ,view);
	gtk_table_attach_defaults (GTK_TABLE(table), btn_import, 0, 1, 1, 2);	

	btn_export = gtk_button_new_with_label("Export List");
	g_signal_connect(G_OBJECT(btn_export),"clicked",G_CALLBACK(callback_export) , NULL);
	gtk_table_attach_defaults (GTK_TABLE(table), btn_export, 0, 1, 2, 3);

	lbl_csv = gtk_label_new("(Supported Format : CSV)");
	gtk_misc_set_alignment(GTK_MISC(lbl_csv), 0 ,0.5);
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_csv, 0, 2, 3, 4);

	lbl_previous_days=gtk_label_new("Past Days");
	gtk_misc_set_alignment(GTK_MISC(lbl_previous_days), 0 ,0.5);
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_previous_days, 4, 5, 0, 1);	
	
	spin_pdays = gtk_spin_button_new_with_range(1, 30, 1);
	gtk_table_attach_defaults (GTK_TABLE(table), spin_pdays, 5, 6, 0, 1);	

	lbl_after_days=gtk_label_new("Future Days");
	gtk_misc_set_alignment(GTK_MISC(lbl_after_days), 0 ,0.5);
	gtk_table_attach_defaults (GTK_TABLE(table), lbl_after_days, 4, 5, 1, 2);
	
	spin_adays = gtk_spin_button_new_with_range(1, 90, 1);
	gtk_table_attach_defaults (GTK_TABLE(table), spin_adays, 5, 6, 1, 2);

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_pdays), (day_after_event));
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin_adays), (day_in_advance));



	btn_clearlist = gtk_button_new_with_label("Clear List");
	g_signal_connect(G_OBJECT(btn_clearlist),"clicked",G_CALLBACK(clear_list) , view);
	gtk_table_attach_defaults (GTK_TABLE(table), btn_clearlist, 5, 6, 2, 3);


	btn_close = gtk_button_new_with_label("Exit");
	g_signal_connect(G_OBJECT(btn_close),"clicked",G_CALLBACK(main_window_destroy) , NULL);
	gtk_table_attach_defaults (GTK_TABLE(table), btn_close, 5, 6, 3, 4);


	sprintf(imgpath, "%s/Images/diamonds.png", path);
	bdimage = gtk_image_new_from_file(imgpath);

	sprintf(imgpath, "%s/Images/giftbox.jpg", path);
	giftimage = gtk_image_new_from_file(imgpath);
	gtk_table_attach_defaults (GTK_TABLE(table), giftimage, 2, 4, 0, 4);
			
	
	topframe = gtk_frame_new (NULL);
	gtk_container_add (GTK_CONTAINER (topframe), scroll_window);

	hsep = gtk_hseparator_new ();

//Packing Components in vbox
	gtk_box_pack_start(GTK_BOX (vbox), bdimage, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX (vbox), topframe, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX (vbox), btntable, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX (vbox), hsep, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX (vbox), table, FALSE, FALSE, 0);
	
//Puting vbox in window
	gtk_container_add (GTK_CONTAINER (window), vbox);

//Handling Events
	g_signal_connect(G_OBJECT(window),"destroy",G_CALLBACK(main_window_destroy),NULL);

//Displaying Window
	
	listwindow();

	gtk_widget_show_all(window);
	gtk_main();

	return EXIT_SUCCESS;
}


void clear_list(GtkWidget *widget, GtkTreeView *view)
{
	GtkWidget *dialog;
	gint response;

	dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "Delete Complete Event List! Are you sure?");
	gtk_window_set_title(GTK_WINDOW(dialog), "Confirm Delete");

	response = gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);

	if(response == GTK_RESPONSE_YES)
	{
		con_to_sql("delete from event_tbl");
		gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(view)));
		
	}
}

/** This function destroys the main window on closing and stores the days in advance and days after event.
 * @param widget is the widget for which function is called
 * @param data is the gpointer supplied by the widget
 * @return void 
 */
void main_window_destroy(GtkWidget *widget, gpointer data)
{
	day_in_advance = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_adays));
	day_after_event = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin_pdays) );
	parameters(day_after_event,day_in_advance,startup);	
	gtk_main_quit();
}

/** This function acts as callback function of toggling of check button for startup run in main window.
 * @param widget is the widget for which function is called
 * @param data is the gpointer supplied by the widget
 * @return void 
 */
void check_button_callback (GtkWidget *widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (widget)->active) 
	{
		startup = 1;
	}
	else
	{
		startup = 0;
	}
}

/** This function stores the days in advance and days after event
 * @param days_after_event stores the no. of days of which records to be shown previous the current date. 
 * @param days_in_advance stores the no of days for which we have to show the birthday in advance. 
 * @param s is flag for startup
 * @return void
 */
void parameters( int days_after_event, int days_in_advance, int s)
{
	sqlite3 *db;
	char *zErrMsg = 0, dbpath[100];
	int rc;
	char sql_query[1024];

	sprintf(dbpath, "%s/EventList.sq", path);
	rc = sqlite3_open (dbpath, &db);
	if (rc)
	{
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db));
		sqlite3_close (db);
		exit (1);
	}

	strcpy(sql_query, "delete from parameters_tbl");
	rc = sqlite3_exec (db, sql_query, callback_parameters, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		//fprintf (stderr, "SQL error: %s\n", zErrMsg);	
	}

	sprintf(sql_query, "insert into parameters_tbl values (%d,%d,%d)",days_after_event, days_in_advance, s);
	rc = sqlite3_exec (db, sql_query, callback_parameters, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		//fprintf (stderr, "SQL error: %s\n", zErrMsg);	
	}

	return;
}

/** This function acts as callback function for query to store records in parameters_tbl.
 * @param NotUsed is the void pointer
 * @param argc Number of arguments passed
 * @param argv NULL terminated array of command line arguments
 * @param azColName is the name of column of the table
 * @return 0 on success
 */
static int callback_parameters (void *NotUsed, int argc, char **argv, char **azColName)
{
	NotUsed = 0;
	if(argc)
	{
		day_after_event = atof(argv[0]);
		day_in_advance = atof(argv[1]);
		
		startup = atoi(argv[2]);
	}

	return 0;
}

/** This function sets the value of parameters.
 * @return 0 on success
 */
int ReadParameters()
{
	
	sqlite3 *db;
	char *zErrMsg = 0, dbpath[100];
	int rc;
	char sql_query[1024];

	sprintf(dbpath, "%s/EventList.sq", path);
	rc = sqlite3_open (dbpath, &db);
	if (rc)
	{
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db));
		sqlite3_close (db);
		//exit (1);
	}

	strcpy(sql_query, "select * from parameters_tbl");
	rc = sqlite3_exec (db, sql_query, callback_parameters, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		//fprintf (stderr, "SQL error: %s\n", zErrMsg);	
	}

	return 0;
}




//-------------EXPORT CODE-------------------------

/** This function acts as callback function for query exicuted in callback_export and writes the records in csv file.
 * @param filePointer is pointer of the csv file exported
 * @param argc Number of arguments passed
 * @param argv NULL terminated array of command line arguments
 * @param azColName is the name of column of the table
 * @return 0 on complition
 */
static int callback_csv (void *filePointer, int argc, char **argv, char **azColName)
{
	if(argc)
		fprintf((FILE*)filePointer,"%s, %s, %s, %s\n", argv[0], argv[1], argv[2], argv[3]);
	
	return 0;
}


/** This function acts as callback function for export button in main window which export csv file of all records.
 * @param btn is the widget for which function is called
 * @param data is the gpointer supplied by the widget
 * @return 0 on success 
 */
int callback_export(GtkWidget* btn, gpointer data)
{
	sqlite3 *db;
	char *zErrMsg = 0, dbpath[100];
	int rc;
	char qry[1024];
	FILE *fp;
	char *filename;
	GtkWidget *filedialog;


	
	filedialog = gtk_file_chooser_dialog_new ("Save File", NULL, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);
	gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (filedialog), TRUE);
	
	//gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (filedialog), "./");
	gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (filedialog), "Events.csv");
	//gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (filedialog), "Events.csv");
	
	if (gtk_dialog_run (GTK_DIALOG (filedialog)) == GTK_RESPONSE_ACCEPT)
	{
		
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (filedialog));

		fp = fopen(filename,"w+");

		g_free (filename);
	}
	else
	{
		gtk_widget_destroy (filedialog);
		return(0);
	}
	gtk_widget_destroy (filedialog);

	strcpy(qry , "select * from event_tbl order by name");

	sprintf(dbpath, "%s/EventList.sq", path);
	rc = sqlite3_open (dbpath, &db);
	if (rc)
	{
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db));
		sqlite3_close (db);
		exit (1);
	}
	rc = sqlite3_exec (db, qry, callback_csv, (void*)fp, &zErrMsg);
	if (rc != SQLITE_OK)
	{
	//	fprintf (stderr, "SQL error: %s\n", zErrMsg);
		
	}
	
	fclose(fp);
	sqlite3_close (db);
	return 0;
}

//------------------IMPORT CODE-------------------------------

/** This function acts as callback function for import button in main window which imports csv file of all records.
 * @param widget1 is the widget for which function is called
 * @param view in which imported records will be shown
 * @return void
 */
int callback_import (GtkWidget *widget1, GtkTreeView* view)
{
	FILE *fp; char line[1024];
	char *filename;
	GtkWidget *filedialog;
	gint response;
	char *pch; int count = 0;
	char name[100], edate[15], etype[15], email[100],*ptr;


	filedialog = gtk_file_chooser_dialog_new ("Choose File", NULL, GTK_FILE_CHOOSER_ACTION_OPEN, "Upload", GTK_RESPONSE_YES, "Cancel", GTK_RESPONSE_NO, NULL);
	
	response = gtk_dialog_run (GTK_DIALOG (filedialog));
		
	if(response == GTK_RESPONSE_YES)
	{
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (filedialog));
		
		fp = fopen (filename, "r");
		g_free (filename);
	}
	else
	{
		gtk_widget_destroy (filedialog);
		return(0);
	}
	gtk_widget_destroy (filedialog);

	while((fscanf(fp,"%[^\n]",line)>0))
	{	
		count = 0;
		fseek(fp,1,1);		
		pch = strtok (line,",");
		 while (pch != NULL)
  	 	{
			if(count == 0)
			{
				strcpy(name,pch);    			
			}
			if(count == 1)
			{
				strcpy(edate,pch);    				
			}
			if(count == 2)
			{
				strcpy(etype,pch);   						
			}
			if(count == 3)
			{
				strcpy(email,pch);   						
			}
			pch = strtok (NULL, ",");
			count++;	
  		 }		
		
		ptr = edate;
		ptr++;
		strcpy(edate,ptr);

		ptr = etype;
		ptr++;
		strcpy(etype,ptr);

		ptr = email;
		ptr++;
		strcpy(email,ptr);

		clicked_name = name;
		replaced_name = clicked_name;
		clicked_edate = edate;
		clicked_etype = etype;
		clicked_email = email;
		AddRecords(name, edate, etype, email);
		gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(view)));
		LoadRecords(gtk_tree_view_get_model(view));
	}
	return(0);
}

/** This function acts as callback function for email button in starting window.
 * @param widget is the widget for which function is called
 * @param second_view is the view showing upcoming/recent birthday list
 * @return void 
 */
void callback_email (GtkWidget *widget, GtkTreeView *second_view)
{
	mail_row_selected(second_view);

	if(strcmp(mail_clicked_email,"")==0)
	{
		GtkWidget *dialog;

		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Email Id of selected person is not available in the record.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return;
	}


	pthread_t new_thread;
	int thr_val;

	thr_val = pthread_create( &new_thread, NULL, mail_thread, NULL);
	if(thr_val != 0)
	{
		GtkWidget *dialog;

		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could Not send mail. Mail send failed.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return;
	}

	
}

void* mail_thread(void* farzi)
{
	char str[100];

	sprintf(str, "evolution mailto:%s", mail_clicked_email);

	system(str);

	pthread_exit(NULL);
}

/** This function fetches the mail id of the selected record.
 * @param view is the widget of view
 * @return 0 on success
 */
int mail_row_selected(GtkTreeView *view)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection* select;
	GList* list;
	guint row_clicked_count;
	GtkWidget *dialog;
	GtkTreePath* treepath;

	select = gtk_tree_view_get_selection(view);

	list = gtk_tree_selection_get_selected_rows(select, NULL);

	row_clicked_count = g_list_length(list);

	if(row_clicked_count < 1)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "No Record Selected! Please Select a Record.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return(1) ;
	}
	else if(row_clicked_count > 1)
	{
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "More Than One Record Selected! Select One Record At a Time.");
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		
		return(1) ;
	}

	treepath = (GtkTreePath*)g_list_nth_data(list, 0);

	model = gtk_tree_view_get_model(view);
	
	if(gtk_tree_model_get_iter(model, &iter, treepath))
	{
		gtk_tree_model_get(model, &iter, NEW_COL_EMAIL, &mail_clicked_email, -1);
	}
	return(0);
}


