#include<gtk/gtk.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<mysql/mysql.h>
#include<time.h>
#include<sys/stat.h>
#include "encode.h"

#define BUFFER 100
#define BUFFER200 200
#define BUFFER500 500
#define BUFFER2500 2500
#define BUFFER5000 5000
#define MAX_BUFF_SIZE 4096
#define PRIMARY_KEY_ERROR 1062

GtkWidget *AddContact();
GtkWidget *EditDeleteExportContact();
GtkWidget *Todo();
char *ExportContact();
void ResizeAndSetImage(char *);
void handler(GtkWidget *, gpointer);
void ButtonAddHandler(GtkWidget *, gpointer);
void SelectDate(GtkWidget *widget, gpointer data);
void GetDate(GtkWidget *widget, gpointer data);
void CloseCalendar(GtkWidget *widget, gpointer data);
void SearchAcquaintance(GtkWidget *widget, gpointer data);
void Validation(GtkWidget *widget, gpointer data);
void SetImage(GtkWidget *widget, gpointer data);
void GetData(GtkTextBuffer *buffer,gpointer user_data);
void SearchTodo(GtkWidget *widget, gpointer data);
void InitializePDMDB();
void ExitProgram();
int EstablishDbConnection(MYSQL **mysql_conn, const char username[BUFFER],const char password[BUFFER],const char database[BUFFER], const char server[BUFFER]);

// ---------------------   Contact Related Methods. ------------------------

// Returns the new contact id. On failure : -1 
int AddContactToDB(char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], char address[BUFFER2500], char email[BUFFER200],
		char imagefilename[BUFFER500]);

// returns 1 if successful. on failure -1  no contact found : -2
int EditContactToDB(int contact, char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], char address[BUFFER2500], char email[BUFFER200],
		char imagefilename[BUFFER500]);

// returns 1 if successful. on failure -1  no contact found : -2
int DeleteContactToDB(int contactid);

int ExportContactFromDB(char filename[BUFFER500], char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], char address[BUFFER2500], 
			char email[BUFFER200], char imagefilename[BUFFER500]);
// -------------------    Todo Related Methods. ----------------------------

// Returns the new todo id. on failure : -1
int AddTodo(char subject[BUFFER500], char note[BUFFER5000], char duedate[BUFFER]);

// returns 1 if successful. on failure -1
int EditTodo(int todoid, char subject[BUFFER500], char note[BUFFER5000], char duedate[BUFFER]);

// returns 1 if successful. on failure -1
int DeleteTodo(int todoid);

void GetTodo(int todoid, char subject[BUFFER500], char note[BUFFER5000], char duedate[BUFFER]);

void GetAllTodoInfo(int** todoid, char*** subject, int* count);

void GetAllContactInfo(int** contactid, char*** fname, char*** lname, int* count);
void GetContact(int contactid, char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], 
			char address[BUFFER2500], char email[BUFFER200], char imagefilename[BUFFER500]);
int GetMaxContactID();
int EncodeImage(char imagefilename[BUFFER500]);

GtkWidget *window;
GtkWidget *tableMain;
GtkWidget *frameMain;

//Todo Variables
GtkWidget *textDate;
GtkWidget *textSubject;	
GtkWidget *textContent;

//Contact Variables
GtkWidget *textFirstName;	
GtkWidget *textLastName;
GtkWidget *textMobile;
GtkWidget *textLandline;
GtkWidget *textEmail;
GtkWidget *textHome;
GtkWidget *buttonImage;
GtkWidget *image;
GtkWidget *comboSearch;
GtkWidget *comboSearchTodo;

MYSQL *default_sql_conn = NULL;

char CS_USER[20] =  "cs3002_user";
char CS_PASSWORD[20] =  "cs3002_password";
char CS_DATABASE[20] = "cs3002_database";
char CS_SERVER[20] = "localhost";

int flag = 0;
int flag2 = 0;
int contactID;
int todoID;
int cnt = 0;
int count = 0;
int i = 0;
char date[11];
char **firstname ,**lastname ;
char **subjectTodo;
char getImageFileName[BUFFER500];
char subTodo[BUFFER200];
char name[402];
const gchar *imageFileName;
int *allContactID;
int *allTodoID;
char homeAddress[BUFFER2500],newPath[1000];
char note[BUFFER2500];
char currentDate[11];

/** This is the function from which the application starts. 
 * The main method of this 'c' application. 
 * @returns zero on success. non-zero on failure.
 * @param argc is the number of arguments
 * @param argv is the actual command line arguments
 * */
int main( int argc, char *argv[])
{

	//Containers
	GtkWidget *window;

	//tables
	GtkWidget *tableContact;
	GtkWidget *tableTodo;
	

	//Frames
	
	GtkWidget *frameTodo;
	GtkWidget *frameContact;

	//ContactButtons
	GtkWidget *buttonContactAdd;
	GtkWidget *buttonContactEdit;
	GtkWidget *buttonContactDelete;
	GtkWidget *buttonContactExport;

	//TodoButtons
	GtkWidget *buttonTodoAdd;
	GtkWidget *buttonTodoEdit;
	GtkWidget *buttonTodoDelete;

	//Initialization
	gtk_init(&argc, &argv);
	InitializePDMDB();

	time_t now;
	struct tm *d;
	time(&now);
	d = localtime(&now);

	strftime(currentDate, 15, "%Y-%m-%d", d);

        char current_working_dir[BUFFER500];
        struct stat st;

        getcwd(current_working_dir,BUFFER500);

        strcat(current_working_dir,"/pics");
        
        if(stat(current_working_dir,&st) != 0)
                system("mkdir pics");

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);	
	gtk_window_set_default_icon_from_file ("app.jpg",NULL);
	gtk_window_set_title(GTK_WINDOW(window), "Data Manager");
  	gtk_window_set_default_size(GTK_WINDOW(window), 600, BUFFER500);
  	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_window_set_resizable(GTK_WINDOW(window),FALSE);

	//tableMain
	tableMain = gtk_table_new(12, 2, TRUE);
  	gtk_container_add(GTK_CONTAINER(window), tableMain);

	//Frames
	frameContact = gtk_frame_new("Contact");
	frameTodo = gtk_frame_new("Todo");
	frameMain = gtk_frame_new(NULL);

	//tables
	tableContact = gtk_table_new(1, 4, TRUE);
  	tableTodo = gtk_table_new(1, 3, TRUE);
  	

	//Initialization of contact buttons
	buttonContactAdd = gtk_button_new_with_label("Add Contact");
	buttonContactEdit = gtk_button_new_with_label("Edit Contact");
	buttonContactDelete = gtk_button_new_with_label("Delete Contact");
	buttonContactExport = gtk_button_new_with_label("Export Contact");

	//Initialization of todo buttons
	buttonTodoAdd = gtk_button_new_with_label("Add Todo");
	buttonTodoEdit = gtk_button_new_with_label("Edit Todo");
	buttonTodoDelete = gtk_button_new_with_label("Delete Todo");

	//Adding contact buttons to tableContact
	gtk_table_attach_defaults(GTK_TABLE(tableContact), buttonContactAdd, 0, 1, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(tableContact),buttonContactEdit, 1, 2, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(tableContact),buttonContactDelete, 2, 3, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(tableContact),buttonContactExport, 3, 4, 0, 1 );

	//Adding todo buttons to tableTodo
	gtk_table_attach_defaults(GTK_TABLE(tableTodo), buttonTodoAdd, 0, 1, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(tableTodo),buttonTodoEdit, 1, 2, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(tableTodo),buttonTodoDelete, 2, 3, 0, 1 );

	//Adding tableContact to  frameContact
	gtk_container_add(GTK_CONTAINER(frameContact),tableContact);

	//Adding tableTodo to frameTodo 
	gtk_container_add(GTK_CONTAINER(frameTodo),tableTodo);

	//Adding main contant to frameMain

	//gtk_container_add(GTK_CONTAINER(frameMain),Contact());


	// Adding frames to tableMain

	gtk_table_attach_defaults(GTK_TABLE(tableMain), frameContact, 0, 1, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(tableMain),frameTodo, 1, 2, 0, 1 );

 	
	g_signal_connect(G_OBJECT(buttonContactAdd),"clicked",G_CALLBACK(handler), NULL);
	g_signal_connect(G_OBJECT(buttonContactEdit),"clicked",G_CALLBACK(handler), NULL);
	g_signal_connect(G_OBJECT(buttonContactDelete),"clicked",G_CALLBACK(handler), NULL);
	g_signal_connect(G_OBJECT(buttonContactExport),"clicked",G_CALLBACK(handler), NULL);
	g_signal_connect(G_OBJECT(buttonTodoAdd),"clicked",G_CALLBACK(handler), NULL);
	g_signal_connect(G_OBJECT(buttonTodoEdit),"clicked",G_CALLBACK(handler), NULL);
	g_signal_connect(G_OBJECT(buttonTodoDelete),"clicked",G_CALLBACK(handler), NULL);
	g_signal_connect_swapped(G_OBJECT(window), "destroy",G_CALLBACK(gtk_main_quit), NULL);	
	gtk_widget_show_all(window);
  	gtk_main();

  	return 0;
}

/** This is the common event handler for Add/Edit/Delete operations on contacts and todo objects. 
 * The event handler keeps track of the flag variable to identify the action and the entity
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void ButtonAddHandler(GtkWidget *widget, gpointer data)
{
	const gchar *firstName, *lastName, *mobileNumber, *landlineNumber, *email;
	const gchar *subject,*dueDate;
	GtkTextBuffer *buffer;
	char dialogMessage[30];
	int ret;
	int error = 0;
	GtkMessageType type;
	GtkWidget *dialog;
	if(flag == 1 || flag ==2 || flag == 3 || flag == 7)
	{
		firstName = gtk_entry_get_text(GTK_ENTRY(textFirstName));
		if(firstName[0] == '\0')			
		{
			strcpy(dialogMessage,"Please enter the first name");
			type = GTK_MESSAGE_ERROR;
			error =1;
		}
		lastName = gtk_entry_get_text(GTK_ENTRY(textLastName));
		mobileNumber = gtk_entry_get_text(GTK_ENTRY(textMobile));
		landlineNumber = gtk_entry_get_text(GTK_ENTRY(textLandline));
		email = gtk_entry_get_text(GTK_ENTRY(textEmail));
	}
	else if(flag == 4 || flag == 5 || flag == 6)
	{
		subject = gtk_entry_get_text(GTK_ENTRY(textSubject));
		if(subject[0] == '\0')			
		{
			strcpy(dialogMessage,"Please enter subject");
			type = GTK_MESSAGE_ERROR;
			error =1;
		}
	}
	if(error == 0)
	{
		if(flag == 1)
		{
			ret = AddContactToDB(firstName, lastName, mobileNumber,landlineNumber,homeAddress,email, newPath);
			if(ret == -1)
			{
				strcpy(dialogMessage,"Error Occured");
				type = GTK_MESSAGE_ERROR;
			}
			else
			{
				strcpy(dialogMessage,"Saved Successfully");
				type = GTK_MESSAGE_INFO;
			}
		}
		else if(flag == 2)
		{
			ret = EditContactToDB(contactID, firstName, lastName, mobileNumber,landlineNumber,homeAddress,email, newPath);
			if(ret != 1)
			{
				strcpy(dialogMessage,"Error Occured");
				type = GTK_MESSAGE_ERROR;
			}
			else
			{
				strcpy(dialogMessage,"Saved Successfully");
				type = GTK_MESSAGE_INFO;
				gtk_widget_destroy(frameMain);
				frameMain = EditDeleteExportContact();
				gtk_table_attach_defaults(GTK_TABLE(tableMain),frameMain, 0, 2, 1, 12 );
				gtk_widget_show_all(frameMain);
			}
		}
		else if(flag == 3)
		{
			ret = DeleteContactToDB(contactID);
			char systemCommand[BUFFER];
			if(ret != 1)
			{
				strcpy(dialogMessage,"Error Occured");
				type = GTK_MESSAGE_ERROR;
			}
			else
			{
				strcpy(dialogMessage,"Deleted Successfully");
				type = GTK_MESSAGE_INFO;
				strcpy(systemCommand,"rm -f ");
				strcat(systemCommand,newPath);
				system(systemCommand);
				gtk_widget_destroy(frameMain);
				frameMain = EditDeleteExportContact();
				gtk_table_attach_defaults(GTK_TABLE(tableMain),frameMain, 0, 2, 1, 12 );
				gtk_widget_show_all(frameMain);
			}
		}
		else if(flag == 7)
		{
			char *fileName = ExportContact();
			ret = ExportContactFromDB(fileName, firstName, lastName, mobileNumber, landlineNumber, homeAddress, email, getImageFileName);
			if(ret != 1)
			{
				strcpy(dialogMessage,"Error Occured");
				type = GTK_MESSAGE_ERROR;
			}
			else
			{
				strcpy(dialogMessage,"Exported Successfully");
				type = GTK_MESSAGE_INFO;
			}
		}
		else if(flag == 4)
		{
			ret =AddTodo(subject,note,date);
			if(ret == -1)
			{
				strcpy(dialogMessage,"Error Occured");
				type = GTK_MESSAGE_ERROR;
			}
			else
			{
				strcpy(dialogMessage,"Saved Successfully");
				type = GTK_MESSAGE_INFO;
			}
		}
		else if(flag == 5)
		{
			ret = EditTodo(todoID,subject,note,date);
			if(ret != 1)
			{
				strcpy(dialogMessage,"Error Occured");
				type = GTK_MESSAGE_ERROR;
			}
			else
			{
				strcpy(dialogMessage,"Saved Successfully");
				type = GTK_MESSAGE_INFO;
				gtk_widget_destroy(frameMain);
				frameMain = Todo();
				gtk_table_attach_defaults(GTK_TABLE(tableMain),frameMain, 0, 2, 1, 12 );
				gtk_widget_show_all(frameMain);
			}
		}
		else if(flag == 6)
		{
			ret = DeleteTodo(todoID);
			if(ret == -1)
			{
				strcpy(dialogMessage,"Error Occured");
				type = GTK_MESSAGE_ERROR;
			}
			else
			{
				strcpy(dialogMessage,"Deleted Successfully");
				type = GTK_MESSAGE_INFO;
				gtk_widget_destroy(frameMain);
				frameMain = Todo();
				gtk_table_attach_defaults(GTK_TABLE(tableMain),frameMain, 0, 2, 1, 12 );
				gtk_widget_show_all(frameMain);
			}
		}
	}
	dialog = gtk_message_dialog_new(GTK_WINDOW(window),GTK_DIALOG_DESTROY_WITH_PARENT,type,GTK_BUTTONS_OK,dialogMessage);
  
  	gtk_dialog_run(GTK_DIALOG(dialog));
  
  	gtk_widget_destroy(dialog);
	if((flag == 1)&&(ret >= 0))
	{
		newPath[0] = '\0';
		email = gtk_entry_get_text(GTK_ENTRY(textEmail));
		gtk_entry_set_text(GTK_ENTRY(textFirstName),"");
		gtk_entry_set_text(GTK_ENTRY(textLastName),"");
		gtk_entry_set_text(GTK_ENTRY(textMobile),"");
		gtk_entry_set_text(GTK_ENTRY(textLandline),"");
		gtk_entry_set_text(GTK_ENTRY(textEmail),"");
		gtk_image_set_from_file (GTK_IMAGE(image),"question.jpg");
		
		homeAddress[0] = '\0';
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textHome));
		gtk_text_buffer_set_text (buffer,homeAddress, -1);

	}
	if((flag == 4)&&(ret >= 0))
	{
		gtk_entry_set_text(GTK_ENTRY(textSubject),"");
		gtk_entry_set_text(GTK_ENTRY(textDate),currentDate);
		note[0] = '\0';
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textContent));
		gtk_text_buffer_set_text (buffer,note, -1);
	}

}

/** This method is the event handler for the text area which is called on "changed" event.  
 * This method copies the address data from the text buffer to the appropriate program variable.
 * 
 * @param buffer is the GtkTextBuffer from which the address details are to be read.
 * @param user_data is the data associated with the event.
 * */
void GetData(GtkTextBuffer *buffer,gpointer user_data)
{
	GtkTextIter start, end;
	gtk_text_buffer_get_iter_at_offset (buffer, &start,0);	//Try setting this limit properly otherwise set "end" value to say 10000 a very large value :)....
        gtk_text_buffer_get_iter_at_offset (buffer, &end,2499);
        gchar *txt;
        txt=gtk_text_buffer_get_text(buffer,&start,&end,FALSE);
	if(flag <= 3 || flag == 7)
		strcpy(homeAddress,txt);
	else if(flag >=4 && flag <= 6)
		strcpy(note,txt);
}

/** This is the common event handler for the buttons in the main tab. 
 * The event handler will display the appropriate form depending on the button that has been clicked.
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void handler(GtkWidget *widget, gpointer data)
{
	char ch[BUFFER];
	strcpy(ch,gtk_button_get_label(GTK_BUTTON(widget)));
	gtk_widget_destroy(frameMain);
	if(!strcmp(ch,"Add Contact"))
	{
		flag = 1;
		frameMain = AddContact();
	}
	else if(!strcmp(ch,"Edit Contact"))
	{
		flag = 2;
		frameMain = EditDeleteExportContact();
	}
	else if(!strcmp(ch,"Delete Contact"))
	{
		flag = 3;
		frameMain = EditDeleteExportContact();
	}
	else if(!strcmp(ch,"Add Todo"))
	{
		flag = 4;
		strcpy(date, currentDate);
		frameMain = Todo();
	}
	else if(!strcmp(ch,"Edit Todo"))
	{
		flag = 5;
		frameMain = Todo();
	}
	else if(!strcmp(ch,"Delete Todo"))
	{
		flag = 6;
		frameMain = Todo();
	}
	else if(!strcmp(ch,"Export Contact"))
	{
		flag = 7;
		frameMain = EditDeleteExportContact();
	}
	gtk_table_attach_defaults(GTK_TABLE(tableMain),frameMain, 0, 2, 1, 12 );
	gtk_widget_show_all(frameMain);
}

/** This method returns the frame used in the add contact functionality. 
 * It adds all the necessary controls to the frame and then returns the final result
 * @returns the frame (GtkWidget) having all the controls required in the add contact feature
 * */
GtkWidget *AddContact()
{
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *scroll;
	GtkTextBuffer *buffer;

	GtkWidget *buttonAdd;

	GtkWidget *labelFirstName;
	GtkWidget *labelLastName;
	GtkWidget *labelMobile;
	GtkWidget *labelLandline;
	GtkWidget *labelEmail;
	GtkWidget *labelHome;
	GtkWidget *labelImage;

	
	scroll = gtk_scrolled_window_new (NULL,NULL);
	frame = gtk_frame_new(NULL);
	table = gtk_table_new(7, 8, TRUE);

	labelFirstName = gtk_label_new("Acquaintance Name");
	labelLastName = gtk_label_new("Family Name");
	labelMobile = gtk_label_new("Mobile No.");
	labelLandline = gtk_label_new("Landline No.");
	labelEmail = gtk_label_new("Email Address");
	labelHome = gtk_label_new("Home Address");
	labelImage = gtk_label_new("Upload Image");
	
	textFirstName = gtk_entry_new_with_max_length(BUFFER200);
	textLastName = gtk_entry_new_with_max_length(BUFFER200);
	textMobile = gtk_entry_new_with_max_length(10);
	textLandline = gtk_entry_new_with_max_length(10);
	textEmail = gtk_entry_new_with_max_length(BUFFER200);
	textHome = gtk_text_view_new();
	image = gtk_image_new_from_file("question.jpg");
	
	

	buttonImage = gtk_file_chooser_button_new("Upload Image" , GTK_FILE_CHOOSER_ACTION_OPEN);	
	buttonAdd = gtk_button_new_with_label("     Save     ");
	
	gtk_table_attach_defaults(GTK_TABLE(table), labelFirstName, 0, 2, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelLastName, 4, 6, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelLandline, 0, 2, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelMobile, 4, 6, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelHome, 0, 2, 2, 5 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelEmail, 0, 2, 5, 6 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelImage, 4, 6, 5, 6 );

	gtk_table_attach_defaults(GTK_TABLE(table),textFirstName, 2, 4, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(table),textLastName, 6, 8, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(table), textLandline, 2, 4, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), textMobile, 6, 8, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), scroll, 2, 4, 2, 5 ); 
	gtk_container_add(GTK_CONTAINER(scroll),textHome);
	gtk_widget_set_size_request(image,250,185);
	gtk_table_attach (GTK_TABLE(table), image, 5, 8, 2, 5, GTK_SHRINK,GTK_SHRINK,0,0);
	gtk_table_attach_defaults(GTK_TABLE(table), textEmail, 2, 4, 5, 6 );
	gtk_table_attach (GTK_TABLE(table),  buttonImage, 6, 8, 5, 6, GTK_FILL,GTK_EXPAND,0,0);

	gtk_table_attach (GTK_TABLE(table), buttonAdd, 6,8,6,7, GTK_EXPAND,GTK_EXPAND,0,0);
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textHome));
	gtk_container_add(GTK_CONTAINER(frame),table);
	g_signal_connect(G_OBJECT(buttonAdd),"clicked",G_CALLBACK(ButtonAddHandler), NULL);
	g_signal_connect(G_OBJECT(textMobile), "changed", G_CALLBACK(Validation),(gpointer)textMobile);
	g_signal_connect(G_OBJECT(textLandline), "changed", G_CALLBACK(Validation),(gpointer)textLandline);
	g_signal_connect(G_OBJECT(buttonImage), "file-set", G_CALLBACK(SetImage),(gpointer)textMobile);
	g_signal_connect(G_OBJECT(buffer),"changed",G_CALLBACK(GetData),NULL);
	return frame;
}

/** This method returns the frame used in edit/delete/export contact functionality. 
 * It adds all the necessary controls to the frame and then returns the final result
 * @returns the frame (GtkWidget) having all the controls required in the contact feature(ie add/edit/delete)
 * */
GtkWidget *EditDeleteExportContact()
{
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *scroll;
	GtkTextBuffer *buffer;

	GtkWidget *buttonAdd;

	GtkWidget *labelFirstName;
	GtkWidget *labelLastName;
	GtkWidget *labelMobile;
	GtkWidget *labelLandline;
	GtkWidget *labelEmail;
	GtkWidget *labelHome;
	GtkWidget *labelImage;
	GtkWidget *labelSearch;
	

	scroll = gtk_scrolled_window_new (NULL,NULL);
	frame = gtk_frame_new(NULL);
	table = gtk_table_new(8, 8, TRUE);

	labelFirstName = gtk_label_new("Acquaintance Name");
	labelLastName = gtk_label_new("Family Name");
	labelMobile = gtk_label_new("Mobile No.");
	labelLandline = gtk_label_new("Landline No.");
	labelEmail = gtk_label_new("Email Address");
	labelHome = gtk_label_new("Home Address");
	labelSearch = gtk_label_new("Search Acquaintance");

	textFirstName = gtk_entry_new_with_max_length(BUFFER200);
	textLastName = gtk_entry_new_with_max_length(BUFFER200);
	textMobile = gtk_entry_new_with_max_length(10);
	textLandline = gtk_entry_new_with_max_length(10);
	textEmail = gtk_entry_new_with_max_length(BUFFER200);
	textHome = gtk_text_view_new();
	comboSearch = gtk_combo_box_new_text();
	image = gtk_image_new_from_file("question.jpg");

	if(flag == 2)
	{		
		labelImage = gtk_label_new("Upload Image");
		buttonImage = gtk_file_chooser_button_new("Upload Image" , GTK_FILE_CHOOSER_ACTION_OPEN);	
		gtk_table_attach_defaults(GTK_TABLE(table), labelImage, 4, 6, 6, 7 );
		gtk_table_attach (GTK_TABLE(table), buttonImage, 6, 8, 6, 7, GTK_FILL,GTK_EXPAND,0,0);
		buttonAdd = gtk_button_new_with_label("Save Changes");
		g_signal_connect(G_OBJECT(buttonImage), "file-set", G_CALLBACK(SetImage),NULL);
	}
	else if(flag == 3)
	{
		buttonAdd = gtk_button_new_with_label("     Delete     ");
	}
	else if(flag == 7)
	{
		buttonAdd = gtk_button_new_with_label("     Export     ");
	}
	if(flag ==3 || flag == 7)
	{
		gtk_entry_set_editable(GTK_ENTRY(textFirstName),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textLastName),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textEmail),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textMobile),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textLandline),FALSE);
		gtk_text_view_set_editable(GTK_TEXT_VIEW(textHome),FALSE);
	}

	gtk_table_attach_defaults(GTK_TABLE(table), labelSearch, 1, 3, 0, 1 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelFirstName, 0, 2, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelLastName, 4, 6, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelLandline, 0, 2, 2, 3 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelMobile, 4, 6, 2, 3 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelHome, 0, 2, 3, 6 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelEmail, 0, 2, 6, 7 );

	gtk_table_attach (GTK_TABLE(table), comboSearch, 3, 6, 0, 1 , GTK_FILL,GTK_SHRINK,0,0);
	gtk_table_attach_defaults(GTK_TABLE(table),textFirstName, 2, 4, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table),textLastName, 6, 8, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), textLandline, 2, 4, 2, 3 );
	gtk_table_attach_defaults(GTK_TABLE(table), textMobile, 6, 8, 2, 3 );
	gtk_table_attach_defaults(GTK_TABLE(table), scroll, 2, 4, 3, 6 );
	gtk_container_add(GTK_CONTAINER(scroll),textHome);
	gtk_widget_set_size_request(image,250,185);
	gtk_table_attach (GTK_TABLE(table), image, 5, 8, 3, 6, GTK_SHRINK,GTK_SHRINK,0,0);
	gtk_table_attach_defaults(GTK_TABLE(table), textEmail, 2, 4, 6, 7 );
	gtk_table_attach (GTK_TABLE(table), buttonAdd, 6,8,7,8, GTK_EXPAND,GTK_EXPAND,0,0);
	GetAllContactInfo(&allContactID,&firstname,&lastname,&cnt);
	if(cnt == 0)
	{
		gtk_entry_set_editable(GTK_ENTRY(textFirstName),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textLastName),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textEmail),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textMobile),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textLandline),FALSE);
		gtk_text_view_set_editable(GTK_TEXT_VIEW(textHome),FALSE);
	}
	for(i = 0; i < cnt; i++)
	{
		sprintf(name,"%s %s",firstname[i],lastname[i]);
		gtk_combo_box_insert_text(GTK_COMBO_BOX(comboSearch),i,name);
	}	
	
	
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textHome));

	gtk_container_add(GTK_CONTAINER(frame),table);
	g_signal_connect(G_OBJECT(buttonAdd),"clicked",G_CALLBACK(ButtonAddHandler), NULL);
	g_signal_connect(G_OBJECT(comboSearch),"changed",G_CALLBACK(SearchAcquaintance), NULL);
	g_signal_connect(G_OBJECT(textMobile), "changed", G_CALLBACK(Validation),(gpointer)textMobile);
	g_signal_connect(G_OBJECT(textLandline), "changed", G_CALLBACK(Validation),(gpointer)textMobile);
	g_signal_connect(G_OBJECT(buffer),"changed",G_CALLBACK(GetData),NULL);

	gtk_combo_box_set_active(GTK_COMBO_BOX(comboSearch),0);

	return frame;
}

/** This method is an event handler for the image button used to display the image associated with a contact
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void SetImage(GtkWidget *widget, gpointer data)
{
	imageFileName = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (buttonImage));
	ResizeAndSetImage(imageFileName);
}

/** This method resizes and saves the image in the pics folder
  * @param imageFileName is the name of the image file to be associated with the contact.
 * */
void ResizeAndSetImage(char *imageFileName)
{
	char systemCommand[1000],newName[BUFFER500];
	int maxContactID=0;
	if(!strcmp(imageFileName,"(null)"))
	{
		gtk_image_set_from_file (GTK_IMAGE(image),"question.jpg");
	}
	else
	{
		if(flag == 1)
		{ 
			maxContactID = GetMaxContactID() + 1;
			sprintf(newName,"%d",maxContactID);
			strcat(newName,".jpg");
			strcpy(newPath,"pics/");
			strcat(newPath,newName);
		}
		else if(newPath[0] == '\0')
		{
			maxContactID = contactID;
			sprintf(newName,"%d",maxContactID);
			strcat(newName,".jpg");
			strcpy(newPath,"pics/");
			strcat(newPath,newName);
		}
		strcpy(systemCommand,"convert -size 5X5 '");
		strcat(systemCommand,imageFileName);
		strcat(systemCommand,"' '");
		strcat(systemCommand,newPath);
		strcat(systemCommand,"'");
		system(systemCommand);
		gtk_image_set_from_file (GTK_IMAGE(image),newPath);
	}
}

/** This method is an event handler for the combo box used in the contact feature
 * When a contact is selected, it populates the controls in the frame with the appropriate details of the contact.
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void SearchAcquaintance(GtkWidget *widget, gpointer data)
{
	int index = -1;
	char firstName[BUFFER200], lastName[BUFFER200], mobileNumber[50], landlineNumber[50],address[BUFFER2500], email[BUFFER200];
	GtkTextBuffer *buffer;
	gint len;
	index = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
	if(index  != -1)
	{
		contactID = allContactID[index];
		newPath[0] = '\0';
		gtk_image_clear(GTK_IMAGE(image));
		GetContact(contactID, firstName,lastName,mobileNumber, landlineNumber,address,email,getImageFileName);
		strcpy(newPath,getImageFileName);
		if(newPath[0] == '\0')
			gtk_image_set_from_file (GTK_IMAGE(image),"question.jpg");
		else
			gtk_image_set_from_file (GTK_IMAGE(image),newPath);
		gtk_entry_set_text(GTK_ENTRY(textFirstName),firstName);
		gtk_entry_set_text(GTK_ENTRY(textLastName),lastName);
		gtk_entry_set_text(GTK_ENTRY(textMobile),mobileNumber);
		gtk_entry_set_text(GTK_ENTRY(textLandline),landlineNumber);
		gtk_entry_set_text(GTK_ENTRY(textEmail),email);
		if(flag == 2)
			gtk_file_chooser_button_set_title(GTK_FILE_CHOOSER_BUTTON (buttonImage),getImageFileName);
		len = strlen(address);
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textHome));
		gtk_text_buffer_set_text (buffer,address, -1);
	}
}	

/** This method is an event handler for the combo box used in the todo feature
 * When a todo is selected, it populates the controls in the frame with the appropriate details of the task/todo item.
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void SearchTodo(GtkWidget *widget, gpointer data)
{
	int index = -1;
	char subject[BUFFER500],duedate[11],notes[BUFFER2500];
	GtkTextBuffer *buffer;
	gint len;
	index = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
	if(index != -1)
	{
		todoID = allTodoID[index];
		GetTodo(todoID,subject,notes,duedate);
		gtk_entry_set_text(GTK_ENTRY(textSubject),subject);
		gtk_entry_set_text(GTK_ENTRY(textDate),duedate);
		len = strlen(notes);
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textContent));
		gtk_text_buffer_set_text (buffer,notes, -1);
	}
}

/** This method returns the frame used in add/edit/delete todo functionality. 
 * It adds all the necessary controls to the frame and then returns the final result
 * @returns the frame (GtkWidget) having all the controls required in the contact feature(ie add/edit/delete)
 * */
GtkWidget *Todo()
{
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *scroll;
	GtkTextBuffer *buffer;

	GtkWidget *buttonAdd;
	GtkWidget *buttonDate;
	GtkWidget *labelSubject;
	GtkWidget *labelDate;
	GtkWidget *labelContent;
	GtkWidget *labelSearch;
	
	//note[0] = '\0';

	textSubject = gtk_entry_new_with_max_length(BUFFER500);
	scroll = gtk_scrolled_window_new (NULL,NULL);
	frame = gtk_frame_new(NULL);
	table = gtk_table_new(7, 7, FALSE);

	labelSubject = gtk_label_new("Subject");
	labelDate = gtk_label_new("Date");
	labelContent = gtk_label_new("Note");
	
	textDate = gtk_entry_new_with_max_length(11);
	gtk_entry_set_text(GTK_ENTRY(textDate),date);
	textContent = gtk_text_view_new();
	buttonDate = gtk_button_new_with_label("..");
	gtk_entry_set_editable(GTK_ENTRY(textDate),FALSE);
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textContent));
	
	if(flag == 4)
	{		
		buttonAdd = gtk_button_new_with_label("Save");
	}
	else if(flag == 5 || flag ==6)
	{
		labelSearch = gtk_label_new("Search Todo");
		comboSearchTodo = gtk_combo_box_new_text();
		gtk_table_attach_defaults (GTK_TABLE(table), labelSearch,0, 2, 0, 1);
		gtk_table_attach (GTK_TABLE(table), comboSearchTodo, 2, 5, 0, 1 , GTK_FILL,GTK_SHRINK,0,0);
		g_signal_connect(G_OBJECT(comboSearchTodo),"changed",G_CALLBACK(SearchTodo), NULL);		
	}
	if(flag == 5)
	{
		buttonAdd = gtk_button_new_with_label("Save Changes");
	}
	else if(flag == 6)
	{
		buttonAdd = gtk_button_new_with_label("Delete");
		gtk_text_view_set_editable(GTK_TEXT_VIEW(textContent),FALSE);
		gtk_entry_set_editable(GTK_ENTRY(textSubject),FALSE);
	}
	//buttonDate = set_size_request(80, 32);

	gtk_table_attach_defaults(GTK_TABLE(table), labelSubject, 0, 1, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelDate, 3, 4, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), labelContent, 0, 1, 2, 6 );

	gtk_table_attach_defaults(GTK_TABLE(table),textSubject, 1, 3, 1, 2 );
	gtk_table_attach_defaults(GTK_TABLE(table), textDate, 4, 6, 1, 2 );
	gtk_table_attach (GTK_TABLE(table), buttonDate, 6, 7, 1, 2 ,GTK_SHRINK,GTK_SHRINK,0,0);
	gtk_button_set_alignment(GTK_BUTTON(buttonDate),0.0,0.0); 
	gtk_table_attach_defaults(GTK_TABLE(table), scroll, 1, 6, 2, 6 );
	gtk_container_add(GTK_CONTAINER(scroll),textContent);
	
	gtk_table_attach (GTK_TABLE(table), buttonAdd, 4,6,6,7, GTK_FILL,GTK_EXPAND,0,0);
	//gtk_table_attach_defaults(GTK_TABLE(table), buttonAdd, 5, 7, 6, 7 );

	if(flag == 5 || flag == 6)
	{
		GetAllTodoInfo(&allTodoID,&subjectTodo,&count);
		if(count == 0)
		{
			gtk_text_view_set_editable(GTK_TEXT_VIEW(textContent),FALSE);
			gtk_entry_set_editable(GTK_ENTRY(textSubject),FALSE);
			gtk_entry_set_text(GTK_ENTRY(textDate),currentDate);
		}
		for(i = 0; i < count; i++)
		{
			sprintf(subTodo,"%s",subjectTodo[i]);
			gtk_combo_box_insert_text(GTK_COMBO_BOX(comboSearchTodo),i,subTodo);
		}
		gtk_combo_box_set_active(GTK_COMBO_BOX(comboSearchTodo),0);
	}
	gtk_container_add(GTK_CONTAINER(frame),table);
	g_signal_connect(G_OBJECT(buttonAdd),"clicked",G_CALLBACK(ButtonAddHandler), NULL);
	if(flag != 6)
	{
		if(count !=0 || (count == 0 && flag == 4))
			g_signal_connect(G_OBJECT(buttonDate),"clicked",G_CALLBACK(SelectDate), NULL);
	}
	g_signal_connect(G_OBJECT(buffer),"changed",G_CALLBACK(GetData),NULL);
	return frame;
}

/** This method is an event handler for the date button used in todo feature for due date. 
 * It creates a window and places a calender control in it and associates the control's event with respective handlers. 
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void SelectDate(GtkWidget *widget, gpointer data)
{
	if(flag2 == 0)
	{
		GtkWidget *calendarWindow;
		GtkWidget *calendar;
		flag2  = 1;
		calendarWindow =  gtk_window_new (GTK_WINDOW_TOPLEVEL);	
		gtk_window_set_title(GTK_WINDOW(calendarWindow), "Calendar");
  		gtk_window_set_default_size(GTK_WINDOW(calendarWindow), BUFFER, BUFFER);
		gtk_window_set_position(GTK_WINDOW(calendarWindow),GTK_WIN_POS_MOUSE);
		gtk_window_set_transient_for(GTK_WINDOW(calendarWindow),GTK_WINDOW(window));
		gtk_window_set_keep_above(GTK_WINDOW(calendarWindow),TRUE);
		gtk_window_set_skip_taskbar_hint(GTK_WINDOW(calendarWindow),TRUE);
		calendar = gtk_calendar_new();
		gtk_container_add(GTK_CONTAINER(calendarWindow), calendar);
		gtk_widget_show_all(calendarWindow);
		g_signal_connect(G_OBJECT(calendarWindow),"delete_event",G_CALLBACK(CloseCalendar),NULL);
		g_signal_connect(G_OBJECT(calendar),"day-selected",G_CALLBACK(GetDate), NULL);	
	}
}

/** This method is an event handler for the calender used in todo feature for due date. 
 * It gets called in the 'delete' event of the widget and destroys the widget 
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void CloseCalendar(GtkWidget *widget, gpointer data)
{
	flag2 = 0;
	gtk_widget_destroy(widget);

}

/** This method is an event handler for the calender used in todo feature for due date. 
 * It gets the date set in the GTK_CALENDER widget and sets it in the text box of due date. 
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void GetDate(GtkWidget *widget, gpointer data)
{
	guint year,month,day;
	gtk_calendar_get_date(GTK_CALENDAR(widget), &year, &month, &day);
	sprintf(date,"%d-%d-%d",year,month+1,day);
	gtk_entry_set_text(GTK_ENTRY(textDate),date);
}

/** This method returns the name of the file to which the contact details are to be exported 
 * @returns the name of the file into which teh details are to be saved - on success.
 * */
char *ExportContact()
{
	GtkWidget *dialog;
	char *fileName;
	dialog = gtk_file_chooser_dialog_new ("Save File",
				      GTK_WINDOW(window),
				      GTK_FILE_CHOOSER_ACTION_SAVE,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
				      NULL);
	gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), "/home");
    	gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (dialog), "*.vcf");
  	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  	{
    		fileName = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  	}
	gtk_widget_destroy (dialog);
	return fileName;
}

/** This method adds the contact details of a person to the application. 
 * @returns new contact id - on success. -1 on failure
 * @param firstname is the first name of the contact
 * @param lastname is the last name of the contact
 * @param mobilenumber cell number of the contact
 * @param landlinenumber is the home phone number of the contact
 * @param address is the postal address of the contact
 * @param email is the email address of the contact
 * @param imagefilename is the image file associated with the contact
 * */
int AddContactToDB(char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], char address[BUFFER2500], char email[BUFFER200], char 				imagefilename[BUFFER500])
{

	int ret_value,contactid = -1;
	char insert_stmt[MAX_BUFF_SIZE], *id = NULL;

	sprintf(insert_stmt, "INSERT into contact values(%d,'%s','%s','%s', '%s', '%s', '%s', '%s',CURDATE(),CURDATE());",(int)id, firstname, lastname, 							mobilenumber, landlinenumber, address, email, imagefilename);
	ret_value = mysql_query (default_sql_conn, insert_stmt);

	if (ret_value == 0)
	{
		printf ("\n contact inserted successfully.\n");
		// Let's retrieve the new contact id. 		
		contactid = GetMaxContactID();
	}
	else if(mysql_errno (default_sql_conn) == PRIMARY_KEY_ERROR)
	{
		fprintf(stderr,"\nCould not insert record. contactid already exists.");
	}
	else
	{
		fprintf (stderr, "\nCould not insert record - Error Number : %d. %s\n", mysql_errno (default_sql_conn), mysql_error (default_sql_conn));
	}
	
	return contactid;
}

/** This method updates the contact details of a person with a given a contact id. 
 * @returns 1 - on success. -1 on failure. -2 - if the contact id is not found in the database.
 * @param contactid is the id of the contact whose details is to be saved.
 * @param firstname is the first name of the contact
 * @param lastname is the last name of the contact
 * @param mobilenumber cell number of the contact
 * @param landlinenumber is the home phone number of the contact
 * @param address is the postal address of the contact
 * @param email is the email address of the contact
 * @param imagefilename is the image file associated with the contact
 * */
int EditContactToDB(int contactid, char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], 
			char address[BUFFER2500], char email[BUFFER200], char imagefilename[BUFFER500])
{

	int ret_value;
	char update_stmt[MAX_BUFF_SIZE];


	sprintf(update_stmt,"UPDATE contact SET firstname = '%s',lastname = '%s',mobilenumber = '%s',landlinenumber = '%s',address = '%s',email = '%s',imagefilename = '%s' where contactid = %d;",firstname, lastname, mobilenumber, landlinenumber, address, email, imagefilename, contactid);


	ret_value = mysql_query (default_sql_conn, update_stmt);

	if (ret_value == 0)
	{
		unsigned long rows_affected = (unsigned long) mysql_affected_rows (default_sql_conn);
		if(rows_affected <= 0 )
		{
			printf ("\nRecord update operation : Id not found in the database. No rows modified. \n" );
			return -2;		
		}
		else
		{
			printf ("\nRecord update operation : %lu row(s) Modified. \n",rows_affected );
			return 1;
		}
	}
	else
	{
		fprintf (stderr, "Record update operation failed : Error Code: %d. %s\n", mysql_errno (default_sql_conn), mysql_error (default_sql_conn));
	}

	return -1;

}

/** This method deletes the contact details of a person with a given a contact id. 
 * @returns 1 - on success. -1 on failure. -2 - if the contact id is not found in the database.  
 * @param contactid is the id of the contact whose details is to deleted.
 * */
int DeleteContactToDB(int contactid)
{

	char delete_stmt[MAX_BUFF_SIZE];
	int ret_value;

	sprintf(delete_stmt, "DELETE FROM contact WHERE contactid = %d", contactid);

	ret_value = mysql_query (default_sql_conn, delete_stmt);

	if (ret_value == 0)
	{
		unsigned long rows_affected = (unsigned long) mysql_affected_rows (default_sql_conn);
		if(rows_affected <= 0 )
		{
			printf ("\nRecord delete operation : Id not found in the database. No rows deleted. \n" );
			return -2;		
		}
		else
		{
			printf ("\nRecord delete operation : %lu row deleted. \n",rows_affected );
			return 1;		
		} 
	}
	else
	{
		fprintf (stderr, "Record delete operation failed : Error Code: %d. %s\n", mysql_errno (default_sql_conn), mysql_error (default_sql_conn));
	}

	return -1;

}

/** This method is an initializer for the Personal Data Manager Application.
 * It establishes a connection with the database, checks for the important tables and 'll create them if not found.
 * */
void InitializePDMDB()
{
	int ret_value = 0;
		
	if(EstablishDbConnection(&default_sql_conn, CS_USER, CS_PASSWORD, CS_DATABASE,CS_SERVER) != 1)
	{	
		exit(0);
	}

	// Creates the table contact and todo if they don't exist in the database.

	ret_value = mysql_query (default_sql_conn, "create table if not exists contact (contactid INTEGER AUTO_INCREMENT, firstname varchar(200), lastname 						varchar(200), mobilenumber varchar(50), landlinenumber varchar(50), address varchar(2500), email VARCHAR(200), 						imagefilename varchar(500), createddate DATE, lastmodifieddate DATE,PRIMARY KEY(contactid))");

	if (ret_value != 0)
	{
		fprintf (stderr, "Could not create contact table in cs3002_database as %d: %s\n", mysql_errno (default_sql_conn), 
			 mysql_error (default_sql_conn));
		ExitProgram();
	}

	ret_value = mysql_query (default_sql_conn, " create table if not exists todo (todoid INTEGER AUTO_INCREMENT, subject varchar(500), 								note varchar(5000), duedate DATE, createddate DATE, lastmodifieddate DATE,PRIMARY KEY(todoid))");

	if (ret_value != 0)
	{
		fprintf (stderr, "Could not create todo table in cs3002_database as %d: %s\n", mysql_errno (default_sql_conn), 
			 mysql_error (default_sql_conn));
		ExitProgram();
	}

}

/** This method establishes a connection with the database.
 * It is called up only during the startup of the applicaion  
 * @returns 1 on success. -1 if initialization with the database fails. -2 if connection to the database fails.
 * @param mysql_conn
 * @param username is the name of the mysql user
 * @param password is the password of the mysql user
 * @param database is the name of the database to which the application would connect to
 * @param server is the server in which the database server resides
 * */
int EstablishDbConnection(MYSQL **mysql_conn, const char username[BUFFER], const char password[BUFFER], const char database[BUFFER], const char server[BUFFER])
{

	(*mysql_conn) = mysql_init (NULL);
	if ((*mysql_conn) == NULL)
	{
		fprintf (stderr, "MySQL initialization failed\n");
		return -1;
	}

	(*mysql_conn) = mysql_real_connect ((*mysql_conn), server, username, password, database, 0, NULL, CLIENT_FOUND_ROWS);

	if ((*mysql_conn) == NULL)
	{
		printf ("Connection failed\n");
		return -2;
	}
	return 1;
}

/** This method provides an exit to the application. 
 * It will close the database connection which is open (if any) and quit the application. 
 * */
void ExitProgram()
{
	mysql_close (default_sql_conn);
	exit(0);
}

/** This is the common event handler for the text boxes which supports numbers only. 
 * The event handler will be called during the 'change' event
 * @param widget is the GtkWidget which has raised the event
 * @param data is the data associated with the event.
 * */
void Validation(GtkWidget *widget, gpointer data)
{
	char *valueEntered=gtk_entry_get_text(GTK_ENTRY(widget));
	int len=strlen(valueEntered);
	int lastPressedKey=valueEntered[len-1];
	if(lastPressedKey<48 || lastPressedKey>57)
	{
		  gtk_editable_delete_text(GTK_EDITABLE(widget),len-1,-1);
	}
	 
}

/** This method returns first name, last name and contact id of all the contacts known to this application 
 * All the arguments are passed as reference and hence form the out variables  
 * @param contactid is an array of all contact ids in the database.
 * @param fname is an array of all first names in the database.
 * @param lname is an array of all last name of in the database.
 * @param count is the total number of contacts known to the application
 * */
void GetAllContactInfo(int** contactid, char*** fname, char*** lname, int* count)
{

	MYSQL_RES *result;
	MYSQL_ROW sqlrow;
	int return_val,index = 0;

	int *contact = (*contactid);
	char **firstname = (*fname);
	char **lastname = (*lname);


	return_val =  mysql_query (default_sql_conn, "select contactid,firstname,lastname from contact");	

	if (return_val != 0)
	{
	    printf ("\nListing of records failed : %s\n", mysql_error (default_sql_conn));
	}
	else
	{
		result = mysql_store_result (default_sql_conn);
		int num_rows = (int)mysql_num_rows(result);
		(*count) = num_rows;
	
		contact = (int*)calloc(num_rows,sizeof(int));
		firstname = (char**)calloc(num_rows,sizeof(char*));
		lastname = (char**)calloc(num_rows,sizeof(char*));

		if(result != NULL)
		{
			while((sqlrow = mysql_fetch_row (result)))
			{
				firstname[index] = (char*)malloc(sizeof(char));
				lastname[index] = (char*)malloc(sizeof(char));
				contact[index] = atoi(sqlrow[0]);
				strcpy(firstname[index],sqlrow[1]);
				strcpy(lastname[index],sqlrow[2]);
				index++;
			}
			if(mysql_errno(default_sql_conn))
			{
				printf ("Error occurred while retrieving records from the database : %s\n", mysql_error (default_sql_conn));
			}
		}
		mysql_free_result(result);
	}
	(*fname) = firstname;
	(*lname) = lastname ;
	(*contactid) = contact;

}

/** This method returns the contact details of a person with a given a contact id. 
 * All the arguments except contact id is passed as reference and hence form the out variables  
 * @param contactid is the id of the contact whose details is to retrieved.
 * @param firstname is the first name of the contact
 * @param lastname is the last name of the contact
 * @param mobilenumber cell number of the contact
 * @param landlinenumber is the home phone number of the contact
 * @param address is the postal address of the contact
 * @param email is the email address of the contact
 * @param imagefilename is the image file associated with the contact
 * */
void GetContact(int contactid, char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], 
			char address[BUFFER2500], char email[BUFFER200], char imagefilename[BUFFER500])
{

	char search_stmt[MAX_BUFF_SIZE];
	int ret_val;

	MYSQL_RES *result;
	MYSQL_ROW sqlrow;

	sprintf(search_stmt,"SELECT * FROM contact WHERE contactid = %d",contactid);

	ret_val =  mysql_query (default_sql_conn, search_stmt);

	if (ret_val != 0)
	{
		printf ("Failed to fetch the record : %s\n", mysql_error (default_sql_conn));
	}
	else
	{
		result = mysql_use_result (default_sql_conn);
		if(result != NULL)
		{
			while((sqlrow = mysql_fetch_row (result)))
			{
				if(atoi(sqlrow[0]) > 0)
				{
					strcpy(firstname,sqlrow[1]);
					strcpy(lastname,sqlrow[2]);
					strcpy(mobilenumber,sqlrow[3]);
					strcpy(landlinenumber,sqlrow[4]);
					strcpy(address,sqlrow[5]);
					strcpy(email,sqlrow[6]);
					strcpy(imagefilename,sqlrow[7]);
				}
			}
			if(mysql_errno(default_sql_conn))
			{
				printf ("Error occurred while retrieving records from the database : %s\n", mysql_error (default_sql_conn));
			}
		}
		mysql_free_result(result);
	}

}

/** This method exports the contact details into .vcf format and saves it with the given file name. 
 * This method combines the details of the contact with the encoded image data, formats and saves it.  
 * @returns 1 on success. -1 on failure.
 * @param filename is the name of the file to which the data is to be exported.
 * @param firstname is the first name of the contact
 * @param lastname is the last name of the contact
 * @param mobilenumber cell number of the contact
 * @param landlinenumber home phone number of the contact
 * @param address is the postal address of the contact
 * @param email is the email address of the contact
 * @param imagefilename is the image file associated with the contact
 * */
int ExportContactFromDB(char filename[BUFFER500], char firstname[BUFFER200], char lastname[BUFFER200], char mobilenumber[50], char landlinenumber[50], char address[BUFFER2500],char email[BUFFER200], char imagefilename[BUFFER500])
{

       char content[10000], *enc_res_filename = "pdm_encresult", temp[BUFFER5000];
       FILE *temp_fp = NULL, *destin_fp = NULL;
       int IsEncodeSuccess = -1;

       char addr[BUFFER2500];
       int i = 0, j= 0, addrlength = 0;

       fprintf(stderr,"address %s. \n",address);

       destin_fp = fopen(filename,"w");
       if(destin_fp == NULL)
       {
               fprintf(stderr,"Fatal error : Failed to open file %s. \n",filename);
               return -1;
       }

       strcpy(content, "BEGIN:VCARD\nVERSION:3.0\n");

       // Name of the person
       sprintf(temp,"N:%s;%s\n",lastname,firstname);
       strcat(content,temp);
       sprintf(temp,"FN:%s %s\n",firstname,lastname);
       strcat(content,temp);

       // Phone numbers
       sprintf(temp,"TEL;X-EVOLUTION-UI-SLOT=1;TYPE=WORK,VOICE:%s\n",mobilenumber);
       strcat(content,temp);
       sprintf(temp,"TEL;X-EVOLUTION-UI-SLOT=2;TYPE=HOME,VOICE:%s\n",landlinenumber);
       strcat(content,temp);

       // Address details.

       addrlength = strlen(address);

       for(j = 0, i = 0; i < addrlength; i++)
       {
               if(address[i] == '\n')
               {
                       addr[j] = '\\';
                       j++;
                       addr[j] = 'n';
                       j++;
               }
               else
               {
                       addr[j] = address[i];
                       j++;
               }
       }
       addr[j] = '\0';

       sprintf(temp,"ADR;TYPE=HOME:;;%s\n",addr);
       strcat(content,temp);
       sprintf(temp,"LABEL;TYPE=HOME:%s\n",addr);
       strcat(content,temp);

       // Email
       sprintf(temp,"EMAIL;X-EVOLUTION-UI-SLOT=2;TYPE=HOME:%s\n",email);
       strcat(content,temp);

       // write out the content to the file.
       fwrite(content,1,strlen(content),destin_fp);

       // Process image if any
       if(imagefilename != NULL && strlen(imagefilename) > 0)
       {
               IsEncodeSuccess = EncodeImage(imagefilename);
       }

       // If encoding is done , then push the content to the vcf file.
       if(IsEncodeSuccess == 1)
       {
               temp_fp = fopen(enc_res_filename,"r");
               if(temp_fp != NULL)
               {
                       strcpy(temp, "PHOTO;TYPE=JPEG;ENCODING=BASE64:\n");
                       fwrite(temp,1,strlen(temp),destin_fp);
                       while((fscanf(temp_fp,"%s",temp) != EOF))
                       {
                               strcpy(content,"    ");
                               strcat(content,temp);
                               strcat(content,"\n");
                               fwrite(content,1,strlen(content),destin_fp);
                       }
               }
       }

       // End of VCF
       strcpy(temp,"\nEND:VCARD");
       fwrite(temp,1,strlen(temp),destin_fp);

       fclose(destin_fp);
       return 1;

}

/** This method encodes th given image and stores it in a temp file.
 * It is an interface method which makes use of encode.h and does a base64 encoding of the given image.
 * @param imagefilename is the name of the image file to be encoded. 
 * @returns 1 - On Success. -1 - On failure.
 * */
int EncodeImage(char imagefilename[BUFFER500])
{

	char *enc_res_filename = "pdm_encresult";
	int ret_val  = -1;
	FILE *fp = NULL;

	fp = fopen(enc_res_filename,"w");
	if(fp == NULL)
	{
		fprintf(stderr,"Fatal error : Failed to temp file %s. \n",enc_res_filename);
		return -1;
	}
	fclose(fp);

	fp = fopen(imagefilename,"r");
	if(fp == NULL)
	{
		fprintf(stderr,"Fatal error : Failed to image file %s. \n",imagefilename);
		return -1;
	}
	fclose(fp);

	ret_val = b64('e', imagefilename, enc_res_filename, 64);

	if(ret_val != 0)
		return -1;
	else
		return 1;

}

/** This method returns the maximum value of the contact id among the set of contacts.
 * It is a db layer method which accesses the database to get the value. 
 * @returns positive contact-id - on success. 0 - if the table is empty. -1 on failure.
 * */
int GetMaxContactID()
{

    int ret_value,contactid = -1;
    MYSQL_ROW sqlrow;
    MYSQL_RES *result;

    ret_value =  mysql_query (default_sql_conn, "select max(contactid) from contact;");

    if (ret_value != 0)
    {
            printf ("Retrieval of record failed : %s\n", mysql_error (default_sql_conn));
    }
    else
    {
        result = mysql_store_result (default_sql_conn);
        if(result != NULL)
        {
	    while((sqlrow = mysql_fetch_row (result)))
            {
		    if(sqlrow[0] == NULL)
			contactid = 0;
		    else if(atoi(sqlrow[0]) > 0)
                    	contactid = atoi(sqlrow[0]);
            }
            if(mysql_errno(default_sql_conn))
            {
                printf ("Error occurred while retrieving records from the database : %s\n", mysql_error (default_sql_conn));
            }
        }
        mysql_free_result(result);
    }

    return contactid;

}

/** This method adds the given todo details to the application. 
 * @returns the new todo -id of thhe given todo details.
 * @param subject is the main topic/summary of the task to be done
 * @param note consists of the task in detail
 * @param duedate is the date on which the task will be due. 
 * */
int AddTodo(char subject[BUFFER500], char note[BUFFER5000], char duedate[BUFFER])
{

	int ret_value,todoid = -1;
	char insert_stmt[MAX_BUFF_SIZE], *id = NULL;
	MYSQL_ROW sqlrow;
	MYSQL_RES *result;

	sprintf(insert_stmt, "INSERT into todo values(%d,'%s','%s','%s',CURDATE(),CURDATE());",(int)id, subject, note, 							duedate);

	ret_value = mysql_query (default_sql_conn, insert_stmt);

	if (ret_value == 0)
	{
		printf ("\n todo inserted successfully.\n");

		// Let's retrieve the new contact id. 

		ret_value =  mysql_query (default_sql_conn, "select max(todoid) from todo;");

		if (ret_value != 0)
		{
	    		printf ("Retrieval of record failed : %s\n", mysql_error (default_sql_conn));
		}
		else
		{
			result = mysql_use_result (default_sql_conn);
			if(result != NULL)
			{
				while((sqlrow = mysql_fetch_row (result)))
				{
					if(atoi(sqlrow[0]) > 0)
						todoid = atoi(sqlrow[0]);
				}
				if(mysql_errno(default_sql_conn))
				{
					printf ("Error occurred while retrieving records from the database : %s\n", mysql_error (default_sql_conn));
				}
			}
			mysql_free_result(result);
			return todoid;	
		}
	}
	else if(mysql_errno (default_sql_conn) == PRIMARY_KEY_ERROR)
	{
		fprintf(stderr,"\nCould not insert record. todo-id already exists.");
	}
	else
	{
		fprintf (stderr, "\nCould not insert record - Error Number : %d. %s\n", mysql_errno (default_sql_conn), mysql_error (default_sql_conn));
	}
	return -1;
}

/** This method edits the given todo details to the application. 
 * @returns 1 - on success. -1 on failure. -2 - if the todo id is not found in the database.
 * @param todoid is the id of the task whose details is to updated.
 * @param subject is the main topic/summary of the task to be done
 * @param note consists of the task in detail
 * @param duedate is the date on which the task will be due. 
 * */
int EditTodo(int todoid, char subject[BUFFER500], char note[BUFFER5000], char duedate[BUFFER])
{

	int ret_value;
	char update_stmt[MAX_BUFF_SIZE];

	sprintf(update_stmt,"UPDATE todo SET subject = '%s',note = '%s',duedate = '%s' where todoid = %d;",subject, note, duedate,todoid);
	ret_value = mysql_query (default_sql_conn, update_stmt);

	if (ret_value == 0)
	{
		unsigned long rows_affected = (unsigned long) mysql_affected_rows (default_sql_conn);
		if(rows_affected <= 0 )
		{
			printf ("\nRecord update operation : Id not found in the database. No rows modified. \n" );
			return -2;		
		}
		else
		{
			printf ("\nRecord update operation : %lu row(s) Modified. \n",rows_affected );
			return 1;
		}
	}
	else
	{
		fprintf (stderr, "Record update operation failed : Error Code: %d. %s\n", mysql_errno (default_sql_conn), mysql_error (default_sql_conn));
	}

	return -1;

}

/** This method deletes the todo details with a given a todo id. 
 * @returns 1 - on success. -1 on failure. -2 - if the todo-id is not found in the database.  
 * @param todoid is the id of the task whose details is to deleted.
 * */
int DeleteTodo(int todoid)
{

	char delete_stmt[MAX_BUFF_SIZE];
	int ret_value;

	sprintf(delete_stmt, "DELETE FROM todo WHERE todoid = %d", todoid);

	ret_value = mysql_query (default_sql_conn, delete_stmt);

	if (ret_value == 0)
	{
		unsigned long rows_affected = (unsigned long) mysql_affected_rows (default_sql_conn);
		if(rows_affected <= 0 )
		{
			printf ("\nRecord delete operation : Id not found in the database. No rows deleted. \n" );
			return -2;		
		}
		else
		{
			printf ("\nRecord delete operation : %lu row deleted. \n",rows_affected );
			return 1;		
		} 
	}
	else
	{
		fprintf (stderr, "Record delete operation failed : Error Code: %d. %s\n", mysql_errno (default_sql_conn), mysql_error (default_sql_conn));
	}

	return -1;

}

/** This method returns the todo details of a task with a given a todo id. 
 * All the arguments except todo id is passed as reference and hence form the out variables  
 * @param todoid is the id of the todo item whose details is to retrieved.
 * @param subject is the main topic/summary of the task to be done
 * @param note consists of the task in detail
 * @param duedate is the date on which the task will be due. 
 * */
void GetTodo(int todoid, char subject[BUFFER500], char note[BUFFER5000], char duedate[BUFFER])
{

	char search_stmt[MAX_BUFF_SIZE];
	int ret_val;

	MYSQL_RES *result;
	MYSQL_ROW sqlrow;

	sprintf(search_stmt,"SELECT * FROM todo WHERE todoid = %d",todoid);

	ret_val =  mysql_query (default_sql_conn, search_stmt);

	if (ret_val != 0)
	{
		printf ("Failed to fetch the record : %s\n", mysql_error (default_sql_conn));
	}
	else
	{
		result = mysql_use_result (default_sql_conn);
		if(result != NULL)
		{
			while((sqlrow = mysql_fetch_row (result)))
			{
				if(atoi(sqlrow[0]) > 0)
				{
					strcpy(subject,sqlrow[1]);
					strcpy(note,sqlrow[2]);
					strcpy(duedate,sqlrow[3]);
				}
			}
			if(mysql_errno(default_sql_conn))
			{
				printf ("Error occurred while retrieving records from the database : %s\n", mysql_error (default_sql_conn));
			}
		}
		mysql_free_result(result);
	}

}

/** This method returns subject/summary and todo id of all the todo items known to this application 
 * All the arguments are passed as reference and hence form the out variables  
 * @param todoid is an array of all todo item ids in the database.
 * @param subject is an array of all task item summaries in the database.
 * @param count is the total number of todo items known to the application
 * */
void GetAllTodoInfo(int** todoid, char*** subject, int* count)
{

	MYSQL_RES *result = NULL;
	MYSQL_ROW sqlrow;
	int return_val,index = 0;

	int *todo = (*todoid);
	char **sub = (*subject);

	return_val =  mysql_query (default_sql_conn, "select todoid,subject from todo");	

	if (return_val != 0)
	{
	    printf ("\nListing of records failed : %s\n", mysql_error (default_sql_conn));
	}
	else
	{
		result = mysql_store_result (default_sql_conn);
		int num_rows = (int)mysql_num_rows(result);
		(*count) = num_rows;
	
		todo = (int*)calloc(num_rows,sizeof(int));
		sub = (char**)calloc(num_rows,sizeof(char*));

		if(result != NULL)
		{
			while((sqlrow = mysql_fetch_row (result)))
			{
				sub[index] = (char*)calloc(strlen(sqlrow[1]) + 1,sizeof(char));
				todo[index] = atoi(sqlrow[0]);
				strcpy(sub[index],sqlrow[1]);
				sub[index][strlen(sqlrow[1])] = '\0';
				index++;
			}
			if(mysql_errno(default_sql_conn))
			{
				printf ("Error occurred while retrieving records from the database : %s\n", mysql_error (default_sql_conn));
			}
		}
		mysql_free_result(result);
	}

	(*subject) = sub;
	(*todoid) = todo;

}
