/*!
 * This class handles operations on the primary window widget.
 */

#ifndef MONITORWIDGET_H
#define MONITORWIDGET_H

#include <QtGui>
#include <QTabWidget>
#include <QItemSelection>
#include <QGraphicsScene>
#include <QGraphicsView>
#include <QToolButton>

#include "tablemodel.h"
#include "sysinfotab.h"
#include "previewwindow.h"
#include "plot.h"

static const QSize resultSize(540, 400);

QT_BEGIN_NAMESPACE
class QSortFilterProxyModel;
class QItemSelectionModel;
QT_END_NAMESPACE

class MonitorWidget : public QTabWidget
{
    Q_OBJECT

public:
    MonitorWidget(QWidget *parent=0);
    void loadImage(const QString &fileName, QImage *image,QToolButton *button);

public slots:
    void addEntry(QString name, QString pid, QString cpu, QString owner);
    void removeEntry();
    void refreshImage();

signals:
    void doubleClicked(QModelIndex);

private:
    QImage *image;
    QTimer *timer;
    QSortFilterProxyModel *proxyModel;
    QToolButton *btn;

    Plot p;
    TableModel *table;
    SysInfoTab *sysInfoTab;

    void setupTabs();
};

#endif // MONITORWIDGET_H
