#include "processextractor.h"

QList<Process> qList;

ProcessExtractor::ProcessExtractor()
{
}

ProcessExtractor::~ProcessExtractor()
{
}

/*!
 * This function executes the top command and populates the result in an output
 * file.
 */
int ProcessExtractor::executeProcess()
{
    char command[50];
    int ret;

    sprintf(command, "top -b -n 1 > %s", OPFILEPATH);
    ret = system(command);
    if (WIFSIGNALED(ret) && (WTERMSIG(ret) == SIGINT || WTERMSIG(ret) == SIGQUIT))
           ret = -1;
    return ret;
}

/*!
 * This function establishes connection with the sqlite database.
 */
int ProcessExtractor::connectToDB(int flag)
{
    char *zErrMsg = 0;
    int rc = sqlite3_open (DBNAME, &db);
    if (rc)
    {
        fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db));
        sqlite3_close (db);
        return -1;
    }
    if(flag == 0)
    {
        rc = sqlite3_exec(db, "CREATE TABLE processes(PID,USER,CPU,NAME);", NULL, 0, &zErrMsg);
        if (rc != SQLITE_OK)
        {
            fprintf (stderr, "SQL error: %s\n", zErrMsg);
            return -1;
        }
    }
    return 1;
}

/*!
 * Function to close the sqlite database connection
 */
void ProcessExtractor::closeDB()
{
    sqlite3_close (db);
}

/*!
 * Function to parse query to insert rows into sqlite database table from the
 * file populated in the function executeProcess().
 */
void ProcessExtractor::addToDatabase()
{
    FILE *fp;
    char *line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0, fieldCounter = 0;;
    char *str, *token;
    char *saveptr;
    std::string query = "";
    if(executeProcess() != -1)
    {
        fp = fopen(OPFILEPATH, "r");
        if(fp == NULL)
        {
            fprintf(stderr, "Cant open file '%s' for writing\n", OPFILEPATH);
            perror("stderr");
            exit(EXIT_FAILURE);
        }
       int flag = 0;
       string rm_cmd = "rm ";
       rm_cmd.append(DBNAME);
       system(rm_cmd.c_str());
       if(connectToDB(0) != -1)
       {
           while ((read = getline(&line, &len, fp)) != -1)
           {
                if(count > 6)
                {
                    query = "INSERT INTO processes(PID,USER,CPU,NAME) VALUES(";
                    fieldCounter = 0;
                    flag = 0;
                    for (str = line; ; str = NULL)
                    {
                        token = strtok_r(str, " \n", &saveptr);
                        if (token == NULL)
                           break;
                        fieldCounter++;
                        if(fieldCounter == 1 || fieldCounter == 2
                           || fieldCounter == 9 || fieldCounter == 12)
                        {
                            query.append("\"");
                            query.append(token);
                            query.append("\"");
                            if(fieldCounter != 12)
                                query.append(",");
                            flag = 1;
                        }

                    }
                    query.append(");");
                    if(flag == 1)
                    {
                        insertIntoDB(query);
                    }
                }
                count++;
            }
           closeDB();
        }
        fclose(fp);
    }

}

/*!
 * Function to exceute the insert query for sqlite database. Called by
 * addToDatabase().
 */
int ProcessExtractor::insertIntoDB(std::string query)
{
    char *zErrMsg = 0;
    int rc = sqlite3_exec(db, query.c_str(), NULL, 0, &zErrMsg);
    if (rc != SQLITE_OK)
    {
        fprintf (stderr, "SQL error: %s\n", zErrMsg);
        return -1;
    }
    return 1;
}

/*!
 * Function pointer used in execution of sqlite select query. Parses every row
 * and calls the get and set functions of Process class.
 */
int callback (void *NotUsed, int argc, char **argv, char **azColName)
{
    NotUsed = 0;
    Process p;
    int i;
    for (i = 0; i < argc; i++)
    {
        switch(i)
       {
            case 0:
                p.setPid(argv[i]);
                break;
            case 1:
                p.setName(argv[i]);
                break;
            case 2:
                p.setCpu(argv[i]);
                break;
            case 3:
                p.setOwner(argv[i]);
                break;
            default: break;
        }
    }
    qList.append(p);
    return 0;
}

/*!
 * Function to execute select query on processes table of sqlite database.
 */
QList<Process> ProcessExtractor::getList()
{

    int rc;
    Process p1;
    char* zErrMsg;
    std::string query = "SELECT * FROM processes;";
    qList.clear();
    if(connectToDB(1) != -1)
    {
        rc = sqlite3_exec(db, query.c_str(), callback, 0, &zErrMsg);
        if (rc != SQLITE_OK)
        {
            fprintf (stderr, "SQL error: %s\n", zErrMsg);
            sqlite3_close (db);
            return qList;
        }
        sqlite3_close (db);
    }

    return qList;
}
