/*!
 * This class represents the system information retrieval
 */

#ifndef __SYSINFO_H__
#define __SYSINFO_H__

#include<string>
#include<vector>

#include<sys/utsname.h>
#include <glib.h>
#include <glib/gi18n.h>

#include <glibtop/fsusage.h>
#include <glibtop/mountlist.h>
#include <glibtop/mem.h>
#include <glibtop/sysinfo.h>

#include<QtGui>
#include <QtXml/QDomDocument>
#include<QtXmlPatterns/QXmlQuery>

using std::string;
using std::vector;

class SysInfo
  {
  public:
    string hostname;
    string distro_name;
    string distro_release;
    string kernel;
    guint64 memory_bytes;
    guint64 free_space_bytes;
    guint n_processors;
    vector<string> processors;

    QString gnome_version;

    SysInfo();
    virtual ~SysInfo();

private:
    void load_memory_info();
    void load_processors_info();
    void load_disk_info();
    void load_uname_info();
    void load_gnome_version();

    static const struct utsname & uname()
    {
        static struct utsname name;

        if (!name.sysname[0])
        {
            ::uname(&name);
        }

        return name;
    }
public:
    QString getHostName();
    QString getKernel();
    QString getGnome();
    QString getFreeSpace();
    QString getProcessor();
    QString getMemory();
    QString getRelease();

    std::string exec(char* cmd) ;
    QString convertGuintToQString(guint64 size, guint64 max_size = 0, bool want_bits = false);

  };
#endif // __SYSINFO_H__
