#include "sysinfotab.h"

/*!
 * Function to display system information on assigned tab of main window.
 */
SysInfoTab::SysInfoTab(QWidget *parent)
{
    Q_UNUSED(parent);

    SysInfo info;
    descriptionLabel = new QLabel();
    kernel = new QLabel();
    gnome = new QLabel();
    hardWare = new QLabel();
    status = new QLabel();
    freeSpace = new QLabel();
    memory = new QLabel();
    release = new QLabel();

    QString str = "<big><big><b><u>";
    str.append(info.getHostName());
    str.append("</u></b></big></big>");
    descriptionLabel->setText(str);
    release->setText(info.getRelease());
    str = "Kernel ";
    str.append(info.getKernel());
    kernel->setText(str);

    str = "GNOME ";
    str.append(info.getGnome());
    gnome->setText(str);

    hardWare->setText("<b>Hardware</b>");
    str = "Memory: ";
    str.append(info.getMemory());
    str.append("\n");
    str.append(info.getProcessor());
    memory->setText(str);
    status->setText("<b>System Status</b>");

    str = "Available disk space: ";
    str.append(info.getFreeSpace());
    freeSpace->setText(str);

    mainLayout = new QVBoxLayout;
    mainLayout->addWidget(descriptionLabel);
    mainLayout->addWidget(release);
    mainLayout->addWidget(kernel);
    mainLayout->addWidget(gnome);
    mainLayout->addWidget(hardWare);
    mainLayout->addWidget(memory);
    mainLayout->addWidget(status);
    mainLayout->addWidget(freeSpace);
    setLayout(mainLayout);
    info.getRelease();
}

SysInfoTab::~SysInfoTab()
{
    delete descriptionLabel;
    delete hardWare;
    delete kernel;
    delete gnome;
    delete status;
    delete freeSpace;
    delete memory;
    delete release;
    delete mainLayout;
}
