/** This program is client program which when executed produce a login window then a product information window.
  * The administrator can insert,update,retrieve and delete information about product on the basis of ProductID. 	
  * The program will use GtkWidget of GtkLabel and GtkWindow to show message to user.
  * We will use sockets in this program to get data from the server.
  * @author Jogender Singh 
  * @version 1.0
  * @file client.c
  * @date 5/4/2010
  */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib.h>

int sockfd;
 
char ch[1000];
GtkWidget *window;
GtkWidget *entry1;
GtkWidget *entry2;
GtkWidget *entry3;	
GtkWidget *entry4;
GtkWidget *entry5;
GtkWidget *combo;
GtkWidget *combo2;
GList *glist=NULL;
GList *glist2=NULL;

char list[4096];
char populate[1000][10];
char retrieval[1000];
int count;
/** It is used to write data to a particular socket file descriptor.
 * @param fd the socket descriptor from where data is to be written.
 * @param buf the characters which are to be written on socket fd.
 * @param count the number of characters which is to be written
 */

void Write(int fd, char *buf, int count)
{
    int return_value;
    printf("%s\n",buf);
    return_value=write(fd,buf,count);
    if(return_value < 0)
    {
	perror("Write failed\n");
	exit(1);
    }
	
}
/** It is used to read data from a particular socket file descriptor.
 * @param fd the socket descriptor from where data is to be read.
 * @param buf the characters which are to be read from socket fd.
 * @param count the number of characters which is to be read
 */

void Read(int fd, char *buf, int count)
{
    int rc;
    rc = read(fd, buf, count);
    if(rc < 0)
    {
	perror("Can't read");
	exit(1);
    }
    strcpy(ch,buf);
    printf("Chars from server = %s\n", buf);
    
}
/** It is called when user tries to close window using window manager.
 * We will always disable closing of window using window manager.
 * @param widget1 Widget which generated the event.
 * @param data any additional data passed while generating signal.
 * @return TRUE if you want to disable closing, FALSE otherwise
 */
gint destroyapp (GtkWidget *widget, gpointer gdata)
{
  g_print ("Quitting...\n");
  gtk_main_quit();
  return (FALSE);
}
/** It sets all the text entries in product info window blank.
 * @return void
 */
void clear()
{
	gtk_entry_set_text(GTK_ENTRY(entry1),"");
	gtk_entry_set_text(GTK_ENTRY(entry2),"");
	gtk_entry_set_text(GTK_ENTRY(entry3),"");
	gtk_entry_set_text(GTK_ENTRY(entry4),"");
	gtk_entry_set_text(GTK_ENTRY(entry5),"");
	gtk_entry_set_text(GTK_ENTRY (GTK_COMBO (combo)->entry)," ");
	gtk_entry_set_text(GTK_ENTRY (GTK_COMBO (combo2)->entry)," ");		
}
/** It is called when user tries to enter or try to modify data using product information window.
 * There should be some value in the combo box while retrieving the data if left empty then it will produce garbage value.
 * Data retrieval can be done on the basis of CATEGORY and Porduct ID.
 * @param widget1 Widget which generated the event.
 * @param data any additional data passed while generating signal.
 * @return void
 */
void callback( GtkWidget *widget,gpointer   data )
{
   char  value[100];
   char L1[100];
   char L2[100];
   char L3[100];
   char L4[100];
   char L5[100];
   char L6[100];	
   	strcpy(value,(char*)data); 
	//g_print("%s ",value);
	if(strcmp(value,"Exit")==0)
          { destroyapp(window,"Exit");
            strcpy(ch,"stop");
	   }	 
        if(strcmp(value,"Clear")==0)
	   clear();
	
        if(strcmp(value,"Update")==0)
        { 
		int len=strlen(value);	
		Write(sockfd,value,len);
        	const gchar* l1=gtk_entry_get_text(GTK_ENTRY (entry1));
		strcpy(L1,l1);			
		const gchar* l2=gtk_entry_get_text(GTK_ENTRY (entry2));
		strcpy(L2,l2);			
		const gchar* l3=gtk_entry_get_text(GTK_ENTRY (entry3));
		strcpy(L3,l3);			
		const gchar* l4=gtk_entry_get_text(GTK_ENTRY (entry4));
		strcpy(L4,l4);			
		const gchar* l5=gtk_entry_get_text(GTK_ENTRY (entry5));
        	strcpy(L5,l5);
		strcpy(L6,gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo2)->entry)));
	
		if(strlen(L1)==0 ||strlen(L2)==0||strlen(L3)==0||strlen(L4)==0||strlen(L5)==0||strlen(L6)==0)
		{
		GtkWidget *dialog;
    		dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"Update cant be performed:one of the 			field is empty");
    		gtk_dialog_run (GTK_DIALOG (dialog));
    		gtk_widget_destroy (dialog);
		clear();
		}
		else
		{
		strcat(L1," ");strcat(L2," ");strcat(L3," ");strcat(L4," ");strcat(L5," ");			
        	strcpy(ch,L1);
		strcat(ch,L2);
		strcat(ch,L3);
		strcat(ch,L4);
		strcat(ch,L5);
		strcat(ch,L6);    
        	int l=strlen(ch);
		Write(sockfd, ch, l);
		Read(sockfd, ch, l);
		clear();
		}	
	}

	if(strcmp(value,"Insert")==0)
        { 
		int len=strlen(value);	
		const gchar* l1=gtk_entry_get_text(GTK_ENTRY (entry1));
		strcpy(L1,l1);			
		const gchar* l2=gtk_entry_get_text(GTK_ENTRY (entry2));
		strcpy(L2,l2);			
		const gchar* l3=gtk_entry_get_text(GTK_ENTRY (entry3));
		strcpy(L3,l3);			
		const gchar* l4=gtk_entry_get_text(GTK_ENTRY (entry4));
		strcpy(L4,l4);			
		const gchar* l5=gtk_entry_get_text(GTK_ENTRY (entry5));
        	strcpy(L5,l5);
		strcpy(L6,gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo2)->entry)));
	
		if(strlen(L1)==0 ||strlen(L2)==0||strlen(L3)==0||strlen(L4)==0||strlen(L5)==0||strlen(L6)==0)
			{
			GtkWidget *dialog;
    			dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"Insert can't be performed:one of the field is empty");
    			gtk_dialog_run (GTK_DIALOG (dialog));
    			gtk_widget_destroy (dialog);
			clear();
			}
			else
			{
			Write(sockfd,value,len);
			strcat(L1," ");	strcat(L2," ");	strcat(L3," ");	strcat(L4," ");strcat(L5," ");
        		strcpy(ch,L1);
			strcat(ch,L2);
			strcat(ch,L3);
			strcat(ch,L4);
			strcat(ch,L5);   
			strcat(ch,L6);
			printf("%s\n",ch);
        		int l=strlen(ch);
			Write(sockfd, ch, l);
			Read(sockfd, ch, l);
			clear();
			}
	}
	if(strcmp(value,"combo")==0)
	{
		int len=strlen(value);	
		write(sockfd,value,len);
        	Read(sockfd,list,4096);
		char delims[]=" ";
		char *result=NULL;
		result = strtok( list, delims );
		count=0;
		glist=NULL;
		while( result != NULL ) 
		{   
			strcpy(populate[count],result);
			    glist = g_list_append(glist, populate[count]);	
			    result = strtok( NULL, delims );
				count++;
			}	
		gtk_combo_set_popdown_strings( GTK_COMBO(combo) , glist );
	}
	
		if(strcmp(value,"combo2")==0)		
		 printf("%s ",value);          

	if(strcmp(value,"Retrieve")==0)
	{	
		Write(sockfd,value,strlen(value));		
		char string[100],string2[100] ;
		strcpy(string,gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry)));
		strcpy(string2,gtk_entry_get_text(GTK_ENTRY (GTK_COMBO (combo2)->entry)));	
		if(strlen(string)!=0||strlen(string2)!=0)
		{
		strcat(string," ");
		strcat(string,string2);	
		Write(sockfd,string,strlen(string));
		read(sockfd,retrieval,1000);
		printf("%d\n",strlen(retrieval));
		}
		else
		{
		GtkWidget *dialog;
	    		dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"Id combo box or category is empty");
	    		gtk_dialog_run (GTK_DIALOG (dialog));
	    		gtk_widget_destroy (dialog);
			clear();
		}
		if(retrieval[0]=='F')
		{
			GtkWidget *dialog;
	    		dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"There is no such ID in Particular Ctegory");
	    		gtk_dialog_run (GTK_DIALOG (dialog));
	    		gtk_widget_destroy (dialog);
			clear();	
		}
		else{	
			char delims[]=" ";
			char *result=NULL;
			result = strtok( retrieval, delims );
			int i=0;
			char str[6][100];
			while( result != NULL ) 
			{   strcpy(str[i],result);
			    result = strtok( NULL, delims );
				i++;
			}		
			gtk_entry_set_text(GTK_ENTRY(entry1),str[0]);
			gtk_entry_set_text(GTK_ENTRY(entry2),str[1]);
			gtk_entry_set_text(GTK_ENTRY(entry3),str[2]);
			gtk_entry_set_text(GTK_ENTRY(entry4),str[3]);
			gtk_entry_set_text(GTK_ENTRY(entry5),str[4]);
			gtk_entry_set_text(GTK_ENTRY (GTK_COMBO (combo2)->entry),str[5]);			
		}
	}
		
	if(strcmp(value,"Delete")==0)
	{	//printf("%s\n",value);
		Write(sockfd,value,strlen(value));
		char string[100]; 
		strcpy(string, gtk_entry_get_text (GTK_ENTRY (entry1)));
		if(strlen(string)!=0)
			Write(sockfd,string,strlen(string));
		else
		{  GtkWidget *dialog;
	    		dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"ID Field is empty ");
	    		gtk_dialog_run (GTK_DIALOG (dialog));
	    		gtk_widget_destroy (dialog);		
			clear();
			}
	          clear();
		
	}
}


GtkWidget *e1;
GtkWidget *e2;
GtkWidget *l3;
GtkWidget *window1;

/** This is where handles the action performed by the login window and the widgets in it.
 * All other arguments are ignored.
 * @param argc  widget Widget which generated the event.
 * @param data data any additional data passed while generating signal.
 * @return void
 */
void action ( GtkWidget *widget,gpointer   data )
{
   	char  value[100];
	strcpy(value,(char*)data); 
	char l1[50];
	strcpy(l1,gtk_entry_get_text(GTK_ENTRY (e1)));
	//printf("%s\n",l1);
	char l2[50];
	strcpy(l2,gtk_entry_get_text(GTK_ENTRY (e2)));
	if((strcmp(l1,"User")==0)&&(strcmp(l2,"lucky")==0))
	{
	gtk_widget_destroy (window1);
	gtk_main_quit();
	}
	else
	{
	GtkWidget *dialog;
    	dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"INCORRECT USERNAME OR PASSWORD--Re ENTER Username & Password");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
	gtk_entry_set_text(GTK_ENTRY(e1),"");
	gtk_entry_set_text(GTK_ENTRY(e2),"");
	}			
	//gtk_entry_set_text(GTK_ENTRY(entry1),value);
}


/** This is code which displays login.
 * The login information is verified on client itself as there is only one user. 
 * All other arguments are ignored.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 * @return 0 
 */

int login (int argc, char *argv[])
{
  
  
  GtkWidget *tab1;
  GtkWidget *tab2;
  GtkWidget *l1;
  GtkWidget *l2;
  GtkWidget *button;

  gtk_init (&argc, &argv);
  window1 = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  e1 = gtk_entry_new();
  e2 = gtk_entry_new();
  l1 = gtk_label_new("USER NAME");
  l2 = gtk_label_new("PASSWORD");
   button = gtk_button_new_with_label("SUBMIT");
  tab1 = gtk_table_new(3, 2, FALSE);
  tab2 = gtk_table_new(1, 3, FALSE);	
  gtk_table_set_col_spacings(GTK_TABLE(tab1), 15); 
  gtk_table_set_row_spacings(GTK_TABLE(tab1), 35);
  gtk_table_set_col_spacings(GTK_TABLE(tab2), 25); 
  gtk_table_set_row_spacings(GTK_TABLE(tab2), 25);
   
  gtk_entry_set_visibility( GTK_ENTRY( e2),FALSE );
  
  gtk_signal_connect(GTK_OBJECT(window1), "delete_event", GTK_SIGNAL_FUNC(destroyapp), NULL);

  /*-- Add the items to the table --*/
  gtk_table_attach(GTK_TABLE(tab1), l2, 0, 1, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tab1), l1, 0, 1, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tab1), e1, 1, 2, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tab1), e2, 1, 2, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tab2), button, 1, 2, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tab1), tab2, 1, 2, 2, 3, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  
  char str[]="SUBMIT";
  gtk_signal_connect (GTK_OBJECT (button), "clicked",GTK_SIGNAL_FUNC (action), (gpointer) str);  
 
  /*-- Add the table to the window --*/
  gtk_container_add(GTK_CONTAINER(window1), tab1);

  /*-- Set window border to zero so that text area takes up the whole window --*/
  gtk_container_border_width (GTK_CONTAINER (window1), 5);

  /*-- Set the window to be 640 x 480 pixels --*/
  gtk_window_set_default_size (GTK_WINDOW(window1), 400, 200);
  gtk_container_border_width (GTK_CONTAINER (window1), 50);
  /*-- Set the window title --*/
  gtk_window_set_title(GTK_WINDOW (window1), "LOGIN");

  /*-- Display the widgets --*/
  gtk_widget_show_all(window1);
  /*-- Start the GTK event loop --*/
  gtk_main();

  /*-- Return 0 if exit is successful --*/
  return 0;
}

/** This is where program for interface to connect server.
 * All other arguments are ignored.
 * The most important thing is that the while entering into the text field no spaces should br given if required then _ , can be included. 
 * It uses tables,entries,combo box,labels and buttons.
 * It is used to Insert,Update,Delete,Retrieve information.
 * It displays the information in the entries on the basis of ID
 * @return void	 
 */

void interface()
{
  
  GtkWidget *table;
  GtkWidget *hlabel;
  GtkWidget *table1;
  GtkWidget *table2;
  GtkWidget *label1;
  GtkWidget *label2;
  
  GtkWidget *button;
  
  char *values[6] = { "Insert", "Update", "Delete","Retrieve", "Clear","Exit" };

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  table = gtk_table_new(3, 2, FALSE); 
  gtk_table_set_row_spacings(GTK_TABLE(table), 25);

  table1 = gtk_table_new(1, 5, FALSE);
  gtk_table_set_col_spacings(GTK_TABLE(table1), 15); 
  //gtk_table_set_row_spacings(GTK_TABLE(table1), 25);
 
  hlabel = gtk_label_new("PRODUCT INFORMATION");
  gtk_table_attach(GTK_TABLE(table), hlabel,  0, 2, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);

  table2 = gtk_table_new(6,4, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table2), 15);
  gtk_table_set_col_spacings(GTK_TABLE(table2), 10);
  label1 = gtk_label_new("ID");
  entry1 = gtk_entry_new();

  combo=gtk_combo_new();
  char str[]="combo"; 
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), "1001"); 
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->button), "pressed",GTK_SIGNAL_FUNC(callback), (gpointer) str );

  combo2=gtk_combo_new();
  char str1[]="combo2"; 
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo2)->entry), "Sports"); 
  
  glist2 = g_list_append(glist2, "Domestic");
  glist2 = g_list_append(glist2, "Sports");
  glist2 = g_list_append(glist2, "Garments"); 
  glist2 = g_list_append(glist2, "Appliances");
  gtk_combo_set_popdown_strings( GTK_COMBO(combo2) , glist2 );
  
  gtk_table_attach(GTK_TABLE(table2), label1, 0, 1, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(table2), entry1, 1, 2, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(table2), combo,  2, 3, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  
  GtkWidget *label6;
  label6=gtk_label_new("CATEGORY");
  gtk_table_attach(GTK_TABLE(table2), label6, 0, 1, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(table2), combo2, 1, 2, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
 
  g_signal_connect (G_OBJECT (GTK_COMBO (combo2)->button), "pressed",GTK_SIGNAL_FUNC(callback), (gpointer) str1 );
  
 
  entry2 = gtk_entry_new();
  label2 = gtk_label_new("DESCRIPTION");
  gtk_table_attach(GTK_TABLE(table2), label2, 0, 1, 2, 3, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(table2), entry2, 1, 3, 2, 3, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
 
  GtkWidget *label3;
  entry3 = gtk_entry_new();
  label3 = gtk_label_new("RATE");
  gtk_table_attach(GTK_TABLE(table2), label3, 0, 1, 3, 4, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(table2), entry3, 1, 3, 3, 4, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  
  GtkWidget *label4;
  entry4 = gtk_entry_new();
  label4 = gtk_label_new("QUANTITY");
  gtk_table_attach(GTK_TABLE(table2), label4, 0, 1, 4, 5, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(table2), entry4, 1, 3, 4, 5, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);  
  
  GtkWidget *label5;
  entry5 = gtk_entry_new();
  label5 = gtk_label_new("UNIT OF MEASUREMENT");
  gtk_table_attach(GTK_TABLE(table2), label5, 0, 1, 5, 6, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(table2), entry5, 1, 3, 5, 6, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);  
  
  gtk_table_attach(GTK_TABLE(table), table2, 0, 2, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  int j,pos=0;
  for(j=0; j < 6; j++) {
      button = gtk_button_new_with_label(values[pos]);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",GTK_SIGNAL_FUNC (callback), (gpointer) values[pos]);
      gtk_table_attach_defaults(GTK_TABLE(table1), button, j, j+1, 0, 1 );
      pos++;
    } 

  gtk_table_attach(GTK_TABLE(table), table1, 0, 2, 2, 3, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(destroyapp), NULL);
  gtk_container_add(GTK_CONTAINER(window), table);
  gtk_container_border_width (GTK_CONTAINER (window), 100);
  gtk_window_set_default_size (GTK_WINDOW(window), 900, 550);
  
  gtk_window_set_title(GTK_WINDOW (window), "PRODUCT INFORMATION");

  gtk_widget_show_all(window);

  gtk_main();
}

/** This is where program execution starts. All arguments are passed
 * to main for processing, which removes any arguments relevant to it.
 * All other arguments are ignored.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 * @return exit(0) on success, exit(-1) on failure
 */
  
int main(int argc, char *argv[])
{
	printf("This is the client program\n");
	
	int len ,port;
	struct sockaddr_in address;
	int result;
	login(argc,argv);
	gtk_init (&argc, &argv);
	   //Create socket for client.
	sockfd = socket(PF_INET, SOCK_STREAM, 0);
	if (sockfd == -1) { 
		perror("Socket create failed.\n") ; 
		return -1 ; 
	} 
	port=atoi(argv[1]);
	//Name the socket as agreed with server.
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = inet_addr("127.0.0.1");
	address.sin_port = htons(port);
	len = sizeof(address);

	result = connect(sockfd, (struct sockaddr *)&address, len);
	if(result == -1)
	{
		perror("Error has occurred");
		exit(-1);
	}
	
	interface();
	while (1)
        {		
		int l=strlen(ch);
		ch[l]='\0';
		if(l==0 || strcmp(ch,"stop")==0)
                {
                break;
                }  		
                
	} 
	close(sockfd);

	exit(0);
}

