/**This program is a server program which reads only one request at a time from a client.
  * The program uses mysql as database.
  * It is assumed that there exists a table named product_info in a database named Product with username as User and password as lucky.	
  * We will not use any signals in this program to keep it simple.
  * This program sends the data from datbase to requesting client.
  * @author Jogender Singh 
  * @version 1.0
  * @file server.c
  * @date 5/4/2010
  */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <mysql/mysql.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
//MYSQL
int ID;
char DESCRIPTION[100];
float RATE;
int QUANTITY;
char UOM[100];
char CATEGORY[100];
///   SERVER   
char buffer[1024];
char insert[1024];
char rev[6][200];
char retrieve[1000];
int listen_file_descriptor;

void print_all_records();
void modifyrecord();
void delete_record();
void fetch_record();
void store_record();
char arr[1000][10];
char buf[4096];
char username[50];
char password[20];
char id[10];
unsigned int key; 
unsigned int count;

/** It is used to close the server properly.
 * @param signal int value.
 * @return void
 */
void close_properly(int signal)
{
    int return_value;
    printf("Shutting down...\n");
    return_value =close(listen_file_descriptor);
    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(1);
    }
    printf("Shutdown complete.\n");
    exit(0);
}
/** It is main where program execution begins.
 * @param argc number of arguments paased.
 * @param argv the argument passed from command line we pass port number as argument.
 * @return void
 */
int main(int argc, char *argv[])
{
	//Declaring process variables.
	int connection_file_descriptor; 
	//int listen_file_descriptor, connection_file_descriptor;
	int server_len ; 
	int rc,port ; 
	struct sockaddr_in server_address;
	port=atoi(argv[1]);
	struct sigaction act1;
    	//CREATE TABLE REFUSE TO CREATE TABLE IF TABLE ALREADY EXISTS
	MYSQL *connection1;
	int result;
    	connection1 = mysql_init (NULL);
    	if (!connection1)
    	{
		fprintf (stderr, "MySQL initialization failed\n");
		exit(EXIT_FAILURE);
    	}
    	connection1 = mysql_real_connect (connection1, "localhost", "User", "lucky", "Product", 0, NULL, 0);
    	if (connection1)
    	{
	printf ("Connection successful\n");
	result = mysql_query (connection1, "create table product_info(ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,DESCRIPTION varchar(100),RATE float,QUANTITY INT,UNIT_OF_MEASUREMENT varchar(100),CATEGORY varchar(100))");
	if (result==0)
	{
	    printf ("Table created successfully.\n");
	}
	else
	{
	    fprintf (stderr, "Could not create table as %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
		    //mysql_close (connection1);
		    //exit(EXIT_FAILURE);
		}

    	}
    	else
    	{
	printf ("Connection failed\n");
    	}
	mysql_close (connection1);
        //TABLE CREATION ENDED HERE
	act1.sa_handler = close_properly;
    	sigemptyset(&act1.sa_mask);
    	act1.sa_flags=0;
    	sigaction(SIGINT, &act1, 0);

	//Remove any old socket and create an unnamed socket for the server.
	listen_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);
	bzero(&server_address, sizeof(server_address));
	server_address.sin_family = AF_INET;
	server_address.sin_addr.s_addr = htons(INADDR_ANY);
	server_address.sin_port = htons(port) ; 
	server_len = sizeof(server_address);

	rc = bind(listen_file_descriptor, (struct sockaddr *) &server_address, server_len);
	printf("RC from bind = %d\n", rc ) ; 
	
	//Create a connection queue and wait for clients
	rc = listen(listen_file_descriptor, 5);
	printf("RC from listen = %d\n", rc ) ; 

	while(1)
	{	connection_file_descriptor = accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);
		printf("after accept()... connection_file_descriptor = %d\n", connection_file_descriptor) ;
		char ch[100];
		printf("server waiting\n");
		while(1){		
				rc = read(connection_file_descriptor, ch, 99);
	                	ch[rc]='\0';
		
				if(strcmp(ch,"Insert")==0)
				{
					int i;
					for(i=0;i<1024;i++)
						buffer[i]='\0';
					printf("%s",ch);
					rc = read(connection_file_descriptor, &insert, 99);
					store_record();   		
					int l=strlen(insert);
					write(connection_file_descriptor, &insert,l);
				}
				if(strcmp(ch,"Update")==0)
				{ 
					int i;	
					for( i=0;i<1024;i++)
					buffer[i]='\0';
					rc = read(connection_file_descriptor, &buffer, 99);
					printf("RC from read = %d \n", rc ) ; 
					modifyrecord();	
			                if(rc==0)
					break; 	
					int l=strlen(buffer);
			                write(connection_file_descriptor, &buffer,l);
				}
				if(strcmp(ch,"combo")==0)
				{
					 print_all_records();
					strcpy(buf,arr[0]);
					int i=1;
					printf("%d\n",count);
					while(i<count)
					{
				        //gcc -Wall -L /usr/lib64/mysql  -lmysqlclient -o server server.c
					strcat(buf," ");
					strcat(buf,arr[i]);			
					//printf("%d\n",strlen(buf));			
					i++;			
					}	
					write(connection_file_descriptor,&buf,4096);	
				}
				if(strcmp(ch,"Retrieve")==0)
				{
					printf("%s\n",ch);
					int i;	
					for( i=0;i<1024;i++)
					    buffer[i]='\0';
					printf("%s\n",buffer);
					rc = read(connection_file_descriptor, &buffer, 99);
					printf("%s\n",buffer);
					fetch_record();
					if(key==0)		
					{
						char fail[]="F";	
						write(connection_file_descriptor,&fail,strlen(fail));	
					}
					else
					{
						strcpy(retrieve,rev[0]);	
						i=1;
						printf("%d\n",key);		
						while(i<key){
						strcat(retrieve," ");
						strcat(retrieve,rev[i]);
						i++;
						}
					printf("%s\n",retrieve);		
					write(connection_file_descriptor,&retrieve,1000);
					}					
				}		
		
				if(strcmp(ch,"Delete")==0)
				{
					printf("%s\n",ch);
					rc = read(connection_file_descriptor, &id, 10);
					printf("%s\n",id);		
					delete_record();
				}		
				if(rc==0)
				break; 	
		}

		close(connection_file_descriptor);
	}
	printf("server exiting\n");
	return 0;
}

/** This function will fetch all IDs tom populate the combo box at client interface.
 * It is assumed that there exists a table named product_info in a database named Product with username as User and password as lucky.
 * @return void
 */

void print_all_records()
{
    char sql_statement[100];
    MYSQL *connection1;
    MYSQL_RES *result;
    MYSQL_ROW sqlrow;

    int return_value;
	
    sprintf(sql_statement, "SELECT ID from product_info");
    
    connection1 = mysql_init(NULL);
    if (mysql_real_connect (connection1, "localhost", "User", "lucky", "Product", 0, NULL, 0))
    {
	return_value =  mysql_query (connection1, sql_statement);
	if (return_value)
	{
	    printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
	    result = mysql_use_result (connection1);
	    if (result)
	    {   count=0;
		while ((sqlrow = mysql_fetch_row (result)))
		{		
			unsigned int field_count;
    			field_count = 0;
    			while (field_count < mysql_field_count (connection1))
    			{
			strcpy(arr[count],sqlrow[field_count]);
			field_count++;
			count++;
			}
    			//printf ("\n");
		}
		
		if (mysql_errno (connection1))
		{
		    printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
		}
	    }
	    mysql_free_result(result);

	}
	mysql_close (connection1);
    }
    else
    {
	fprintf (stderr, "Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
	
    }

}
/** It is used to modify any record on the basis of product ID.
 * It is assumed that there exists a table named product_info in a database named Product with username as User and password as lucky.	 
 * @return void
 */
void modifyrecord()
{
	char delims[]=" ";
	char *result=NULL;
	char str[6][100];	
	result = strtok( buffer, delims );
	int i=0;
	while( result != NULL ) 
	{   strcpy(str[i],result);
	    
	    result = strtok( NULL, delims );
		i++;
	}
	
	ID=atoi(str[0]);
	strcpy(DESCRIPTION,str[1]);
	RATE=atof(str[2]);
	QUANTITY=atoi(str[3]);
	strcpy(UOM,str[4]);
	strcpy(CATEGORY,str[5]);	

	char sql_statement[1000];
    	   
    	MYSQL *connection1;
    	int res;  
    	sprintf(sql_statement, "Update product_info set DESCRIPTION='%s',RATE=%f,QUANTITY=%d,UNIT_OF_MEASUREMENT='%s',CATEGORY='%s'  where ID=%d ",DESCRIPTION,RATE,QUANTITY,UOM,CATEGORY,ID);         
    
    	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "User", "lucky", "Product", 0, NULL, 0))
    	{
	res = mysql_query (connection1, sql_statement);
	if (res==0)
	{
	    printf ("Row UPDATED successfully.\n");
	}
	else
	{
	    fprintf (stderr, "Could not update data as %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	    //mysql_close (connection1);
	    //exit(EXIT_FAILURE);
	}

	mysql_close (connection1);
    }
    else
    {
	fprintf (stderr, "Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
    }
}
/** It is used to insert a new record in the database.
 * The input given in text entries must not contain spaces.   
 * It is assumed that there exists a table named product_info in a database named Product with username as User and password as lucky.
 * @return void
 */
void store_record()
{
	char delims[]=" ";
	char *result=NULL;
	char str[6][100];	
	result = strtok( insert, delims );
	int i=0;
	while( result != NULL ) 
	{   strcpy(str[i],result);
	    
	    result = strtok( NULL, delims );
		i++;
	}
	
	ID=atoi(str[0]);
	strcpy(DESCRIPTION,str[1]);
	RATE=atof(str[2]);
	QUANTITY=atoi(str[3]);
	strcpy(UOM,str[4]);
	strcpy(CATEGORY,str[5]);
	printf( "ID=%d DESCRIPTION=%s RATE=%f QUANTITY=%d UNIT=%s CATEGORY=%s", ID,DESCRIPTION,RATE,QUANTITY,UOM,CATEGORY);
	
    	char sql_statement[1000];
    	   
    	MYSQL *connection1;
    	int res;  
	printf("RATE=%f\n",RATE);
    	sprintf(sql_statement, "Insert into product_info values (%d,'%s',%f,%d,'%s','%s')",ID,DESCRIPTION,RATE,QUANTITY,UOM,CATEGORY);         
    
    	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "User", "lucky", "Product", 0, NULL, 0))
    	{
	res = mysql_query (connection1, sql_statement);
	if (res==0)
	{
	    printf ("Row inserted successfully.\n");
	}
	else
	{
	    fprintf (stderr, "Could not insert data as %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
	mysql_close (connection1);
    }
    else
    {
	fprintf (stderr, "Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
    }
}
/** It is used to fetch a record of given ID from the database.  
 * It is assumed that there exists a table named product_info in a database named Product with username as User and password as lucky.
 * @return void
 */
void fetch_record()
{
    char sql_statement[100];
    MYSQL *connection1;
    MYSQL_RES *selectresult;
    MYSQL_ROW sqlrow;

    char delims[]=" ";
	char *result=NULL;
	char str[2][100];	
	result = strtok( buffer, delims );
	int i=0;
	while( result != NULL ) 
	{   strcpy(str[i],result);
	    
	    result = strtok( NULL, delims );
		i++;
	}	    
    
    ID=atoi(str[0]);
    strcpy(CATEGORY,str[1]);	  
  	
    int return_value;

    sprintf(sql_statement, "SELECT * from product_info where ID='%d' and CATEGORY='%s'", ID,CATEGORY);
    
    connection1 = mysql_init(NULL);
    if (mysql_real_connect (connection1, "localhost", "User", "lucky", "Product", 0, NULL, 0))
    {
	return_value =  mysql_query (connection1, sql_statement);
	//printf("%d\n",return_value);
	if (return_value)
	{
	    printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else 
         {
	    selectresult = mysql_use_result (connection1);
	    if (selectresult)
	    {   key=0;
		while ((sqlrow = mysql_fetch_row (selectresult)))
		   { //display_row (connection1,sqlrow);
			unsigned int field_count;
    			field_count = 0;
    			while (field_count < mysql_field_count (connection1))
    			{
			strcpy(rev[key],sqlrow[field_count]);
			//printf("%s\n",rev[key]);
			field_count++;
			key++;
			}
		   }
		if (mysql_errno (connection1))
	        {
         	    printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
		}
	    }
	    mysql_free_result(selectresult);

	}
	mysql_close (connection1);
    }
    else
    {
	fprintf (stderr, "Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
	
    }

}

/** It is used to delete a record of given ID from the product_info.  
 * It is assumed that there exists a table named product_info in a database named Product with username as User and password as lucky.
 * @return void
 */
void delete_record()
{
    char sql_statement[1000];
    MYSQL *connection1;
    int result;
    printf("%s\n",id);	
    sprintf(sql_statement, "DELETE from product_info where ID=%s", id);

    connection1 = mysql_init(NULL);
    if (mysql_real_connect (connection1, "localhost", "User", "lucky", "Product", 0, NULL, 0))
    {
	result = mysql_query (connection1, sql_statement);
	if (result==0)
	{
	    printf ("Row deleted successfully.\n");
	}
	else
	{
	    fprintf (stderr, "Could not insert data as %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
	mysql_close (connection1);
    }
    else
    {
	fprintf (stderr, "Connection failed\n");
	if (mysql_errno (connection1))
	{
	    fprintf (stderr, "Connection error %d: %s\n",
		     mysql_errno (connection1),
		     mysql_error (connection1));
	}
    }
}
