/**This program acts like client which first connects to the server by the information provided 
  *by the user like Server IP address, Port Number, Nick Name, then the client can sent messages 
  *and recieve messages from all other clients. The client can also see the list of all other 
  *connected clients..
  *@file client.c
  *@author Ratna Kumar K.V.R
  */

#include "client.h"

/**This function calls when we close the window.. which quits the window and exits the program.
  *It shutdowns the socket and closes all the widgets.
  *@param widget1 Widget to be closed
  *@param data pointer 
  */
void end_program(GtkWidget *widget1, gpointer data)
{
    shutdown(socket_file_descriptor, 2);
    gtk_main_quit();
}

/**This function calls when we close the window.. which quits the window and exits the program.
  *so it shutdowns and closes all the connections.
  *@param window Widget to be closed
  *@param data pointer 
  */
void onExit(GtkWidget *window, gpointer data)
{
	exit(0);
}

/**This function adds the widget to the Box with corresponding label passed
  *@param box  Box into which widget has to be packed
  *@param caption label to be given.
  *@param widget widget to be packed. 
  */
void add_widget_with_label(GtkContainer *box, gchar *caption, GtkWidget *widget)
{
    GtkWidget *label = gtk_label_new(caption);
    GtkWidget *hbox = gtk_hbox_new(TRUE, 4);

    gtk_container_add(GTK_CONTAINER (hbox), label);
    gtk_container_add(GTK_CONTAINER (hbox), widget);
    gtk_container_add(box, hbox);
}

/**This function is called when we press Ctrl+C key or on any error condition.
  *It does proper closing of file descriptors.
  */
void close_properly()
{
	 shutdown(socket_file_descriptor, 2);
	 exit(0);
}

/**This function is called when we enter some message in the GTK entry.
  *It sends the message to the server.It prints appropriate error message 
  *and closes all connections if sending fails..
  *@param widget1 GTK entry
  *@param data pointer
  */
void msg_func(GtkWidget *widget1, gpointer data)
{	
	int return_value;
	sprintf(msg, "%s", gtk_entry_get_text(GTK_ENTRY(entry)));
	gtk_entry_set_text( GTK_ENTRY(entry), "");//clear the GTK entry
	
	return_value = write(socket_file_descriptor, msg, strlen(msg));
	if(return_value < 0)
	{
	    fprintf(stderr, "write() failed.");
	    close_properly();
	}
}

/**This function is called when "connect" button is pressed.It connects to the server 
  *with the information provided by the user(like server IP, client Nick, Port). If the connection
  *is successful it displays the chat Room, else it displays appriopriate dialog message.
  *@param widget1 "connect" button
  *@param data pointer
  */
void connect_server(GtkWidget *widget1, gpointer data)
{
	struct sockaddr_in server_address; //for storing the server address
	struct client_data rcvd_blk; // for stroing the client information

    	int character_read; // for getting the number of characters read
	int return_value; // for getting the status
	int success = 1; // for checking if connection to server is successful or not.
	char err_msg[BUFFER]; //for storing the error messages
	GtkWidget *dialog; // for showing the message dialog if server connection cant be established

	//try to open socket
     	socket_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);
	
        //if socket opening failed then print error message and quit
     	if(socket_file_descriptor < 0)
    	{
		strcpy(err_msg, "Can't open socket.\n");
		success = 0;
    	}	

	if(success == 1)
	{
		bzero(&server_address, sizeof(server_address));//initlize the server_address structure
		server_address.sin_family = AF_INET;
		server_address.sin_port = htons(atoi(gtk_entry_get_text(GTK_ENTRY(entry_port))));//assign server port with given port
		sprintf(ip, "%s", gtk_entry_get_text(GTK_ENTRY(entry_ipaddress)));//assign ip address with given ip address
	
		if(inet_pton(AF_INET, ip, &server_address.sin_addr) <= 0)// convert ip address string to network format
    		{
			strcpy(err_msg, "The supplied ipv4 address is incorrect.\n");
			success = 0;
    		}	
	}
	
	//trying to connect to the server
   	if((success == 1) && connect(socket_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address)) < 0)
    	{
		strcpy(err_msg, "Can't connect to server\n");
		success = 0;
    	}
 
	//sending the nick name of client
	if(success == 1)
	{
		sprintf(nick, "%s", gtk_entry_get_text(GTK_ENTRY(entry_nick)));
		return_value = write(socket_file_descriptor, nick, strlen(nick));
		if(return_value < 0)
    		{
			strcpy(err_msg, "Can't connect to server...");
			success = 0;
    		}
	}

	//checking for duplicate nick..
   	if((success == 1) && (character_read = read(socket_file_descriptor, &rcvd_blk, sizeof(struct client_data))) <= 0)//(character_read = read(socket_file_descriptor, temp_line, BUFFER-1)) <= 0)
   	{
		strcpy(err_msg, "Can't connect to server as nick might already exist or server LIMIT EXCEEDED\n");
		success = 0;
   	}

	//if connection suucessful, read all the connected client list..
	if(success == 1)
	{
		while(rcvd_blk.fd >= 0) // until end of list is occured
		{
			gtk_list_store_append(list_store, &t_iter);//add client to the list
   		        gtk_list_store_set (list_store, &t_iter, 0, rcvd_blk.nick, 1, rcvd_blk.ip, -1); //set the values.
			read(socket_file_descriptor, &rcvd_blk, sizeof(struct client_data)); //read next client in the list from server
		}
		gtk_main_quit(); // quit the Authentication window and display the Chat room
	}
	else
	{
		//Print corresponding error message for not able to connect to the server
		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"%s", err_msg);
		gtk_dialog_run (GTK_DIALOG (dialog));
        	gtk_widget_destroy (dialog);	
	}
}

/**This function starts the client side of Messenger after succesfully connecting to the server.
  *It can send messages to and recieve messages from all other connected clients and can also see the list of connected clients
  *@param arg paramters
  */
void * start_client(void *arg)
{
    char temp_line[BUFFER];//temporary variable used for storing data
    int character_read;//for getting number of charaters read
    int isDuplicate;//for checking duplicate items in the connected client list.
    struct transmit_unit rcvd_blk; // storing the recieved unit of information from server
    gboolean valid; // used for traversing list of client list
    gchar *nick_name;//used for getting nick name

   //Initlizing..
   sprintf(temp_line, "Connected to IP %s\n", ip);
   gtk_text_buffer_insert_with_tags_by_name(buffer, &iter, temp_line, strlen(temp_line), "blue_fg", "lmarg",  NULL);
   printf("connected..\n");

   while(1)
   {		
	   //server has shutdown the connection	
	   if((character_read = read(socket_file_descriptor, &rcvd_blk, sizeof(struct transmit_unit))) <= 0)
   	   {
		printf("Client Closed\n");
		close_properly();
	   }
	   else
	   {
		if(strcmp(rcvd_blk.msg, "") != 0)
		{ 
			sprintf(temp_line, "[%s] <%s>:%s\n", rcvd_blk.time, rcvd_blk.nick, rcvd_blk.msg);
			gtk_text_buffer_insert_with_tags_by_name(buffer, &iter, temp_line, strlen(temp_line), "blue_fg", "lmarg",  NULL);
		}
		//If the received message indicates that a client is disconnected, then update the list by removing the client from list
		if(strcasecmp(rcvd_blk.msg, "disconnected..") == 0)
		{
			//removing the corresponding client from list
			valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(list_store), &t_iter);
			while(valid)
			{
				gtk_tree_model_get(GTK_TREE_MODEL(list_store), &t_iter, 0, &nick_name, -1);
				if(strcmp(nick_name, rcvd_blk.nick) == 0)
				{
					gtk_list_store_remove(list_store, &t_iter);
					g_free(nick_name);
					break;
				}
				valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(list_store), &t_iter);
				g_free(nick_name);
			}
		}
	
		//if the received message indicates that a new client is connected, then update the list by adding a client to the list
		if(strcasecmp(rcvd_blk.msg, "connected..") == 0)
		{
			isDuplicate = 0;//checking the duplictes..
			valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(list_store), &t_iter);
			while(valid)
			{
				gtk_tree_model_get(GTK_TREE_MODEL(list_store), &t_iter, 0, &nick_name, -1);
				if(strcmp(nick_name, rcvd_blk.nick) == 0)
				{
					isDuplicate = 1;
					g_free(nick_name);
					break;
				}
				valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(list_store), &t_iter);
				g_free(nick_name);
			}
			
			if(isDuplicate == 0)//if duplicates doesnt exist then add to the list..
			{
				gtk_list_store_append(list_store, &t_iter);
	   		        gtk_list_store_set (list_store, &t_iter, 0, rcvd_blk.nick, 1, rcvd_blk.ip, -1);
			}
		}
    	   }
   }

   pthread_exit(0);    

}

/** This is where program execution starts. All arguments are passed
 * to gtk for processing, which removes any arguments relevant to it.
 * All other arguments are ignored. This function first gets a window for 
 * user to enter Server IP Address, port and Nick of client. If it can connect succesfully 
 * then it displays the chat room, else it displays the dialog box with approriate message.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 * @return EXIT_SUCCESS on success, EXIT_FAILURE on failure
 */
int main(int argc, char *argv[])
{
	int return_value; //to get the return status
	pthread_t child1; // for threading
	GtkWidget *window;	//the main window
	GtkWidget *window1;	//the main window

	//the boxes and subboxes
	GtkWidget *mainbox; // BOX
	GtkWidget *subbox; //BOX
	GtkWidget *view1; //view for text buffer (Chat Window)
	GtkWidget *view2; //view for List Window
	GtkWidget *scrolled_window1; // scrolled window for chat
	GtkWidget *scrolled_window2;// scrolled window for List
	GtkCellRenderer *renderer;// used in Lists.
	
	GtkWidget *button_connect; //connect button
    	GtkWidget *vbox; // BOX
	
	gtk_init(&argc, &argv);

	//create a window for entering the Server IP, port and Client Nick
	window1 = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    	gtk_window_set_default_size(GTK_WINDOW(window1), 300, 200);
	g_signal_connect(GTK_OBJECT(window1), "delete_event", GTK_SIGNAL_FUNC(onExit), NULL);


	/*creating a tree view of list model for showing list of all connected clients*/
	view2 = gtk_tree_view_new ();
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (view2), -1, "Nick", renderer, "text", 0, NULL);
	
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (view2), -1, "Ip Address", renderer, "text", 1, NULL);

	list_store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	gtk_tree_view_set_model (GTK_TREE_VIEW (view2), GTK_TREE_MODEL(list_store));


	vbox = gtk_vbox_new(TRUE, 5);
	entry_ipaddress = gtk_entry_new();
	entry_nick = gtk_entry_new();
	entry_port = gtk_entry_new();
	button_connect = gtk_button_new_with_label("Connect");

	add_widget_with_label(GTK_CONTAINER(vbox), "IP Address : ", entry_ipaddress);
        add_widget_with_label(GTK_CONTAINER(vbox), "Nick Name : ", entry_nick);	
        add_widget_with_label(GTK_CONTAINER(vbox), "Port : ", entry_port);
        gtk_box_pack_start(GTK_BOX(vbox), button_connect, TRUE, FALSE, 5);
	gtk_container_add(GTK_CONTAINER(window1), vbox);
        g_signal_connect(GTK_OBJECT(button_connect), "clicked", GTK_SIGNAL_FUNC(connect_server), NULL);

	gtk_widget_show_all(window1);
        gtk_main();

	//If connection successful destroy this window and display Chat Room window
	gtk_widget_destroy (window1);

	//creating window
    	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "LAN-Messenger (Client)");
	gtk_window_set_default_size(GTK_WINDOW(window),800,400);
	g_signal_connect(G_OBJECT(window),"delete_event",G_CALLBACK(end_program),NULL);

	
	//creating horizantal box main box.. 
        mainbox = gtk_hbox_new (TRUE, 2);

	scrolled_window1=gtk_scrolled_window_new(NULL, NULL);
        gtk_widget_set_usize(scrolled_window1, 250, 150);

	view1 = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(view1), FALSE);
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view1));
	gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
	gtk_text_buffer_create_tag(buffer, "blue_fg", "foreground", "blue", NULL); 
	gtk_text_buffer_create_tag(buffer, "lmarg", "left_margin", 5, NULL);


	gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW(scrolled_window1), view1);
	
	subbox = gtk_vbox_new(TRUE, 2);
	//creating an entry and calling evalate expression function on pressing ENTER key
        entry = gtk_entry_new_with_max_length(50);
	gtk_signal_connect(GTK_OBJECT(entry), "activate", GTK_SIGNAL_FUNC(msg_func), entry);

	//packing entry and vertical box into main box
	gtk_box_pack_start(GTK_BOX(subbox), scrolled_window1, TRUE, TRUE, 0);
        gtk_box_pack_start (GTK_BOX (subbox), entry, TRUE, TRUE, 2);
	

	/* This is the scrolled window to put the List widget inside */
	scrolled_window2=gtk_scrolled_window_new(NULL, NULL);
        gtk_widget_set_usize(scrolled_window2, 250, 150);
	gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW(scrolled_window2), view2);


	gtk_box_pack_start (GTK_BOX (mainbox), subbox, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (mainbox), scrolled_window2, TRUE, TRUE, 0);	

	gtk_container_add (GTK_CONTAINER (window), mainbox);
	gtk_widget_show_all (window);

	//create a  thread for running client..
	return_value = 	pthread_create(&child1, NULL, start_client, NULL);
	if(return_value !=0)
	{
	    perror("Thread 1  creation failed");
	    exit(EXIT_FAILURE);
	}	
	
        gtk_main();
	return 0;
}		
