/** This program is created for implementing the Exam Evaluator project client. It will ask u for the cut off marks and
  * create a window which will have three options next,previous and exit.
  * @file client.c
  * @author Khaja Peer Syed
  */

#include <gtk/gtk.h>
#include <glib.h>
#include <stdio.h>	
#include <unistd.h>	
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>	
#include <arpa/inet.h>	
#include <netinet/in.h>	
#include <sys/socket.h>	
#include <time.h>	
#include <signal.h>	
#include <sqlite3.h>
#define BUFFER 4096



GtkWidget *text_view;
GtkTextBuffer *buffer;
char **result;

//used to store line from server temporarily
char temp[BUFFER];

//used to store line from server temporarily
char msg[10*BUFFER];

//used to store number of rows and columns in the table
int nrow,ncol,rc,re;

//used to connect to databases of sqlite3
sqlite3 *database1;

//used to store the current roll number of a student
int roll=0,num=0;

//used to store the port and ip address of the server inorder to connect
char *port,*addr;



/** This function is called when someone tries to close top level window.
  * @param widget1 Widget that generated the event
  * @param data Additional data passed by widget while generating the signal
  *
  */
void onExit(GtkWidget *window, gpointer data)
{
    gtk_main_quit();
}

//used to store file descriptor of socket when opened.
int sfd;



/** This function is called when user types ctrl+c which will shut down the client completely. 
 * @param signal is the file descriptor which needs to be closed.
 */
void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    
    return_value =close(sfd);

    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(1);
    }

    printf("Shutdown complete.\n");
    exit(0);
}



/** This function is called when user clicks the next button on the window . All arguments are passed
 * to gtk for processing, which removes any arguments relevant to it.
 * All other arguments are ignored.
 */
void send_message(GtkWidget *button, gpointer data)
{
	if(roll<num-1)
	{
		roll++;
		int re;
		re= write(sfd,result[roll],strlen(result[roll]));
		if(re<0)
		{
			printf("Written Failed\n");
			exit(1);
		}
			
		re = read(sfd,msg, BUFFER-1);
		msg[re]='\0';
		
		GtkTextBuffer *buffer;
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
		gtk_text_buffer_set_text(buffer,msg,strlen(msg));	
	}
	else
	{
		if(roll<num)
		roll++;
		strcpy(msg,"\n\n\n\n\t\t\tNo More Students\n");
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
		gtk_text_buffer_set_text(buffer,msg,strlen(msg));

	}
}


/** This function is called when user clicks the previous button on the window . All arguments are passed
 * to gtk for processing, which removes any arguments relevant to it.
 * All other arguments are ignored.
 */
void send_message1(GtkWidget *button, gpointer data)
{
	if(roll>1)
	{
		roll--;
		int re;
		re= write(sfd,result[roll],strlen(result[roll]));
		if(re<0)
		{
			printf("Written Failed\n");
			exit(1);
		}
			
		re = read(sfd,msg, BUFFER-1);
		msg[re]='\0';
		
		GtkTextBuffer *buffer;

		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
		gtk_text_buffer_set_text(buffer,msg,strlen(msg));	
	}
	else
	{
		if(roll!=0)
		roll--;
		strcpy(msg,"\n\n\n\n\t\t\t\tNo More Students\n");
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
		gtk_text_buffer_set_text(buffer,msg,strlen(msg));

	}
}

/**
  * Used to connect to tcp server and print the results on the window.
  * The use must provide the i.p. address of tcp day tine server and port number
  * through command line argument and then time is printed in 
  * human readable format. Note that it will work only for ipv4
  * servers.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{  
    //make sure user has given server i.p. address and port number through command line argument
    if(argc != 3)
    {
	fprintf(stderr, "%s: usage: %s <server_ip_address> <port_number>\n", argv[0], argv[0]);
	exit(1);
    }
  
    addr=argv[1];
    port=argv[2];    
  
    GtkWidget *window;
    GtkWidget *next;
    GtkWidget *exit1;	
    GtkWidget *prev;
    GtkWidget *vbox;

    char buff1[BUFFER]="cse";   
    int rc1;
    char sql_statement[BUFFER];
    char *zErrMsg = 0;
    gtk_init(&argc, &argv);
    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_default_size(GTK_WINDOW(window), 400, 400);
    g_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(onExit), NULL);
    vbox = gtk_vbox_new(FALSE, 10);
    text_view = gtk_text_view_new ();

	
	rc = sqlite3_open (buff1, &database1);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "\nDatabase Does Not Exists : %s\n", zErrMsg);
	}

	sprintf(sql_statement,"select name from sqlite_master where type='table' order by name");
	rc1=sqlite3_get_table(database1,sql_statement,&result,&nrow,&ncol,&zErrMsg);

	if (rc1 != SQLITE_OK)
	{
		fprintf (stderr, "\nSQL error: %s\n", zErrMsg);
   	}
	
	num=(nrow*ncol)+1;		
	

	strcpy(msg,"\tExam Evaluation Started\n\n\tClick NEXT To View Next Student Marks\n\n\tClick PREVIOUS to View Previous Student Marks\n\n\tClick EXIT to exit");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
	gtk_text_buffer_set_text(buffer,msg,strlen(msg));

	//used to count number of characters read or written from or to socket.
	int re,temp;

	//used to store address of ipv4 server 
	struct sockaddr_in address;

	//try to open socket
	sfd= socket(AF_INET, SOCK_STREAM, 0);

	//if socket opening failed then print error message and quit
	if(sfd<0)
	{
		printf("Cannot Open Socket\n");
		exit(1);
	}

	//initialize struct server_address to all zeros.
	bzero(&address,sizeof(address));

	//set the protocol used to be ipv4
	address.sin_family=AF_INET;

	//set the port to be "port" variable value, by default tcp day time servers
    	//listen on port 13. htons is used to convert byte ordering from
    	//system dependent (bigendian|littlendian) to network type, i.e.
    	//system indepent. htons is host to network short.
	address.sin_port=htons(atoi(port));


	 //convert the given server i.p. address in string or ascii notation
    	//to proper address in binary format. if conversion is not done
   	//then print proper error message and exit. The function inet_pton
    	//can convert ipv4(AF_INET) and ipv6(AF_INET6) addresses into their 
    	//proper format. This is also the first argument. The second time takes
    	//string to convert to binary format and third argument takes address 
    	//where the converted value has to be placed if conversion is successfull.
	temp=inet_pton(AF_INET,addr,&address.sin_addr);
	if(temp<0)
	{
		printf("Supplied Address Is Incorrect\n");
		exit(1);
	}

	//try to connect to server port using socket. The function socket
    	//take three arguments. first of them  is  socket to be used to connect 
    	//to server. Second is address of server_address structure type casted as
    	//(struct sockaddr *). Third is sizeof() server_address structure. This size is important 
    	//as we send the address of struct so connect function does not knows what 
    	//is the length of structure. Also, since same connect is used to connect 
    	//to ipv6 servers too, connect() internally cannot do sizeof(struct sockaddr_in)
    	//to find the size of socket.
	temp=connect(sfd,(struct sockaddr *)&address,sizeof(address));
	if(temp<0)
	{
		printf("Connection Failed\n");
		exit(1);
	}


	re= write(sfd,buff1,strlen(buff1));
	if(re<0)
	{
		printf("Written Failed\n");
		exit(1);
	}

	char ch[10]="";
	printf("Enter Cut off marks out of 10 :");
	scanf("%s",ch);
	re= write(sfd,ch,strlen(ch));
	if(re<0)
	{
		printf("Written Failed\n");
		exit(1);
	}
   
    next = gtk_button_new_with_label("NEXT");
    prev = gtk_button_new_with_label("PREVIOUS");
    exit1 = gtk_button_new_with_label("EXIT");
    gtk_box_pack_start (GTK_BOX (vbox), text_view, 180, 180, 0);
    gtk_box_pack_start(GTK_BOX(vbox),next,FALSE, TRUE, 0);   
    gtk_box_pack_start(GTK_BOX(vbox),prev,FALSE, TRUE, 0); 
    gtk_box_pack_start(GTK_BOX(vbox),exit1,FALSE, TRUE, 0); 
    gtk_container_add(GTK_CONTAINER(window), vbox);
    
    g_signal_connect(GTK_OBJECT(next), "clicked", GTK_SIGNAL_FUNC(send_message), NULL);
    g_signal_connect(GTK_OBJECT(prev), "clicked", GTK_SIGNAL_FUNC(send_message1), NULL);  
    g_signal_connect(GTK_OBJECT(exit1), "clicked", GTK_SIGNAL_FUNC(onExit), NULL);  
    gtk_widget_show_all(window);
    gtk_main();

    close(sfd);
    printf("\n");
    return 0;
}
