/** This program is created for implementing the Exam Evaluator project server. 
  * This evaluates the student answers and gives the result.
  * @file server.c
  * @author Khaja Peer Syed
  */


#include <stdio.h>	
#include <unistd.h>	
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>	
#include <arpa/inet.h>	
#include <netinet/in.h>	
#include <sys/socket.h>	
#include <time.h>	
#include <signal.h>	
#include <sqlite3.h>
   
#define BUFFER 4096

//used to connect to databases of sqlite3
sqlite3 *database1,*database2; 

//used to store file descriptor of socket when opened.
int sfd1;


/** This function is called when user types ctrl+c which will shut down the client completely. 
 * @param signal is the file descriptor which needs to be closed.
 */
void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    
    return_value =close(sfd1);

    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(1);
    }

    printf("Shutdown complete.\n");
    exit(0);
}


/**
  * Used to connect to tcp server and print the results on the window.
  * The use must provide the i.p. address of tcp day tine server
  * through command line argument and then time is printed in 
  * human readable format. Note that it will work only for ipv4
  * servers.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{

    //make sure user has given port address through command line argument
    if(argc != 2)
    {
	fprintf(stderr, "%s: usage: %s <port_number>\n", argv[0], argv[0]);
	exit(1);
    }

//used to count number of characters read or written from or to socket.
int re1;

//used to store address of ipv4 server 
struct sockaddr_in address1;

//used to store line from client temporarily
char buff1[BUFFER];

//used to store file descriptor of socket when a client is connected.
int cfd1;   

//used to store the database name of the " key ".
char datadir[100];

//used to store the sql commands to be executed
char sql_statement[BUFFER];

//used to store the records of the tables
char **result1,**result2;

//used to store the error that occured
char *zErrMsg = 0;

//used to store the student question and answers along with the result
char outcome[10000]="",temp[1000]="";

//used to store the number of rows and number of columns
int rc,trow,tcol,rrow,rcol,j;

//try to open socket
sfd1= socket(AF_INET, SOCK_STREAM, 0);

//if socket opening failed then print error message and quit
if(sfd1<0)
{
	printf("Cannot Open Socket\n");
	exit(1);
}

//initialize struct server_address to all zeros.
bzero(&address1,sizeof(address1));

//set the protocol used to be ipv4
address1.sin_family=AF_INET;

//let server listen on any interface connected to
//the server
address1.sin_addr.s_addr  = htonl(INADDR_ANY);

//set the port to be "port address", by default tcp day time servers
//listen on port 13. htons is used to convert byte ordering from
//system dependent (bigendian|littlendian) to network type, i.e.
//system indepent. htons is host to network short.
address1.sin_port=htons(atoi(argv[1]));

//bind the socket to port, so that it we can listen on socket
re1 = bind(sfd1,(struct sockaddr *) &address1, sizeof(address1));

//quit if could not bind
if(re1<0)
{
	printf("Binding Failed\n");
	exit(1);
}


//let clients queue on socket and start listening to it
//Let 5 clients queue at a time.
re1= listen(sfd1, 5);


//quit if could not listen
if(re1 < 0)
{
	perror("Cannot listen");
	exit(1);
}

//accepts the connection
cfd1= accept(sfd1,(struct sockaddr *) NULL, NULL);    

//quit if connection failed
if(cfd1 < 0)
{
    perror("accept() failed.");
    exit(1);
}

//reading from the client
re1= read(cfd1,buff1, BUFFER-1);
buff1[re1]='\0';

//quit if unable to read
if(re1 < 0)
{
    perror("read() failed.\n");
    exit(1);
}


//database of the client's i.e " cse " if path is given the tokenize it and takes the last value...
char des[100];
strcpy(des,buff1);
char *token,des1[100];
token=strtok(des,"/");
while(token!=NULL)
{
	strcpy(des1,token);
	token=strtok(NULL,"/");
}


//opens a sqlite database connection
rc = sqlite3_open (buff1, &database1);

//if unable to connect to database...
if (rc != SQLITE_OK)
{
	fprintf (stderr, "\nDatabase Does Not Exists : %s\n", zErrMsg);
}

//read from client to read the cut off marks
re1= read(cfd1,buff1, BUFFER-1);
buff1[re1]='\0';

//stores the cut off marks
int cf=atoi(buff1);

while(1)
{
	re1= read(cfd1,buff1, BUFFER-1);
	buff1[re1]='\0';
	
	if(re1 < 0)
	{
	    perror("read() failed.\n");
	    exit(1);
	}

	sprintf(temp,"Roll No :%s\t\t\t",buff1);
	strcpy(outcome,temp);

	sprintf(sql_statement, "SELECT * from %s order by qno",buff1);
	rc=sqlite3_get_table(database1,sql_statement,&result1,&trow,&tcol,&zErrMsg);
	if (rc != SQLITE_OK)
	{
		//fprintf (stderr, "\nSQL error: %s\n", zErrMsg);
	}

	strcpy(datadir,"key");

	rc = sqlite3_open (datadir, &database2);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "\nDatabase Does Not Exists : %s\n", zErrMsg);
	}

	sprintf(sql_statement, "SELECT name from %s where rno='%s'",des1,buff1);
	rc=sqlite3_get_table(database2,sql_statement,&result2,&rrow,&rcol,&zErrMsg);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "\nSQL error: %s\n", zErrMsg);
	}
	sprintf(temp,"Name :%s\n",result2[1]);
	strcat(outcome,temp);
	
	sprintf(sql_statement, "select * from answers order by qno");
	rc=sqlite3_get_table(database2,sql_statement,&result2,&rrow,&rcol,&zErrMsg);
	sprintf(temp,"Question\tAnswer\tCorrect Answer\tCorrect/Incorrect\n");
	strcat(outcome,temp);
	int count=0;
	for(j=2;j<(trow*tcol)+2;j+=2)
	{
		if((!strcmp(result2[j],result1[j]))&&(!strcmp(result2[j+1],result1[j+1])))
		{
			sprintf(temp,"%s\t\t%s\t\t\t%s\t\t\tCorrect\n",result1[j],result1[j+1],result2[j+1]);
			strcat(outcome,temp);
			count++;
		}
		else
		{
			sprintf(temp,"%s\t\t%s\t\t\t%s\t\t\tIncorrect\n",result1[j],result1[j+1],result2[j+1]);
			strcat(outcome,temp);
		} 	
	}

	sprintf(temp,"\n\t\t\tMarks Obtained are :%d\n",count);
	strcat(outcome,temp);
	if(count<cf)
	{
		sprintf(temp,"\n\t\t\tResult : Fail\n");
		strcat(outcome,temp);
	}
	else
	{
		sprintf(temp,"\n\t\t\tResult : Pass\n");
		strcat(outcome,temp);
	}
	re1 = write(cfd1, outcome, strlen(outcome));
	if(re1 < 0)
	{
	    perror("write() failed.\n");
	    exit(1);
	}

}

re1 = close(cfd1);
if(re1 <0)
{
    perror("close failed\n");
    exit(1);
}

return 0;
}
