// With doxygen
#include <stdio.h>	//for printf(),
#include <unistd.h>	//for close(),
#include <stdlib.h>	//for exit(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), inet_pton()
#include <sys/types.h>	//for socket(), inet_pton()
#include <arpa/inet.h>	//for htons(), inet_pton()
#include <netinet/in.h>	//for struct sockaddr_in,
#include<string.h>
#include <gtk/gtk.h>

#define BUFFER 4096
#define SERVER_PORT 8000
/**
  * Properly ends the GTK program
  * @returns false
  * @param widget GTKWidget
  * @param event Event handling
  * @param data data object
*/
gint closewin(GtkWidget *widget,GdkEvent  *event,gpointer   data)
{
  gtk_main_quit();
  return(FALSE);
}

void button1(GtkWidget *widget1, gpointer data);
void button2(GtkWidget *widget1, gpointer data);
void button3(GtkWidget *widget1, gpointer data);
void button4(GtkWidget *widget1, gpointer data);
void question(char */*,int,char*[]*/);
int submit(GtkWidget *widget1, gpointer data);
void endexam(int,int);

int read_desc;
int write_desc;
gboolean radio1=TRUE,radio2=FALSE,radio3=FALSE,radio4=FALSE;
GtkWidget *window,*group;
GtkWidget *label1,*rad1,*rad2,*rad3,*rad4,*box,*button5;

/**
  * Parses the question and prints it in a GUI window using GTK. 
  * @returns nothing 
  * @param que takes a question in string. Options Separated by |
*/
void question(char que[])
{

	char *q,*op1,*op2,*op3,*op4,temp[BUFFER];
	int i=0,x,y;
	
	fprintf(stderr,"%s\n",que);

	//gtk_init(&argc, &argv);
	//window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                        GTK_SIGNAL_FUNC(closewin),
                        NULL);
   
	//box = gtk_vbox_new (FALSE, 0);
	//gtk_container_add (GTK_CONTAINER (window), box);

	//PARSE QUESTION
	strcpy(temp,que);
	q=strtok(que,"|");
	if(strcmp(q,temp)==0)
	{
		q=strtok(q," ");
		q=strtok(NULL," ");
		x=atoi(q);
		q=strtok(NULL," ");
		y=atoi(q);		
		endexam(x,y);
	}
	op1=strtok(NULL,"|");
	op2=strtok(NULL,"|");
	op3=strtok(NULL,"|");
	op4=strtok(NULL,"|");
	//fprintf(stderr,"%s",q);

	box = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), box);

	label1=gtk_label_new(q);
	gtk_box_pack_start (GTK_BOX (box), label1, TRUE, TRUE, 0);
	
	gtk_window_set_title(GTK_WINDOW(window),"exam");
	gtk_window_set_default_size(GTK_WINDOW(window),440,300);

	rad1 = gtk_radio_button_new_with_label(NULL,op1);
  	group=gtk_radio_button_group(GTK_RADIO_BUTTON(rad1));
   	rad2 = gtk_radio_button_new_with_label(group,op2);
   	group=gtk_radio_button_group(GTK_RADIO_BUTTON(rad1));
   	rad3 = gtk_radio_button_new_with_label(group,op3);
   	group=gtk_radio_button_group(GTK_RADIO_BUTTON(rad1));
   	rad4 = gtk_radio_button_new_with_label(group,op4);

   	button5 = gtk_button_new_with_label("submit");
	
	gtk_box_pack_start (GTK_BOX (box), rad1, TRUE, TRUE, 0);
 	gtk_box_pack_start (GTK_BOX (box), rad2, TRUE, TRUE, 0);
 	gtk_box_pack_start (GTK_BOX (box), rad3, TRUE, TRUE, 0);
 	gtk_box_pack_start (GTK_BOX (box), rad4, TRUE, TRUE, 0);
 	gtk_box_pack_start (GTK_BOX (box), button5, TRUE, TRUE, 0);

	g_signal_connect(G_OBJECT(rad1), "toggled", G_CALLBACK(button1), NULL);
	g_signal_connect(G_OBJECT(rad2), "toggled", G_CALLBACK(button2), NULL);
 	g_signal_connect(G_OBJECT(rad3), "toggled", G_CALLBACK(button3), NULL);
 	g_signal_connect(G_OBJECT(rad4), "toggled", G_CALLBACK(button4), NULL);
 	g_signal_connect_swapped(G_OBJECT(button5), "clicked", G_CALLBACK(submit), GTK_OBJECT(window));

    	gtk_widget_show_all(window);
    	gtk_main();	
}
/**
  * Processes the answer provided by the client.
  * @returns answer given by the user.
  * @param wid GTKWidget
  * @param data gpointer 
*/
int submit(GtkWidget *wid, gpointer data)//RETURN THE OPTION
{

	int ans=0;
	char str[1000];
	fprintf(stderr,"submit called");
	if(radio1==TRUE)
	{
		ans=1;		
	}
	else if(radio2==TRUE)
	{
		ans=2;		
	}
	else if(radio3==TRUE)
	{
		ans=3;		
	}
	else if(radio4==TRUE)
	{
		ans=4;		
	}
        
	gtk_container_remove (GTK_CONTAINER (window), box);
	sprintf(str,"%d",ans);
        write(write_desc,str,strlen(str));
	int num;
	num=read(write_desc,str,BUFFER-1);
	str[num]='\0';
//	strcpy(str,"1+1 = ?|2|22|222|none of the above");
        radio1=TRUE;
        radio2=FALSE;
        radio3=FALSE;
        radio4=FALSE;
	question(str);
       	endexam(-1,-1);
	return ans;
}
/**
  * Prints the final score when exam is ended, Prints an error message if exam is ended abruptly. 
  * @returns nothing
  * @param score final score
  * @param total total marks
*/
void endexam(int score,int total)
{
	GtkWidget *dialog;
	if(score!=-1)
	{
		dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "YOUR EXAM IS SUCCESSFULLY COMPLETED. YOUR SCORE IS %d/%d",score,total);
	}
	else
	{
		dialog = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "YOU CLOSED THE EXAM ABRUPTLY, SO YOUR EXAM IS CANCELLED");
	}
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
	gtk_main_quit();	
	exit(1);
}
/**
  * Radio button handler for button1
  * @returns nothing
  * @param widget1 GTKWidget
  * @param data gpointer object	
*/
void button1(GtkWidget *widget1, gpointer data)
{
    if(radio1==TRUE)
	radio1=FALSE;
    else
    {
	radio1=TRUE;
    }
}
/**
  * Radio button handler for button2
  * @returns nothing
  * @param widget1 GTKWidget
  * @param data gpointer object	
*/
void button2(GtkWidget *widget1, gpointer data)
{
    if(radio2==TRUE)
	radio2=FALSE;
    else
    {
	radio2=TRUE;
    }
}
/**
  * Radio button handler for button3
  * @returns nothing
  * @param widget1 GTKWidget
  * @param data gpointer object	
*/
void button3(GtkWidget *widget1, gpointer data)
{
    if(radio3==TRUE)
	radio3=FALSE;
    else
    {
	radio3=TRUE;
    }
}
/**
  * Radio button handler for button4
  * @returns nothing
  * @param widget1 GTKWidget
  * @param data gpointer object	
*/
void button4(GtkWidget *widget1, gpointer data)
{
    if(radio4==TRUE)
	radio4=FALSE;
    else
    {
	radio4=TRUE;
    }
}
/**
  * Used to connect to the exam server and recieve the questions. The questions
  * are displayed in GTK window. It then send the answers. The client connects to the server 
  * using an IP address provided to it through command line. It uses the server port 8000 to 
  * connect to the server.
  * @returns 0 if successful non-zero if fails.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv  array of command line arguments.
*/
int main(int argc, char *argv[])
{
	
    char temp_line[BUFFER];

	int character_read;
	int return_value;
	char echo_mssg[BUFFER];
	char return_mssg[BUFFER];	


    struct sockaddr_in server_address,servaddr;


    if(argc != 2)
    {
	fprintf(stderr, "%s: usage: %s <server_ip_address> \n", argv[0], argv[0]);
	exit(1);
    }
	gtk_init(&argc, &argv);
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                        GTK_SIGNAL_FUNC(closewin),
                        NULL);

    write_desc = socket(AF_INET, SOCK_STREAM, 0);

    if(write_desc < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(1);
    }

    bzero(&server_address, sizeof(servaddr));

    server_address.sin_family = AF_INET;

    server_address.sin_port = htons(SERVER_PORT);

    if(inet_pton(AF_INET, argv[1], &server_address.sin_addr) <= 0)
    {
	fprintf(stderr, "%s: the supplied ipv4 address %s is incorrect.\n", argv[0], argv[1]);
	exit(1);
    }


    if(connect(write_desc, (struct sockaddr *) &server_address, sizeof(server_address)) < 0)
    {
	fprintf(stderr, "%s: cannot connect to server %s\n", argv[0], argv[1]);
	exit(1);
    }
	    character_read=read(write_desc,return_mssg,BUFFER-1);
	    return_mssg[character_read]='\0';
	    question(return_mssg);
	    endexam(-1,-1);
//	    gtk_widget_show_all(window);
            return EXIT_SUCCESS;

}
