/**This program is to act like a server for writing exam
  * @author Raghavendar and chandan
  * @version 1.0
  * @file server.c
  *
  */
#include <unistd.h>	//for close(), write(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strlen(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 
#include <gtk/gtk.h>

#define BUFFER 4096
int listen_file_descriptor;
/**
 * to close the signal
 *
 */
void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    
    return_value =close(listen_file_descriptor);

    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(1);
    }

    printf("Shutdown complete.\n");
    exit(0);
}
/**
  * Used to create a tcp server. This is an iterative server
  * and hence responds to only clients.
  * Note that it will work only for ipv4 servers.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{
    //used to store file descriptor of socket when a client is connected.
    int connection_file_descriptor; 
    ////used to store line from server temporarily	
    char temp_line[BUFFER];
    //used to store address of ipv4 server
    struct sockaddr_in server_address;
    //struct sockaddr_in client_address;	
    int return_value;
    //used to store return value for checking whether call to
    //a function was successfull or not
    //used to catch Ctrl+C and close listen_file_descriptor
    //and terminate.	
    struct sigaction act1;
    
    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;

    sigaction(SIGINT, &act1, 0);
      //try to open socket
    listen_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);
    if(listen_file_descriptor < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(1);
    }
    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    server_address.sin_port = htons(8892);
    return_value = bind(listen_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address));
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(1);
    }
    return_value = listen(listen_file_descriptor, 5);
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(1);
    }
    
   while(1)
    {
	connection_file_descriptor = accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);
    
	if(connection_file_descriptor < 0)
	{
	    perror("accept() failed.");
	    exit(1);
	}
	temp_line[0]='\0';
	int num;
	num=read (connection_file_descriptor, temp_line, BUFFER);
	temp_line[num]='\0';
	printf("\n total marks are:%s\n",temp_line);
	char str[100];
	if(atoi(temp_line)>5)
		sprintf(str,"You passed with marks:%d",atoi(temp_line));
	else
		sprintf(str,"You failed(could not clear cutoff)");
	
	write(connection_file_descriptor,str, strlen(str));
	str[0]='\0';
   }	
	
    return 0;
}

