#include <gtk/gtk.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include "fileselect.c"
#include "menu.c"


/** Gtk Window variable
  *
  */
GtkWidget *window1;


/** This program is to used to create a TEXT EDITOR for C 
  * which will have facilities for compiling, error
  * messages and some highlighting for special keywords
  * @authors: 200905023 - V.Meena, 200905037 - A.V.S.L.G.Swetha
  * @version 1.0
  * @file editor.c
  *
  */


static void err_msg(const gchar *msg)
{
	/* pop up window with only OK button */
	GtkWidget *dialog; 
	dialog = gtk_message_dialog_new(GTK_WINDOW(window), 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, msg);
	gtk_dialog_run(GTK_DIALOG(dialog));
	/* destroy the window after ok is pressed */
	gtk_widget_destroy(dialog); 
}



/** This function would be invoked when the user clicks on quit button or quits 
  * the application fires the delete event signal 
  * but first check if the file is modified or not
  *
  */

static gboolean delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	return !save_if_modified();
}


/** This function would be invoked when the user enters the gcc command 
  * into the gtkTextEntry
  * 
  */
void gcc_entry( GtkWidget *widget,gpointer  entry )
{
	entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
	   
}

/** This function sets the entry text
  * 
  */

void entrycursor(GtkWidget *entry_text,gpointer data)
{
	gtk_entry_set_text(GTK_ENTRY (entry_text),"");
	status = 1;
}



/**This is where program starts and generates a C editor along with gcc Compile button.
  * @param argc Number of arguments passed to program
  * @param argv Array of arugments passed to program
  * @returns EXIT_SUCCESS if program exits properly, EXIT_FAILURE otherwise.
  *
  */


int main(int argc, char *argv[])
{
	status = 0;
		
	GtkWidget *box, *scroll, *widget, *box1;
       
	GtkAccelGroup *accel;
	
	/* gtk initializer can take filename as an argument*/
	gtk_init(&argc, &argv);  

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	/* if the user quits the application */  
	g_signal_connect(G_OBJECT(window), "delete_event",G_CALLBACK(delete_event), window);
	g_signal_connect(G_OBJECT(window), "destroy",G_CALLBACK(gtk_main_quit), NULL);

	/* sets the title to the window */
	gtk_window_set_title(GTK_WINDOW(window), "C Editor (Insert file name)");
	gtk_window_set_default_size(GTK_WINDOW(window), 600, 500); /* window size y & x values */

	/* create a container where the menus n text widget goes */
	/* false if u dont want extra padding in the box, 0 for spacing */
	
	box = gtk_vbox_new(FALSE, 0); 
	box1 = gtk_vbox_new(FALSE, 0); 
	
	/* create an accerelator for the item factory, keyboard shortcuts */
	accel = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(window), accel);


	/* Create a menu above the text view widget */
	main_menu = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<TextView>", accel);
	gtk_item_factory_create_items(main_menu,sizeof(menu_def) / sizeof(*menu_def),menu_def, NULL);


	/* Return the actual menu bar created by the item factory. */
	widget = gtk_item_factory_get_widget(main_menu, "<TextView>");

	/* put the menu in the menu container */
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);

	scroll = gtk_scrolled_window_new(NULL, NULL); /* put a scroll window widget */

	/* put the scroll window in the text container */
	gtk_box_pack_start(GTK_BOX(box), scroll, TRUE, TRUE, 0);

	/* create the text view widget */
	view = gtk_text_view_new();

	/* create a buffer for the text view where everything gets stored */
	buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));

	/* put the text widget in the scroll window */
	gtk_container_add(GTK_CONTAINER(scroll), view);


	/* Creating tags */
        gtk_text_buffer_create_tag(buf, "gap", "pixels_above_lines", 30, NULL);
	
	gtk_text_buffer_create_tag(buf, "lmarg", "left_margin", 5, NULL);
		  
	gtk_text_buffer_create_tag(buf, "blue_fg", "foreground", "blue", NULL);
	
	gtk_text_buffer_create_tag(buf, "purple_fg", "foreground", "#9900CC", NULL);
		 
	gtk_text_buffer_create_tag(buf, "pink_fg", "foreground", "#FF00FF", NULL); 
		  
	gtk_text_buffer_create_tag(buf, "maroon_fg", "foreground", "maroon", NULL);

	gtk_text_buffer_create_tag(buf, "green_fg", "foreground", "#336600", NULL);
		
	gtk_text_buffer_create_tag(buf, "gray_bg", "background", "#EEEEEE", NULL); 

	gtk_text_buffer_create_tag(buf, "yellow_bg", "background", "yellow", NULL); 
		
	gtk_text_buffer_create_tag(buf, "italic", "style", PANGO_STYLE_ITALIC, NULL);

	gtk_text_buffer_create_tag(buf, "bold", "weight", PANGO_WEIGHT_BOLD, NULL);

 	GtkWidget *quitbox,*button,*scroll2;


	scroll2 = gtk_scrolled_window_new(NULL, NULL); /* creates a scroll window */
	gtk_box_pack_start(GTK_BOX(box1), scroll2, TRUE, TRUE, 0);

	view2 = gtk_text_view_new();
	buf2 = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view2));
	gtk_container_add(GTK_CONTAINER(scroll2), view2);
	
	gtk_text_buffer_create_tag(buf2, "orange", "background", "#FFCC33", NULL); 
	
	/* Creation of table for alignment of textview */

	GtkWidget *table; 	
	table = gtk_table_new(3, 0, TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(table), 10);
	gtk_table_set_col_spacings(GTK_TABLE(table), 10);

	gtk_table_attach_defaults(GTK_TABLE(table), box, 0, 1, 0, 6 );
	gtk_table_attach_defaults(GTK_TABLE(table), box1, 0, 1, 6, 9 );


	gtk_container_add(GTK_CONTAINER (window), GTK_WIDGET(table));

	g_signal_connect (buf2, "notify::cursor-position", G_CALLBACK (gtk_text_view_notify_cursor_position), view2);

	/* Create another new hbox */
	quitbox = gtk_hbox_new (FALSE, 0);
	
	gtk_table_attach_defaults(GTK_TABLE(table), quitbox, 0, 1, 9, 10);	

	entry = gtk_entry_new_with_max_length (500);
	gtk_entry_set_text (GTK_ENTRY (entry),"Enter gcc command here...");

	gtk_entry_select_region (GTK_ENTRY (entry), 0, GTK_ENTRY(entry)->text_length);

	gtk_box_pack_start (GTK_BOX (quitbox), entry, TRUE, TRUE, 0);

	gtk_signal_connect_object (GTK_OBJECT (entry), "activate", G_CALLBACK (gcc_entry), (gpointer)entry);

	gtk_signal_connect_object (GTK_OBJECT (entry), "activate", G_CALLBACK (submit_clicked), NULL);


	/* Our quit button. */
	button = gtk_button_new_with_label ("Compile (gcc)");

	/* Setup the signal to terminate the program when the button is clicked */
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(gcc_entry), (gpointer)entry);


	gtk_signal_connect_object (GTK_OBJECT (button), "clicked", G_CALLBACK (submit_clicked), NULL);


	/* Pack the button into the quitbox. The last 3 arguments to gtk_box_pack_start are:* expand, fill, padding. */
	gtk_box_pack_start (GTK_BOX (quitbox), button, TRUE, FALSE, 0);

	/* pack the quitbox into the vbox (box1) */
	gtk_widget_show_all(window); /* show all widgets in the window */

	/* error checking */
	g_set_printerr_handler(err_msg);

	/* load the file if a filename is specified */
	if(argc > 1)
		load_file(g_strdup(argv[1]));

	/* the main loop where the app waits for mouse n keyboard events */

	gtk_main();

	return 0;
}
