#include <gtk/gtk.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#define CHAR_BUF 2000
#include<string.h>
#include<ctype.h>

/** These give entry text
  *
  */
GtkWidget *entry;
gchar *entry_text= " ";

/** This creates main window
  *
  */
GtkWidget *window;

/** These variables give us the status, error 
  * filenames when loaded.
  *
  */
int errno, status;

/** variables indicating the file name
  *
  */

char *Fname, LoadFile[300], *filename, file_name[300], f_name[300], fname1[300];

/** variables indicating the GtkTextBuffers
  *
  */
GtkTextBuffer *buf, *buf2, *buf1;

/** These give us text view widgets  where all the typing is done.
  *
  */
GtkWidget *view, *view2;

/**This function would be invoked to parse the path name to retrieve the filename.  
  * 
  */

void parseFilename(char *text)
{
	
	int i;		
	for(i = strlen(text)-1; i >= 0; i--)
	{
		if(text[i]=='/')
			break;
	}

	int f = 0,j;       
	for(j = i+1;j <strlen(text); j++)
	{
	    fname1[f++]=text[j];
	}
	fname1[f++]='\0';
		
}

/** This function would be invoked when the user loads an application  
  * and is used to highlight the header files and macros in the 
  * c program.
  * 
  */
void highlight_include()
{
   
	GtkTextIter mstart,mend,iter1,mstart1,mend1,iter2,iter3;
	int found,found1;
	
	/* #include */
	gtk_text_buffer_get_start_iter(buf, &iter3);
	
	do
	{
		found = gtk_text_iter_forward_search(&iter3, "#include", 0, &mstart, &mend, NULL);

		if(found)
		{
			iter2 = mend;       
			found1 = gtk_text_iter_forward_search(&iter2, ">", 0, &mstart1, &mend1, NULL);
			if(found1)
			{
			iter1 = mstart;           
			gtk_text_iter_forward_to_line_end(&iter1);
			if(gtk_text_iter_compare(&iter1, &mend1)>=0)
			{
				gtk_text_buffer_apply_tag_by_name(buf, "pink_fg", &mend, &mend1);
				gtk_text_buffer_apply_tag_by_name(buf, "purple_fg", &mstart, &mend);
				iter3 = mend1;               
			}
			else
				iter3 = iter1;        
			}
			else
			iter3 = mend;
		}

	}while(found);   


	gtk_text_buffer_get_start_iter(buf, &iter3);
	
	do
	{
		found = gtk_text_iter_forward_search(&iter3, "#include", 0, &mstart, &mend, NULL);

		if(found)
		{
			iter2 = mend;       
			found1 = gtk_text_iter_forward_search(&iter2, "\"", 0, &mstart1, &mend1, NULL);
			if(found1)
			{
			iter1 = mstart;           
			gtk_text_iter_forward_to_line_end(&iter1);
			if(gtk_text_iter_compare(&iter1, &mend1)>=0)
			{
				gtk_text_buffer_apply_tag_by_name(buf, "pink_fg", &mend, &mend1);
				gtk_text_buffer_apply_tag_by_name(buf, "purple_fg", &mstart, &mend);
				iter3 = mend1;               
			}
			else
				iter3 = iter1;        
			}
			else
			iter3 = mend;
		}

	}while(found);  



	/* #define */
	gtk_text_buffer_get_start_iter(buf, &iter2);

	found =1;
	do
	{
		found = gtk_text_iter_forward_search(&iter2, "#define", 0, &mstart, &mend, NULL);

		if(found)
		{
			iter1 = mstart;
			gtk_text_iter_forward_to_line_end(&iter1);   
			gtk_text_buffer_apply_tag_by_name(buf,"purple_fg", &mstart, &iter1);
			iter2 = iter1;
		}
	}while(found);

}    

/**This function would be invoked when the user loads an application  
  * and is used to highlight the quotes and comments in the 
  * program.
  * 
  */

void highlight_comments() 
{
	GtkTextIter mstart1, mend1;

	GtkTextIter mstart2, mend2;
	GtkTextIter iter1, iter2, it1;
	GtkTextIter line_end;

	GtkTextBuffer *buffer;
	gboolean found1, found2;

	char *text = "\"";
	char *text1 = "/*";
	char *text2 = "*/";

	buffer = buf;
	gtk_text_buffer_get_start_iter(buf, &iter1);


	found1 = found2 = 1;
	while(found2)
	{
		found1 = gtk_text_iter_forward_search (&iter1, text, 0, &mstart1, &mend1, NULL);
		if (found1)
		{
			iter2 = mend1;

			found2 = gtk_text_iter_forward_search (&iter2, text, 0, &mstart2, &mend2, NULL);

			if(found2)
			{   

				it1 = mend2;
				line_end = mstart1;
				gtk_text_iter_forward_to_line_end(&line_end);

				if(gtk_text_iter_compare(&it1, &line_end) < 0)
				{

					gtk_text_buffer_remove_all_tags(buf, &mstart1, &it1);                           
					gtk_text_buffer_apply_tag_by_name(buffer, "pink_fg", &mstart1, &it1);
					iter1 = mend2;                   
				}
				else
				{
					gtk_text_buffer_remove_all_tags(buf, &mstart1, &line_end);   
					gtk_text_buffer_apply_tag_by_name(buffer, "pink_fg", &mstart1, &line_end);

					iter1 = line_end;                   
				}               


			}

			else /* pair not found */
			{
				if(gtk_text_iter_forward_to_line_end(&iter2))
				{
					/* do nothing */ 
				}
				else
				{   
				gtk_text_buffer_get_end_iter(buf, &iter2);

				}
			gtk_text_buffer_apply_tag_by_name(buffer, "pink_fg", &mstart1, &iter2);
			}

		}
		else
		found2 = 0;

	}
	/* this is highlighting comments */

	gtk_text_buffer_get_start_iter(buf, &iter1);
	found1 = found2 = 1;
	while(found2)
	{
		found1 = gtk_text_iter_forward_search (&iter1, text1, 0, &mstart1, &mend1, NULL);
		if (found1)
		{

			iter2 = mend1;

			found2 = gtk_text_iter_forward_search (&iter2, text2, 0, &mstart2, &mend2, NULL);

			if(found2)
			{   
				it1 = mstart2;               
				if(gtk_text_iter_forward_char(&it1))
				{               
					gtk_text_buffer_remove_all_tags(buf, &mstart1, &it1);                           
					gtk_text_buffer_apply_tag_by_name(buffer, "blue_fg", &mstart1, &it1);
				}
				else
				{
					gtk_text_buffer_remove_all_tags(buf, &mstart1, &mstart2);                           
					gtk_text_buffer_apply_tag_by_name(buffer, "blue_fg", &mstart1, &mstart2);
				}               
				iter1 = mend2;       
			}

			else /* pair not found */
			{
				gtk_text_buffer_get_end_iter(buf, &iter2);                           
				gtk_text_buffer_remove_all_tags(buf, &mstart1, &iter2);       
				gtk_text_buffer_apply_tag_by_name(buffer, "blue_fg", &mstart1, &iter2);
			}

		}
		else
			found2 = 0;

	}

	/* highlighting single line comments */
	gtk_text_buffer_get_start_iter(buf, &iter2);

	found1 =1;
	do
	{
		found1 = gtk_text_iter_forward_search(&iter2, "//", 0, &mstart1, &mend1, NULL);

		if(found1)
		{
			iter1 = mstart1;
			gtk_text_iter_forward_to_line_end(&iter1);   
			gtk_text_buffer_apply_tag_by_name(buf,"blue_fg", &mstart1, &iter1);
			iter2 = iter1;
		}
	}while(found1);


}



/**This function would be invoked when the user loads an application  
  * and is used to highlight the keywords in the 
  * program
  *
  */

void highlight_keywords()
{
	
	FILE *fp;
	char line[1000];
	int num;
	char str[100];
	GtkTextIter iter,iter1,it1;
	GtkTextIter mstart, mend;
	GtkTextBuffer *buffer;
	gboolean found;	
	int k;
	int flag = 1;
	fp = fopen("keywords.c", "r");
	
	while(fgets(line, 1000, fp) != NULL)
	{
		sscanf(line,"%s %d",str, &num);		
			
		k = 0;
			
		gtk_text_buffer_get_start_iter(buf, &iter); 
		buffer = buf;
		
		found = 1;
		while(found)
		{
		
		found = gtk_text_iter_forward_search (&iter, str, 0, &mstart, &mend, NULL); /*  starting and ending postions of match*/
		  
		if (found)
		{
			gunichar c1;
			
			it1 = mstart;
			flag = 1;
			if(gtk_text_iter_backward_char(&it1))  /*FALSE IF NOT OK */
			 	c1 = gtk_text_iter_get_char (&it1);
			else
				c1 = ' ';

			gunichar c2 = gtk_text_iter_get_char (&mend);  /* 0 if not deferencevale*/

			if(g_unichar_isalpha(c1) || g_unichar_isalpha(c2) || c1 == '_' || c2== '_' || g_unichar_isdigit(c1) || g_unichar_isdigit(c2) )
			{ 
				flag = 0; /*dont highli*/
			}
				      	
			else
			{

				/*everthing ok*/
			}
		      	
			
			iter1 = mstart;
			if(flag)
			{
				gtk_text_buffer_apply_tag_by_name(buffer, "bold", &mstart, &mend );				
				switch(num)
				{
				
				case 1: gtk_text_buffer_apply_tag_by_name(buffer, "green_fg", &mstart, &mend);
					break;
				case 2: gtk_text_buffer_apply_tag_by_name(buffer, "maroon_fg", &mstart, &mend);
					break;
				}
			}
		   }
		iter = mend;
		}
	}


}


/**This function would be invoked when the user loads an application  
  * and is used to highlight the numbers in the program
  *
  */

void highlight_digits()
{
	GtkTextIter mstart, mend, iter, iter2;
	gunichar start_c, end_c, c;
	int flag;

	gtk_text_buffer_get_start_iter(buf, &iter);	
	 
	
	int k;char string[500];
	
	do
	{	
	 	c = gtk_text_iter_get_char(&iter);
		
		k = 0;		
		start_c = c;	
		mstart = iter;	
		flag = 0 ;	
		while(g_unichar_isdigit(c))
		{
			string[k++] = c;
			flag = 1;			
			if(gtk_text_iter_forward_char(&iter))
			{	
				c = gtk_text_iter_get_char(&iter);
				mend = iter;
				end_c = c;
			
			}			
			else
				break;		
		}
		string[k++] = '\0';
		iter2 = mstart;
		if(gtk_text_iter_backward_char(&iter2))
			start_c = gtk_text_iter_get_char(&iter2);	
		if(g_unichar_isalpha(start_c) || g_unichar_isalpha(end_c) || end_c == '_' || start_c == '_')
		{
			start_c = end_c;
			mstart = mend;
		}
		else 
		{

			if(flag == 1)
				gtk_text_buffer_apply_tag_by_name(buf, "pink_fg", &mstart, &mend);
		}
	}while(gtk_text_iter_forward_char(&iter));
	
}	
/** This function is for the syntax highlighting this in turn calls the functions 
  * for highlighting digits, keywords, macros, comments.
  *
  */
void Syntax_highlight()
{
	/*digits high light*/ 
	highlight_digits();
	/*keywords highlight*/	
	highlight_keywords();
	/*macros highlight*/
	highlight_include();
	/*comments highlight*/
	highlight_comments();
	
}

/** The following function is used to LOAD THE FILE IN UTF-8 format into a file selection dialog.
  *  else displays error. 
  *
  */
static  void load_file(char *fname)
{
	GtkTextIter p;	
	status = 0;
	FILE *f; 
	
	/* Iterator is an object that represents positions between two characters in a buffer */
	
	char fbuf[CHAR_BUF];
	size_t l; /* read the contents of file in size_t l */

	if(!fname) 
	{    /* create file selection dialog */
		GtkWidget *dialog = gtk_file_selection_new("Open File ...");
		int resp = gtk_dialog_run(GTK_DIALOG(dialog));
		if(resp == GTK_RESPONSE_OK) 
		{   
			/* fname contains the file selected by the user */
			/* show the file selection dialog */
			fname = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog)));
			gtk_widget_destroy(dialog);
		} 
		else 
		{
			/* cancel */
			gtk_widget_destroy(dialog);
			return;
		}
	}
	
	

	if(!(f = fopen(fname, "r"))) /* if file cannot be opened */
	{
		g_printerr("%s: %s\n", fname, g_strerror(errno));
		return;
	}


	if(fname != filename) 
	{
		gchar *wt = g_strdup_printf("Text Editor (%s)", fname);
		g_free(filename);
		filename = fname;

		/* set titlebar as the file name */
		gtk_window_set_title(GTK_WINDOW(window), wt);
		g_free(wt);
	}

	/* put the ending iterator in p of buffer */
	gtk_text_buffer_get_end_iter(buf, &p);

	while((l = fread(fbuf, 1, sizeof(fbuf), f)) > 0) 
	{
		/* only text files in Utf-8 format can be opened */

		GError *err = NULL;
		gsize br, bw;
		gchar *text;
		if(!(text = g_locale_to_utf8(fbuf, l, &br, &bw, &err))) 
		{
			g_printerr("File is not in UTF-8 format : %s\n", err->message);
			g_clear_error(&err);
			filename = NULL; /* If an invalid file is opened enter the file name as NULL */
			gtk_window_set_title(GTK_WINDOW(window), "Text Editor (Insert file name)");
			fclose(f);
			return;
		}
		gtk_text_buffer_insert(buf, &p, text, bw);
		g_free(text);
	}

	strcpy(LoadFile, fname);

	gtk_text_buffer_set_modified(buf, FALSE);
	gtk_text_buffer_get_start_iter(buf, &p);
	gtk_text_buffer_place_cursor(buf, &p);
	
	/* check for error conditions */	
	if(ferror(f)) 
	{
		g_printerr("%s: %s\n", fname, g_strerror(errno));
		fclose(f);
		return;
	}
	if(fclose(f) == EOF)
		g_printerr("%s: %s\n", fname, g_strerror(errno));


	GtkTextIter  p1, p2;

	gtk_text_buffer_get_start_iter(buf2,&p2);
	gtk_text_buffer_get_end_iter(buf2, &p1);
	gtk_text_buffer_delete(buf2,&p2,&p1);
	
	parseFilename(fname);

	char object_file[300];
	char string[500];
	strcpy(object_file,fname1);
	char *new = strtok (object_file, ".");
		
	sprintf(string,"gcc -Wall -o %s %s",new, filename);
	gtk_entry_set_text(GTK_ENTRY (entry), string);
	
	/* Syntax highlighting */
	Syntax_highlight();

}


/** The functions helps us getting name of the function executing
  *
  */
static char* getFileName()
{
	return LoadFile;
}

/** Have the line no where error occured so go that line in mainfile and retrive the iterators
  * to highlight the line
  *
  */
void getLine(int no, int flag) 
{
	FILE *fp;
	char line[1000];	
	fp = fopen(filename, "r");
	int count = 0;
	while(fgets(line,1000,fp) != NULL)
	{
		count++;
		if(count == no)
			break;
	}			
	/* line where occured  */ 
	GtkTextIter iter, iter1;
	GtkTextIter mstart, mend;
	GtkTextBuffer *buffer;
	gboolean found;

	gtk_text_buffer_get_start_iter(buf, &iter); 
	
	buffer = buf;
	
	found = gtk_text_iter_forward_search (&iter, line , 0, &mstart, &mend, NULL); /*  starting and ending postions of match*/
	  
	gtk_text_buffer_create_mark (buffer, "pos", &mstart, FALSE);
	   	
	if (found)
	{
	        	
		iter1 = mstart;
		if(flag) /* this is for normal highlighting */
			gtk_text_buffer_apply_tag_by_name(buffer,"gray_bg",&mstart,&mend );
		else
		{
			GtkTextIter ms,me;
			gtk_text_buffer_get_start_iter(buf, &ms);
			gtk_text_buffer_get_end_iter(buf, &me);  
			gtk_text_buffer_remove_tag_by_name(buf,"yellow_bg",&ms,&me);
			gtk_text_view_scroll_to_iter(view, &mstart, 0.0,TRUE,0.5,0.5);
			gtk_text_buffer_apply_tag_by_name(buffer,"yellow_bg",&mstart,&mend);
		} 	 

	   }

	return;
}


/** This function highlights the errors in the program when clicked in the error-window
  *
  */

void getLine_error(int no, int flag) 
{
	FILE *fp;
	char line[1000];	
	fp = fopen("errorfile","r");
	int count = 0;
	while(fgets(line,1000,fp) != NULL)
	{
		count++;
		if(count == no + 1)
			break;
	}			
	/* line where occured  */ 
	GtkTextIter iter, iter1;
	GtkTextIter mstart, mend;
	GtkTextBuffer *buffer;
	gboolean found;

	gtk_text_buffer_get_start_iter(buf2, &iter); 
	
	gtk_text_buffer_create_mark(buf2, "pos", &iter, NULL);
        found = gtk_text_iter_forward_search (&iter, line , 0, &mstart, &mend, NULL); /*  starting and ending postions of match*/
	  
		   	
	 if (found)
	  {
	        if(flag)
		{ 
			GtkTextIter ms, me;
			gtk_text_buffer_get_start_iter(buf2, &ms);
			gtk_text_buffer_get_end_iter(buf2, &me);  
			gtk_text_buffer_remove_tag_by_name(buf2, "orange", &ms, &me);
			gtk_text_view_scroll_to_iter(view2, &mstart, 0.0, TRUE, 0.5, 0.5);
			gtk_text_buffer_apply_tag_by_name(buf2,"orange",&mstart, &mend);
		}

	   }

	


	return ;
}




/**The function save_file would save the file in to the directory  
  *
  */

static gboolean save_file(char *fname)
{
	FILE *f;
	
	status = 0;
	int ok = TRUE;
	if(!fname) 
	{
		GtkWidget *dialog = gtk_file_selection_new("Save File As...");
		int resp = gtk_dialog_run(GTK_DIALOG(dialog));
		if(resp == GTK_RESPONSE_OK) 
		{
			fname = g_strdup(
			gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog)));
			gtk_widget_destroy(dialog);
		}
		else 
		{
			gtk_widget_destroy(dialog);
			return FALSE;
		}
	}
  
	/*fname = Fname;
  	*/
	if(!(f = fopen(fname, "w")))  /* Error opening file */
	{
		g_printerr("%s: %s\n", fname, g_strerror(errno));
		ok = FALSE;
	} 
	else 
	{
		GtkTextIter start, end, p;

		/* get the starting and ending position */
		gtk_text_buffer_get_bounds(GTK_TEXT_BUFFER(buf), &start, &end);
		p = start;
		while(!gtk_text_iter_equal(&start, &end)) 
		{
			gchar *buf, *fbuf;
			gsize br, bw;
			GError *err = NULL;
			gtk_text_iter_forward_chars(&p, CHAR_BUF);
			buf = gtk_text_iter_get_slice(&start, &p);
			fbuf = g_locale_from_utf8(buf, -1, &br, &bw, &err);
			g_free(buf);

			if(!fbuf) 
			{
				g_printerr("Failed UTF-8 to locale conversion: %s\n",
				err->message);
				g_clear_error(&err);
				ok = FALSE;
				break;
			}
			fwrite(fbuf, bw, 1, f);
			g_free(fbuf);
			if(ferror(f)) 
			{
				g_printerr("%s: %s\n", fname, g_strerror(errno));
				ok = FALSE;
				break;
			}
			start = p;
		}
		if(fclose(f) == EOF) 
		{	
		g_printerr("%s: %s\n", fname, g_strerror(errno));
		ok = FALSE;
		}
	}

	strcpy(LoadFile, fname); 

	if(ok) 
	{
		gtk_text_buffer_set_modified(buf, FALSE);
		if(fname != filename) 
		{
			gchar *wt = g_strdup_printf("TextView (%s)", fname);
			g_free(filename);
			filename = fname;
			gtk_window_set_title(GTK_WINDOW(window), wt);
			g_free(wt);
		}
	}
	
	GtkTextIter p1, p2;
	gtk_text_buffer_get_start_iter(buf2, &p2);
	gtk_text_buffer_get_end_iter(buf2, &p1);
	gtk_text_buffer_delete(buf2, &p2, &p1);	
	
	GtkTextIter p3, p4;
	gtk_text_buffer_get_start_iter(buf, &p3);
	gtk_text_buffer_get_end_iter(buf, &p4);
	gtk_text_buffer_remove_all_tags(buf, &p3, &p4);	
	
	Syntax_highlight();
	parseFilename(fname);

	/* creates the object file name*/
	char object_file[300];
	char string[500];
	strcpy(object_file,fname1);
	char *new = strtok (object_file,".");

		
	sprintf(string,"gcc -Wall -o %s %s",new,filename);
	gtk_entry_set_text(GTK_ENTRY (entry),string);


	return ok;
}

/** This function is used to prompt the user to save if the buffer is modified 
  * whenever he quits the application or loads a new file 
  *
  */

static gboolean save_if_modified(void)
{
	status = 0;

	int resp;
	GtkWidget *dialog;
	
	/* returns true if buffer is not modified... u will exit out of this function*/
	if(!gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(buf)))
		return TRUE;

	dialog = gtk_message_dialog_new(GTK_WINDOW(window), 0, GTK_MESSAGE_QUESTION,GTK_BUTTONS_NONE,"Buffer Modified. Do you want to save it now?");
	gtk_dialog_add_buttons(GTK_DIALOG(dialog), GTK_STOCK_YES, GTK_RESPONSE_YES, GTK_STOCK_NO, GTK_RESPONSE_NO,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
	resp = gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
	switch(resp) 
	{
		case GTK_RESPONSE_YES:
			return save_file(filename);
		case GTK_RESPONSE_NO:
			return TRUE;
		case GTK_RESPONSE_CANCEL:
		case GTK_RESPONSE_DELETE_EVENT:
			return FALSE;
		default:
			g_printerr("Error response %d from dialog\n", resp);
	return FALSE;
	}
}


/**The function returns the errors in the program and calls getLine() to get the lines highlighted.
  * The errors are loaded in the UTF-8 format 
  * into a file selection dialog.
  *
  */
 
void getError()
{
	char line[3000];
	FILE *fp;
	int n;	
	char f_name[300];
	fp = fopen("errorfile", "r+");
	while (fgets(line,256,fp)!= NULL)
	{
		
		char *k1 = strstr(line,":");
		int i1 = k1-line;
		int k=0; int i;
		char num[100];
		
		int f1 = 0;
		for(i=0 ;i < i1 ;i++)
		{
		    f_name[f1++]=line[i];
		}

		f_name[f1++]='\0';
	       
		for(i = i1 + 1; i < strlen(line); i++)
		{
			if(line[i]==' ' || line[i]==':' || isalpha(line[i]))
				break;
			num[k++]=line[i];
		}
		num[k++]='\0';

		
		if((k!=1 && strcmp(f_name,file_name)==0 ) || (k!=1 && strcmp(f_name,filename)==0 ))
		{
			n = atoi(num);							
			getLine(n,1);
		
		}
	}
	Syntax_highlight();
}




/** The following function is triggered when the user clicks on the gcc button 
  * used to compile the file selected by the user and display the errors.
  *
  */

void submit_clicked(GtkWidget *widget, gpointer gdata)
{
	status = 0;
	char command[300];
	
	if(getFileName()!=NULL)
	{
		char string[300];
		strcpy(string, getFileName());
		int i,j;
		int k=0;
		char pathname[500];

		for(i = strlen(string)-1; i >= 0; i--)
		{
			if(string[i] == '/')
				break;
		}

		int f=0;       
		for(j=i+1;j<strlen(string);j++)
		{
		    file_name[f++]=string[j];
		}
		file_name[f++]='\0';
		
				
		for(j=0;j<i;j++)
		{
			pathname[k++]=string[j];
		}
		pathname[k++]='\0';
		
		char setpath[1000];
		
		sprintf(setpath,"cd %s",pathname);			
				
		
		
		sprintf(command,"%s > errorfile 2>&1 ",entry_text);
		
		system(setpath);
		
		
		save_file(filename);
		system(command);
		
		
	}

	FILE *f; 
	/* Iterator is an object that represents positions between two characters in a buffer */
	GtkTextIter p,p1,p2;

	char fbuf[CHAR_BUF];
	size_t l; /* read the contents of file in size_t l */


	if(!(f = fopen("errorfile", "r"))) /* if file cannot be opened */
	{
		g_printerr("%s: %s\n", Fname, g_strerror(errno));
		return;
	}
	
	gtk_text_buffer_get_start_iter(buf2,&p2);
	gtk_text_buffer_get_end_iter(buf2, &p1);
	gtk_text_buffer_delete(buf2,&p2,&p1);
	

	gtk_text_buffer_get_end_iter(buf2, &p);
	/* put the ending iterator in p of buffer */
	
	while((l = fread(fbuf, 1, sizeof(fbuf), f)) > 0) 
	{
		/* only text files in Utf-8 format can be opened */
		GError *err = NULL;
		gsize br, bw;
		gchar *text;
		if(!(text = g_locale_to_utf8(fbuf, l, &br, &bw, &err))) 
		{
			g_printerr("File is not in UTF-8 format : %s\n", err->message);
			g_clear_error(&err);
			filename = NULL; /* If an invalid file is opened enter the file name as NULL */
			gtk_window_set_title(GTK_WINDOW(window), "C Editor (Insert file name)");
			fclose(f);
			return;
		}
		gtk_text_buffer_insert(buf2, &p, text, bw);  
		g_free(text);
	}

	/* clear the buffer of window2 */
	gtk_text_buffer_set_modified(buf2, FALSE);
	gtk_text_buffer_get_start_iter(buf2, &p);
	gtk_text_buffer_place_cursor(buf2, &p);

	
	status = 1;
	if(ferror(f)) 
	{
		g_printerr("%s: %s\n", "errorfile", g_strerror(errno));
		fclose(f);
		return;
	}
	if(fclose(f) == EOF)
		g_printerr("%s: %s\n", "errorfile", g_strerror(errno));
	
	getError(); /* highlighting */
}


/** The following function is used to highlight the errors  
  * in the program.
  *
  */

void get_Line_At_Cursor(int lno)
{
	char line[3000];
	FILE *fp;
	int n;	
	int count = 0;
	
	/*getfname();*/

	fp = fopen("errorfile", "r+");
	
	while (fgets(line,500,fp)!= NULL)
	{
		if(count == lno)
			break;	
		count++;
	}
		
	char f_name[400];
	char *k1 = strstr(line,":");
	int i1 = k1-line;

	int k=0; int i;
	char num[100];
	
	for(i = 0; i < i1 ;i++)
	{
		f_name[k++] = line[i];
	}
	f_name[k++]='\0';
	
	k=0;

	for(i = i1 + 1; i < strlen(line); i++)
	{
		if(line[i]==' ' || line[i]==':' || isalpha(line[i]))
			break;
		num[k++]=line[i];
	}
	num[k++]='\0';
	if((k!=1 && strcmp(f_name,file_name)==0 ) || (k!=1 && strcmp(f_name,filename)==0 )) /* else this doesnt get have line number in it */
	{
		n = atoi(num);							
		getLine(n,0);
	
	}
	else
	{
		GtkTextIter ms1,me1;
		gtk_text_buffer_get_start_iter(buf, &ms1);
		gtk_text_buffer_get_end_iter(buf, &me1);  
		gtk_text_buffer_remove_tag_by_name(buf,"yellow_bg",&ms1,&me1);
	}
	fclose(fp);
}

/** get mark, then markname and then get iterator at that markname
*  Get the line number from iterator
*  Then get the corresponding line from errorFile
*/
void get_iter_at_cursor()
{
		
	GtkTextMark *pos_cursor;
	gchar *mark_name;		
	GtkTextIter iter;
	gint lineNo;

	pos_cursor = gtk_text_buffer_get_insert(buf2); /*mark */
	 
	mark_name = gtk_text_mark_get_name(pos_cursor); /*markname */

	gtk_text_buffer_get_iter_at_mark(buf2,&iter,pos_cursor);	
	
	/*lineNo starts from 0 */
	lineNo = gtk_text_iter_get_line(&iter);		

	getLine_error((int)lineNo,1);

	get_Line_At_Cursor((int)lineNo);	

}


/** This function is event handler triggered when the cursor position is changed. 
 *
 */
void gtk_text_view_notify_cursor_position(GtkTextBuffer *buffer,GtkWidget *v)
{
	if(status)	
	{	
		get_iter_at_cursor();	

	}
}


