#include <gtk/gtk.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include "search.c"


extern GtkWidget *entry;

/** Creates the text_view
  *
  */
GtkWidget *view; 

/** Creates the main_menu
  *
  */
GtkItemFactory *main_menu;


void show_help(void);
void show_about(void); 
/** All menu functions of the C editor are invoked with this function.
  *
  */
/* Cut operation is done here
 *
 */
void edit_cut()
{
	gtk_text_buffer_cut_clipboard(buf,gtk_clipboard_get(GDK_SELECTION_CLIPBOARD), TRUE);
}

/** Copy operation is done here
  *
  */
void edit_copy()
{
	gtk_text_buffer_copy_clipboard(buf,gtk_clipboard_get(GDK_SELECTION_CLIPBOARD));
}

/** Paste operation is done here
  *
  */
void edit_paste()
{
	gtk_text_buffer_paste_clipboard(buf,gtk_clipboard_get(GDK_SELECTION_CLIPBOARD), NULL, TRUE);
}

/** select operation is done here
  *
  */
void edit_select()
{
	GtkTextIter p; 	
	gtk_text_buffer_get_start_iter(buf, &p); 
	gtk_text_buffer_place_cursor(buf, &p);    /* ignore the selection made by the mouse */
	gtk_text_buffer_get_end_iter(buf, &p);  
	gtk_text_buffer_move_mark_by_name(buf, "selection_bound", &p);
}

/** Find operation is done here
  *
  */
void search_find()
{
	textfind();
}

/** Replace operation is done here
  *
  */
void search_replace()
{
	text_find_replace();	
}

/** Help function is called.
  *
  */
void help_contents()
{
	show_help();
}
/** This describes about the C-editor
  *
  */
void help_about()
{
	show_about();
}


/** new file creation 
  *
  */
void file_new()
{
	if(save_if_modified())  /* call save if modified wen user opens a new file */
	{
		/* get all the current tag table n put them in the new buffer */
		buf = gtk_text_buffer_new(gtk_text_buffer_get_tag_table(buf));

		gtk_text_view_set_buffer(GTK_TEXT_VIEW(view), buf);

		GtkTextIter  p1, p2;

		gtk_text_buffer_get_start_iter(buf2,&p2);
		gtk_text_buffer_get_end_iter(buf2, &p1);
		gtk_text_buffer_delete(buf2,&p2,&p1);

		gtk_entry_set_text(GTK_ENTRY (entry),"");
		filename = NULL; /*loadbuf(NULL)*/
		gtk_window_set_title(GTK_WINDOW(window),"C_Editor(NewFile)");
		g_object_unref(G_OBJECT(buf)); 
		/* needed for freeing memory by the buffer wen a new buffer is created */
	}
		

}

/** Opening existing file
  *
  */
void file_open()
{
	if(save_if_modified()) 
	{
		/* call save if modified wen user opens a new file */
		buf = gtk_text_buffer_new(gtk_text_buffer_get_tag_table(buf));
		gtk_text_view_set_buffer(GTK_TEXT_VIEW(view), buf);

		/* needed for freeing memory by the buffer wen a new buffer is created */
		g_object_unref(G_OBJECT(buf));
		load_file(NULL);
	}
		
}

/** Saving the file
  *
  */
void file_save()
{
	save_file(filename);
}

/** Save as operation
  *
  */
void file_saveas()
{
	save_file(NULL);
}
/** Quits the application
  *
  */
void file_quit()
{
	if(save_if_modified())            /* call save if modified wen user opens a new file */
		gtk_widget_destroy(window);
}


/** This is the GtkItemFactoryEntry structure used to generate new menus.
 *  Item 1: The menu path. The letter after the underscore indicates an
 *          accelerator key once the menu is open.
 *  Item 2: The accelerator key for the entry
 *  Item 3: The callback function.
 *  Item 4: The callback action.  This changes the parameters with
 *          which the function is called.  The default is 0.
 *  Item 5: The item type, used to define what kind of an item it is.
 *          Here are the possible values:
 *
 *          NULL               -> "<Item>"
 *          ""                 -> "<Item>"
 *          "<Title>"          -> create a title item
 *          "<Item>"           -> create a simple item
 *          "<CheckItem>"      -> create a check item
 *          "<ToggleItem>"     -> create a toggle item
 *          "<RadioItem>"      -> create a radio item
 *          "<path>"           -> path of a radio item to link against
 *          "<Separator>"      -> create a separator
 *          "<Branch>"         -> create an item to hold sub items (optional)
 *          "<LastBranch>"     -> create a right justified branch 
 */

GtkItemFactoryEntry menu_def[] = 
  {
    { (char *)"/_File", NULL, NULL, 0, (char *)"<Branch>", NULL },
    { (char *)"/File/_New", (char *)"<control>N", file_new, 0, NULL },
    { (char *)"/File/_Open...", (char *)"<control>O", file_open, 0,NULL  },
    { (char *)"/File/_Save", (char *)"<control>S", file_save,0,NULL  },
    { (char *)"/File/Save _As...", NULL, file_saveas,0,NULL },
    { (char *)"/File/sep", NULL, NULL, 0, (char *)"<Separator>", NULL },
    { (char *)"/File/_Quit", (char *)"<control>Q", file_quit, 0,NULL },
    { (char *)"/_Edit", NULL, NULL, 0, (char *)"<Branch>", NULL },
    { (char *)"/Edit/C_ut", (char *)"<control>X", edit_cut, 0,NULL },
    { (char *)"/Edit/_Copy", (char *)"<control>C", edit_copy ,0,NULL },
    { (char *)"/Edit/_Paste", (char *)"<control>V", edit_paste, 0,NULL},
    { (char *)"/Edit/sep", NULL, NULL, 0, (char *)"<Separator>", NULL },
    { (char *)"/Edit/Select All", NULL, edit_select, NULL, NULL },
    { (char *)"/_Search", NULL, NULL, 0, (char *)"<Branch>", NULL },
    { (char *)"/Search/_Find",  (char *)"<control>F" , search_find, 0,NULL },
    { (char *)"/Search/_Replace", (char *)"<control>R" , search_replace, 0,NULL },
    { (char *)"/_Help", NULL, NULL, 0, (char *)"<Branch>", NULL },
    { (char *)"/Help/_Contents", (char *)"<control>H", help_contents,0,NULL },
    { (char *)"/Help/_About",  NULL , help_about, 0, "<Item>" },
    
  };
