
#include <gtk/gtk.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

extern GtkWidget *view;
GtkWidget *text_view;
/** Search entry variable*/
GtkWidget *search_entry;

/** replace variables */
GtkWidget *replace_entry;

/** Finds the text in the textbuffer
 *
 */
void find (GtkTextView *text_view, const gchar *text, GtkTextIter *iter)
{
	GtkTextIter mstart, mend;
	GtkTextBuffer *buffer;
	gboolean found;
	
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(text_view));
	found = gtk_text_iter_forward_search (iter, text, 0, &mstart, &mend, NULL);

	if (found)
	{
		gtk_text_buffer_select_range (buffer, &mstart, &mend);
		gtk_text_buffer_create_mark (buffer, "last_pos", &mend, FALSE);
	}
}
/** Destroy the window
 *
 */
void win_destroy (void)
{
	gtk_main_quit();
}

/** Event handler when "next" button is clicked.
  * 
  */
void next_button_clicked (GtkWidget *next_button)
{
	const gchar *text;
	GtkTextBuffer *buffer;
	GtkTextMark *last_pos;
	GtkTextIter iter;

	text = gtk_entry_get_text (GTK_ENTRY (search_entry));
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(text_view));
	last_pos = gtk_text_buffer_get_mark (buffer, "last_pos");

	if (last_pos == NULL)
	{
		GtkWidget *window1;
		GtkWidget *label;

		window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title (GTK_WINDOW (window1), "Search");
		gtk_window_set_default_size(GTK_WINDOW(window1), 50, 300);


		label = gtk_label_new ("End of Search!!!!  \n\n");

		gtk_container_add (GTK_CONTAINER (window1), label); 

		gtk_widget_show_all (window1);

		return;
      
   	 }
  
	gtk_text_buffer_get_iter_at_mark (buffer, &iter, last_pos);
	find (GTK_TEXT_VIEW (text_view),(gchar *)gtk_entry_get_text((GtkEntry *)search_entry), &iter);
}

/** Event handler when "search"
 * button is clicked 
 */
void search_button_clicked (GtkWidget *search_button)
{

	GtkTextBuffer *buffer;
	GtkTextIter iter;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(text_view));;
	gtk_text_buffer_get_start_iter(buffer, &iter);

	find (GTK_TEXT_VIEW(text_view),(gchar *)gtk_entry_get_text((GtkEntry *)search_entry),&iter);
}

/** Displays a window to enter search text
 *
 */
void textfind(void)
{
	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *search_button;
	GtkWidget *next_button;


	win = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	vbox = gtk_vbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (win), vbox);

	hbox = gtk_hbox_new (FALSE, 2);

	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	text_view = view;
	search_entry = gtk_entry_new();

	gtk_box_pack_start (GTK_BOX (hbox),search_entry, TRUE, TRUE, 0);

	search_button = gtk_button_new_with_label ("Search");
	gtk_box_pack_start (GTK_BOX (hbox), search_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT (search_button), "clicked",G_CALLBACK (search_button_clicked), NULL);

	next_button = gtk_button_new_with_label ("Next");
	gtk_box_pack_start (GTK_BOX (hbox), next_button, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (next_button), "clicked",G_CALLBACK (next_button_clicked), NULL);



	gtk_widget_show_all(win);
}



/** Replaces the text with text1 in textbuffer
  *
  */
void replace (GtkTextView *text_view, const gchar *text,const gchar *text1, GtkTextIter *iter)
{
	GtkTextIter mstart, mend;
	GtkTextBuffer *buffer;
	gboolean found;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(text_view));
	found = gtk_text_iter_forward_search (iter, text, 0, &mstart, &mend, NULL);
	if (found)
	{
		gtk_text_buffer_select_range (buffer, &mstart, &mend);
		gtk_text_buffer_create_mark (buffer, "last_pos", &mend, FALSE);

		int len=strlen(text1);
		gtk_text_buffer_delete(buffer,&mstart,&mend);
		gtk_text_buffer_insert(buffer,&mstart,text1,len);
	}
}
/** Event handler when replace button is clicked
  *
  */
void replace_button_clicked(GtkWidget *replace_button)
{
	GtkTextBuffer *buffer;
	GtkTextIter iter;

	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text_view));
	gtk_text_buffer_get_start_iter(buffer, &iter);

	replace (GTK_TEXT_VIEW(text_view),(gchar *)gtk_entry_get_text((GtkEntry *)search_entry),(gchar *)gtk_entry_get_text((GtkEntry *)replace_entry),&iter);
}

/** Opens a window to enter text to find and text to be replaced
 *
 */
void text_find_replace(void)
{
	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *search_button;
	GtkWidget *replace_button;  

	win = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	vbox = gtk_vbox_new (FALSE, 2);
	gtk_container_add (GTK_CONTAINER (win), vbox);

	hbox = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	text_view = view;

	search_entry = gtk_entry_new();
	replace_entry = gtk_entry_new();

	gtk_box_pack_start (GTK_BOX (hbox),search_entry, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox),replace_entry, TRUE, TRUE, 0);

	search_button = gtk_button_new_with_label ("Search");
	gtk_box_pack_start (GTK_BOX (hbox), search_button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT (search_button), "clicked",G_CALLBACK (search_button_clicked), NULL);

	replace_button = gtk_button_new_with_label ("Replace");
	gtk_box_pack_start (GTK_BOX (hbox), replace_button, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (replace_button),"clicked",G_CALLBACK (replace_button_clicked), NULL);

	gtk_widget_show_all(win);
}








/** This tells about the editor 
  *
  */
void show_about(void)
{

	GtkWidget *window1;
	GtkWidget *label;
        char about[300];
	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window1), "About Text Editor for C");
	gtk_window_set_default_size(GTK_WINDOW(window1), 300, 300);


	strcpy(about,"This is C editor used for compilation of C programs.\n\n This has features for syntax highlighting and highlights the"
	"lines that contains errors.\n ");

	strcat(about,"\0");
	label = gtk_label_new (about);
	gtk_container_add (GTK_CONTAINER (window1), label); 

	gtk_widget_show_all (window1);
}

/** Explains the functions available
  *
  */


void show_help(void)
{

	GtkWidget *window1;
	GtkWidget *label;
	char help[5000];
	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window1), "Help");
	gtk_window_set_default_size(GTK_WINDOW(window1), 300, 300);


	strcpy(help,"\nTo Create a New C file, choose file -> New. The application displays a new file in the C editor.\n\nTo Save a File\n - To save changes in an existing file, choose File -> Save.\n - To save a new file or to save an existing file under a new filename, choose File -> Save As. Enter a name for the file in the Save As dialog, then click Save.\n\nTo Edit text\n\n - To copy the selected text to a buffer, choose Edit -> Copy.\n - To delete the selected text from the file and move the selected text to a buffer, choose Edit -> Cut.\n - To insert the contents of the buffer at the cursor position, choose Edit -> Paste.You must cut or copy text before you can paste text into the file.\n - To select all of the text in the file, choose Edit -> Select All.\n\nTo Find Text\n\n - Choose Search -> Find to display the Find dialog.\n-Type the string that you want to find, in the text box.\n- Click Find to search the file for the first occurence of the string.\n If the editor finds the string, application moves the cursor position to the string, and selects the string.\n- To find the next occurence of the string, click Next\n\nTo Find and Replace Text\n\nChoose Search -> Replace to display the Replace dialog.\n-Type the string that you want to find, in the Search For field.\n-Click Find to search the file for the first occurence of the string.\n  If the editor finds the string, application moves the cursor position to the string, and selects the string.\n- Click Replace to replace the occurences of the string with the text in the Replace with field. \n- To find the next occurence of the string,click Next.\n\nTo Compile:-\n Select the file to be complied. \nThe file gets displayed on the window1 with all the keywords highlighted.\n Now click on gcc button to compile the code.\n If any errors , they would be displayed in the bottom window and would be highlighted in gray in the main program.\n To view the error at a particular line, click on the error in the window2 and it gets highlighted in the program in yellow.\n. If no errors then the .o file would be created in the current folder.");


	strcat(help,"\0");
	label = gtk_label_new (help);
	gtk_container_add (GTK_CONTAINER (window1), label); 
	gtk_widget_show_all (window1);

}
