/**
 * Client.c
 * @author:Prashant sharma & Narendra Singh
 * @version:1.0
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include<gtk-2.0/gtk/gtk.h>
#include<regex.h>
#include<arpa/inet.h>
#include<sys/socket.h>
#include<pthread.h>
#include<sys/types.h>
#include<netinet/in.h>
#include<sys/stat.h>
#include<unistd.h>
#include<fcntl.h>
#include<time.h>
#include <poll.h>

#define BUFFER 1024
#define PORT_NUMBER 9999
#define SERVER_ADDRESS "127.0.0.1"
#define LABEL_MAX_LENGTH 100


/** Gtk Window. */
GtkWidget *window;
/** Gtk related global parameters. entry1 taking username from user. */
GtkWidget *entry1;
/** Gtk related global parameters. entry 2 for taking password from user. */
GtkWidget *entry2;
/** Gtk related global parameters. Gtknotebook instance*/
GtkWidget *notebook;
/** Gtk gloabal variable for updating time via a time update thread.*/
GtkWidget *label_timeleft;
/** Socket gloabal variable socket file descriptor */
int socket_file_descriptor;
/** used to store the characters read from the socket */
int characters_read;

/** used to store the username */
char username[BUFFER];
/** used to store the password */
char password[BUFFER];
/** used to store total no of Questions */
int tot_question;
/** used to store current question being answered.*/
int current_question;
/** used to store total time*/
int tot_time;
/** used to store marks obtained by user*/
int marks;
/** to store the anser given by the user */
char answer[BUFFER], input_data[BUFFER], ack[10], login_status[10], connection_flag, time_flag;


/** Records the start time of the exam */
time_t start;
/** used to take the time difference */
double dif;

/** updates time left to the label in time update thread.*/
int time_left;

/** data file descripter for image file */
int data_file_descriptor;

void show_questions();

/**
* This is used to update the time left 
* @see time_thread()
*/
void update_time_thread() {
    char time_string[100];
    time_t current;
    int time_min;
    sleep(1);
    while (1) {
        time(&current);
        dif = difftime (current,start);
        time_min=tot_time-(int) dif/60;
        
        sprintf(time_string, "Time Left:%d Mins", time_min);
	if(time_min == 0)
	{      
	      pthread_exit(0);
	}
	gtk_label_set_text((GtkLabel *) label_timeleft, (gchar *) time_string);
        //gtk_label_set_te
        gtk_widget_show(label_timeleft);
        sleep(1);
    }

}

/**
 * This is a thread that sleeps for the time the test run or the allowed
 * time for the user to answer the test
 *
 * @param   time_wait    Time allowed to take the test.
 * @see verify_user()
 * */
void time_thread(void *time_wait) {
    int temp=*((int*)time_wait);
    time (&start);
    pthread_t thread;
    pthread_create(&thread, NULL, (void *) & update_time_thread, (void *) & tot_time);

    sleep(temp * 60);
   
    //terminate test here :P
    time_flag=1;
    current_question=tot_question+1;
    show_questions();
    pthread_exit(0);
}

/**
 * Socket function reimplementation with error handling .
 *
 * @param   domain Domain value passed to the socket
 * @param   type Type of socket.TCP/UDP
 * @param   protocol    protocol of the socket being created.
 * */

int Socket(int domain, int type, int protocol) {
    int return_value;
    return_value = socket(domain, type, protocol);
    if (return_value < 0) {
        fprintf(stderr, "Cannot open socket.\n");
        perror("REASON");
        exit(1);
    }
    return return_value;
}

/**
 * Read function reimplementation with error handling .
 *
 * @param   fd  filedescriptor to read
 * @param   buf Buffer it is read into
 * @param   count   no of bytes to read.
 * */

ssize_t Read(int fd, void *buf, size_t count) {
    ssize_t characters_read;
    characters_read = read(fd, buf, count);
    if (characters_read < 0) {
        perror("Can't read");
        exit(1);
    }
    return characters_read;
}

/**
 * write function reimplementation with error handling .
 *
 * @param   fd  filedescriptor to read
 * @param   buf Buffer it is read into
 * @param   count   no of bytes to read.
 * */

ssize_t Write(int fd, const void *buf, size_t count) {
    ssize_t return_value;
    return_value = write(fd, buf, count);
    if (return_value < 0) {
        perror("Write failed\n");
        exit(1);
    }
    return return_value;
}

/**
 * Close function reimplementation with error handling. 
 *
 * @param   fd  filedescriptor to close
 * */

void Close(int fd) {
    int return_value;
    return_value = close(fd);
    if (return_value < 0) {
        fprintf(stderr, "Cannot close\n");
        perror("REASON");

    }
}
/**
 * to open a file 
 * @param pathname path of the file 
 * @param flags    read,write etc
 */
int Open(const char *pathname, int flags)
{
    int file_descriptor;
    file_descriptor=open(pathname,flags,0777);
    if(file_descriptor < 0)
    {
        fprintf(stderr, "Cannot open file\n");
	perror("REASON");
	
    }
    return file_descriptor;
}
   

/**
 * Used to destroy the window.
 * */

static gboolean delete(GtkWidget *widget,
        GtkWidget *event,
        gpointer data) {
    gtk_main_quit();
    return FALSE;
}

/**
 * Used to copy the option selected by the user in the radio button to global answer variable.
 */

void check_radio(GtkWidget *widget, gpointer ans) {

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))) {
        strcpy(answer, ans);
    }

}

/**
 * Used to check the length of the labels if its more than LABEL_MAX_LENGTH then
 *insert a new line after each LABEL_MAX_LENGTH.
 *@param check_string string to be checked
 */
void label_length_check(char* check_string) {
    /* Label length check */
    int temp_length;
    char temp_ch1, temp_ch2;
    temp_length = strlen(check_string);
    if (temp_length > LABEL_MAX_LENGTH) {
        int i, j, k, l, x;
        x = temp_length / LABEL_MAX_LENGTH;
        for (i = 1; i <= x; i++) {

            if (i == 1) {
                j = (i * LABEL_MAX_LENGTH) + 1;
                temp_ch1 = check_string[j];
                check_string[j] = '\n';
            }
            for (k = j; k < j + i; k++) {
                l = k;
                while (l < temp_length && l < ((i + 1) * LABEL_MAX_LENGTH)) {
                    l = l + i;
                    temp_ch2 = check_string[l];
                    check_string[l] = temp_ch1;
                    temp_ch1 = temp_ch2;
                }
            }
            j = l;
            if (j < temp_length) {
                check_string[j + i] = '\n';
            } else {
                check_string[j + i] = temp_ch1;
                check_string[j + i + 1] = '\0';
            }
            temp_length = temp_length + 1;
        }
    }
    return;
}

/**
 * this is the function that is used to create a different 
 * thread for time out and then call tha show_questions() 
 * @see show_questions()
*/
void start_test() {
    pthread_t thread;
    
    pthread_create(&thread, NULL, (void *) & time_thread, (void *) & tot_time);
    time_flag=0;
    strcpy(answer, "A");
    show_questions();
}

/**
 * Question frames. Used to get the Questions 
 * from the server and display them in frames.
 * 
 */
void show_questions() {
    
    /*Variable declaration of GtkWidget for different components of the window*/

    GtkWidget *label_empty;
    GtkWidget *label_qno;
    GtkWidget *label_question;
    GtkWidget *label;
    GtkWidget *image;
    GtkWidget *button;
    GtkWidget *gridLayout;
    GtkWidget *frame;
    GtkWidget *halign;
    GtkWidget *hseparator;
    GtkWidget *radio1, *radio2, *radio3, *radio4;


    /* Buffers storing various components of the questions. eg. Question statement options etc.. */
    char question_imageurl[BUFFER];
    char question_statement[BUFFER];
    char question_optiona[BUFFER];
    char question_optionb[BUFFER];
    char question_optionc[BUFFER];
    char question_optiond[BUFFER];
    char temp_string[BUFFER];


    if (current_question == tot_question + 1) {
        
        //answer
        Write(socket_file_descriptor, answer, strlen(answer));
        if(time_flag == 1)
	{
	    
	    //read imageurl just to synchronization
            characters_read = Read(socket_file_descriptor, question_imageurl, BUFFER - 1);
            question_imageurl[characters_read] = '\0';

            //write an ack to server
            Write(socket_file_descriptor, "Timeout",7);
	}
	
       
        //read marks
        characters_read = Read(socket_file_descriptor, input_data, BUFFER - 1);
        input_data[characters_read] = '\0';
        marks = atoi(input_data);
	
        //write an ack to server
        Write(socket_file_descriptor, ack, strlen(ack));
    }
    if (current_question <= tot_question) {

        //answer
	if(current_question != 1)
	{
	    Write(socket_file_descriptor, answer, strlen(answer));
	    
	}
	strcpy(answer, "A");
        

        /* get the question data */

        //read imageurl
        characters_read = Read(socket_file_descriptor, question_imageurl, BUFFER - 1);
        question_imageurl[characters_read] = '\0';
	
	 
        //write an ack to server
        Write(socket_file_descriptor, ack, strlen(ack));
	
	//if there is an image url
	if(strcmp(question_imageurl,"NO IMAGE"))
	{
	    
	    struct pollfd pfd[1];
	    pfd[0].fd = socket_file_descriptor;
	    pfd[0].events = POLLIN;
	   
	    data_file_descriptor = Open(question_imageurl, O_WRONLY | O_CREAT | O_TRUNC);
	    if(data_file_descriptor < 0)
	    {
		printf("Image file can not created\n");		      
	    }
	    else
	    {
		
		  
		characters_read = Read(socket_file_descriptor, input_data, BUFFER -1);
		//fprintf(stderr,"%s",input_data);
		while(1)
		{
		    poll (pfd, 1, 200);
		    if (!pfd[0].revents)
		    {
			break;
		    }
		    Write(data_file_descriptor, input_data, characters_read);
		    characters_read = Read(socket_file_descriptor, input_data, BUFFER -1);
		  //  fprintf(stderr,"%s",input_data);
		    
		}
		if(characters_read > 0)
		{    
		   Write(data_file_descriptor, input_data, characters_read);
		}
		
	         //write an ack to server
                Write(socket_file_descriptor, ack, strlen(ack));

		Close(data_file_descriptor);
	    }
	}
	
	

     
      
        //read question statement
        characters_read = Read(socket_file_descriptor, question_statement, BUFFER - 1);
        question_statement[characters_read] = '\0';
        //write an ack to server
        Write(socket_file_descriptor, ack, strlen(ack));

        //read optiona
        characters_read = Read(socket_file_descriptor, question_optiona, BUFFER - 1);
        question_optiona[characters_read] = '\0';
        //write an ack to server
        Write(socket_file_descriptor, ack, strlen(ack));

        //read optionb
        characters_read = Read(socket_file_descriptor, question_optionb, BUFFER - 1);
        question_optionb[characters_read] = '\0';
        //write an ack to server
        Write(socket_file_descriptor, ack, strlen(ack));

        //read optionc
        characters_read = Read(socket_file_descriptor, question_optionc, BUFFER - 1);
        question_optionc[characters_read] = '\0';
        //write an ack to server
        Write(socket_file_descriptor, ack, strlen(ack));

        //read optiond
        characters_read = Read(socket_file_descriptor, question_optiond, BUFFER - 1);
        question_optiond[characters_read] = '\0';
        //write an ack to server
        Write(socket_file_descriptor, ack, strlen(ack));

        //read ack ignore
        characters_read = Read(socket_file_descriptor, input_data, BUFFER - 1);
        input_data[characters_read] = '\0';

	
         

        /* Label length check */
        label_length_check(question_statement);
        label_length_check(question_optiona);
        label_length_check(question_optionb);
        label_length_check(question_optionc);
        label_length_check(question_optiond);


        /* Arranging the components of the frame in table */
        gridLayout = gtk_table_new(11, 3, FALSE);
        gtk_table_set_col_spacings(GTK_TABLE(gridLayout), 10);
        gtk_table_set_row_spacings(GTK_TABLE(gridLayout), 10);
        
	/** first row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 3, 0, 1,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** second row */
        label_timeleft = gtk_label_new("Time Left:");
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), label_timeleft);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 0, 1, 1, 2,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_timeleft);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 1, 2, 1, 2,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        sprintf(temp_string, "%d of %d", current_question, tot_question);
        label_qno = gtk_label_new(temp_string);
        halign = gtk_alignment_new(1, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), label_qno);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 2, 3, 1, 2,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_qno);

        /** third row */
        hseparator = gtk_hseparator_new();
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 2, 3,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(hseparator);

        /** fourth row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 3, 4,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);
        //
        if (!strcmp(question_imageurl, "NO IMAGE")) {
            label_empty = gtk_label_new("");
            gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 1, 2, 3, 4,
                    GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
            gtk_widget_show(label_empty);
        } else {
            image = gtk_image_new_from_file(question_imageurl);
            gtk_table_attach(GTK_TABLE(gridLayout), image, 1, 2, 3, 4,
                    GTK_SHRINK, GTK_SHRINK, 1, 1);
            gtk_widget_show(image);
        }
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 3, 4,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** fifth row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 4, 5,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        label_question = gtk_label_new(question_statement);
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), label_question);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 4, 5,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(label_question);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 4, 5,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** sixth row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 5, 6,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        radio1 = gtk_radio_button_new_with_label_from_widget(NULL, question_optiona);
        g_signal_connect(G_OBJECT(radio1), "toggled", G_CALLBACK(check_radio), (gpointer) "A");
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), radio1);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 5, 6,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(radio1);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 5, 6,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** seventh row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 6, 7,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        radio2 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio1), question_optionb);
        g_signal_connect(G_OBJECT(radio2), "toggled", G_CALLBACK(check_radio), (gpointer) "B");
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), radio2);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 6, 7,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(radio2);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 6, 7,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** eighth row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 7, 8,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        radio3 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio1), question_optionc);
        g_signal_connect(G_OBJECT(radio3), "toggled", G_CALLBACK(check_radio), (gpointer) "C");
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), radio3);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 7, 8,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(radio3);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 7, 8,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** nineth row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 8, 9,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        radio4 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio1), question_optiond);
        g_signal_connect(G_OBJECT(radio4), "toggled", G_CALLBACK(check_radio), (gpointer) "D");
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), radio4);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 8, 9,
                GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
        gtk_widget_show(radio4);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 8, 9,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);


        /** tenth row */

        hseparator = gtk_hseparator_new();
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 9, 10,
                GTK_FILL, GTK_FILL, 1, 1);
        gtk_widget_show(hseparator);

        /** eleventh row */
        button = gtk_button_new_with_label("Quit Test");
        gtk_widget_set_size_request(button, 70, 30);
        g_signal_connect_swapped(G_OBJECT(button), "clicked",
                G_CALLBACK(delete), NULL);
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), button);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 0, 1, 10, 11,
                GTK_SHRINK, GTK_SHRINK, 1, 1);
        gtk_widget_show(button);

        gtk_widget_show(label_empty);
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 1, 2, 10, 11,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        button = gtk_button_new_with_label("Next");
        gtk_widget_set_size_request(button, 70, 30);
        g_signal_connect_swapped(G_OBJECT(button), "clicked",
                G_CALLBACK(show_questions),
                G_OBJECT(notebook));
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), button);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 2, 3, 10, 11,
                GTK_SHRINK, GTK_SHRINK, 1, 1);
        gtk_widget_show(button);



        frame = gtk_frame_new(temp_string);
        gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
        gtk_widget_set_size_request(frame, 580, 580);
        gtk_widget_show(frame);
        gtk_container_add(GTK_CONTAINER(frame), gridLayout);
        gtk_widget_show_all(gridLayout);

        label = gtk_label_new(temp_string);
        gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);

        gtk_notebook_next_page(GTK_NOTEBOOK(notebook));
        current_question++;
	if(strcmp(question_imageurl,"NO IMAGE"))
	{
	    unlink(question_imageurl);
	}
    } else if (current_question == tot_question + 1) {
        /** Arranging the components of the frame in table */
        gridLayout = gtk_table_new(6, 3, FALSE);
        gtk_table_set_col_spacings(GTK_TABLE(gridLayout), 10);
        gtk_table_set_row_spacings(GTK_TABLE(gridLayout), 10);

        /** first row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 3, 0, 1,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** second row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 1, 2,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        sprintf(temp_string, "Good Bye %s", username);
        label = gtk_label_new(temp_string);
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), label);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 1, 2,
                GTK_FILL, GTK_FILL, 0, 0);
        gtk_widget_show(label);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 1, 2,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** third row */
        hseparator = gtk_hseparator_new();
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 2, 3,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(hseparator);

        /** fourth row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 3, 4,
                GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
        gtk_widget_show(label_empty);
	if(time_flag == 0)
	{
        strcpy(temp_string, "\n\
\n\
You have completed the test\n\
\n\
Press OK button to see your Score\n\
\n\
Have a good time!!!");
	}
	else
	{
        strcpy(temp_string, "\n\
\n\
Time UP!!!\n\
\n\
Press OK button to see your Score\n\
\n\
Have a good time!!!");
	}
        label = gtk_label_new(temp_string);
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), label);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 3, 4,
                GTK_FILL, GTK_FILL | GTK_EXPAND, 1, 1);
        gtk_widget_show(label);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 3, 4,
                GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
        gtk_widget_show(label_empty);

        /** fifth row */

        hseparator = gtk_hseparator_new();
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 4, 5,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(hseparator);

        /** sixth row */
        button = gtk_button_new_with_label("OK");
        gtk_widget_set_size_request(button, 70, 30);
        g_signal_connect_swapped(G_OBJECT(button), "clicked",
                G_CALLBACK(show_questions),
                G_OBJECT(notebook));
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), button);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 0, 3, 5, 6,
                GTK_SHRINK, GTK_SHRINK, 1, 1);
        gtk_widget_show(button);



        frame = gtk_frame_new("Test Completed");
        gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
        gtk_widget_set_size_request(frame, 580, 580);
        gtk_widget_show(frame);
        gtk_container_add(GTK_CONTAINER(frame), gridLayout);
        gtk_widget_show_all(gridLayout);

        label = gtk_label_new("Test Completed");
        gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);
        ;

        gtk_notebook_next_page(GTK_NOTEBOOK(notebook));
        current_question++;
    } else {
        /** Arranging the components of the frame in table */
        gridLayout = gtk_table_new(5, 3, FALSE);
        gtk_table_set_col_spacings(GTK_TABLE(gridLayout), 10);
        gtk_table_set_row_spacings(GTK_TABLE(gridLayout), 10);

        /** first row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 3, 0, 1,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(label_empty);

        /** second row */
        hseparator = gtk_hseparator_new();
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 1, 2,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(hseparator);

        /** Third row */
        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 2, 3,
                GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
        gtk_widget_show(label_empty);

        sprintf(temp_string, "Your Score is \n\
\n\
%d\n\
\n\
Thanks for using Online Examination Portal\n\
\n\
Press Exit Button to exit\n\
\n\
Good Luck!!!", marks);
        label = gtk_label_new(temp_string);
        //gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), label);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 2, 3,
                GTK_FILL, GTK_FILL | GTK_EXPAND, 1, 1);
        gtk_widget_show(label);

        label_empty = gtk_label_new("");
        gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 2, 3,
                GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
        gtk_widget_show(label_empty);

        /** fourth row */

        hseparator = gtk_hseparator_new();
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 3, 4,
                GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
        gtk_widget_show(hseparator);

        /** fifth row */

        button = gtk_button_new_with_label("Finish");
        gtk_widget_set_size_request(button, 70, 30);
        g_signal_connect_swapped(G_OBJECT(button), "clicked",
                G_CALLBACK(delete),
                (gpointer) window);
        halign = gtk_alignment_new(0, 0, 0, 0);
        gtk_container_add(GTK_CONTAINER(halign), button);
        gtk_table_attach(GTK_TABLE(gridLayout), halign, 0, 3, 4, 5,
                GTK_SHRINK, GTK_SHRINK, 1, 1);
        gtk_widget_show(button);



        frame = gtk_frame_new("Goodbye");
        gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
        gtk_widget_set_size_request(frame, 580, 580);
        gtk_widget_show(frame);
        gtk_container_add(GTK_CONTAINER(frame), gridLayout);
        gtk_widget_show_all(gridLayout);

        label = gtk_label_new("Goodbye");
        gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);

        gtk_notebook_next_page(GTK_NOTEBOOK(notebook));
    }

    return;

}

/** welcome frame. This function adds the welcome frame to the notebook and then it is
 * displayed to the user all the test realted intructions.
 */

static void add_welcome_frame() {

    GtkWidget *label_heading;
    GtkWidget *label_empty;
    GtkWidget *button;
    GtkWidget *gridLayout;
    GtkWidget *frame;
    GtkWidget *label;
    GtkWidget *halign;
    GtkWidget *hseparator;

    char welcome_string[100];
    /* Arranging the components of the frame in table */
    gridLayout = gtk_table_new(6, 3, FALSE);
    gtk_table_set_col_spacings(GTK_TABLE(gridLayout), 10);
    gtk_table_set_row_spacings(GTK_TABLE(gridLayout), 10);

    /* first row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 3, 0, 1,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* second row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 1, 2,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    sprintf(welcome_string, "Welcome %s", username);
    label_heading = gtk_label_new(welcome_string);
    //gtk_label_set_justify(GTK_LABEL(label_heading), GTK_JUSTIFY_LEFT);
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_container_add(GTK_CONTAINER(halign), label_heading);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 1, 2,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
    gtk_widget_show(label_heading);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 1, 2,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* third row */
    hseparator = gtk_hseparator_new();
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 2, 3,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(hseparator);

    /* fourth row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 3, 4,
            GTK_FILL, GTK_FILL | GTK_EXPAND, 1, 1);
    gtk_widget_show(label_empty);

    label = gtk_label_new("Instructions\n\
\n\
1.This exam contain 10 Questions\n\
\n\
2.You can exit the test anytime using Quit Test button\n\
\n\
3.In that case your examination will be treated cancelled\n\
\n\
4.Use Next button to see next page/question\n\
\n\
5.You have 15 mins for this exam\n\
\n\
6.Maximum score is 800\n\
\n\
7.You can start the test using Start Test button\n\
\n\
Good Luck!!!");
    //gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_container_add(GTK_CONTAINER(halign), label);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 3, 4,
            GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
    gtk_widget_show(label);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 2, 3, 3, 4,
            GTK_FILL, GTK_FILL | GTK_EXPAND, 1, 1);
    gtk_widget_show(label_empty);

    /* fifth row */

    hseparator = gtk_hseparator_new();
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 0, 3, 4, 5,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(hseparator);

    /* sixth row */
    button = gtk_button_new_with_label("Quit Test");
    gtk_widget_set_size_request(button, 70, 30);
    g_signal_connect_swapped(G_OBJECT(button), "clicked",
            G_CALLBACK(delete), NULL);
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_container_add(GTK_CONTAINER(halign), button);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 0, 1, 5, 6,
            GTK_SHRINK, GTK_SHRINK, 1, 1);
    gtk_widget_show(button);

    gtk_widget_show(label_empty);
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 1, 2, 5, 6,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    button = gtk_button_new_with_label("Start Test");
    gtk_widget_set_size_request(button, 70, 30);
    g_signal_connect_swapped(G_OBJECT(button), "clicked",
            G_CALLBACK(start_test),
            G_OBJECT(notebook));
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_container_add(GTK_CONTAINER(halign), button);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 2, 3, 5, 6,
            GTK_SHRINK, GTK_SHRINK, 1, 1);
    gtk_widget_show(button);



    frame = gtk_frame_new("Welcome Page");
    gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
    gtk_widget_set_size_request(frame, 580, 580);
    gtk_widget_show(frame);
    gtk_container_add(GTK_CONTAINER(frame), gridLayout);
    gtk_widget_show_all(gridLayout);

    label = gtk_label_new("Welcome Page");
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);
}

/**
 * Verify user first sends the username and password to the server and recieves the
 * reply whether the username and passwords validates.It the authenticates the user and pass over
 * to the next screen containing welcome user message and test instruction.
 * @see add_welcome_frame()
 *
 * */

void verify_user() {
    
    if (connection_flag == 1) {
        GtkWidget *dialog;
        dialog = gtk_message_dialog_new(GTK_WINDOW(window),
                GTK_DIALOG_DESTROY_WITH_PARENT,
                GTK_MESSAGE_ERROR,
                GTK_BUTTONS_OK,
                "Network Error:Connection to the \n server could notbe established\n");
        gtk_window_set_title(GTK_WINDOW(dialog), "ERROR");
        gtk_dialog_run(GTK_DIALOG(dialog));
        gtk_widget_destroy(dialog);
        return;
    }

    strcpy(username, gtk_entry_get_text(GTK_ENTRY(entry1)));
    strcpy(password, gtk_entry_get_text(GTK_ENTRY(entry2)));
    if (!strcmp(username, "") || !strcmp(password, "")) {
        GtkWidget *dialog;
        dialog = gtk_message_dialog_new(GTK_WINDOW(window),
                GTK_DIALOG_DESTROY_WITH_PARENT,
                GTK_MESSAGE_INFO,
                GTK_BUTTONS_OK,
                "\nEnter Username and Password\n");
        gtk_window_set_title(GTK_WINDOW(dialog), "ERROR");
        gtk_dialog_run(GTK_DIALOG(dialog));
        gtk_widget_destroy(dialog);
        return;

    }


    //username
    Write(socket_file_descriptor, username, strlen(username));
    //read ack ignore
    characters_read = Read(socket_file_descriptor, input_data, BUFFER - 1);
    input_data[characters_read] = '\0';

    //password
    Write(socket_file_descriptor, password, strlen(password));
    //read ack ignore
    characters_read = Read(socket_file_descriptor, input_data, BUFFER - 1);
    input_data[characters_read] = '\0';

    //write an ack to server
    Write(socket_file_descriptor, ack, strlen(ack));

    //read login status
    characters_read = Read(socket_file_descriptor, login_status, BUFFER - 1);
    login_status[characters_read] = '\0';
    //write an ack to server
    Write(socket_file_descriptor, ack, strlen(ack));

    if (!strcmp(login_status, "DBF")) {
        GtkWidget *dialog;
        dialog = gtk_message_dialog_new(GTK_WINDOW(window),
                GTK_DIALOG_DESTROY_WITH_PARENT,
                GTK_MESSAGE_ERROR,
                GTK_BUTTONS_OK,
                "\nError in Connection with Database\n");
        gtk_window_set_title(GTK_WINDOW(dialog), "ERROR");
        gtk_dialog_run(GTK_DIALOG(dialog));
        gtk_widget_destroy(dialog);
        return;
    }
    if (!strcmp(login_status, "UPNM")) {
        GtkWidget *dialog;
        dialog = gtk_message_dialog_new(GTK_WINDOW(window),
                GTK_DIALOG_DESTROY_WITH_PARENT,
                GTK_MESSAGE_INFO,
                GTK_BUTTONS_OK,
                "\nUsername or Password is incorrect\n");
        gtk_window_set_title(GTK_WINDOW(dialog), "ERROR");
        gtk_dialog_run(GTK_DIALOG(dialog));
        gtk_widget_destroy(dialog);
        return;

    }


    //read tot_question
    characters_read = Read(socket_file_descriptor, input_data, BUFFER - 1);
    input_data[characters_read] = '\0';
    tot_question = atoi(input_data);
    //write an ack to server
    Write(socket_file_descriptor, ack, strlen(ack));

    //read tot_question
    characters_read = Read(socket_file_descriptor, input_data, BUFFER - 1);
    input_data[characters_read] = '\0';
    tot_time = atoi(input_data);
    //place this at correct place

    time_left = tot_time;
    //write an ack to server
    Write(socket_file_descriptor, ack, strlen(ack));

    current_question = 1;
    add_welcome_frame();
    gtk_notebook_next_page(GTK_NOTEBOOK(notebook));
    return;
}

/** Login Frame. Adds the login frame that is the first screen displayed to the notebook
 * and calls verify user when user clicks the submit button.
 * @see verify_user()
 */
void add_login_frame() {
    //GtkWidget *login;
    GtkWidget *label_heading;
    GtkWidget *label_empty;
    GtkWidget *label_username;
    GtkWidget *label_password;
    //GtkWidget *box;
    GtkWidget *button;
    GtkWidget *gridLayout;
    GtkWidget *frame;
    GtkWidget *label;
    GtkWidget *halign;
    GtkWidget *hseparator;

    /* Arranging the components of the frame in table */
    gridLayout = gtk_table_new(8, 4, FALSE);
    gtk_table_set_col_spacings(GTK_TABLE(gridLayout), 10);
    gtk_table_set_row_spacings(GTK_TABLE(gridLayout), 7);

    /* first row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 4, 0, 1,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* second row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 1, 2,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    label_heading = gtk_label_new("ONLINE EXAMINATION PORTAL");
    halign = gtk_alignment_new(.5, .5, .5, .5);
    gtk_container_add(GTK_CONTAINER(halign), label_heading);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 3, 1, 2,
            GTK_FILL, GTK_FILL, 0, 0);
    gtk_widget_show(label_heading);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 3, 4, 1, 2,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* third row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 2, 3,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    hseparator = gtk_hseparator_new();
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 1, 3, 2, 3,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(hseparator);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 3, 4, 2, 3,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* fourth row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 3, 4,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    label_username = gtk_label_new("Username :");
    halign = gtk_alignment_new(1, .5, 0, .5);
    gtk_container_add(GTK_CONTAINER(halign), label_username);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 3, 4,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(label_username);

    entry1 = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(entry1), 80);
    halign = gtk_alignment_new(0, .5, 0, .5);
    gtk_container_add(GTK_CONTAINER(halign), entry1);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 2, 3, 3, 4,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(entry1);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 3, 4, 3, 4,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* fifth row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 4, 5,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    label_password = gtk_label_new("Password  :");
    halign = gtk_alignment_new(1, .5, 0, .5);
    gtk_container_add(GTK_CONTAINER(halign), label_password);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 1, 2, 4, 5,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(label_password);

    entry2 = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(entry2), 80);
    gtk_entry_set_visibility(GTK_ENTRY(entry2), FALSE);
    halign = gtk_alignment_new(0, .5, 0, .5);
    gtk_container_add(GTK_CONTAINER(halign), entry2);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 2, 3, 4, 5,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(entry2);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 3, 4, 4, 5,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* sixth row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 1, 5, 6,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    hseparator = gtk_hseparator_new();
    halign = gtk_alignment_new(0, 0, 0, 0);
    gtk_table_attach(GTK_TABLE(gridLayout), hseparator, 1, 3, 5, 6,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(hseparator);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 3, 4, 5, 6,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);


    /* seventh row */
    gtk_widget_show(label_empty);
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 2, 6, 7,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    button = gtk_button_new_with_label("Sign In");
    gtk_widget_set_size_request(button, 70, 30);
    g_signal_connect_swapped(G_OBJECT(button), "clicked",
            G_CALLBACK(verify_user),
            (gpointer) notebook);
    halign = gtk_alignment_new(0, .5, 0, .5);
    gtk_container_add(GTK_CONTAINER(halign), button);
    gtk_table_attach(GTK_TABLE(gridLayout), halign, 2, 3, 6, 7,
            GTK_FILL, GTK_FILL, 1, 1);
    gtk_widget_show(button);

    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 3, 4, 6, 7,
            GTK_FILL | GTK_EXPAND, GTK_FILL, 1, 1);
    gtk_widget_show(label_empty);

    /* last row */
    label_empty = gtk_label_new("");
    gtk_table_attach(GTK_TABLE(gridLayout), label_empty, 0, 4, 7, 8,
            GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
    gtk_widget_show(label_empty);

    frame = gtk_frame_new("Login Page");
    gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
    gtk_widget_set_size_request(frame, 580, 580);
    gtk_widget_show(frame);
    gtk_container_add(GTK_CONTAINER(frame), gridLayout);
    gtk_widget_show_all(gridLayout);


    label = gtk_label_new("Login Page");
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);
}

/**
 * Main function declares all variables and performs connection with the server
 * and socket file descriptor is set.
 * @param   argc    command line arguments length
 * @param   argv    command line arguments.
 * @return returns Zero on success.
 */
int main(int argc, char *argv[]) {


    int connection_file_descriptor;
    struct sockaddr_in server_address;

    GtkWidget *table;

    //Connection to server

    connection_flag = 0;
    strcpy(ack, "ACK");
    //try to open socket
    socket_file_descriptor = Socket(AF_INET, SOCK_STREAM, 0);

    //if socket opening failed then print error message and quit
    if (socket_file_descriptor < 0) {
        fprintf(stderr, "cannot open socket.\n");
        connection_flag = 1;
    }

    //initialize struct server_address to all zeros.
    bzero(&server_address, sizeof (server_address));

    //set the protocol used to be ipv4
    server_address.sin_family = AF_INET;

    server_address.sin_port = htons(PORT_NUMBER);

    if (inet_pton(AF_INET, SERVER_ADDRESS, &server_address.sin_addr) <= 0) {
        fprintf(stderr, ": the supplied ipv4 address  is incorrect.\n");
        connection_flag = 1;
    }

    if ((connection_file_descriptor = connect(socket_file_descriptor, (struct sockaddr *) & server_address, sizeof (server_address))) < 0) {
        fprintf(stderr, ": cannot connect to server \n");
        connection_flag = 1;
    }


    //GTK part
    gtk_init(&argc, &argv);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    g_signal_connect(G_OBJECT(window), "delete_event",
            G_CALLBACK(delete), NULL);

    gtk_window_set_title(GTK_WINDOW(window), "Examination Portal");
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_widget_set_size_request(window, 900, 600);
    //gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
    gtk_container_set_border_width(GTK_CONTAINER(window), 10);


    table = gtk_table_new(2, 2, FALSE);
    gtk_table_set_col_spacings(GTK_TABLE(table), 3);
    gtk_table_set_row_spacings(GTK_TABLE(table), 3);
    gtk_container_add(GTK_CONTAINER(window), table);

    /* Create a new notebook */
    notebook = gtk_notebook_new();
    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
    gtk_table_attach(GTK_TABLE(table), notebook, 0, 2, 0, 2,
            GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 1, 1);
    gtk_widget_show(notebook);
    add_login_frame();

    /* Set what page to start at page that is login page */
    gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 1);
    gtk_widget_show(table);
    gtk_widget_show(window);

    gtk_main();

    close(socket_file_descriptor);

    return 0;
}