#include <unistd.h>	//for close(), write(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(),
#include <string.h>	//for strlen(),
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t,
#include <signal.h>	//for sigaction(),
#include <poll.h>
#include <sys/wait.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <mysql/mysql.h>


#define BUFFER 4096

int sfd;
int re;
int khj=0;

void close_properly(int signal)
{
	int return_value;    
	printf("Shutting down...\n");    
	return_value =close(sfd);

    	if(return_value <0)
    	{
		perror("Cannot close listening socket.");
		exit(1);
    	}
    	printf("Shutdown complete.\n");
    	exit(0);
}

GtkWidget *get_msg;
GtkWidget *text_view;

void onExit(GtkWidget *window, gpointer data)
{
    	gtk_main_quit();
}

void add_widget_with_label(GtkContainer *box, gchar *caption, GtkWidget *widget)
{
    	GtkWidget *label = gtk_label_new(caption);
    	GtkWidget *hbox = gtk_hbox_new(TRUE, 4);

    	gtk_container_add(GTK_CONTAINER (hbox), label);
    	gtk_container_add(GTK_CONTAINER (hbox), widget);
   	gtk_container_add(box, hbox);
}

void send_message(GtkWidget *button, gpointer data)
{
	const char *msg=gtk_entry_get_text(GTK_ENTRY(get_msg));		
	char msg1[1000];
	strcpy(msg1,msg);
	GtkTextBuffer *buffer;
	//This is to set the text in the text box
	//gtk_entry_set_text(GTK_ENTRY(set_msg), msg1);
	int temp=0;char buff[BUFFER];
	re= write(sfd,msg1,strlen(msg1));	

	if(re<0)
	{
		printf("Written Failed\n");
		exit(1);
	}
	//printf("Writing finished \n");
	strcpy(buff,"");
	buff[0]='\0';				
	temp = read(sfd, buff, BUFFER-1);
	buff[temp]='\0';
		
	if(temp >0)
	{
		strcat(buff,msg1);
		strcat(buff,"\n");			
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
		gtk_text_buffer_set_text (buffer,"", -1);  
		gtk_text_buffer_set_text(buffer,buff,temp);
database_mysql(buffer);
	}			
			
}

 void database_mysql(GtkTextBuffer *buffer)
{
MYSQL *connection1;
    	int result;

char sql_query[BUFFER];

	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
		printf ("Connection successful\n");
		GtkTextBuffer *buffer;
		gchar *ch;   
		buffer=gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
		GtkTextIter start;
		GtkTextIter end;
		gtk_text_buffer_get_start_iter (buffer, &start);
		gtk_text_buffer_get_end_iter (buffer, &end);
		ch = gtk_text_buffer_get_text (buffer, &start, &end, FALSE);
		char *mm;
		mm=(char *)ch;
		sprintf(sql_query,"INSERT INTO messenger VALUES ('%s')",mm);
		//sprintf(sql_query,"INSERT INTO messenger (id,msg) VALUES ('%s','%s')",a);

		result = mysql_query (connection1, sql_query);
		if (result==0)
		{
	    		printf ("Row inserted successfully.\n");
		}
		else
		{
	    		fprintf (stderr, "Could not insert data as %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
	    		mysql_close (connection1);
	    		exit(EXIT_FAILURE);
		}
		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
			fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
    	}
    	//exit(EXIT_SUCCESS);
    	//return 0;
//close(sfd);
//	printf("\n");

}



int main(int argc, char *argv[])
{
	
	
	int re,temp;
	struct sockaddr_in address;
	char buff[BUFFER];
	//int cfd;

	sfd= socket(AF_INET, SOCK_STREAM, 0);
	if(sfd<0)
	{
		printf("Cannot Open Socket\n");
		exit(1);
	}

	bzero(&address,sizeof(address));
	address.sin_family=AF_INET;
	address.sin_port=htons(atoi(argv[2]));
	temp=inet_pton(AF_INET,argv[1],&address.sin_addr);

	if(temp<0)
	{
		printf("Supplied Address Is Incorrect\n");
		exit(1);
	}
	temp=connect(sfd,(struct sockaddr *)&address,sizeof(address));
	
	if(temp<0)
	{
		printf("Connection Failed\n");
		exit(1);
	}
	
	GtkWidget *window;
	GtkWidget *send;
	GtkWidget *vbox;
	GtkWidget *save;

	gtk_init(&argc, &argv);
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_resizable(GTK_WINDOW(window),TRUE);
	gtk_window_set_default_size(GTK_WINDOW(window), 300, 200);
	g_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(onExit), NULL);
	
	vbox = gtk_vbox_new(TRUE, 5);
	get_msg = gtk_entry_new();
	text_view = gtk_text_view_new ();
	gtk_box_pack_start (GTK_BOX (vbox), text_view, 3, 3, 0);
	
	send = gtk_button_new_with_label("Send");
	add_widget_with_label(GTK_CONTAINER(vbox), "Sender : ", get_msg);
	gtk_box_pack_start(GTK_BOX(vbox), send, TRUE, FALSE, 5);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	//gtk_entry_set_editable(GTK_ENTRY(set_msg), FALSE);
	g_signal_connect(GTK_OBJECT(send), "clicked", GTK_SIGNAL_FUNC(send_message), NULL);
	
	//to save in the db
	///save = gtk_button_new_with_label("Save");
	//gtk_container_add(GTK_CONTAINER(window), vbox);
	///g_signal_connect(GTK_OBJECT(send), "clicked", GTK_SIGNAL_FUNC(send_message), text_view);
	///gtk_box_pack_start (GTK_BOX (vbox), save, 3, 3, 0);

	//add_widget_with_label(GTK_CONTAINER(vbox), "Sender : ", get_msg);
	//g_signal_connect(GTK_OBJECT(send), "clicked", GTK_SIGNAL_FUNC(send_message), NULL);

	gtk_widget_show_all(window);
	gtk_main();

	//MYSQL *connection1;
    	//int result;
	//char cmd;	
close(sfd);
	printf("\n");	

	

    return 0;
}

