#include <unistd.h>	//for close(), write(), read(), fstat(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(), atoi(),
#include <string.h>	//for strlen(),strcpy()
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(), fstat(), open()
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 
#include <sys/stat.h>	//for fstat(), open()
#include <fcntl.h>	//for open(),

#define BUFFER 4096

int listen_file_descriptor;
char filename[100]="index.html";

void Close(int fd)
{
    int return_value;
    return_value=close(fd);
    if(return_value<0)
    {
	fprintf(stderr, "Cannot close\n");
	perror("REASON");
	exit(1);
    }
}


void close_properly(int signal)
{
    printf("Shutting down...\n");
    Close(listen_file_descriptor);
    printf("Shutdown complete.\n");
    exit(0);
}


ssize_t Write(int fd, const void *buf, size_t count)
{
    ssize_t return_value;
    return_value=write(fd,buf,count);
    if(return_value < 0)
    {
	perror("Write failed\n");
	exit(1);
    }
    return return_value;
}


int Socket(int domain, int type, int protocol)
{
    int return_value;
    return_value = socket(domain, type, protocol);
    if(return_value < 0)
    {
	fprintf(stderr, "Cannot open socket.\n");
	perror("REASON");
	exit(1);
    }
    return return_value;
}


void check_argument(int argc, char *argv[])
{
    if(argc < 2)
    {
	fprintf(stderr, "usage: %s <port_number> [file_name]\n", argv[0]);
	exit(1);
    }
    if(argc==3)
    {
	strncpy(filename, argv[2], 99);
	filename[99]='\0';
    }
}


void Bind(int  sockfd,  const  struct  sockaddr *my_addr, socklen_t addrlen)
{
    int return_value;
    return_value= bind(sockfd,my_addr,addrlen);
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(1);
    }
}


void Listen(int sockfd, int backlog)
{
    int return_value;
    return_value = listen(sockfd, backlog);
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(1);
    }
}


int Open(const char *pathname, int flags)
{
    int file_descriptor;
    file_descriptor=open(pathname,flags);
    if(file_descriptor < 0)
    {
	fprintf(stderr, "Cannot open file\n");
	perror("REASON");
	exit(1);
    }
    return file_descriptor;
}
   

void Fstat(int filedes, struct stat *buf)
{
    int return_value;
    return_value = fstat(filedes,buf);
    if(return_value == -1)
    {
	fprintf(stderr, "Cannot read file status\n");
	perror("REASON");
	exit(1);
    }
}


int Accept(int sockfd, struct sockaddr *addr, socklen_t *addrlen)
{
    int file_descriptor;
    file_descriptor = accept(sockfd, addr, addrlen);
    if(file_descriptor < 0)
    {
	perror("accept() failed.");
	exit(1);
    }
    return file_descriptor;
}


ssize_t Read(int fd, void *buf, size_t count)
{
    ssize_t characters_read;
    characters_read = read(fd, buf, count);
    if(characters_read < 0)
    {
	perror("Can't read");
	exit(1);
    }
    return characters_read;
}


int main(int argc, char *argv[])
{
    int connection_file_descriptor; 
    char temp_line[BUFFER];
    char temp_char1, temp_char2;
    struct sockaddr_in server_address;
    struct sigaction act1;
    int characters_read;
    struct stat file_status;
    int data_file_descriptor;

    check_argument(argc,argv);

    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;
    sigaction(SIGINT, &act1, 0);
    
    listen_file_descriptor = Socket(AF_INET, SOCK_STREAM, 0);
    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    server_address.sin_port = htons(atoi(argv[1]));
    Bind(listen_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address));
    Listen(listen_file_descriptor, 5);
    
    while(1)
    {
	data_file_descriptor = Open(filename, O_RDONLY);
	Fstat(data_file_descriptor, &file_status);
	connection_file_descriptor = Accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);

	characters_read = Read(connection_file_descriptor, &temp_char1, 1);
	while(characters_read > 0)
	{
	    //printf("%c",temp_char1);
	    characters_read = Read(connection_file_descriptor, &temp_char2, 1);
	    if(temp_char2=='\n' && temp_char1=='\r')
	    {
	        temp_char1=temp_char2;
		//printf("%c",temp_char1);
		characters_read = Read(connection_file_descriptor, &temp_char2, 1);
		if(temp_char2=='\r')
		{
		    printf("Received request\n");
		    printf("Sending HTTP response\n");
		    break;
		}
	    }
	    temp_char1=temp_char2;
	}

	strcpy(temp_line, "HTTP/1.1 200 OK\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Server: Barjatiya\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Last-Modified: Fri, 29 Sep 2006 10:40:55 GMT\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Accept-Ranges: bytes\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	sprintf(temp_line, "Content-Length: %d\n", (int)file_status.st_size);
	Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Content-Type: text/html\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));

	printf("Sending file\n");
	
	characters_read = Read(data_file_descriptor, temp_line, BUFFER -1);
	while(characters_read > 0)
	{
	    Write(connection_file_descriptor, temp_line, characters_read);
	    characters_read = Read(data_file_descriptor, temp_line, BUFFER -1);
	}

	Close(data_file_descriptor);
	printf("File send complete\n");
	Close(connection_file_descriptor);
	printf("Connection closed\n\n");
    }
        
    return 0;
}

