#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#define REMOTE_SERVER_PORT 9999
#define MAX_MSG 512

int main (int argc, char *argv[])
{
    int socket_descriptor, return_value, counter1;
    struct sockaddr_in client_address, server_address;

    if (argc < 3)
    {
	printf ("usage : %s <server> <data1> ... <dataN> \n", argv[0]);
	exit (1);
    }

    server_address.sin_family = AF_INET;
    if(inet_pton(AF_INET, argv[1], &server_address.sin_addr) <= 0)
    {
	fprintf(stderr, "%s: The supplied IPv4 address %s is incorrect.\n", argv[0], argv[1]);
	exit(EXIT_FAILURE);
    }
    server_address.sin_port = htons (REMOTE_SERVER_PORT);

    socket_descriptor = socket (AF_INET, SOCK_DGRAM, 0);
    if (socket_descriptor < 0)
    {
	printf ("%s: cannot open socket \n", argv[0]);
	exit (EXIT_FAILURE);
    }

    /* bind any port */
    client_address.sin_family = AF_INET;
    client_address.sin_addr.s_addr = htonl (INADDR_ANY);
    client_address.sin_port = htons (0);

    return_value = bind (socket_descriptor, (struct sockaddr *) &client_address, sizeof (client_address));
    if (return_value < 0)
    {
	printf ("%s: cannot bind port\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    for (counter1=2;  counter1<argc; counter1++)
    {
	return_value = sendto (socket_descriptor, argv[counter1], strlen (argv[counter1]) + 1, 0,
		     (struct sockaddr *) &server_address,
		     sizeof (server_address));
	if (return_value < 0)
	{
	    printf ("%s: cannot send data %d \n", argv[0], counter1-1);
	    close (socket_descriptor);
	    exit (EXIT_FAILURE);
	}
    }
    
    close(socket_descriptor);
    exit(EXIT_SUCCESS);
    return 0;
}

