#!/bin/bash

DATABASE=01-records.sqlite

function initialize_database()
{
	rm -f "$DATABASE"
	sqlite3 $DATABASE <<"InitializeDatabaseEOF" >/dev/null
	CREATE TABLE records(ID, Name, Email);
	.quit

InitializeDatabaseEOF
}


function display_menu()
{
	cat <<"RecordsMenuEOF"
	Welcome to record program.

	Please choose one of the below options:
	1. Add record
	2. List all records
	3. Delete record by complete ID, name or email
	4. Search record by complete ID, name or email
	5. Edit record by ID
	6. Search record by part of name / email ignoring case
	7. Save records to file
	8. Read records from file
	9. Exit

RecordsMenuEOF
}


function take_user_choice
{
	local user_choice;

	display_menu
	echo -n "Please enter your choice (1/9): "
	read user_choice
	
	case "$user_choice" in
		[1-9] ) ;;
		*)
			echo "Your choice $user_choice is not valid. Please enter number between 1 and 9"
			echo
			take_user_choice
			;;

	esac
	return $user_choice;
}



function insert_record()
{
	echo -n "Enter ID : "
	read id1
	echo -n "Enter name : "
	read name1
	echo -n "Enter email address : "
	read email1

	sqlite3 $DATABASE <<insertrecordEOF 
	INSERT INTO records VALUES('$id1','$name1','$email1');
insertrecordEOF

	echo
	echo "Record $id1, $name1, $email1 entered successfully.";	
	echo
	echo
	
}


function display_all_records
{
	sqlite3 -header -column $DATABASE <<displayallrecordsEOF 
	SELECT * from records;
displayallrecordsEOF
	echo
	echo
}


function perform_user_choice()
{
	case "$1" in 
		1)
			insert_record
			;;

		2)
			display_all_records
			;;


		9) 
			exit 0
			;;

		*) 
			echo "The given choice $1 is not yet implemented."
			;;
	esac
}



function main()
{
	local user_choice;

	
	initialize_database
	while :
	do
		take_user_choice
		user_choice=$?
		perform_user_choice $user_choice
	done

}


main

exit 0

