<?php
/** This page is to provide information about documentation available
	for PHP language. This also explains how to document code so that
	it can be processed by doxygen or similar tools for automated
	documentation generation.

	@file 02-documentation/index.php
	@version 1.0
	@author Saurabh Barjatiya
*/



/** This function is used to display documentation page which has links
	to PHP online documentation in English language

	@returns Nothing
*/
function display_documentation_page()
{
	?>
		<html>
		<head>
			<title>PHP documentation</title>
			<style type="text/css">
				p {text-align:justify}
			</style>
		</head>
		<body>
			<h3>PHP documentation</h3>

			<p>
				There are two seemingly unrelated purposes of this example.
				First is to provide links to PHP documentation so that
				students can refer to it while writing code. 
			</p>

			<p>
				PHP being open source and collaboratively developed, is very
				well documented. This is necessary for so many people to work
				together. To add to this PHP documentation supports comments
				where users post very useful code snippets related to function
				whose documentation is being discussed. Thus documentation not
				only includes description of function, but also several examples
				where the function has been used to achieve good results. Thus making
				PHP online documentation indepensible resource while using PHP.
				If Internet connection is a problem then various downloadable versions
				of documentation are also avaiable.
			</p>

			<h4>Important documentation links:</h4>
			<ul>
				<li><a href="http://www.php.net/manual/en/" target="_blank">PHP manual english</a></li>
				<li><a href="http://www.php.net/manual/en/indexes.php" target="_blank">Function index (My favorite)</a></li>
				<li><a href="http://www.php.net/docs.php" target="_blank">Top level documentation page</a></li>
			</ul>
	
	
			<h3>Doxygen</h3>
			<p>
				Other purpose of this page is to explain about doxygen and automated documentation.
				There are two types of comments supported by PHP:
			</p>
			<ol>
				<li>Single line comments starting with //</li>
				<li>Multiple line comments enclosed in /* */</li>
			</ol>

			<p>
				This is same as many other languages like C, Java etc. For purpose of documentation
				a third type of comment can be used in all these languages, called documentation
				comments. Documentation comments start with /** and end with */. Hence as far as
				compilers or interpreters are concerned there is no difference between documentation
				comments and multi-line comments and hence they simply ignore it. These comments are
				used by tools like doxygen, javadoc etc. which generate documentation in various
				formats with help of these comments.
			</p>

			<p>
				Use '<tt>doxygen -g</tt>' to generate a doxygen configuration file. The file is huge
				and heavily commented. Modify following parameters in configuration file with appropriate 
				values:
			</p>
			<dl>
				<dt>PROJECT_NAME : </dt>
				<dd>
					Fill in some proper project name like "PHP example documentation" (with quotes)
				</dd>


				<dt>PROJECT_NUMBER : </dt>
				<dd>
					Any number like 1.0 is fine. This would be useful if version control systems like
					subversion, git, cvs, etc. are used. We will try to cover subversion in this course
					later on, based on available time.
				</dd>


				<dt>OUTPUT_DIRECTORY : </dt>
				<dd>
					Keep output directory outside the top-level source code directory. Path of output
					directory can be relative so that you can specify something like ../documentation
					to generate documentation in another sub-folder of parent folder.
				</dd>


				<dt>ALWAYS_DETAILED_SEC : </dt>
				<dd>
					Set to YES
				</dd>
	

				<dt>FULL_PATH_NAMES : </dt>
				<dd>
					Set to NO
				</dd>

				
				<dt>JAVADOC_AUTOBRIEF : </dt>
				<dd>
					Set to YES
				</dd>

				
				<dt>TAB_SIZE : </dt>
				<dd>
					Set to 4
				</dd>


				<dt>EXTRACT_ALL : </dt>
				<dd>
					Set to YES
				</dd>


				<dt>EXTRACT_STATIC : </dt>
				<dd>
					Set to YES
				</dd>


				<dt>SORT_BRIEF_DOCS :</dt>
				<dd>
					Set to YES
				</dd>


				<dt>WARN_NO_PARAMDOC :</dt>
				<dd>
					Set to YES
				</dd>


				<dt>INPUT : </dt>
				<dd>
						Specify parent folder in which all code files are present. If Doxygen config
						file is present in parent code folder then you can specify INPUT as '.', that
						is current folder. When using Doxygen in this manner the OUPUT should be
						something like '../documentation' so that documentation itself does not gets
 						processed by Doxygen.

					<span style="font-weight:bold">
						If you are new to Doxygen then take backup of code folder before trying to use
						Doxygen until you are comfortable with it.
					</span>
				</dd>


				<dt>FILE_PATTERNS :</dt>
				<dd>
					Set to *.php
				</dd>


				<dt>RECURSIVE : </dt>
				<dd>
					Set to YES
				</dd>
				

				<dt>SOURCE_BROWSER : </dt>
				<dd>
					Set to YES
				</dd>

				
				<dt>INLINE_SOURCES : </dt>
				<dd>
					Set to NO
				</dd>


				<dt>ALPHABETICAL_INDEX : </dt>
				<dd>
					Set to YES
				</dd>
	
				<dt>GENERATE_LATEX : </dt>
				<dd>
					Set to NO
				</dd>
			</dl>


			<p>
				After configuring doxygen running it from same folder using '<tt>doxygen</tt>' command.
				Browse through generated documentation. 
			</p>
		</body>
		</html>

	<?php
}


display_documentation_page();


?>


