<?php
/** This program displays information about php.net configuration file.

	@author Saurabh Barjatiya
	@file 04-php.net/index.php
	@version 1.0
*/


/** This function displays information about php[dot]net configuration file.
	@returns Nothing
*/
function show_php_net_page()
{
	?>
		<html>
			<head>
				<title>php.net configuration file</title>
				<style type="text/css">
					p {text-align:justify}
				</style>
			</head>
			<body>
				<h3>php.net configuration file</h3>
				<p>
					Location of php.net file can be found using phpinfo() function.
					It is important to verify that we are modifying correct php.net
					file as there can be multiple php.net files due to improper 
					installations or due to multiple parallel versions of PHP etc.
				</p>


				<p>	
					Following variables are of considerable interest:
				</p>
				<dl>
					<dt>short_open_tag</dt>
					<dd>
						Historically PHP start tag was &lt;? instead of &lt;?php. But it
						was soon realized that &lt;? starting tag would cause confusion / 
						problems and hence &lt;?php was introduced as new PHP start tag.
						But since there is enough legacy code already present, the new
						PHP engines support both &lt;? and &lt;?php tags for starting PHP.
						Using this option we can stop support for old start tag (&lt;?).
						If you are not going to use any old code then it can be set to Off
					</dd>
			

					<dt>output_buffering</dt>
					<dd>
						This parameter had to be introduced to resolve too many problems which
						novice programmers where facing while using header() function. It is
						important to understand why this was required and what it does.
						(Details will be explained in class).
					</dd>

					
					<dt>zlib.output_compression</dt>
					<dd>
						This option saves considerable bandwidth but is security nightmare. It is
						important to understand why. (Details will be explained in class).
					</dd>


					<dt>max_execution_time</dt>
					<dd>
						Maximum execution time of each script, in seconds. Increase to at least 150
						if you are going to use PHP from command line very often or if you do complex
						calculations / long database manipulations using PHP. You can also optionally
						use a differnet php.ini file when using PHP from command line using 
						'<tt>--php-ini</tt>' option.
					</dd>


					<dt>max_input_time</dt>
					<dd>
						 Maximum amount of time each script may spend parsing request data. Again this
						 can be made equal to max_execution_time when using command line.
					</dd>


					<dt>memory_limit</dt>
					<dd>
						Maximum amount of memory a script may consume. Increase it with caution. If you
						face memory errors too often and you have enough free RAM and less number of 
						parallel users then this can be increased.
					</dd>


					<dt>error_reporting</dt>
					<dd>
						This is used to set what type of errors to report. Once can use E_ALL in most
						setups.
					</dd>


					<dt>display_errors</dt>
					<dd>
						<span style="font-weight:bold">Should be 'On' during development, should be 'Off' during
						production</span>. This whole php.net configuration file page is created just to explain
						proper configuration for this parameter. 
					</dd>


					<dt>display_startup_errors</dt>
					<dd>
						Can be left On during development. Carefully choose based on application / scenario whether
						to be left On or Off during production.
					</dd>


					<dt>log_errors</dt>
					<dd>
						If display_errors is Off then this must be set to On, else debugging would be nightmare.
					</dd>


					<dt>variables_order</dt>
					<dd>
						Interesting to know. (Details explained in class)
					</dd>


					<dt>register_globals</dt>
					<dd>
						Never turn this On. Habit of using this feature is 
						<span style="font-weight:bold">extremely</span> bad idea.
						(Details explained in class)
					</dd>

					<dt>post_max_size</dt>
					<dd>
						This must be increased if your PHP page is going to handle upload
						of bigger files. For servers that are going to handle file uploads
						of files about 50MB in size this can be set to 64MB or so.
					</dd>

					<dt>upload_max_filesize</dt>
					<dd>
						Maximum allowed size for uploaded files. Set to 50MB if you want to
						handle file uploads of up to 50MB in size.
					</dd>
				</dl>

				<p>
					Students are encouraged to look at other parameters defined in php.net file
					and read about them. The case of sessions and how they work should be 
					interesting.
				</p>
			</body>
		</html>
	<?php
}

show_php_net_page();

?>
