<?php
/** This page shows welcome message to logged in user. If user is not
	logged in this page redirects to 'index.php' page. If user is logged
	in, it also shows link to logout page.

	@author Saurabh Barjatiya
	@version 1.0
	@file 13-post_variables/welcome.php
*/


//When using sessions we must start session as early in program
//as possible, preferably first line.
session_start();

/** This is used to store username of user who logged in to keep
	track of logged in user */
session_register('logged_in');


//including file which has common functions like redirect
//and get_session which will be reused in many scripts
require('common_functions.php');



/** This function displays welcome page to user with link for
	logout.php page to logout.

	@returns Nothing
*/
function show_welcome_page()
{
	?>
		<html>
			<head>
				<title>Welcome Page<title>
			</head>
			<body>
				<h3>Welcome <?php echo htmlspecialchars(get_session('logged_in')); ?></h3>
				<br/>
				<br/>
				Click<a href="logout.php">here</a> to logout
			</body>
		</html>
	<?php
}


/** This is where program execution starts. This function will check with
	session variables if user is logged in or not. If user is logged in
	welcome message along with link for logout page is displayed. If user
	is not logged in then he/she is redirected to index.php page.
	
	@returns Nothing
*/
function main()
{
	//Check for logged in user.
	$username1=get_session('logged_in');
	if($username1=="")
	{
		//If no one is logged in then redirect to index.php page
		redirect('index.php');
	}
	else
	{
		//If some user is logged in show welcome page.
		show_welcome_page();
	}
}


main();

?>
