<?php
/** This program is used to demonstrate use of SERVER variables provided
	by apache to PHP interpreter. We can use these variables to get
	information about current client or server.

	@author Saurabh Barjatiya
	@version 1.0
	@file 15-server_variables/index.php
*/

/** This array is used to store list of server variables to be displayed. */
$server_variables=array(
		'HTTP_HOST',
		'HTTP_USER_AGENT',
		'HTTP_ACCEPT_ENCODING',
		'HTTP_CONNECTION',
		'HTTP_REFERER',
		'HTTP_COOKIE',
		'SERVER_SIGNATURE',
		'DOCUMENT_ROOT',
		'REMOTE_ADDR',
		'REMOTE_PORT',
		'SCRIPT_FILENAME',
		'REQUEST_URI',
		'SCRIPT_NAME'
	);


/** This function looks for given variable in server variables. If variable
	if found its value is returned else empty string "" is returned.

	@param 	var1	Variable to be looked in SERVER variables array.
	@returns	Value of given variable from $_SERVER array or empty string
*/
function get_server($var1)
{
	if(isset($_SERVER[$var1]))
		return $_SERVER[$var1];
	else
		return "";
}

/** This function displays HTML page with values of various server variables
	to demonstrate information about client / server that is available to
	PHP interpreter

	@returns Nothing.
*/
function show_server_page()
{
	global $server_variables;
	?>
		<html>
			<head>
				<title>Server variables<title>
			</head>
			<body>
				Various server variables and there values are:
				<ul>
					<?php 
						$limit=count($server_variables);
						for($counter1=0; $counter1<$limit; $counter1++)
							print_variable($server_variables[$counter1]);
					?>
				</ul>
				For other variables one can refer to phpinfo.php ( phpinfo() ) output.
			</body>
		</html>
	<?php
}

/** This function echoes or prints list items for given server variable. This
	make generation of list very easy.

	@param 	var1	Name of server variable for which list item should be echoed.
	@returns Nothing
*/
function print_variable($var1)
{
	echo '<li><span style="font-weight:bold">' . $var1 . ': </span>' . get_server($var1) . "</li>\n";
}

show_server_page();

?>
