<?php
/** This file is not intended to be run / executed directly from browser. This
	file contains definitions of functions which can be used in many different
	pages.

	@author Saurabh Barjatiya
	@file 17-mysql_database/common_functions.php
	@version 1.0
*/

/** This variable is used for storing verification code being displayed
	in captcha image. */
session_register('verification_code');


// This file is used to define various parameters like database name, etc.
// which are used by address book for its operations 
require_once('parameters.php');


/** Following function is used to get server variables. If it does not exist 
  *  then it returns empty string. But no warning or error is generated. 
  * @param $variable Name of the variable to be retrieved. It must be
  *               passed as string.
  * @returns Value of SERVER variable with given name. It returns blank if
  *                no variable with given name was submitted.
  *
  */
function get_server($variable)
{
	if(isset($_SERVER[$variable]))
		return $_SERVER[$variable];
	else
		return "";
}


/** It is used to find proper i.p. address of client. It returns
  * proper i.p. address even if the client is connected through proxy
  * server.
  */
function get_remote_address()
{
	$remote_address = get_server('REMOTE_ADDR');
	
	if($remote_address == "10.4.8.204" || $remote_address == "10.4.8.230")
		$remote_address = get_server('HTTP_X_FORWARDED_FOR');
		
	return $remote_address;
}


/** Following function is used to get session variable.
  * If it does not exist then it returns empty string. But no warning 
  * or error is generated. 
  * @param $variable Name of the variable to be retrieved. It must be 
  *                passed as string.
  * @returns Value of session variable of given name. If no such variable 
  *                 exists, it returns blank.
  *
  */
function get_session($variable)
{
	if(isset($_SESSION[$variable]))
		return $_SESSION[$variable];
	else
		return "";
}


/** Following function is used to get post variable. If it does not exist 
  *  then it returns empty string. But no warning or error is generated. 
  * @param $variable Name of the variable to be retrieved. It must be
  *               passed as string.
  * @returns Value of POST variable with given name. It returns blank if
  *                no variable with given name was submitted.
  *
  */
function get_post($variable)
{
	if(isset($_POST[$variable]))
		return $_POST[$variable];
	else
		return "";
}


/** It is used to create random image. It stores the random number 
   * displayed in image in session variable 'verification_code'. It 
   * generates image named IMAGE_FILENAME. Web server must have write permissions 
   * on folder where image is to be created for this to work.
   * Also php-gd package must be installed for the image manipulation 
   * functions to work. This function uses constants IMAGE_MINIMUM_NUMBER,
   * IMAGE_MAXIMUM_NUMBER, IMAGE_CUTS, IMAGE_FONT_SIZE, IMAGE_SPACING, 
   * IMAGE_NUMBER_OF_CHARS, IMAGE_FILENAME, etc. for its operations. 
   *
   */
function create_random_image()
{
	//Generate random number to be displayed on image
	$random_number = mt_rand(IMAGE_MINIMUM_NUMBER, IMAGE_MAXIMUM_NUMBER);

	//save number as session variable, so that it can be verified
	$_SESSION['verification_code']=$random_number;
	
	//Calculate width and height of image based on font size, number of
	//characters to be displayed and spacing
	$random_image_width = (imagefontwidth(IMAGE_FONT_SIZE) * IMAGE_NUMBER_OF_CHARS) + (IMAGE_SPACING * 2);
	$random_image_height = imagefontheight(IMAGE_FONT_SIZE) + (IMAGE_SPACING * 2);
	
	//Create image and set appropriate background color
	$random_image = imagecreate($random_image_width, $random_image_height);
	$background = imagecolorallocate($random_image, IMAGE_BACKGROUND_RED, IMAGE_BACKGROUND_GREEN, IMAGE_BACKGROUND_BLUE);

	//Create color for foreground digits and cuts
	//Using same color for both digits and cuts so that they cannot be separated
	//based on color, as that would defeat the purpose of adding cuts
	$foreground= imagecolorallocate($random_image, IMAGE_FOREGROUND_RED, IMAGE_FOREGROUND_GREEN, IMAGE_FOREGROUND_BLUE);
	imagestring($random_image, IMAGE_FONT_SIZE, IMAGE_SPACING, IMAGE_SPACING, $random_number, $foreground);
	
	//cut image by random lines
	for($counter1=0; $counter1<IMAGE_CUTS; $counter1++)
	{
		$x1 = mt_rand(1, $random_image_width);
		$y1 = mt_rand(1, $random_image_height);
		$x2 = mt_rand(1, $random_image_width);
		$y2 = mt_rand(1, $random_image_height);
		imageline($random_image, $x1, $y1, $x2, $y2, $foreground);
	}
	
	//save image to file	
	imagepng($random_image, IMAGE_FILENAME);
	imagedestroy($random_image);
}


/** This function is used to connect to mysql server and use database. 
	Values for Username, password, database name, database server address are
	taken from constants DATABASE_USERNAME, DATABASE_PASSWORD, DATABASE_DBNAME
	and DATABASE_HOST respectively. if error occurs then this function displays
	proper error message and stops execution of script.

	@returns Database connection in which we have already selected a database to
		work on after connection to database server
*/
function connect_to_database()
{
	//connect to database server
	$connection = @mysql_pconnect(DATABASE_HOST, DATABASE_USERNAME, DATABASE_PASSWORD);
	if(!$connection)
	{
		echo "FATAL ERROR. Could not connect to database.<br> Since, ". mysql_error();
		exit;
	}

	//use or select database to work with
	$sql = "USE " . DATABASE_DBNAME;
	$result = mysql_query($sql, $connection);
	if(!$result)
		die("Could not use database " . DATABASE_DBNAME . " since, " . mysql_error());
							
	return $connection;
}


/** This function is used to redirect the user to given page. It redirects
  * using META-REFRESH with time interval  seconds.
  * @param page Page relative to current page where user should be redirected.
  *
  */
function redirect($page)
{
	?>
		<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
		<html>
			<head>
				<title>Address book redirect page</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
				<link rel="stylesheet" type="text/css" href="style1.css" />
				<?php
					echo "<meta http-equiv=\"refresh\" content=\"0;url=$page?" . session_id() . "\"/>";
				?>
			</head>
		<body>
		</body>
		</html>
	<?php	
}

?>
