<?php 
/** This program prepares alphabetical list of all folders stored in examples folder
	and provides link to each folder with respect to some base URL. This program
	is intended to provide links for each example so that all examples can be
	browsed easily. 

	@file index.php
	@version 1.0
	@author Saurabh Barjatiya
*/


/** EXAMPLES_DIR is used to specify location of examples directory 
*/
define('EXAMPLES_DIR','/home/saurabh/Desktop/courses/2011/monsoon/scripting_and_computer_environment/lectures/source_code/11-php/11-php-examples');


/** BASE_URL is used to specify location of base folder wrt which all
	the URLs for examples would be generated
*/
define('BASE_URL','http://10.5.1.222/php/');



/** This function reads examples dir whose location is defined using constant
	EXAMPLES_DIR. It than prepares a sorted array of all sub-folders stored
	in EXAMPLES_DIR excluding . and .. in global array named $example_array.

	@returns Nothing
*/
function read_example_dir()
{
	global $example_array;

	//Opening example dir to read its contents
	$example_dir = opendir(EXAMPLES_DIR);
	if($example_dir == false)
	{
		die('Cannot open dir ' . EXAMPLES_DIR . ' for reading');
	}

	$example_count=0;

	//looping through all example dir contents ignoring ., .. and files
	$current_file=readdir($example_dir);
	while($current_file != false)
	{
		if($current_file != '.' && $current_file != '..' && is_dir($current_file))
		{
			$example_array[$example_count]=$current_file;
			$example_count++;
		}
		$current_file=readdir($example_dir);
	}

	//It is important to close dir opened using opendir().
	//Such habits help in minimizing RAM usage while script is running
	closedir($example_dir);

	//Sorting folders alphabetically using PHP sort() function
	if($example_count > 1)
		sort($example_array, SORT_STRING);
}



/** This function displays proper index page
	in HTML format. This page includes links to all
	example dirs in alphabetical order. 

	@returns Nothing
*/
function display_index_page()
{
	global $example_array;

	//Reading example dir and sorting all dir entries alphabetically
	//in global array $example_array
	read_example_dir();

	?>
	<html>
		<head>
			<title>PHP examples</title>
		</head>
		<body>
			<h3>PHP examples:</h3>
			<ul>
				<?php
					//Although count is already available in $example_count we are still
					//using count function just to demonstrate how to find number of
					//elements in array.
					$limit=count($example_array);

					//Displaying link for each folder stored in example array 				
					for($counter1=0; $counter1<$limit; $counter1++)
					{
						echo '<li><a href="' . BASE_URL . $example_array[$counter1] . '">' . 
								$example_array[$counter1] . '</a></li>' . "\n";
					}
				?>
			</ul>
		</body>
	</html>
	<?php
}



/** This function just displays index page by calling
	display_index_page() function.

	@returns Nothing 
*/
function main()
{
	//Calling function display_index_page which displays index page
	display_index_page();
}



//Calling main() to execute functionality desired from this program.
main();
?>
