#include <stdio.h>
#include <pcap.h>
#include <stdlib.h>
#include <arpa/inet.h>

#define ADDRESS_SIZE 100

int main ()
{
    pcap_if_t *all_device_list;
    pcap_if_t *current_device;
    pcap_addr_t *current_address;
    int interface_count = 0;
    int address_count = 0;
    char error_message[PCAP_ERRBUF_SIZE];
    char ipaddress[ADDRESS_SIZE];

    /* Retrieve the device list from the local machine */
    if (pcap_findalldevs(&all_device_list, error_message)	== -1)
    {
	fprintf (stderr, "Error in pcap_findall_device_list_ex: %s\n", error_message);
	exit(EXIT_FAILURE);
    }

    /* Print the list */
    for (current_device = all_device_list; current_device != NULL; current_device = current_device->next)
    {
	printf ("%d. %s", ++interface_count, current_device->name);
	if (current_device->description)
	    printf (" (%s)\n", current_device->description);
	else
	    printf (" (No description available)\n");

	address_count=0;
	for(current_address=current_device->addresses; current_address!=NULL; current_address=current_address->next)
	{
	    printf("\t%d. ", ++address_count);

	    if(current_address->addr->sa_family==AF_INET)
	    {
    		inet_ntop(current_address->addr->sa_family, &((struct sockaddr_in *)current_address->addr)->sin_addr.s_addr, ipaddress, sizeof(ipaddress));
		printf("IPv4 address is : %s\n", ipaddress);
	    }
	    else if(current_address->addr->sa_family==AF_INET6)
	    {
		inet_ntop(current_address->addr->sa_family, &((struct sockaddr_in6 *)current_address->addr)->sin6_addr, ipaddress, sizeof(ipaddress));
		printf("IPv6 address is : %s\n", ipaddress);
	    }
	    else
		printf("Unknown address type :%d\n", current_address->addr->sa_family);
	}

	if(address_count==0)
	{
	    printf("\tThere is no address for this interface\n");
	}
    }

    if (interface_count == 0)
    {
	fprintf(stderr, "Either No interfaces found! Make sure WinPcap is installed.\n");
	fprintf(stderr, "OR you are not running program as root user.\n");
	exit(EXIT_FAILURE);
    }

    /* We don't need any more the device list. Free it */
    pcap_freealldevs(all_device_list);

    exit(EXIT_SUCCESS);
    return 0;
}
