#include <stdio.h>
#include <pcap.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <string.h>

#define ADDRESS_SIZE 100
#define INTERFACE_NAME_SIZE 20

int find_local_interface (char *interface_name);
void packet_handler(u_char *param, const struct pcap_pkthdr *header, const u_char *pkt_data);

int main()
{
    char interface_name[INTERFACE_NAME_SIZE];
    int result=0;
    pcap_t *packet_capture_handle;
    char error_message[PCAP_ERRBUF_SIZE];

    result=find_local_interface(interface_name);
    if(!result)
    {
	fprintf(stderr, "There is not local interface worth listening. Are you root?\n");
	exit(EXIT_FAILURE);
    }

    packet_capture_handle = pcap_open_live(
	    	interface_name, 	//interface to open
		65535,			//first n bytes of packet to capture
		1,  			//non-zero means promiscuous
		1000, 			//timeout in ms
		error_message); 	//error_message in case open fails
    if(packet_capture_handle==NULL)
    {
	fprintf(stderr, "Could not open interface %s for live capture. Are you root?\n", interface_name);
	exit(EXIT_FAILURE);
    }

    pcap_loop(packet_capture_handle, //loop on this handle
	    -1, //number of packets to capture, -1 means loop indefinitely
	    packet_handler, //callback function, called once per packet
	    NULL); //u_char which gets passed to packet_handler

    exit(EXIT_SUCCESS);
    return 0;
}


int find_local_interface (char *interface_name)
{
    pcap_if_t *all_device_list;
    pcap_if_t *current_device;
    pcap_addr_t *current_address;
    char error_message[PCAP_ERRBUF_SIZE];
    char ipaddress[ADDRESS_SIZE];
    int found=0;

    /* Retrieve the device list from the local machine */
    if (pcap_findalldevs(&all_device_list, error_message)	== -1)
    {
	fprintf (stderr, "Error in pcap_findall_device_list_ex: %s\n", error_message);
	exit(EXIT_FAILURE);
    }

    /* Print the list */
    for (current_device = all_device_list; current_device != NULL; current_device = current_device->next)
    {
	for(current_address=current_device->addresses; current_address!=NULL; current_address=current_address->next)
	{
	    if(current_address->addr->sa_family==AF_INET)
	    {
    		inet_ntop(current_address->addr->sa_family, &((struct sockaddr_in *)current_address->addr)->sin_addr.s_addr, ipaddress, sizeof(ipaddress));
		if(strcmp(ipaddress, "127.0.0.1")!=0)
		{
		    //This interface has IPv4 address and this is not loopback. 
		    //Hence it is worth listening too.
		    strcpy(interface_name, current_device->name);
		    found=1;
		    break;
		}
	    }
	}
	if(found)
	    break;
    }

    /* We don't need any more the device list. Free it */
    pcap_freealldevs(all_device_list);

    return found;
}

void packet_handler(u_char *param, const struct pcap_pkthdr *header, const u_char *pkt_data)
{
    printf("Got one :)\n");
    
}
