#include <libnet.h>
#include <stdio.h>

#define ETHERNET_HEADER_SIZE 14

void send_one_packet (unsigned char *packet_data, int length);
    
libnet_t *libnet_session1;

int main ()
{
    char error_buffer1[LIBNET_ERRBUF_SIZE];
    unsigned char packet_data[ETHERNET_HEADER_SIZE] = 
    	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //destination MAC
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,   //source MAC
	0x08, 0x00		//Network layer protocol, 0x0800 for IPv4
    };

    libnet_session1 = libnet_init (LIBNET_LINK_ADV, NULL, error_buffer1);
    if (libnet_session1 == NULL)
    {
	fprintf (stderr, "libnet_init() failed as %s\n", error_buffer1);
	exit (EXIT_FAILURE);
    }

    send_one_packet (packet_data, ETHERNET_HEADER_SIZE);

    libnet_destroy (libnet_session1);
    exit (EXIT_SUCCESS);
    return 0;
}

void send_one_packet (unsigned char *packet_data, int length)
{
    if (libnet_adv_write_link (libnet_session1, packet_data, (unsigned long) length) == -1)
	fprintf (stderr, "Packet sending failed as %s.\n", libnet_geterror (libnet_session1));
}
