#include <unistd.h>	//for close(), write(), read(),
#include <stdio.h>	//for fprintf(), perror(), snprintf(),
#include <stdlib.h>	//for exit(), atoi(),
#include <string.h>	//for strlen(),strcpy()
#include <strings.h>	//for bzero(),
#include <sys/socket.h>	//for socket(), bind(), listen(), accept(),
#include <sys/types.h>	//for socket(), bind(), accpet(),
#include <netinet/in.h>	//for struct sockaddr_in,
#include <time.h>	//for time(), time_t, 
#include <signal.h>	//for sigaction(), 

#define BUFFER 4096

int listen_file_descriptor;

void close_properly(int signal)
{
    int return_value;
    
    printf("Shutting down...\n");
    return_value =close(listen_file_descriptor);
    if(return_value <0)
    {
	perror("Cannot close listening socket.");
	exit(1);
    }

    printf("Shutdown complete.\n");
    exit(0);
}

ssize_t Write(int fd, const void *buf, size_t count)
{
    ssize_t return_value;

    return_value=write(fd,buf,count);
    if(return_value < 0)
    {
	perror("Write failed\n");
	exit(1);
    }
    return return_value;
}
    

/**
  * Used to create a tcp server on given port.
  * It sends a HTTP response page containing word hi
  * and then closes the connection. Note that it will work only 
  * for ipv4 clients.
  *
  * @returns zero to calling program on success, else 1.
  * @param argc number of command line arguments passed to the program
  *             including program name itself.
  * @param argv array of command line arguments.
  *
  */
int main(int argc, char *argv[])
{
    int connection_file_descriptor; 
    char temp_line[BUFFER];
    char temp_char1, temp_char2;
    struct sockaddr_in server_address;
    int return_value;
    struct sigaction act1;
    int characters_read;
    
    if(argc < 2)
    {
	fprintf(stderr, "usage: %s <port_number>\n", argv[0]);
	exit(1);
    }

    act1.sa_handler = close_properly;
    sigemptyset(&act1.sa_mask);
    act1.sa_flags=0;

    sigaction(SIGINT, &act1, 0);
    
    listen_file_descriptor = socket(AF_INET, SOCK_STREAM, 0);
    if(listen_file_descriptor < 0)
    {
	fprintf(stderr, "%s: cannot open socket.\n", argv[0]);
	exit(1);
    }

    bzero(&server_address, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr  = htonl(INADDR_ANY);
    server_address.sin_port = htons(atoi(argv[1]));

    return_value = bind(listen_file_descriptor, (struct sockaddr *) &server_address, sizeof(server_address));
    if(return_value < 0)
    {
	perror("Cannot bind");
	exit(1);
    }

    return_value = listen(listen_file_descriptor, 5);
    if(return_value < 0)
    {
	perror("Cannot listen");
	exit(1);
    }
    
    while(1)
    {
	connection_file_descriptor = accept(listen_file_descriptor, (struct sockaddr *) NULL, NULL);
	if(connection_file_descriptor < 0)
	{
	    perror("accept() failed.");
	    exit(1);
	}

	characters_read = read(connection_file_descriptor, &temp_char1, 1);
	while(characters_read > 0)
	{
	    //printf("%c",temp_char1);
	    characters_read = read(connection_file_descriptor, &temp_char2, 1);
	    if(temp_char2=='\n' && temp_char1=='\r')
	    {
	        temp_char1=temp_char2;
		//printf("%c",temp_char1);
		characters_read = read(connection_file_descriptor, &temp_char2, 1);
		if(temp_char2=='\r')
		{
		    //printf("found\n");
		    break;
		}
	    }
	    temp_char1=temp_char2;
	}

	if(characters_read < 0)
	{
	    perror("Error reading from socket.");
	    exit(1);
	}

	strcpy(temp_line, "HTTP/1.1 200 OK\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Server: Barjatiya\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Last-Modified: Fri, 29 Sep 2006 10:40:55 GMT\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Accept-Ranges: bytes\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Content-Length: 3\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Content-Type: text/html\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	strcpy(temp_line, "Hi\n");
        Write(connection_file_descriptor, temp_line, strlen(temp_line));
	
	return_value = close(connection_file_descriptor);

	if(return_value <0)
	{
	    perror("close failed");
	    exit(1);
	}
    }
        
    return 0;
}

