#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <strings.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

GtkWidget *entry_hostname;
GtkWidget *entry_ipaddress;

#define BUFFER 100

int Getaddrinfo(const char *node, const char *service, const struct addrinfo *hints, struct addrinfo **res);

extern int errno;

void onExit(GtkWidget *window, gpointer data)
{
    gtk_main_quit();
}


void add_widget_with_label(GtkContainer *box, gchar *caption, GtkWidget *widget)
{
    GtkWidget *label = gtk_label_new(caption);
    GtkWidget *hbox = gtk_hbox_new(TRUE, 4);

    gtk_container_add(GTK_CONTAINER (hbox), label);
    gtk_container_add(GTK_CONTAINER (hbox), widget);
    gtk_container_add(box, hbox);
}


void find_ipaddress(GtkWidget *button, gpointer data)
{
    const char *hostname=gtk_entry_get_text(GTK_ENTRY(entry_hostname));
    const char *service="domain";
    struct addrinfo hints, *res;
    char ipaddress[BUFFER+1];
    
    bzero(&hints, sizeof(hints));
    if(Getaddrinfo(hostname, service, &hints, &res)!=0)
	return;

    while(res!=NULL)
    {
	if(res->ai_family==AF_INET)
	{
	    inet_ntop(res->ai_family, &((struct sockaddr_in *)res->ai_addr)->sin_addr, ipaddress, sizeof(ipaddress));
	    printf("IPv4 address is : %s\n", ipaddress);
	    gtk_entry_set_text(GTK_ENTRY(entry_ipaddress), ipaddress);
	}
	else if(res->ai_family==AF_INET6)
	{
	    inet_ntop(res->ai_family, &((struct sockaddr_in6 *)res->ai_addr)->sin6_addr, ipaddress, sizeof(ipaddress));
	    printf("IPv6 address is : %s\n", ipaddress);
	    gtk_entry_set_text(GTK_ENTRY(entry_ipaddress), ipaddress);
	}
	else
	    printf("Unknown address type :%d\n",res->ai_family);
		    
	res=res->ai_next;
    }
}


int main(int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *button_find_ipaddress;
    GtkWidget *vbox;

    gtk_init(&argc, &argv);
    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_default_size(GTK_WINDOW(window), 300, 200);

    g_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(onExit), NULL);
    
    vbox = gtk_vbox_new(TRUE, 5);
    entry_hostname = gtk_entry_new();
    entry_ipaddress = gtk_entry_new();
    button_find_ipaddress = gtk_button_new_with_label("Find IP Address");
    add_widget_with_label(GTK_CONTAINER(vbox), "Hostname : ", entry_hostname);
    add_widget_with_label(GTK_CONTAINER(vbox), "IP Address : ", entry_ipaddress);
    gtk_box_pack_start(GTK_BOX(vbox), button_find_ipaddress, TRUE, FALSE, 5);

    gtk_container_add(GTK_CONTAINER(window), vbox);

    gtk_entry_set_editable(GTK_ENTRY(entry_ipaddress), FALSE);
    g_signal_connect(GTK_OBJECT(button_find_ipaddress), "clicked", GTK_SIGNAL_FUNC(find_ipaddress), NULL);
        
    gtk_widget_show_all(window);
    gtk_main();
    return 0;
}


int Getaddrinfo(const char *node, const char *service, const struct addrinfo *hints, struct addrinfo **res)
{
    int return_value=-1;
    return_value = getaddrinfo(node, service, hints, res);

    if(return_value != 0)
    {
	fprintf(stderr, "getaddrinfo failed since : %s\n", gai_strerror(return_value));
	gtk_entry_set_text(GTK_ENTRY(entry_ipaddress), gai_strerror(return_value));
    }
    return return_value;
}
    
