#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <unistd.h>		/* close() */
#include <stdlib.h>

#define LOCAL_SERVER_PORT 9999
#define MAX_MSG 512

int main (int argc, char *argv[])
{

    int socket_descriptor, return_value, characters_read;
    unsigned int client_address_length;
    struct sockaddr_in client_address, server_address;
    char message[MAX_MSG];

    /* socket creation */
    socket_descriptor = socket (AF_INET, SOCK_DGRAM, 0);
    if (socket_descriptor < 0)
    {
	printf ("%s: cannot open socket \n", argv[0]);
	exit (EXIT_FAILURE);
    }

    /* bind local server port */
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = htonl (INADDR_ANY);
    server_address.sin_port = htons(LOCAL_SERVER_PORT);
    return_value =  bind (socket_descriptor, (struct sockaddr *) &server_address, sizeof (server_address));
    if (return_value < 0)
    {
	printf ("%s: cannot bind port number %d \n", argv[0], LOCAL_SERVER_PORT);
	exit (EXIT_FAILURE);
    }

    printf ("%s: waiting for data on port UDP %u \n", argv[0], LOCAL_SERVER_PORT);

    /* server infinite loop */
    while (1)
    {
	client_address_length = sizeof (client_address);
	characters_read = recvfrom (socket_descriptor, message, MAX_MSG, 0,
				    (struct sockaddr *) &client_address, &client_address_length);

	if (characters_read < 0)
	{
	    printf ("%s: cannot receive data \n", argv[0]);
	    continue;
	}
	message[characters_read]='\0';

	printf ("Received message %s from IP %s, port %u\n",
		message, inet_ntoa (client_address.sin_addr),
		ntohs (client_address.sin_port));
    }

    exit(EXIT_SUCCESS);
    return 0;
}
