#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdlib.h>

#define BUFFER_SIZE 4096

int main (int argc, char *argv[])
{
    int unix_socket_file_descriptor;
    int server_address_length;
    struct sockaddr_un server_address;
    int result;
    char buffer1[BUFFER_SIZE];
    int characters_read;

    if(argc<2)
    {
	fprintf(stderr, "Usage: %s <message>\n", argv[0]);
	exit(EXIT_FAILURE);
    }

    unix_socket_file_descriptor = socket (AF_UNIX, SOCK_STREAM, 0);

    server_address.sun_family = AF_UNIX;
    strcpy (server_address.sun_path, "echo_socket");
    server_address_length = sizeof (server_address);

    result = connect (unix_socket_file_descriptor, (struct sockaddr *) &server_address, server_address_length);
    if (result == -1)
    {
	fprintf(stderr, "Cound not connected to server\n");
	exit (EXIT_FAILURE);
    }

    printf("Writing message %s to server\n", argv[1]);
    write (unix_socket_file_descriptor, argv[1], strlen(argv[1]));
    printf("Reading message from server\n");
    characters_read = read (unix_socket_file_descriptor, buffer1 , BUFFER_SIZE);
    buffer1[characters_read]='\0';
    printf("%s\n", buffer1);

    close (unix_socket_file_descriptor);
    exit (EXIT_SUCCESS);
}
