/**This program is to practice GTK by creating a dialog with OK and cancel buttons
  * @author Saurabh Barjatiya
  * @version 1.0
  * @file 05-gtk_dialog.c
  *
  */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>

void end_program(GtkWidget *widget1, gpointer data);
void dialog_button_clicked(GtkWidget *widget1, gpointer data);

/**This is where program starts and generates a dialog box with OK and Cancel buttons.
  * @param argc Number of arguments passed to program
  * @param argv Array of arugments passed to program
  * @returns EXIT_SUCCESS if program exits properly, EXIT_FAILURE otherwise.
  *
  */
int main(int argc, char *argv[])
{
    GtkWidget *dialog;
    gint result;

    gtk_init(&argc, &argv);

    dialog = gtk_dialog_new_with_buttons ("Should we continue?", NULL, 
	    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
	    GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL,
	    GTK_RESPONSE_REJECT, NULL);

    result = gtk_dialog_run (GTK_DIALOG (dialog));
    switch (result)
    {
	case GTK_RESPONSE_ACCEPT:
	    printf("You clicked OK\n");
	    break;

	case GTK_RESPONSE_REJECT:
	    printf("You clicked cancel\n");
	    break;

	default:
	    printf("You closed dialog\n");
	    break;
    }
    gtk_widget_destroy (dialog);

    return EXIT_SUCCESS;
}




